#!/bin/sh

# This is an example for usage of xjobs.

# To run please set the correct device for icedax below.

# Execute ./ripcd.sh -r
# to read an audio CD with icedax and encode all wav files using all
# CPUs for maximum performance.
#
# Ripped .wav files will be placed in `pwd`/tmp
# Encoded .mp3 files will be placed in a directory named based on the
# ID3 tag.
#
# Icedax and lame are needed to run this script.


getopts r readcd
getopts d delete

if [ ! -d tmp ]; then
       	mkdir tmp
fi

if [ "$readcd" == "r" ]; then
	cd tmp
	# !!! SPECIFY the correct address of your CD/DVD/BlueRay-device
	icedax -L1 -B -D1,0,0

	#cdda2wav dev=4,2,0 -vall cddb=0 -B -Owav 
	cd ..
fi


for i in `echo tmp/*.inf`; do
	oldname=`basename $i .inf`.wav
	artist=`grep Performer $i | sed 's/Performer=..\(.*\).$/\1/'`
	#echo artist="$artist"
	track=`grep Tracktitle $i | sed 's/Tracktitle=..\(.*\).$/\1/' | sed 's/\// /g'`
	#echo track="$track"
	album=`grep Albumtitle $i | sed 's/Albumtitle=..\(.*\).$/\1/'`
	#echo album="$album"
	newname="$track".mp3
	if [ "$track" == "" ]; then
		track=$oldname
	fi
	if [ ! -d "$artist - $album" ]; then
		mkdir "$artist - $album"
	fi
	echo --tt \"$track\"  --tl \"$album\" --ta \"$artist\" \"tmp/$oldname\" \"$artist - $album/$track.mp3\"
	if [ "$delete" == "d" ]; then
		rm "$i" tmp/"$oldname"
	fi
done | xjobs lame --silent -h
