// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SMLSL2_4S_8H_H_TRACE_AARCH64_H_
#define VIXL_SIM_SMLSL2_4S_8H_H_TRACE_AARCH64_H_

const uint32_t kExpected_NEON_smlsl2_4S_8H_H[] = {
  0xffc1017a, 0xffc100fd, 0xffc10080, 0x00000020,
  0xff8182f7, 0xff8181fb, 0xff8180ff, 0x00000020,
  0xe5e89c90, 0xe5e86861, 0xe5e83432, 0x00000020,
  0xbb3f1c8f, 0xbb3e930b, 0xbb3e0987, 0x00000020,
  0x7b421c86, 0x7b411305, 0x7b400984, 0x00000020,
  0x3b449c80, 0x3b431301, 0x3b418982, 0x00000020,
  0xfb469c7d, 0xfb4492ff, 0xfb428981, 0x00000020,
  0xfb469c7d, 0xfb4492ff, 0xfb428981, 0x00000020,
  0xffc0817d, 0xffc080ff, 0xffc08081, 0x00000020,
  0xe6279b16, 0xe6276765, 0xe62733b4, 0x00000020,
  0xbb7e1b15, 0xbb7d920f, 0xbb7d0909, 0x00000020,
  0x7b811b0c, 0x7b801209, 0x7b7f0906, 0x00000020,
  0x3b839b06, 0x3b821205, 0x3b808904, 0x00000020,
  0xfb859b03, 0xfb839203, 0xfb818903, 0x00000020,
  0xfb859b03, 0xfb839203, 0xfb818903, 0x00000020,
  0xfb851b06, 0xfb831205, 0xfb810904, 0x00000020,
  0xe6671999, 0xe666e667, 0xe666b335, 0x00000020,
  0xbbbd9998, 0xbbbd1111, 0xbbbc888a, 0x00000020,
  0x7bc0998f, 0x7bbf910b, 0x7bbe8887, 0x00000020,
  0x3bc31989, 0x3bc19107, 0x3bc00885, 0x00000020,
  0xfbc51986, 0xfbc31105, 0xfbc10884, 0x00000020,
  0xfbc51986, 0xfbc31105, 0xfbc10884, 0x00000020,
  0xfbc49989, 0xfbc29107, 0xfbc08885, 0x00000020,
  0xfbc3998f, 0xfbc1910b, 0xfbbf8887, 0x00000020,
  0xd5567fff, 0xd5562aab, 0xd555d557, 0x00000020,
  0x95597ff6, 0x9558aaa5, 0x9557d554, 0x00000020,
  0x555bfff0, 0x555aaaa1, 0x55595552, 0x00000020,
  0x155dffed, 0x155c2a9f, 0x155a5551, 0x00000020,
  0x155dffed, 0x155c2a9f, 0x155a5551, 0x00000020,
  0x155d7ff0, 0x155baaa1, 0x1559d552, 0x00000020,
  0x155c7ff6, 0x155aaaa5, 0x1558d554, 0x00000020,
  0x15548026, 0x1552aac5, 0x1550d564, 0x00000020,
  0xc002fff7, 0xc0027ffb, 0xc001ffff, 0x00000020,
  0x80057ff1, 0x80047ff7, 0x80037ffd, 0x00000020,
  0x40077fee, 0x4005fff5, 0x40047ffc, 0x00000020,
  0x40077fee, 0x4005fff5, 0x40047ffc, 0x00000020,
  0x4006fff1, 0x40057ff7, 0x4003fffd, 0x00000020,
  0x4005fff7, 0x40047ffb, 0x4002ffff, 0x00000020,
  0x3ffe0027, 0x3ffc801b, 0x3ffb000f, 0x00000020,
  0x3fbf819e, 0x3fbe0115, 0x3fbc808c, 0x00000020,
  0xc0027ffa, 0xc001fffd, 0xc0018000, 0x00000020,
  0x80047ff7, 0x80037ffb, 0x80027fff, 0x00000020,
  0x80047ff7, 0x80037ffb, 0x80027fff, 0x00000020,
  0x8003fffa, 0x8002fffd, 0x80020000, 0x00000020,
  0x80030000, 0x80020001, 0x80010002, 0x00000020,
  0x7ffb0030, 0x7ffa0021, 0x7ff90012, 0x00000020,
  0x7fbc81a7, 0x7fbb811b, 0x7fba808f, 0x00000020,
  0x7f7d8321, 0x7f7c8217, 0x7f7b810d, 0x00000020,
  0xc001fffd, 0xc0017fff, 0xc0010001, 0x00000020,
  0xc001fffd, 0xc0017fff, 0xc0010001, 0x00000020,
  0xc0018000, 0xc0010001, 0xc0008002, 0x00000020,
  0xc0008006, 0xc0000005, 0xbfff8004, 0x00000020,
  0xbff88036, 0xbff80025, 0xbff78014, 0x00000020,
  0xbfba01ad, 0xbfb9811f, 0xbfb90091, 0x00000020,
  0xbf7b0327, 0xbf7a821b, 0xbf7a010f, 0x00000020,
  0xbf3b84a4, 0xbf3b0319, 0xbf3a818e, 0x00000020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff8003, 0xffff8003, 0xffff8003, 0x00000020,
  0xfffe8009, 0xfffe8007, 0xfffe8005, 0x00000020,
  0xfff68039, 0xfff68027, 0xfff68015, 0x00000020,
  0xffb801b0, 0xffb80121, 0xffb80092, 0x00000020,
  0xff79032a, 0xff79021d, 0xff790110, 0x00000020,
  0xff3984a7, 0xff39831b, 0xff39818f, 0x00000020,
  0xe5a09e40, 0xe5a06981, 0xe5a034c2, 0x00000020,
  0xffff8003, 0xffff8003, 0xffff8003, 0x00000020,
  0xfffe8009, 0xfffe8007, 0xfffe8005, 0x00000020,
  0xfff68039, 0xfff68027, 0xfff68015, 0x00000020,
  0xffb801b0, 0xffb80121, 0xffb80092, 0x00000020,
  0xff79032a, 0xff79021d, 0xff790110, 0x00000020,
  0xff3984a7, 0xff39831b, 0xff39818f, 0x00000020,
  0xe5a09e40, 0xe5a06981, 0xe5a034c2, 0x00000020,
  0xbaf71e3f, 0xbaf6942b, 0xbaf60a17, 0x00000020,
  0xffff0006, 0xffff0005, 0xffff0004, 0x00000020,
  0xfff70036, 0xfff70025, 0xfff70014, 0x00000020,
  0xffb881ad, 0xffb8811f, 0xffb88091, 0x00000020,
  0xff798327, 0xff79821b, 0xff79810f, 0x00000020,
  0xff3a04a4, 0xff3a0319, 0xff3a018e, 0x00000020,
  0xe5a11e3d, 0xe5a0e97f, 0xe5a0b4c1, 0x00000020,
  0xbaf79e3c, 0xbaf71429, 0xbaf68a16, 0x00000020,
  0x7afa9e33, 0x7af99423, 0x7af88a13, 0x00000020,
  0xfff80030, 0xfff80021, 0xfff80012, 0x00000020,
  0xffb981a7, 0xffb9811b, 0xffb9808f, 0x00000020,
  0xff7a8321, 0xff7a8217, 0xff7a810d, 0x00000020,
  0xff3b049e, 0xff3b0315, 0xff3b018c, 0x00000020,
  0xe5a21e37, 0xe5a1e97b, 0xe5a1b4bf, 0x00000020,
  0xbaf89e36, 0xbaf81425, 0xbaf78a14, 0x00000020,
  0x7afb9e2d, 0x7afa941f, 0x7af98a11, 0x00000020,
  0x3afe1e27, 0x3afc941b, 0x3afb0a0f, 0x00000020,
  0xffc18177, 0xffc180fb, 0xffc1807f, 0x00000020,
  0xff8282f1, 0xff8281f7, 0xff8280fd, 0x00000020,
  0xff43046e, 0xff4302f5, 0xff43017c, 0x00000020,
  0xe5aa1e07, 0xe5a9e95b, 0xe5a9b4af, 0x00000020,
  0xbb009e06, 0xbb001405, 0xbaff8a04, 0x00000020,
  0x7b039dfd, 0x7b0293ff, 0x7b018a01, 0x00000020,
  0x3b061df7, 0x3b0493fb, 0x3b0309ff, 0x00000020,
  0xfb081df4, 0xfb0613f9, 0xfb0409fe, 0x00000020,
  0xffc1017a, 0xffc100fd, 0xffc10080, 0x00000020,
  0xff8182f7, 0xff8181fb, 0xff8180ff, 0x00000020,
  0xe5e89c90, 0xe5e86861, 0xe5e83432, 0x00000020,
  0xbb3f1c8f, 0xbb3e930b, 0xbb3e0987, 0x00000020,
  0x7b421c86, 0x7b411305, 0x7b400984, 0x00000020,
  0x3b449c80, 0x3b431301, 0x3b418982, 0x00000020,
  0xfb469c7d, 0xfb4492ff, 0xfb428981, 0x00000020,
  0x3b451c7d, 0x3b4392ff, 0x3b420981, 0x00000020,
  0xffc0817d, 0xffc080ff, 0xffc08081, 0x00000020,
  0xe6279b16, 0xe6276765, 0xe62733b4, 0x00000020,
  0xbb7e1b15, 0xbb7d920f, 0xbb7d0909, 0x00000020,
  0x7b811b0c, 0x7b801209, 0x7b7f0906, 0x00000020,
  0x3b839b06, 0x3b821205, 0x3b808904, 0x00000020,
  0xfb859b03, 0xfb839203, 0xfb818903, 0x00000020,
  0x3b841b03, 0x3b829203, 0x3b810903, 0x00000020,
  0x7b821b06, 0x7b811205, 0x7b800904, 0x00000020,
  0xe6671999, 0xe666e667, 0xe666b335, 0x00000020,
  0xbbbd9998, 0xbbbd1111, 0xbbbc888a, 0x00000020,
  0x7bc0998f, 0x7bbf910b, 0x7bbe8887, 0x00000020,
  0x3bc31989, 0x3bc19107, 0x3bc00885, 0x00000020,
  0xfbc51986, 0xfbc31105, 0xfbc10884, 0x00000020,
  0x3bc39986, 0x3bc21105, 0x3bc08884, 0x00000020,
  0x7bc19989, 0x7bc09107, 0x7bbf8885, 0x00000020,
  0xa66b9987, 0xa66ae65b, 0xa66a332f, 0x00000020,
  0xd5567fff, 0xd5562aab, 0xd555d557, 0x00000020,
  0x95597ff6, 0x9558aaa5, 0x9557d554, 0x00000020,
  0x555bfff0, 0x555aaaa1, 0x55595552, 0x00000020,
  0x155dffed, 0x155c2a9f, 0x155a5551, 0x00000020,
  0x555c7fed, 0x555b2a9f, 0x5559d551, 0x00000020,
  0x955a7ff0, 0x9559aaa1, 0x9558d552, 0x00000020,
  0xc0047fee, 0xc003fff5, 0xc0037ffc, 0x00000020,
  0xd99de652, 0xd99d998d, 0xd99d4cc8, 0x00000020,
  0xc002fff7, 0xc0027ffb, 0xc001ffff, 0x00000020,
  0x80057ff1, 0x80047ff7, 0x80037ffd, 0x00000020,
  0x40077fee, 0x4005fff5, 0x40047ffc, 0x00000020,
  0x8005ffee, 0x8004fff5, 0x8003fffc, 0x00000020,
  0xc003fff1, 0xc0037ff7, 0xc002fffd, 0x00000020,
  0xeaadffef, 0xeaadd54b, 0xeaadaaa7, 0x00000020,
  0x04476653, 0x04476ee3, 0x04477773, 0x00000020,
  0x048764d3, 0x04876de3, 0x048776f3, 0x00000020,
  0xc0027ffa, 0xc001fffd, 0xc0018000, 0x00000020,
  0x80047ff7, 0x80037ffb, 0x80027fff, 0x00000020,
  0xc002fff7, 0xc0027ffb, 0xc001ffff, 0x00000020,
  0x0000fffa, 0x0000fffd, 0x00010000, 0x00000020,
  0x2aaafff8, 0x2aab5551, 0x2aabaaaa, 0x00000020,
  0x4444665c, 0x4444eee9, 0x44457776, 0x00000020,
  0x448464dc, 0x4484ede9, 0x448576f6, 0x00000020,
  0x44c3e35f, 0x44c46ceb, 0x44c4f677, 0x00000020,
  0xc001fffd, 0xc0017fff, 0xc0010001, 0x00000020,
  0x00007ffd, 0x00007fff, 0x00008001, 0x00000020,
  0x3ffe8000, 0x3fff0001, 0x3fff8002, 0x00000020,
  0x6aa87ffe, 0x6aa95555, 0x6aaa2aac, 0x00000020,
  0x8441e662, 0x8442eeed, 0x8443f778, 0x00000020,
  0x8481e4e2, 0x8482eded, 0x8483f6f8, 0x00000020,
  0x84c16365, 0x84c26cef, 0x84c37679, 0x00000020,
  0x850061eb, 0x85016bf3, 0x850275fb, 0x00000020,
  0x3ffe8000, 0x3fff0001, 0x3fff8002, 0x00000020,
  0x7ffc8003, 0x7ffd8003, 0x7ffe8003, 0x00000020,
  0xaaa68001, 0xaaa7d557, 0xaaa92aad, 0x00000020,
  0xc43fe665, 0xc4416eef, 0xc442f779, 0x00000020,
  0xc47fe4e5, 0xc4816def, 0xc482f6f9, 0x00000020,
  0xc4bf6368, 0xc4c0ecf1, 0xc4c2767a, 0x00000020,
  0xc4fe61ee, 0xc4ffebf5, 0xc50175fc, 0x00000020,
  0xc53ce077, 0xc53e6afb, 0xc53ff57f, 0x00000020,
  0x3ffe0003, 0x3ffe8003, 0x3fff0003, 0x00000020,
  0x6aa80001, 0x6aa8d557, 0x6aa9aaad, 0x00000020,
  0x84416665, 0x84426eef, 0x84437779, 0x00000020,
  0x848164e5, 0x84826def, 0x848376f9, 0x00000020,
  0x84c0e368, 0x84c1ecf1, 0x84c2f67a, 0x00000020,
  0x84ffe1ee, 0x8500ebf5, 0x8501f5fc, 0x00000020,
  0x853e6077, 0x853f6afb, 0x8540757f, 0x00000020,
  0x85466047, 0x85476adb, 0x8548756f, 0x00000020,
  0x2aa9fffe, 0x2aaa5555, 0x2aaaaaac, 0x00000020,
  0x44436662, 0x4443eeed, 0x44447778, 0x00000020,
  0x448364e2, 0x4483eded, 0x448476f8, 0x00000020,
  0x44c2e365, 0x44c36cef, 0x44c3f679, 0x00000020,
  0x4501e1eb, 0x45026bf3, 0x4502f5fb, 0x00000020,
  0x45406074, 0x4540eaf9, 0x4541757e, 0x00000020,
  0x45486044, 0x4548ead9, 0x4549756e, 0x00000020,
  0x4549e03b, 0x454a6ad3, 0x454af56b, 0x00000020,
  0x19996664, 0x19999999, 0x1999ccce, 0x00000020,
  0x19d964e4, 0x19d99899, 0x19d9cc4e, 0x00000020,
  0x1a18e367, 0x1a19179b, 0x1a194bcf, 0x00000020,
  0x1a57e1ed, 0x1a58169f, 0x1a584b51, 0x00000020,
  0x1a966076, 0x1a9695a5, 0x1a96cad4, 0x00000020,
  0x1a9e6046, 0x1a9e9585, 0x1a9ecac4, 0x00000020,
  0x1a9fe03d, 0x1aa0157f, 0x1aa04ac1, 0x00000020,
  0x1aa0e037, 0x1aa1157b, 0x1aa14abf, 0x00000020,
  0x003ffe80, 0x003fff01, 0x003fff82, 0x00000020,
  0x007f7d03, 0x007f7e03, 0x007f7f03, 0x00000020,
  0x00be7b89, 0x00be7d07, 0x00be7e85, 0x00000020,
  0x00fcfa12, 0x00fcfc0d, 0x00fcfe08, 0x00000020,
  0x0104f9e2, 0x0104fbed, 0x0104fdf8, 0x00000020,
  0x010679d9, 0x01067be7, 0x01067df5, 0x00000020,
  0x010779d3, 0x01077be3, 0x01077df3, 0x00000020,
  0x0107f9d0, 0x0107fbe1, 0x0107fdf2, 0x00000020,
  0x003f7f02, 0x003f7f82, 0x00000002, 0x0000009f,
  0x007e7e06, 0x007e7f04, 0x00000002, 0x0000011d,
  0x00bcfd0c, 0x00bcfe87, 0x00000002, 0x0000019a,
  0x00c4fcec, 0x00c4fe77, 0x00000002, 0x000001aa,
  0x00c67ce6, 0x00c67e74, 0x00000002, 0x000001ad,
  0x00c77ce2, 0x00c77e72, 0x00000002, 0x000001af,
  0x00c7fce0, 0x00c7fe71, 0x00000002, 0x000001b0,
  0x00c7fce0, 0x00c7fe71, 0x00000002, 0x000001b0,
  0x003eff04, 0x003eff83, 0x00000002, 0x0000009e,
  0x007d7e0a, 0x007d7f06, 0x00000002, 0x0000011b,
  0x00857dea, 0x00857ef6, 0x00000002, 0x0000012b,
  0x0086fde4, 0x0086fef3, 0x00000002, 0x0000012e,
  0x0087fde0, 0x0087fef1, 0x00000002, 0x00000130,
  0x00887dde, 0x00887ef0, 0x00000002, 0x00000131,
  0x00887dde, 0x00887ef0, 0x00000002, 0x00000131,
  0x0087fde0, 0x0087fef1, 0x00000002, 0x00000130,
  0x003e7f06, 0x003e7f84, 0x00000002, 0x0000009d,
  0x00467ee6, 0x00467f74, 0x00000002, 0x000000ad,
  0x0047fee0, 0x0047ff71, 0x00000002, 0x000000b0,
  0x0048fedc, 0x0048ff6f, 0x00000002, 0x000000b2,
  0x00497eda, 0x00497f6e, 0x00000002, 0x000000b3,
  0x00497eda, 0x00497f6e, 0x00000002, 0x000000b3,
  0x0048fedc, 0x0048ff6f, 0x00000002, 0x000000b2,
  0x0047fee0, 0x0047ff71, 0x00000002, 0x000000b0,
  0x0007ffe0, 0x0007fff1, 0x00000002, 0x00000030,
  0x00097fda, 0x00097fee, 0x00000002, 0x00000033,
  0x000a7fd6, 0x000a7fec, 0x00000002, 0x00000035,
  0x000affd4, 0x000affeb, 0x00000002, 0x00000036,
  0x000affd4, 0x000affeb, 0x00000002, 0x00000036,
  0x000a7fd6, 0x000a7fec, 0x00000002, 0x00000035,
  0x00097fda, 0x00097fee, 0x00000002, 0x00000033,
  0x00017ffa, 0x00017ffe, 0x00000002, 0x00000023,
  0x00017ffa, 0x00017ffe, 0x00000002, 0x00000023,
  0x00027ff6, 0x00027ffc, 0x00000002, 0x00000025,
  0x0002fff4, 0x0002fffb, 0x00000002, 0x00000026,
  0x0002fff4, 0x0002fffb, 0x00000002, 0x00000026,
  0x00027ff6, 0x00027ffc, 0x00000002, 0x00000025,
  0x00017ffa, 0x00017ffe, 0x00000002, 0x00000023,
  0xfff9801a, 0xfff9800e, 0x00000002, 0x00000013,
  0xffbb0114, 0xffbb008b, 0x00000002, 0xffffff96,
  0x0000fffc, 0x0000ffff, 0x00000002, 0x00000022,
  0x00017ffa, 0x00017ffe, 0x00000002, 0x00000023,
  0x00017ffa, 0x00017ffe, 0x00000002, 0x00000023,
  0x0000fffc, 0x0000ffff, 0x00000002, 0x00000022,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfff80020, 0xfff80011, 0x00000002, 0x00000010,
  0xffb9811a, 0xffb9808e, 0x00000002, 0xffffff93,
  0xff7a8216, 0xff7a810c, 0x00000002, 0xffffff15,
  0x00007ffe, 0x00008000, 0x00000002, 0x00000021,
  0x00007ffe, 0x00008000, 0x00000002, 0x00000021,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff0004, 0xffff0003, 0x00000002, 0x0000001e,
  0xfff70024, 0xfff70013, 0x00000002, 0x0000000e,
  0xffb8811e, 0xffb88090, 0x00000002, 0xffffff91,
  0xff79821a, 0xff79810e, 0x00000002, 0xffffff13,
  0xff3a0318, 0xff3a018d, 0x00000002, 0xfffffe94,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff8002, 0xffff8002, 0x00000002, 0x0000001f,
  0xfffe8006, 0xfffe8004, 0x00000002, 0x0000001d,
  0xfff68026, 0xfff68014, 0x00000002, 0x0000000d,
  0xffb80120, 0xffb80091, 0x00000002, 0xffffff90,
  0xff79021c, 0xff79010f, 0x00000002, 0xffffff12,
  0xff39831a, 0xff39818e, 0x00000002, 0xfffffe93,
  0xe5a06980, 0xe5a034c1, 0x00000002, 0xffffcb60,
  0xffff8002, 0xffff8002, 0x00000002, 0x0000001f,
  0xfffe8006, 0xfffe8004, 0x00000002, 0x0000001d,
  0xfff68026, 0xfff68014, 0x00000002, 0x0000000d,
  0xffb80120, 0xffb80091, 0x00000002, 0xffffff90,
  0xff79021c, 0xff79010f, 0x00000002, 0xffffff12,
  0xff39831a, 0xff39818e, 0x00000002, 0xfffffe93,
  0xe5a06980, 0xe5a034c1, 0x00000002, 0xffffcb60,
  0xbaf6942a, 0xbaf60a16, 0x00000002, 0xffff760b,
  0xffff0004, 0xffff0003, 0x00000002, 0x0000001e,
  0xfff70024, 0xfff70013, 0x00000002, 0x0000000e,
  0xffb8811e, 0xffb88090, 0x00000002, 0xffffff91,
  0xff79821a, 0xff79810e, 0x00000002, 0xffffff13,
  0xff3a0318, 0xff3a018d, 0x00000002, 0xfffffe94,
  0xe5a0e97e, 0xe5a0b4c0, 0x00000002, 0xffffcb61,
  0xbaf71428, 0xbaf68a15, 0x00000002, 0xffff760c,
  0x7af99422, 0x7af88a12, 0x00000002, 0xfffef60f,
  0xfff80020, 0xfff80011, 0x00000002, 0x00000010,
  0xffb9811a, 0xffb9808e, 0x00000002, 0xffffff93,
  0xff7a8216, 0xff7a810c, 0x00000002, 0xffffff15,
  0xff3b0314, 0xff3b018b, 0x00000002, 0xfffffe96,
  0xe5a1e97a, 0xe5a1b4be, 0x00000002, 0xffffcb63,
  0xbaf81424, 0xbaf78a13, 0x00000002, 0xffff760e,
  0x7afa941e, 0x7af98a10, 0x00000002, 0xfffef611,
  0x3afc941a, 0x3afb0a0e, 0x00000002, 0xfffe7613,
  0xffc180fa, 0xffc1807e, 0x00000002, 0xffffffa3,
  0xff8281f6, 0xff8280fc, 0x00000002, 0xffffff25,
  0xff4302f4, 0xff43017b, 0x00000002, 0xfffffea6,
  0xe5a9e95a, 0xe5a9b4ae, 0x00000002, 0xffffcb73,
  0xbb001404, 0xbaff8a03, 0x00000002, 0xffff761e,
  0x7b0293fe, 0x7b018a00, 0x00000002, 0xfffef621,
  0x3b0493fa, 0x3b0309fe, 0x00000002, 0xfffe7623,
  0xfb0613f8, 0xfb0409fd, 0x00000002, 0xfffdf624,
  0xffc100fc, 0xffc1007f, 0x00000002, 0xffffffa2,
  0xff8181fa, 0xff8180fe, 0x00000002, 0xffffff23,
  0xe5e86860, 0xe5e83431, 0x00000002, 0xffffcbf0,
  0xbb3e930a, 0xbb3e0986, 0x00000002, 0xffff769b,
  0x7b411304, 0x7b400983, 0x00000002, 0xfffef69e,
  0x3b431300, 0x3b418981, 0x00000002, 0xfffe76a0,
  0xfb4492fe, 0xfb428980, 0x00000002, 0xfffdf6a1,
  0x3b4392fe, 0x3b420980, 0x00000002, 0xfffe76a1,
  0xffc080fe, 0xffc08080, 0x00000002, 0xffffffa1,
  0xe6276764, 0xe62733b3, 0x00000002, 0xffffcc6e,
  0xbb7d920e, 0xbb7d0908, 0x00000002, 0xffff7719,
  0x7b801208, 0x7b7f0905, 0x00000002, 0xfffef71c,
  0x3b821204, 0x3b808903, 0x00000002, 0xfffe771e,
  0xfb839202, 0xfb818902, 0x00000002, 0xfffdf71f,
  0x3b829202, 0x3b810902, 0x00000002, 0xfffe771f,
  0x7b811204, 0x7b800903, 0x00000002, 0xfffef71e,
  0xe666e666, 0xe666b334, 0x00000002, 0xffffcced,
  0xbbbd1110, 0xbbbc8889, 0x00000002, 0xffff7798,
  0x7bbf910a, 0x7bbe8886, 0x00000002, 0xfffef79b,
  0x3bc19106, 0x3bc00884, 0x00000002, 0xfffe779d,
  0xfbc31104, 0xfbc10883, 0x00000002, 0xfffdf79e,
  0x3bc21104, 0x3bc08883, 0x00000002, 0xfffe779e,
  0x7bc09106, 0x7bbf8884, 0x00000002, 0xfffef79d,
  0xa66ae65a, 0xa66a332e, 0x00000002, 0xffff4cf3,
  0xd5562aaa, 0xd555d556, 0x00000002, 0xffffaacb,
  0x9558aaa4, 0x9557d553, 0x00000002, 0xffff2ace,
  0x555aaaa0, 0x55595551, 0x00000002, 0xfffeaad0,
  0x155c2a9e, 0x155a5550, 0x00000002, 0xfffe2ad1,
  0x555b2a9e, 0x5559d550, 0x00000002, 0xfffeaad1,
  0x9559aaa0, 0x9558d551, 0x00000002, 0xffff2ad0,
  0xc003fff4, 0xc0037ffb, 0x00000002, 0xffff8026,
  0xd99d998c, 0xd99d4cc7, 0x00000002, 0xffffb35a,
  0xc0027ffa, 0xc001fffe, 0x00000002, 0xffff8023,
  0x80047ff6, 0x80037ffc, 0x00000002, 0xffff0025,
  0x4005fff4, 0x40047ffb, 0x00000002, 0xfffe8026,
  0x8004fff4, 0x8003fffb, 0x00000002, 0xffff0026,
  0xc0037ff6, 0xc002fffc, 0x00000002, 0xffff8025,
  0xeaadd54a, 0xeaadaaa6, 0x00000002, 0xffffd57b,
  0x04476ee2, 0x04477772, 0x00000002, 0x000008af,
  0x04876de2, 0x048776f2, 0x00000002, 0x0000092f,
  0xc001fffc, 0xc0017fff, 0x00000002, 0xffff8022,
  0x80037ffa, 0x80027ffe, 0x00000002, 0xffff0023,
  0xc0027ffa, 0xc001fffe, 0x00000002, 0xffff8023,
  0x0000fffc, 0x0000ffff, 0x00000002, 0x00000022,
  0x2aab5550, 0x2aabaaa9, 0x00000002, 0x00005578,
  0x4444eee8, 0x44457775, 0x00000002, 0x000088ac,
  0x4484ede8, 0x448576f5, 0x00000002, 0x0000892c,
  0x44c46cea, 0x44c4f676, 0x00000002, 0x000089ab,
  0xc0017ffe, 0xc0010000, 0x00000002, 0xffff8021,
  0x00007ffe, 0x00008000, 0x00000002, 0x00000021,
  0x3fff0000, 0x3fff8001, 0x00000002, 0x00008020,
  0x6aa95554, 0x6aaa2aab, 0x00000002, 0x0000d576,
  0x8442eeec, 0x8443f777, 0x00000002, 0x000108aa,
  0x8482edec, 0x8483f6f7, 0x00000002, 0x0001092a,
  0x84c26cee, 0x84c37678, 0x00000002, 0x000109a9,
  0x85016bf2, 0x850275fa, 0x00000002, 0x00010a27,
  0x3fff0000, 0x3fff8001, 0x00000002, 0x00008020,
  0x7ffd8002, 0x7ffe8002, 0x00000002, 0x0001001f,
  0xaaa7d556, 0xaaa92aac, 0x00000002, 0x00015575,
  0xc4416eee, 0xc442f778, 0x00000002, 0x000188a9,
  0xc4816dee, 0xc482f6f8, 0x00000002, 0x00018929,
  0xc4c0ecf0, 0xc4c27679, 0x00000002, 0x000189a8,
  0xc4ffebf4, 0xc50175fb, 0x00000002, 0x00018a26,
  0xc53e6afa, 0xc53ff57e, 0x00000002, 0x00018aa3,
  0x3ffe8002, 0x3fff0002, 0x00000002, 0x0000801f,
  0x6aa8d556, 0x6aa9aaac, 0x00000002, 0x0000d575,
  0x84426eee, 0x84437778, 0x00000002, 0x000108a9,
  0x84826dee, 0x848376f8, 0x00000002, 0x00010929,
  0x84c1ecf0, 0x84c2f679, 0x00000002, 0x000109a8,
  0x8500ebf4, 0x8501f5fb, 0x00000002, 0x00010a26,
  0x853f6afa, 0x8540757e, 0x00000002, 0x00010aa3,
  0x85476ada, 0x8548756e, 0x00000002, 0x00010ab3,
  0x2aaa5554, 0x2aaaaaab, 0x00000002, 0x00005576,
  0x4443eeec, 0x44447777, 0x00000002, 0x000088aa,
  0x4483edec, 0x448476f7, 0x00000002, 0x0000892a,
  0x44c36cee, 0x44c3f678, 0x00000002, 0x000089a9,
  0x45026bf2, 0x4502f5fa, 0x00000002, 0x00008a27,
  0x4540eaf8, 0x4541757d, 0x00000002, 0x00008aa4,
  0x4548ead8, 0x4549756d, 0x00000002, 0x00008ab4,
  0x454a6ad2, 0x454af56a, 0x00000002, 0x00008ab7,
  0x19999998, 0x1999cccd, 0x00000002, 0x00003354,
  0x19d99898, 0x19d9cc4d, 0x00000002, 0x000033d4,
  0x1a19179a, 0x1a194bce, 0x00000002, 0x00003453,
  0x1a58169e, 0x1a584b50, 0x00000002, 0x000034d1,
  0x1a9695a4, 0x1a96cad3, 0x00000002, 0x0000354e,
  0x1a9e9584, 0x1a9ecac3, 0x00000002, 0x0000355e,
  0x1aa0157e, 0x1aa04ac0, 0x00000002, 0x00003561,
  0x1aa1157a, 0x1aa14abe, 0x00000002, 0x00003563,
  0x003fff00, 0x003fff81, 0x00000002, 0x000000a0,
  0x007f7e02, 0x007f7f02, 0x00000002, 0x0000011f,
  0x00be7d06, 0x00be7e84, 0x00000002, 0x0000019d,
  0x00fcfc0c, 0x00fcfe07, 0x00000002, 0x0000021a,
  0x0104fbec, 0x0104fdf7, 0x00000002, 0x0000022a,
  0x01067be6, 0x01067df4, 0x00000002, 0x0000022d,
  0x01077be2, 0x01077df2, 0x00000002, 0x0000022f,
  0x0107fbe0, 0x0107fdf1, 0x00000002, 0x00000230,
  0x003f7f81, 0x00000001, 0x00000081, 0x0000011e,
  0x007e7f03, 0x00000001, 0x000000ff, 0x0000021a,
  0x00bcfe86, 0x00000001, 0x0000017c, 0x00000314,
  0x00c4fe76, 0x00000001, 0x0000018c, 0x00000334,
  0x00c67e73, 0x00000001, 0x0000018f, 0x0000033a,
  0x00c77e71, 0x00000001, 0x00000191, 0x0000033e,
  0x00c7fe70, 0x00000001, 0x00000192, 0x00000340,
  0x00c7fe70, 0x00000001, 0x00000192, 0x00000340,
  0x003eff82, 0x00000001, 0x00000080, 0x0000011c,
  0x007d7f05, 0x00000001, 0x000000fd, 0x00000216,
  0x00857ef5, 0x00000001, 0x0000010d, 0x00000236,
  0x0086fef2, 0x00000001, 0x00000110, 0x0000023c,
  0x0087fef0, 0x00000001, 0x00000112, 0x00000240,
  0x00887eef, 0x00000001, 0x00000113, 0x00000242,
  0x00887eef, 0x00000001, 0x00000113, 0x00000242,
  0x0087fef0, 0x00000001, 0x00000112, 0x00000240,
  0x003e7f83, 0x00000001, 0x0000007f, 0x0000011a,
  0x00467f73, 0x00000001, 0x0000008f, 0x0000013a,
  0x0047ff70, 0x00000001, 0x00000092, 0x00000140,
  0x0048ff6e, 0x00000001, 0x00000094, 0x00000144,
  0x00497f6d, 0x00000001, 0x00000095, 0x00000146,
  0x00497f6d, 0x00000001, 0x00000095, 0x00000146,
  0x0048ff6e, 0x00000001, 0x00000094, 0x00000144,
  0x0047ff70, 0x00000001, 0x00000092, 0x00000140,
  0x0007fff0, 0x00000001, 0x00000012, 0x00000040,
  0x00097fed, 0x00000001, 0x00000015, 0x00000046,
  0x000a7feb, 0x00000001, 0x00000017, 0x0000004a,
  0x000affea, 0x00000001, 0x00000018, 0x0000004c,
  0x000affea, 0x00000001, 0x00000018, 0x0000004c,
  0x000a7feb, 0x00000001, 0x00000017, 0x0000004a,
  0x00097fed, 0x00000001, 0x00000015, 0x00000046,
  0x00017ffd, 0x00000001, 0x00000005, 0x00000026,
  0x00017ffd, 0x00000001, 0x00000005, 0x00000026,
  0x00027ffb, 0x00000001, 0x00000007, 0x0000002a,
  0x0002fffa, 0x00000001, 0x00000008, 0x0000002c,
  0x0002fffa, 0x00000001, 0x00000008, 0x0000002c,
  0x00027ffb, 0x00000001, 0x00000007, 0x0000002a,
  0x00017ffd, 0x00000001, 0x00000005, 0x00000026,
  0xfff9800d, 0x00000001, 0xfffffff5, 0x00000006,
  0xffbb008a, 0x00000001, 0xffffff78, 0xffffff0c,
  0x0000fffe, 0x00000001, 0x00000004, 0x00000024,
  0x00017ffd, 0x00000001, 0x00000005, 0x00000026,
  0x00017ffd, 0x00000001, 0x00000005, 0x00000026,
  0x0000fffe, 0x00000001, 0x00000004, 0x00000024,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfff80010, 0x00000001, 0xfffffff2, 0x00000000,
  0xffb9808d, 0x00000001, 0xffffff75, 0xffffff06,
  0xff7a810b, 0x00000001, 0xfffffef7, 0xfffffe0a,
  0x00007fff, 0x00000001, 0x00000003, 0x00000022,
  0x00007fff, 0x00000001, 0x00000003, 0x00000022,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff0002, 0x00000001, 0x00000000, 0x0000001c,
  0xfff70012, 0x00000001, 0xfffffff0, 0xfffffffc,
  0xffb8808f, 0x00000001, 0xffffff73, 0xffffff02,
  0xff79810d, 0x00000001, 0xfffffef5, 0xfffffe06,
  0xff3a018c, 0x00000001, 0xfffffe76, 0xfffffd08,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff8001, 0x00000001, 0x00000001, 0x0000001e,
  0xfffe8003, 0x00000001, 0xffffffff, 0x0000001a,
  0xfff68013, 0x00000001, 0xffffffef, 0xfffffffa,
  0xffb80090, 0x00000001, 0xffffff72, 0xffffff00,
  0xff79010e, 0x00000001, 0xfffffef4, 0xfffffe04,
  0xff39818d, 0x00000001, 0xfffffe75, 0xfffffd06,
  0xe5a034c0, 0x00000001, 0xffffcb42, 0xffff96a0,
  0xffff8001, 0x00000001, 0x00000001, 0x0000001e,
  0xfffe8003, 0x00000001, 0xffffffff, 0x0000001a,
  0xfff68013, 0x00000001, 0xffffffef, 0xfffffffa,
  0xffb80090, 0x00000001, 0xffffff72, 0xffffff00,
  0xff79010e, 0x00000001, 0xfffffef4, 0xfffffe04,
  0xff39818d, 0x00000001, 0xfffffe75, 0xfffffd06,
  0xe5a034c0, 0x00000001, 0xffffcb42, 0xffff96a0,
  0xbaf60a15, 0x00000001, 0xffff75ed, 0xfffeebf6,
  0xffff0002, 0x00000001, 0x00000000, 0x0000001c,
  0xfff70012, 0x00000001, 0xfffffff0, 0xfffffffc,
  0xffb8808f, 0x00000001, 0xffffff73, 0xffffff02,
  0xff79810d, 0x00000001, 0xfffffef5, 0xfffffe06,
  0xff3a018c, 0x00000001, 0xfffffe76, 0xfffffd08,
  0xe5a0b4bf, 0x00000001, 0xffffcb43, 0xffff96a2,
  0xbaf68a14, 0x00000001, 0xffff75ee, 0xfffeebf8,
  0x7af88a11, 0x00000001, 0xfffef5f1, 0xfffdebfe,
  0xfff80010, 0x00000001, 0xfffffff2, 0x00000000,
  0xffb9808d, 0x00000001, 0xffffff75, 0xffffff06,
  0xff7a810b, 0x00000001, 0xfffffef7, 0xfffffe0a,
  0xff3b018a, 0x00000001, 0xfffffe78, 0xfffffd0c,
  0xe5a1b4bd, 0x00000001, 0xffffcb45, 0xffff96a6,
  0xbaf78a12, 0x00000001, 0xffff75f0, 0xfffeebfc,
  0x7af98a0f, 0x00000001, 0xfffef5f3, 0xfffdec02,
  0x3afb0a0d, 0x00000001, 0xfffe75f5, 0xfffcec06,
  0xffc1807d, 0x00000001, 0xffffff85, 0xffffff26,
  0xff8280fb, 0x00000001, 0xffffff07, 0xfffffe2a,
  0xff43017a, 0x00000001, 0xfffffe88, 0xfffffd2c,
  0xe5a9b4ad, 0x00000001, 0xffffcb55, 0xffff96c6,
  0xbaff8a02, 0x00000001, 0xffff7600, 0xfffeec1c,
  0x7b0189ff, 0x00000001, 0xfffef603, 0xfffdec22,
  0x3b0309fd, 0x00000001, 0xfffe7605, 0xfffcec26,
  0xfb0409fc, 0x00000001, 0xfffdf606, 0xfffbec28,
  0xffc1007e, 0x00000001, 0xffffff84, 0xffffff24,
  0xff8180fd, 0x00000001, 0xffffff05, 0xfffffe26,
  0xe5e83430, 0x00000001, 0xffffcbd2, 0xffff97c0,
  0xbb3e0985, 0x00000001, 0xffff767d, 0xfffeed16,
  0x7b400982, 0x00000001, 0xfffef680, 0xfffded1c,
  0x3b418980, 0x00000001, 0xfffe7682, 0xfffced20,
  0xfb42897f, 0x00000001, 0xfffdf683, 0xfffbed22,
  0x3b42097f, 0x00000001, 0xfffe7683, 0xfffced22,
  0xffc0807f, 0x00000001, 0xffffff83, 0xffffff22,
  0xe62733b2, 0x00000001, 0xffffcc50, 0xffff98bc,
  0xbb7d0907, 0x00000001, 0xffff76fb, 0xfffeee12,
  0x7b7f0904, 0x00000001, 0xfffef6fe, 0xfffdee18,
  0x3b808902, 0x00000001, 0xfffe7700, 0xfffcee1c,
  0xfb818901, 0x00000001, 0xfffdf701, 0xfffbee1e,
  0x3b810901, 0x00000001, 0xfffe7701, 0xfffcee1e,
  0x7b800902, 0x00000001, 0xfffef700, 0xfffdee1c,
  0xe666b333, 0x00000001, 0xffffcccf, 0xffff99ba,
  0xbbbc8888, 0x00000001, 0xffff777a, 0xfffeef10,
  0x7bbe8885, 0x00000001, 0xfffef77d, 0xfffdef16,
  0x3bc00883, 0x00000001, 0xfffe777f, 0xfffcef1a,
  0xfbc10882, 0x00000001, 0xfffdf780, 0xfffbef1c,
  0x3bc08882, 0x00000001, 0xfffe7780, 0xfffcef1c,
  0x7bbf8883, 0x00000001, 0xfffef77f, 0xfffdef1a,
  0xa66a332d, 0x00000001, 0xffff4cd5, 0xfffe99c6,
  0xd555d555, 0x00000001, 0xffffaaad, 0xffff5576,
  0x9557d552, 0x00000001, 0xffff2ab0, 0xfffe557c,
  0x55595550, 0x00000001, 0xfffeaab2, 0xfffd5580,
  0x155a554f, 0x00000001, 0xfffe2ab3, 0xfffc5582,
  0x5559d54f, 0x00000001, 0xfffeaab3, 0xfffd5582,
  0x9558d550, 0x00000001, 0xffff2ab2, 0xfffe5580,
  0xc0037ffa, 0x00000001, 0xffff8008, 0xffff002c,
  0xd99d4cc6, 0x00000001, 0xffffb33c, 0xffff6694,
  0xc001fffd, 0x00000001, 0xffff8005, 0xffff0026,
  0x80037ffb, 0x00000001, 0xffff0007, 0xfffe002a,
  0x40047ffa, 0x00000001, 0xfffe8008, 0xfffd002c,
  0x8003fffa, 0x00000001, 0xffff0008, 0xfffe002c,
  0xc002fffb, 0x00000001, 0xffff8007, 0xffff002a,
  0xeaadaaa5, 0x00000001, 0xffffd55d, 0xffffaad6,
  0x04477771, 0x00000001, 0x00000891, 0x0000113e,
  0x048776f1, 0x00000001, 0x00000911, 0x0000123e,
  0xc0017ffe, 0x00000001, 0xffff8004, 0xffff0024,
  0x80027ffd, 0x00000001, 0xffff0005, 0xfffe0026,
  0xc001fffd, 0x00000001, 0xffff8005, 0xffff0026,
  0x0000fffe, 0x00000001, 0x00000004, 0x00000024,
  0x2aabaaa8, 0x00000001, 0x0000555a, 0x0000aad0,
  0x44457774, 0x00000001, 0x0000888e, 0x00011138,
  0x448576f4, 0x00000001, 0x0000890e, 0x00011238,
  0x44c4f675, 0x00000001, 0x0000898d, 0x00011336,
  0xc000ffff, 0x00000001, 0xffff8003, 0xffff0022,
  0x00007fff, 0x00000001, 0x00000003, 0x00000022,
  0x3fff8000, 0x00000001, 0x00008002, 0x00010020,
  0x6aaa2aaa, 0x00000001, 0x0000d558, 0x0001aacc,
  0x8443f776, 0x00000001, 0x0001088c, 0x00021134,
  0x8483f6f6, 0x00000001, 0x0001090c, 0x00021234,
  0x84c37677, 0x00000001, 0x0001098b, 0x00021332,
  0x850275f9, 0x00000001, 0x00010a09, 0x0002142e,
  0x3fff8000, 0x00000001, 0x00008002, 0x00010020,
  0x7ffe8001, 0x00000001, 0x00010001, 0x0002001e,
  0xaaa92aab, 0x00000001, 0x00015557, 0x0002aaca,
  0xc442f777, 0x00000001, 0x0001888b, 0x00031132,
  0xc482f6f7, 0x00000001, 0x0001890b, 0x00031232,
  0xc4c27678, 0x00000001, 0x0001898a, 0x00031330,
  0xc50175fa, 0x00000001, 0x00018a08, 0x0003142c,
  0xc53ff57d, 0x00000001, 0x00018a85, 0x00031526,
  0x3fff0001, 0x00000001, 0x00008001, 0x0001001e,
  0x6aa9aaab, 0x00000001, 0x0000d557, 0x0001aaca,
  0x84437777, 0x00000001, 0x0001088b, 0x00021132,
  0x848376f7, 0x00000001, 0x0001090b, 0x00021232,
  0x84c2f678, 0x00000001, 0x0001098a, 0x00021330,
  0x8501f5fa, 0x00000001, 0x00010a08, 0x0002142c,
  0x8540757d, 0x00000001, 0x00010a85, 0x00021526,
  0x8548756d, 0x00000001, 0x00010a95, 0x00021546,
  0x2aaaaaaa, 0x00000001, 0x00005558, 0x0000aacc,
  0x44447776, 0x00000001, 0x0000888c, 0x00011134,
  0x448476f6, 0x00000001, 0x0000890c, 0x00011234,
  0x44c3f677, 0x00000001, 0x0000898b, 0x00011332,
  0x4502f5f9, 0x00000001, 0x00008a09, 0x0001142e,
  0x4541757c, 0x00000001, 0x00008a86, 0x00011528,
  0x4549756c, 0x00000001, 0x00008a96, 0x00011548,
  0x454af569, 0x00000001, 0x00008a99, 0x0001154e,
  0x1999cccc, 0x00000001, 0x00003336, 0x00006688,
  0x19d9cc4c, 0x00000001, 0x000033b6, 0x00006788,
  0x1a194bcd, 0x00000001, 0x00003435, 0x00006886,
  0x1a584b4f, 0x00000001, 0x000034b3, 0x00006982,
  0x1a96cad2, 0x00000001, 0x00003530, 0x00006a7c,
  0x1a9ecac2, 0x00000001, 0x00003540, 0x00006a9c,
  0x1aa04abf, 0x00000001, 0x00003543, 0x00006aa2,
  0x1aa14abd, 0x00000001, 0x00003545, 0x00006aa6,
  0x003fff80, 0x00000001, 0x00000082, 0x00000120,
  0x007f7f01, 0x00000001, 0x00000101, 0x0000021e,
  0x00be7e83, 0x00000001, 0x0000017f, 0x0000031a,
  0x00fcfe06, 0x00000001, 0x000001fc, 0x00000414,
  0x0104fdf6, 0x00000001, 0x0000020c, 0x00000434,
  0x01067df3, 0x00000001, 0x0000020f, 0x0000043a,
  0x01077df1, 0x00000001, 0x00000211, 0x0000043e,
  0x0107fdf0, 0x00000001, 0x00000212, 0x00000440,
  0x00000000, 0x00000080, 0x00000100, 0x00000810,
  0x00000000, 0x000000fe, 0x000001fc, 0x00000ff0,
  0x00000000, 0x0000017b, 0x000002f6, 0x000017c0,
  0x00000000, 0x0000018b, 0x00000316, 0x000018c0,
  0x00000000, 0x0000018e, 0x0000031c, 0x000018f0,
  0x00000000, 0x00000190, 0x00000320, 0x00001910,
  0x00000000, 0x00000191, 0x00000322, 0x00001920,
  0x00000000, 0x00000191, 0x00000322, 0x00001920,
  0x00000000, 0x0000007f, 0x000000fe, 0x00000800,
  0x00000000, 0x000000fc, 0x000001f8, 0x00000fd0,
  0x00000000, 0x0000010c, 0x00000218, 0x000010d0,
  0x00000000, 0x0000010f, 0x0000021e, 0x00001100,
  0x00000000, 0x00000111, 0x00000222, 0x00001120,
  0x00000000, 0x00000112, 0x00000224, 0x00001130,
  0x00000000, 0x00000112, 0x00000224, 0x00001130,
  0x00000000, 0x00000111, 0x00000222, 0x00001120,
  0x00000000, 0x0000007e, 0x000000fc, 0x000007f0,
  0x00000000, 0x0000008e, 0x0000011c, 0x000008f0,
  0x00000000, 0x00000091, 0x00000122, 0x00000920,
  0x00000000, 0x00000093, 0x00000126, 0x00000940,
  0x00000000, 0x00000094, 0x00000128, 0x00000950,
  0x00000000, 0x00000094, 0x00000128, 0x00000950,
  0x00000000, 0x00000093, 0x00000126, 0x00000940,
  0x00000000, 0x00000091, 0x00000122, 0x00000920,
  0x00000000, 0x00000011, 0x00000022, 0x00000120,
  0x00000000, 0x00000014, 0x00000028, 0x00000150,
  0x00000000, 0x00000016, 0x0000002c, 0x00000170,
  0x00000000, 0x00000017, 0x0000002e, 0x00000180,
  0x00000000, 0x00000017, 0x0000002e, 0x00000180,
  0x00000000, 0x00000016, 0x0000002c, 0x00000170,
  0x00000000, 0x00000014, 0x00000028, 0x00000150,
  0x00000000, 0x00000004, 0x00000008, 0x00000050,
  0x00000000, 0x00000004, 0x00000008, 0x00000050,
  0x00000000, 0x00000006, 0x0000000c, 0x00000070,
  0x00000000, 0x00000007, 0x0000000e, 0x00000080,
  0x00000000, 0x00000007, 0x0000000e, 0x00000080,
  0x00000000, 0x00000006, 0x0000000c, 0x00000070,
  0x00000000, 0x00000004, 0x00000008, 0x00000050,
  0x00000000, 0xfffffff4, 0xffffffe8, 0xffffff50,
  0x00000000, 0xffffff77, 0xfffffeee, 0xfffff780,
  0x00000000, 0x00000003, 0x00000006, 0x00000040,
  0x00000000, 0x00000004, 0x00000008, 0x00000050,
  0x00000000, 0x00000004, 0x00000008, 0x00000050,
  0x00000000, 0x00000003, 0x00000006, 0x00000040,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0xfffffff1, 0xffffffe2, 0xffffff20,
  0x00000000, 0xffffff74, 0xfffffee8, 0xfffff750,
  0x00000000, 0xfffffef6, 0xfffffdec, 0xffffef70,
  0x00000000, 0x00000002, 0x00000004, 0x00000030,
  0x00000000, 0x00000002, 0x00000004, 0x00000030,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0xffffffff, 0xfffffffe, 0x00000000,
  0x00000000, 0xffffffef, 0xffffffde, 0xffffff00,
  0x00000000, 0xffffff72, 0xfffffee4, 0xfffff730,
  0x00000000, 0xfffffef4, 0xfffffde8, 0xffffef50,
  0x00000000, 0xfffffe75, 0xfffffcea, 0xffffe760,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000000, 0x00000000, 0x00000000, 0x00000010,
  0x00000000, 0xfffffffe, 0xfffffffc, 0xfffffff0,
  0x00000000, 0xffffffee, 0xffffffdc, 0xfffffef0,
  0x00000000, 0xffffff71, 0xfffffee2, 0xfffff720,
  0x00000000, 0xfffffef3, 0xfffffde6, 0xffffef40,
  0x00000000, 0xfffffe74, 0xfffffce8, 0xffffe750,
  0x00000000, 0xffffcb41, 0xffff9682, 0xfffcb420,
  0x00000000, 0x00000000, 0x00000000, 0x00000010,
  0x00000000, 0xfffffffe, 0xfffffffc, 0xfffffff0,
  0x00000000, 0xffffffee, 0xffffffdc, 0xfffffef0,
  0x00000000, 0xffffff71, 0xfffffee2, 0xfffff720,
  0x00000000, 0xfffffef3, 0xfffffde6, 0xffffef40,
  0x00000000, 0xfffffe74, 0xfffffce8, 0xffffe750,
  0x00000000, 0xffffcb41, 0xffff9682, 0xfffcb420,
  0x00000000, 0xffff75ec, 0xfffeebd8, 0xfff75ed0,
  0x00000000, 0xffffffff, 0xfffffffe, 0x00000000,
  0x00000000, 0xffffffef, 0xffffffde, 0xffffff00,
  0x00000000, 0xffffff72, 0xfffffee4, 0xfffff730,
  0x00000000, 0xfffffef4, 0xfffffde8, 0xffffef50,
  0x00000000, 0xfffffe75, 0xfffffcea, 0xffffe760,
  0x00000000, 0xffffcb42, 0xffff9684, 0xfffcb430,
  0x00000000, 0xffff75ed, 0xfffeebda, 0xfff75ee0,
  0x00000000, 0xfffef5f0, 0xfffdebe0, 0xffef5f10,
  0x00000000, 0xfffffff1, 0xffffffe2, 0xffffff20,
  0x00000000, 0xffffff74, 0xfffffee8, 0xfffff750,
  0x00000000, 0xfffffef6, 0xfffffdec, 0xffffef70,
  0x00000000, 0xfffffe77, 0xfffffcee, 0xffffe780,
  0x00000000, 0xffffcb44, 0xffff9688, 0xfffcb450,
  0x00000000, 0xffff75ef, 0xfffeebde, 0xfff75f00,
  0x00000000, 0xfffef5f2, 0xfffdebe4, 0xffef5f30,
  0x00000000, 0xfffe75f4, 0xfffcebe8, 0xffe75f50,
  0x00000000, 0xffffff84, 0xffffff08, 0xfffff850,
  0x00000000, 0xffffff06, 0xfffffe0c, 0xfffff070,
  0x00000000, 0xfffffe87, 0xfffffd0e, 0xffffe880,
  0x00000000, 0xffffcb54, 0xffff96a8, 0xfffcb550,
  0x00000000, 0xffff75ff, 0xfffeebfe, 0xfff76000,
  0x00000000, 0xfffef602, 0xfffdec04, 0xffef6030,
  0x00000000, 0xfffe7604, 0xfffcec08, 0xffe76050,
  0x00000000, 0xfffdf605, 0xfffbec0a, 0xffdf6060,
  0x00000000, 0xffffff83, 0xffffff06, 0xfffff840,
  0x00000000, 0xffffff04, 0xfffffe08, 0xfffff050,
  0x00000000, 0xffffcbd1, 0xffff97a2, 0xfffcbd20,
  0x00000000, 0xffff767c, 0xfffeecf8, 0xfff767d0,
  0x00000000, 0xfffef67f, 0xfffdecfe, 0xffef6800,
  0x00000000, 0xfffe7681, 0xfffced02, 0xffe76820,
  0x00000000, 0xfffdf682, 0xfffbed04, 0xffdf6830,
  0x00000000, 0xfffe7682, 0xfffced04, 0xffe76830,
  0x00000000, 0xffffff82, 0xffffff04, 0xfffff830,
  0x00000000, 0xffffcc4f, 0xffff989e, 0xfffcc500,
  0x00000000, 0xffff76fa, 0xfffeedf4, 0xfff76fb0,
  0x00000000, 0xfffef6fd, 0xfffdedfa, 0xffef6fe0,
  0x00000000, 0xfffe76ff, 0xfffcedfe, 0xffe77000,
  0x00000000, 0xfffdf700, 0xfffbee00, 0xffdf7010,
  0x00000000, 0xfffe7700, 0xfffcee00, 0xffe77010,
  0x00000000, 0xfffef6ff, 0xfffdedfe, 0xffef7000,
  0x00000000, 0xffffccce, 0xffff999c, 0xfffcccf0,
  0x00000000, 0xffff7779, 0xfffeeef2, 0xfff777a0,
  0x00000000, 0xfffef77c, 0xfffdeef8, 0xffef77d0,
  0x00000000, 0xfffe777e, 0xfffceefc, 0xffe777f0,
  0x00000000, 0xfffdf77f, 0xfffbeefe, 0xffdf7800,
  0x00000000, 0xfffe777f, 0xfffceefe, 0xffe77800,
  0x00000000, 0xfffef77e, 0xfffdeefc, 0xffef77f0,
  0x00000000, 0xffff4cd4, 0xfffe99a8, 0xfff4cd50,
  0x00000000, 0xffffaaac, 0xffff5558, 0xfffaaad0,
  0x00000000, 0xffff2aaf, 0xfffe555e, 0xfff2ab00,
  0x00000000, 0xfffeaab1, 0xfffd5562, 0xffeaab20,
  0x00000000, 0xfffe2ab2, 0xfffc5564, 0xffe2ab30,
  0x00000000, 0xfffeaab2, 0xfffd5564, 0xffeaab30,
  0x00000000, 0xffff2ab1, 0xfffe5562, 0xfff2ab20,
  0x00000000, 0xffff8007, 0xffff000e, 0xfff80080,
  0x00000000, 0xffffb33b, 0xffff6676, 0xfffb33c0,
  0x00000000, 0xffff8004, 0xffff0008, 0xfff80050,
  0x00000000, 0xffff0006, 0xfffe000c, 0xfff00070,
  0x00000000, 0xfffe8007, 0xfffd000e, 0xffe80080,
  0x00000000, 0xffff0007, 0xfffe000e, 0xfff00080,
  0x00000000, 0xffff8006, 0xffff000c, 0xfff80070,
  0x00000000, 0xffffd55c, 0xffffaab8, 0xfffd55d0,
  0x00000000, 0x00000890, 0x00001120, 0x00008910,
  0x00000000, 0x00000910, 0x00001220, 0x00009110,
  0x00000000, 0xffff8003, 0xffff0006, 0xfff80040,
  0x00000000, 0xffff0004, 0xfffe0008, 0xfff00050,
  0x00000000, 0xffff8004, 0xffff0008, 0xfff80050,
  0x00000000, 0x00000003, 0x00000006, 0x00000040,
  0x00000000, 0x00005559, 0x0000aab2, 0x000555a0,
  0x00000000, 0x0000888d, 0x0001111a, 0x000888e0,
  0x00000000, 0x0000890d, 0x0001121a, 0x000890e0,
  0x00000000, 0x0000898c, 0x00011318, 0x000898d0,
  0x00000000, 0xffff8002, 0xffff0004, 0xfff80030,
  0x00000000, 0x00000002, 0x00000004, 0x00000030,
  0x00000000, 0x00008001, 0x00010002, 0x00080020,
  0x00000000, 0x0000d557, 0x0001aaae, 0x000d5580,
  0x00000000, 0x0001088b, 0x00021116, 0x001088c0,
  0x00000000, 0x0001090b, 0x00021216, 0x001090c0,
  0x00000000, 0x0001098a, 0x00021314, 0x001098b0,
  0x00000000, 0x00010a08, 0x00021410, 0x0010a090,
  0x00000000, 0x00008001, 0x00010002, 0x00080020,
  0x00000000, 0x00010000, 0x00020000, 0x00100010,
  0x00000000, 0x00015556, 0x0002aaac, 0x00155570,
  0x00000000, 0x0001888a, 0x00031114, 0x001888b0,
  0x00000000, 0x0001890a, 0x00031214, 0x001890b0,
  0x00000000, 0x00018989, 0x00031312, 0x001898a0,
  0x00000000, 0x00018a07, 0x0003140e, 0x0018a080,
  0x00000000, 0x00018a84, 0x00031508, 0x0018a850,
  0x00000000, 0x00008000, 0x00010000, 0x00080010,
  0x00000000, 0x0000d556, 0x0001aaac, 0x000d5570,
  0x00000000, 0x0001088a, 0x00021114, 0x001088b0,
  0x00000000, 0x0001090a, 0x00021214, 0x001090b0,
  0x00000000, 0x00010989, 0x00021312, 0x001098a0,
  0x00000000, 0x00010a07, 0x0002140e, 0x0010a080,
  0x00000000, 0x00010a84, 0x00021508, 0x0010a850,
  0x00000000, 0x00010a94, 0x00021528, 0x0010a950,
  0x00000000, 0x00005557, 0x0000aaae, 0x00055580,
  0x00000000, 0x0000888b, 0x00011116, 0x000888c0,
  0x00000000, 0x0000890b, 0x00011216, 0x000890c0,
  0x00000000, 0x0000898a, 0x00011314, 0x000898b0,
  0x00000000, 0x00008a08, 0x00011410, 0x0008a090,
  0x00000000, 0x00008a85, 0x0001150a, 0x0008a860,
  0x00000000, 0x00008a95, 0x0001152a, 0x0008a960,
  0x00000000, 0x00008a98, 0x00011530, 0x0008a990,
  0x00000000, 0x00003335, 0x0000666a, 0x00033360,
  0x00000000, 0x000033b5, 0x0000676a, 0x00033b60,
  0x00000000, 0x00003434, 0x00006868, 0x00034350,
  0x00000000, 0x000034b2, 0x00006964, 0x00034b30,
  0x00000000, 0x0000352f, 0x00006a5e, 0x00035300,
  0x00000000, 0x0000353f, 0x00006a7e, 0x00035400,
  0x00000000, 0x00003542, 0x00006a84, 0x00035430,
  0x00000000, 0x00003544, 0x00006a88, 0x00035450,
  0x00000000, 0x00000081, 0x00000102, 0x00000820,
  0x00000000, 0x00000100, 0x00000200, 0x00001010,
  0x00000000, 0x0000017e, 0x000002fc, 0x000017f0,
  0x00000000, 0x000001fb, 0x000003f6, 0x00001fc0,
  0x00000000, 0x0000020b, 0x00000416, 0x000020c0,
  0x00000000, 0x0000020e, 0x0000041c, 0x000020f0,
  0x00000000, 0x00000210, 0x00000420, 0x00002110,
  0x00000000, 0x00000211, 0x00000422, 0x00002120,
  0x0000007f, 0x000000ff, 0x000007f2, 0x00003e23,
  0x000000fd, 0x000001fb, 0x00000fd2, 0x00007ba9,
  0x0000017a, 0x000002f5, 0x000017a2, 0x0000b8b2,
  0x0000018a, 0x00000315, 0x000018a2, 0x0000c082,
  0x0000018d, 0x0000031b, 0x000018d2, 0x0000c1f9,
  0x0000018f, 0x0000031f, 0x000018f2, 0x0000c2f3,
  0x00000190, 0x00000321, 0x00001902, 0x0000c370,
  0x00000190, 0x00000321, 0x00001902, 0x0000c370,
  0x0000007e, 0x000000fd, 0x000007e2, 0x00003da6,
  0x000000fb, 0x000001f7, 0x00000fb2, 0x00007aaf,
  0x0000010b, 0x00000217, 0x000010b2, 0x0000827f,
  0x0000010e, 0x0000021d, 0x000010e2, 0x000083f6,
  0x00000110, 0x00000221, 0x00001102, 0x000084f0,
  0x00000111, 0x00000223, 0x00001112, 0x0000856d,
  0x00000111, 0x00000223, 0x00001112, 0x0000856d,
  0x00000110, 0x00000221, 0x00001102, 0x000084f0,
  0x0000007d, 0x000000fb, 0x000007d2, 0x00003d29,
  0x0000008d, 0x0000011b, 0x000008d2, 0x000044f9,
  0x00000090, 0x00000121, 0x00000902, 0x00004670,
  0x00000092, 0x00000125, 0x00000922, 0x0000476a,
  0x00000093, 0x00000127, 0x00000932, 0x000047e7,
  0x00000093, 0x00000127, 0x00000932, 0x000047e7,
  0x00000092, 0x00000125, 0x00000922, 0x0000476a,
  0x00000090, 0x00000121, 0x00000902, 0x00004670,
  0x00000010, 0x00000021, 0x00000102, 0x000007f0,
  0x00000013, 0x00000027, 0x00000132, 0x00000967,
  0x00000015, 0x0000002b, 0x00000152, 0x00000a61,
  0x00000016, 0x0000002d, 0x00000162, 0x00000ade,
  0x00000016, 0x0000002d, 0x00000162, 0x00000ade,
  0x00000015, 0x0000002b, 0x00000152, 0x00000a61,
  0x00000013, 0x00000027, 0x00000132, 0x00000967,
  0x00000003, 0x00000007, 0x00000032, 0x00000197,
  0x00000003, 0x00000007, 0x00000032, 0x00000197,
  0x00000005, 0x0000000b, 0x00000052, 0x00000291,
  0x00000006, 0x0000000d, 0x00000062, 0x0000030e,
  0x00000006, 0x0000000d, 0x00000062, 0x0000030e,
  0x00000005, 0x0000000b, 0x00000052, 0x00000291,
  0x00000003, 0x00000007, 0x00000032, 0x00000197,
  0xfffffff3, 0xffffffe7, 0xffffff32, 0xfffff9c7,
  0xffffff76, 0xfffffeed, 0xfffff762, 0xffffbcbe,
  0x00000002, 0x00000005, 0x00000022, 0x0000011a,
  0x00000003, 0x00000007, 0x00000032, 0x00000197,
  0x00000003, 0x00000007, 0x00000032, 0x00000197,
  0x00000002, 0x00000005, 0x00000022, 0x0000011a,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfffffff0, 0xffffffe1, 0xffffff02, 0xfffff850,
  0xffffff73, 0xfffffee7, 0xfffff732, 0xffffbb47,
  0xfffffef5, 0xfffffdeb, 0xffffef52, 0xffff7dc1,
  0x00000001, 0x00000003, 0x00000012, 0x0000009d,
  0x00000001, 0x00000003, 0x00000012, 0x0000009d,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfffffffe, 0xfffffffd, 0xffffffe2, 0xffffff26,
  0xffffffee, 0xffffffdd, 0xfffffee2, 0xfffff756,
  0xffffff71, 0xfffffee3, 0xfffff712, 0xffffba4d,
  0xfffffef3, 0xfffffde7, 0xffffef32, 0xffff7cc7,
  0xfffffe74, 0xfffffce9, 0xffffe742, 0xffff3ec4,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffffffff, 0xffffffff, 0xfffffff2, 0xffffffa3,
  0xfffffffd, 0xfffffffb, 0xffffffd2, 0xfffffea9,
  0xffffffed, 0xffffffdb, 0xfffffed2, 0xfffff6d9,
  0xffffff70, 0xfffffee1, 0xfffff702, 0xffffb9d0,
  0xfffffef2, 0xfffffde5, 0xffffef22, 0xffff7c4a,
  0xfffffe73, 0xfffffce7, 0xffffe732, 0xffff3e47,
  0xffffcb40, 0xffff9681, 0xfffcb402, 0xffe63e60,
  0xffffffff, 0xffffffff, 0xfffffff2, 0xffffffa3,
  0xfffffffd, 0xfffffffb, 0xffffffd2, 0xfffffea9,
  0xffffffed, 0xffffffdb, 0xfffffed2, 0xfffff6d9,
  0xffffff70, 0xfffffee1, 0xfffff702, 0xffffb9d0,
  0xfffffef2, 0xfffffde5, 0xffffef22, 0xffff7c4a,
  0xfffffe73, 0xfffffce7, 0xffffe732, 0xffff3e47,
  0xffffcb40, 0xffff9681, 0xfffcb402, 0xffe63e60,
  0xffff75eb, 0xfffeebd7, 0xfff75eb2, 0xffbc93df,
  0xfffffffe, 0xfffffffd, 0xffffffe2, 0xffffff26,
  0xffffffee, 0xffffffdd, 0xfffffee2, 0xfffff756,
  0xffffff71, 0xfffffee3, 0xfffff712, 0xffffba4d,
  0xfffffef3, 0xfffffde7, 0xffffef32, 0xffff7cc7,
  0xfffffe74, 0xfffffce9, 0xffffe742, 0xffff3ec4,
  0xffffcb41, 0xffff9683, 0xfffcb412, 0xffe63edd,
  0xffff75ec, 0xfffeebd9, 0xfff75ec2, 0xffbc945c,
  0xfffef5ef, 0xfffdebdf, 0xffef5ef2, 0xff7e15d3,
  0xfffffff0, 0xffffffe1, 0xffffff02, 0xfffff850,
  0xffffff73, 0xfffffee7, 0xfffff732, 0xffffbb47,
  0xfffffef5, 0xfffffdeb, 0xffffef52, 0xffff7dc1,
  0xfffffe76, 0xfffffced, 0xffffe762, 0xffff3fbe,
  0xffffcb43, 0xffff9687, 0xfffcb432, 0xffe63fd7,
  0xffff75ee, 0xfffeebdd, 0xfff75ee2, 0xffbc9556,
  0xfffef5f1, 0xfffdebe3, 0xffef5f12, 0xff7e16cd,
  0xfffe75f3, 0xfffcebe7, 0xffe75f32, 0xff3f97c7,
  0xffffff83, 0xffffff07, 0xfffff832, 0xffffc317,
  0xffffff05, 0xfffffe0b, 0xfffff052, 0xffff8591,
  0xfffffe86, 0xfffffd0d, 0xffffe862, 0xffff478e,
  0xffffcb53, 0xffff96a7, 0xfffcb532, 0xffe647a7,
  0xffff75fe, 0xfffeebfd, 0xfff75fe2, 0xffbc9d26,
  0xfffef601, 0xfffdec03, 0xffef6012, 0xff7e1e9d,
  0xfffe7603, 0xfffcec07, 0xffe76032, 0xff3f9f97,
  0xfffdf604, 0xfffbec09, 0xffdf6042, 0xff012014,
  0xffffff82, 0xffffff05, 0xfffff822, 0xffffc29a,
  0xffffff03, 0xfffffe07, 0xfffff032, 0xffff8497,
  0xffffcbd0, 0xffff97a1, 0xfffcbd02, 0xffe684b0,
  0xffff767b, 0xfffeecf7, 0xfff767b2, 0xffbcda2f,
  0xfffef67e, 0xfffdecfd, 0xffef67e2, 0xff7e5ba6,
  0xfffe7680, 0xfffced01, 0xffe76802, 0xff3fdca0,
  0xfffdf681, 0xfffbed03, 0xffdf6812, 0xff015d1d,
  0xfffe7681, 0xfffced03, 0xffe76812, 0xff3fdd1d,
  0xffffff81, 0xffffff03, 0xfffff812, 0xffffc21d,
  0xffffcc4e, 0xffff989d, 0xfffcc4e2, 0xffe6c236,
  0xffff76f9, 0xfffeedf3, 0xfff76f92, 0xffbd17b5,
  0xfffef6fc, 0xfffdedf9, 0xffef6fc2, 0xff7e992c,
  0xfffe76fe, 0xfffcedfd, 0xffe76fe2, 0xff401a26,
  0xfffdf6ff, 0xfffbedff, 0xffdf6ff2, 0xff019aa3,
  0xfffe76ff, 0xfffcedff, 0xffe76ff2, 0xff401aa3,
  0xfffef6fe, 0xfffdedfd, 0xffef6fe2, 0xff7e9a26,
  0xffffcccd, 0xffff999b, 0xfffcccd2, 0xffe70039,
  0xffff7778, 0xfffeeef1, 0xfff77782, 0xffbd55b8,
  0xfffef77b, 0xfffdeef7, 0xffef77b2, 0xff7ed72f,
  0xfffe777d, 0xfffceefb, 0xffe777d2, 0xff405829,
  0xfffdf77e, 0xfffbeefd, 0xffdf77e2, 0xff01d8a6,
  0xfffe777e, 0xfffceefd, 0xffe777e2, 0xff4058a6,
  0xfffef77d, 0xfffdeefb, 0xffef77d2, 0xff7ed829,
  0xffff4cd3, 0xfffe99a7, 0xfff4cd32, 0xffa88327,
  0xffffaaab, 0xffff5557, 0xfffaaab2, 0xffd6559f,
  0xffff2aae, 0xfffe555d, 0xfff2aae2, 0xff97d716,
  0xfffeaab0, 0xfffd5561, 0xffeaab02, 0xff595810,
  0xfffe2ab1, 0xfffc5563, 0xffe2ab12, 0xff1ad88d,
  0xfffeaab1, 0xfffd5563, 0xffeaab12, 0xff59588d,
  0xffff2ab0, 0xfffe5561, 0xfff2ab02, 0xff97d810,
  0xffff8006, 0xffff000d, 0xfff80062, 0xffc1830e,
  0xffffb33a, 0xffff6675, 0xfffb33a2, 0xffda8372,
  0xffff8003, 0xffff0007, 0xfff80032, 0xffc18197,
  0xffff0005, 0xfffe000b, 0xfff00052, 0xff830291,
  0xfffe8006, 0xfffd000d, 0xffe80062, 0xff44830e,
  0xffff0006, 0xfffe000d, 0xfff00062, 0xff83030e,
  0xffff8005, 0xffff000b, 0xfff80052, 0xffc18291,
  0xffffd55b, 0xffffaab7, 0xfffd55b2, 0xffeb2d8f,
  0x0000088f, 0x0000111f, 0x000088f2, 0x00042df3,
  0x0000090f, 0x0000121f, 0x000090f2, 0x00046c73,
  0xffff8002, 0xffff0005, 0xfff80022, 0xffc1811a,
  0xffff0003, 0xfffe0007, 0xfff00032, 0xff830197,
  0xffff8003, 0xffff0007, 0xfff80032, 0xffc18197,
  0x00000002, 0x00000005, 0x00000022, 0x0000011a,
  0x00005558, 0x0000aab1, 0x00055582, 0x0029ac18,
  0x0000888c, 0x00011119, 0x000888c2, 0x0042ac7c,
  0x0000890c, 0x00011219, 0x000890c2, 0x0042eafc,
  0x0000898b, 0x00011317, 0x000898b2, 0x004328ff,
  0xffff8001, 0xffff0003, 0xfff80012, 0xffc1809d,
  0x00000001, 0x00000003, 0x00000012, 0x0000009d,
  0x00008000, 0x00010001, 0x00080002, 0x003e8020,
  0x0000d556, 0x0001aaad, 0x000d5562, 0x00682b1e,
  0x0001088a, 0x00021115, 0x001088a2, 0x00812b82,
  0x0001090a, 0x00021215, 0x001090a2, 0x00816a02,
  0x00010989, 0x00021313, 0x00109892, 0x0081a805,
  0x00010a07, 0x0002140f, 0x0010a072, 0x0081e58b,
  0x00008000, 0x00010001, 0x00080002, 0x003e8020,
  0x0000ffff, 0x0001ffff, 0x000ffff2, 0x007cffa3,
  0x00015555, 0x0002aaab, 0x00155552, 0x00a6aaa1,
  0x00018889, 0x00031113, 0x00188892, 0x00bfab05,
  0x00018909, 0x00031213, 0x00189092, 0x00bfe985,
  0x00018988, 0x00031311, 0x00189882, 0x00c02788,
  0x00018a06, 0x0003140d, 0x0018a062, 0x00c0650e,
  0x00018a83, 0x00031507, 0x0018a832, 0x00c0a217,
  0x00007fff, 0x0000ffff, 0x0007fff2, 0x003e7fa3,
  0x0000d555, 0x0001aaab, 0x000d5552, 0x00682aa1,
  0x00010889, 0x00021113, 0x00108892, 0x00812b05,
  0x00010909, 0x00021213, 0x00109092, 0x00816985,
  0x00010988, 0x00021311, 0x00109882, 0x0081a788,
  0x00010a06, 0x0002140d, 0x0010a062, 0x0081e50e,
  0x00010a83, 0x00021507, 0x0010a832, 0x00822217,
  0x00010a93, 0x00021527, 0x0010a932, 0x008229e7,
  0x00005556, 0x0000aaad, 0x00055562, 0x0029ab1e,
  0x0000888a, 0x00011115, 0x000888a2, 0x0042ab82,
  0x0000890a, 0x00011215, 0x000890a2, 0x0042ea02,
  0x00008989, 0x00011313, 0x00089892, 0x00432805,
  0x00008a07, 0x0001140f, 0x0008a072, 0x0043658b,
  0x00008a84, 0x00011509, 0x0008a842, 0x0043a294,
  0x00008a94, 0x00011529, 0x0008a942, 0x0043aa64,
  0x00008a97, 0x0001152f, 0x0008a972, 0x0043abdb,
  0x00003334, 0x00006669, 0x00033342, 0x00190084,
  0x000033b4, 0x00006769, 0x00033b42, 0x00193f04,
  0x00003433, 0x00006867, 0x00034332, 0x00197d07,
  0x000034b1, 0x00006963, 0x00034b12, 0x0019ba8d,
  0x0000352e, 0x00006a5d, 0x000352e2, 0x0019f796,
  0x0000353e, 0x00006a7d, 0x000353e2, 0x0019ff66,
  0x00003541, 0x00006a83, 0x00035412, 0x001a00dd,
  0x00003543, 0x00006a87, 0x00035432, 0x001a01d7,
  0x00000080, 0x00000101, 0x00000802, 0x00003ea0,
  0x000000ff, 0x000001ff, 0x00000ff2, 0x00007ca3,
  0x0000017d, 0x000002fb, 0x000017d2, 0x0000ba29,
  0x000001fa, 0x000003f5, 0x00001fa2, 0x0000f732,
  0x0000020a, 0x00000415, 0x000020a2, 0x0000ff02,
  0x0000020d, 0x0000041b, 0x000020d2, 0x00010079,
  0x0000020f, 0x0000041f, 0x000020f2, 0x00010173,
  0x00000210, 0x00000421, 0x00002102, 0x000101f0,
  0x000000fe, 0x000007f1, 0x00003e05, 0x00003ea2,
  0x000001fa, 0x00000fd1, 0x00007b8b, 0x00007ca6,
  0x000002f4, 0x000017a1, 0x0000b894, 0x0000ba2c,
  0x00000314, 0x000018a1, 0x0000c064, 0x0000c20c,
  0x0000031a, 0x000018d1, 0x0000c1db, 0x0000c386,
  0x0000031e, 0x000018f1, 0x0000c2d5, 0x0000c482,
  0x00000320, 0x00001901, 0x0000c352, 0x0000c500,
  0x00000320, 0x00001901, 0x0000c352, 0x0000c500,
  0x000000fc, 0x000007e1, 0x00003d88, 0x00003e24,
  0x000001f6, 0x00000fb1, 0x00007a91, 0x00007baa,
  0x00000216, 0x000010b1, 0x00008261, 0x0000838a,
  0x0000021c, 0x000010e1, 0x000083d8, 0x00008504,
  0x00000220, 0x00001101, 0x000084d2, 0x00008600,
  0x00000222, 0x00001111, 0x0000854f, 0x0000867e,
  0x00000222, 0x00001111, 0x0000854f, 0x0000867e,
  0x00000220, 0x00001101, 0x000084d2, 0x00008600,
  0x000000fa, 0x000007d1, 0x00003d0b, 0x00003da6,
  0x0000011a, 0x000008d1, 0x000044db, 0x00004586,
  0x00000120, 0x00000901, 0x00004652, 0x00004700,
  0x00000124, 0x00000921, 0x0000474c, 0x000047fc,
  0x00000126, 0x00000931, 0x000047c9, 0x0000487a,
  0x00000126, 0x00000931, 0x000047c9, 0x0000487a,
  0x00000124, 0x00000921, 0x0000474c, 0x000047fc,
  0x00000120, 0x00000901, 0x00004652, 0x00004700,
  0x00000020, 0x00000101, 0x000007d2, 0x00000800,
  0x00000026, 0x00000131, 0x00000949, 0x0000097a,
  0x0000002a, 0x00000151, 0x00000a43, 0x00000a76,
  0x0000002c, 0x00000161, 0x00000ac0, 0x00000af4,
  0x0000002c, 0x00000161, 0x00000ac0, 0x00000af4,
  0x0000002a, 0x00000151, 0x00000a43, 0x00000a76,
  0x00000026, 0x00000131, 0x00000949, 0x0000097a,
  0x00000006, 0x00000031, 0x00000179, 0x0000019a,
  0x00000006, 0x00000031, 0x00000179, 0x0000019a,
  0x0000000a, 0x00000051, 0x00000273, 0x00000296,
  0x0000000c, 0x00000061, 0x000002f0, 0x00000314,
  0x0000000c, 0x00000061, 0x000002f0, 0x00000314,
  0x0000000a, 0x00000051, 0x00000273, 0x00000296,
  0x00000006, 0x00000031, 0x00000179, 0x0000019a,
  0xffffffe6, 0xffffff31, 0xfffff9a9, 0xfffff9ba,
  0xfffffeec, 0xfffff761, 0xffffbca0, 0xffffbc34,
  0x00000004, 0x00000021, 0x000000fc, 0x0000011c,
  0x00000006, 0x00000031, 0x00000179, 0x0000019a,
  0x00000006, 0x00000031, 0x00000179, 0x0000019a,
  0x00000004, 0x00000021, 0x000000fc, 0x0000011c,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffffffe0, 0xffffff01, 0xfffff832, 0xfffff840,
  0xfffffee6, 0xfffff731, 0xffffbb29, 0xffffbaba,
  0xfffffdea, 0xffffef51, 0xffff7da3, 0xffff7cb6,
  0x00000002, 0x00000011, 0x0000007f, 0x0000009e,
  0x00000002, 0x00000011, 0x0000007f, 0x0000009e,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfffffffc, 0xffffffe1, 0xffffff08, 0xffffff24,
  0xffffffdc, 0xfffffee1, 0xfffff738, 0xfffff744,
  0xfffffee2, 0xfffff711, 0xffffba2f, 0xffffb9be,
  0xfffffde6, 0xffffef31, 0xffff7ca9, 0xffff7bba,
  0xfffffce8, 0xffffe741, 0xffff3ea6, 0xffff3d38,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfffffffe, 0xfffffff1, 0xffffff85, 0xffffffa2,
  0xfffffffa, 0xffffffd1, 0xfffffe8b, 0xfffffea6,
  0xffffffda, 0xfffffed1, 0xfffff6bb, 0xfffff6c6,
  0xfffffee0, 0xfffff701, 0xffffb9b2, 0xffffb940,
  0xfffffde4, 0xffffef21, 0xffff7c2c, 0xffff7b3c,
  0xfffffce6, 0xffffe731, 0xffff3e29, 0xffff3cba,
  0xffff9680, 0xfffcb401, 0xffe63e42, 0xffe609a0,
  0xfffffffe, 0xfffffff1, 0xffffff85, 0xffffffa2,
  0xfffffffa, 0xffffffd1, 0xfffffe8b, 0xfffffea6,
  0xffffffda, 0xfffffed1, 0xfffff6bb, 0xfffff6c6,
  0xfffffee0, 0xfffff701, 0xffffb9b2, 0xffffb940,
  0xfffffde4, 0xffffef21, 0xffff7c2c, 0xffff7b3c,
  0xfffffce6, 0xffffe731, 0xffff3e29, 0xffff3cba,
  0xffff9680, 0xfffcb401, 0xffe63e42, 0xffe609a0,
  0xfffeebd6, 0xfff75eb1, 0xffbc93c1, 0xffbc09ca,
  0xfffffffc, 0xffffffe1, 0xffffff08, 0xffffff24,
  0xffffffdc, 0xfffffee1, 0xfffff738, 0xfffff744,
  0xfffffee2, 0xfffff711, 0xffffba2f, 0xffffb9be,
  0xfffffde6, 0xffffef31, 0xffff7ca9, 0xffff7bba,
  0xfffffce8, 0xffffe741, 0xffff3ea6, 0xffff3d38,
  0xffff9682, 0xfffcb411, 0xffe63ebf, 0xffe60a1e,
  0xfffeebd8, 0xfff75ec1, 0xffbc943e, 0xffbc0a48,
  0xfffdebde, 0xffef5ef1, 0xff7e15b5, 0xff7d0bc2,
  0xffffffe0, 0xffffff01, 0xfffff832, 0xfffff840,
  0xfffffee6, 0xfffff731, 0xffffbb29, 0xffffbaba,
  0xfffffdea, 0xffffef51, 0xffff7da3, 0xffff7cb6,
  0xfffffcec, 0xffffe761, 0xffff3fa0, 0xffff3e34,
  0xffff9686, 0xfffcb431, 0xffe63fb9, 0xffe60b1a,
  0xfffeebdc, 0xfff75ee1, 0xffbc9538, 0xffbc0b44,
  0xfffdebe2, 0xffef5f11, 0xff7e16af, 0xff7d0cbe,
  0xfffcebe6, 0xffe75f31, 0xff3f97a9, 0xff3e0dba,
  0xffffff06, 0xfffff831, 0xffffc2f9, 0xffffc29a,
  0xfffffe0a, 0xfffff051, 0xffff8573, 0xffff8496,
  0xfffffd0c, 0xffffe861, 0xffff4770, 0xffff4614,
  0xffff96a6, 0xfffcb531, 0xffe64789, 0xffe612fa,
  0xfffeebfc, 0xfff75fe1, 0xffbc9d08, 0xffbc1324,
  0xfffdec02, 0xffef6011, 0xff7e1e7f, 0xff7d149e,
  0xfffcec06, 0xffe76031, 0xff3f9f79, 0xff3e159a,
  0xfffbec08, 0xffdf6041, 0xff011ff6, 0xfeff1618,
  0xffffff04, 0xfffff821, 0xffffc27c, 0xffffc21c,
  0xfffffe06, 0xfffff031, 0xffff8479, 0xffff839a,
  0xffff97a0, 0xfffcbd01, 0xffe68492, 0xffe65080,
  0xfffeecf6, 0xfff767b1, 0xffbcda11, 0xffbc50aa,
  0xfffdecfc, 0xffef67e1, 0xff7e5b88, 0xff7d5224,
  0xfffced00, 0xffe76801, 0xff3fdc82, 0xff3e5320,
  0xfffbed02, 0xffdf6811, 0xff015cff, 0xfeff539e,
  0xfffced02, 0xffe76811, 0xff3fdcff, 0xff3e539e,
  0xffffff02, 0xfffff811, 0xffffc1ff, 0xffffc19e,
  0xffff989c, 0xfffcc4e1, 0xffe6c218, 0xffe68e84,
  0xfffeedf2, 0xfff76f91, 0xffbd1797, 0xffbc8eae,
  0xfffdedf8, 0xffef6fc1, 0xff7e990e, 0xff7d9028,
  0xfffcedfc, 0xffe76fe1, 0xff401a08, 0xff3e9124,
  0xfffbedfe, 0xffdf6ff1, 0xff019a85, 0xfeff91a2,
  0xfffcedfe, 0xffe76ff1, 0xff401a85, 0xff3e91a2,
  0xfffdedfc, 0xffef6fe1, 0xff7e9a08, 0xff7d9124,
  0xffff999a, 0xfffcccd1, 0xffe7001b, 0xffe6cd06,
  0xfffeeef0, 0xfff77781, 0xffbd559a, 0xffbccd30,
  0xfffdeef6, 0xffef77b1, 0xff7ed711, 0xff7dceaa,
  0xfffceefa, 0xffe777d1, 0xff40580b, 0xff3ecfa6,
  0xfffbeefc, 0xffdf77e1, 0xff01d888, 0xfeffd024,
  0xfffceefc, 0xffe777e1, 0xff405888, 0xff3ed024,
  0xfffdeefa, 0xffef77d1, 0xff7ed80b, 0xff7dcfa6,
  0xfffe99a6, 0xfff4cd31, 0xffa88309, 0xffa7cffa,
  0xffff5556, 0xfffaaab1, 0xffd65581, 0xffd6004a,
  0xfffe555c, 0xfff2aae1, 0xff97d6f8, 0xff9701c4,
  0xfffd5560, 0xffeaab01, 0xff5957f2, 0xff5802c0,
  0xfffc5562, 0xffe2ab11, 0xff1ad86f, 0xff19033e,
  0xfffd5562, 0xffeaab11, 0xff59586f, 0xff58033e,
  0xfffe5560, 0xfff2ab01, 0xff97d7f2, 0xff9702c0,
  0xffff000c, 0xfff80061, 0xffc182f0, 0xffc10314,
  0xffff6674, 0xfffb33a1, 0xffda8354, 0xffda36ac,
  0xffff0006, 0xfff80031, 0xffc18179, 0xffc1019a,
  0xfffe000a, 0xfff00051, 0xff830273, 0xff820296,
  0xfffd000c, 0xffe80061, 0xff4482f0, 0xff430314,
  0xfffe000c, 0xfff00061, 0xff8302f0, 0xff820314,
  0xffff000a, 0xfff80051, 0xffc18273, 0xffc10296,
  0xffffaab6, 0xfffd55b1, 0xffeb2d71, 0xffeb02ea,
  0x0000111e, 0x000088f1, 0x00042dd5, 0x00043682,
  0x0000121e, 0x000090f1, 0x00046c55, 0x00047582,
  0xffff0004, 0xfff80021, 0xffc180fc, 0xffc1011c,
  0xfffe0006, 0xfff00031, 0xff830179, 0xff82019a,
  0xffff0006, 0xfff80031, 0xffc18179, 0xffc1019a,
  0x00000004, 0x00000021, 0x000000fc, 0x0000011c,
  0x0000aab0, 0x00055581, 0x0029abfa, 0x002a0170,
  0x00011118, 0x000888c1, 0x0042ac5e, 0x00433508,
  0x00011218, 0x000890c1, 0x0042eade, 0x00437408,
  0x00011316, 0x000898b1, 0x004328e1, 0x0043b28a,
  0xffff0002, 0xfff80011, 0xffc1807f, 0xffc1009e,
  0x00000002, 0x00000011, 0x0000007f, 0x0000009e,
  0x00010000, 0x00080001, 0x003e8002, 0x003f0020,
  0x0001aaac, 0x000d5561, 0x00682b00, 0x00690074,
  0x00021114, 0x001088a1, 0x00812b64, 0x0082340c,
  0x00021214, 0x001090a1, 0x008169e4, 0x0082730c,
  0x00021312, 0x00109891, 0x0081a7e7, 0x0082b18e,
  0x0002140e, 0x0010a071, 0x0081e56d, 0x0082ef92,
  0x00010000, 0x00080001, 0x003e8002, 0x003f0020,
  0x0001fffe, 0x000ffff1, 0x007cff85, 0x007dffa2,
  0x0002aaaa, 0x00155551, 0x00a6aa83, 0x00a7fff6,
  0x00031112, 0x00188891, 0x00bfaae7, 0x00c1338e,
  0x00031212, 0x00189091, 0x00bfe967, 0x00c1728e,
  0x00031310, 0x00189881, 0x00c0276a, 0x00c1b110,
  0x0003140c, 0x0018a061, 0x00c064f0, 0x00c1ef14,
  0x00031506, 0x0018a831, 0x00c0a1f9, 0x00c22c9a,
  0x0000fffe, 0x0007fff1, 0x003e7f85, 0x003effa2,
  0x0001aaaa, 0x000d5551, 0x00682a83, 0x0068fff6,
  0x00021112, 0x00108891, 0x00812ae7, 0x0082338e,
  0x00021212, 0x00109091, 0x00816967, 0x0082728e,
  0x00021310, 0x00109881, 0x0081a76a, 0x0082b110,
  0x0002140c, 0x0010a061, 0x0081e4f0, 0x0082ef14,
  0x00021506, 0x0010a831, 0x008221f9, 0x00832c9a,
  0x00021526, 0x0010a931, 0x008229c9, 0x0083347a,
  0x0000aaac, 0x00055561, 0x0029ab00, 0x002a0074,
  0x00011114, 0x000888a1, 0x0042ab64, 0x0043340c,
  0x00011214, 0x000890a1, 0x0042e9e4, 0x0043730c,
  0x00011312, 0x00089891, 0x004327e7, 0x0043b18e,
  0x0001140e, 0x0008a071, 0x0043656d, 0x0043ef92,
  0x00011508, 0x0008a841, 0x0043a276, 0x00442d18,
  0x00011528, 0x0008a941, 0x0043aa46, 0x004434f8,
  0x0001152e, 0x0008a971, 0x0043abbd, 0x00443672,
  0x00006668, 0x00033341, 0x00190066, 0x001933b8,
  0x00006768, 0x00033b41, 0x00193ee6, 0x001972b8,
  0x00006866, 0x00034331, 0x00197ce9, 0x0019b13a,
  0x00006962, 0x00034b11, 0x0019ba6f, 0x0019ef3e,
  0x00006a5c, 0x000352e1, 0x0019f778, 0x001a2cc4,
  0x00006a7c, 0x000353e1, 0x0019ff48, 0x001a34a4,
  0x00006a82, 0x00035411, 0x001a00bf, 0x001a361e,
  0x00006a86, 0x00035431, 0x001a01b9, 0x001a371a,
  0x00000100, 0x00000801, 0x00003e82, 0x00003f20,
  0x000001fe, 0x00000ff1, 0x00007c85, 0x00007da2,
  0x000002fa, 0x000017d1, 0x0000ba0b, 0x0000bba6,
  0x000003f4, 0x00001fa1, 0x0000f714, 0x0000f92c,
  0x00000414, 0x000020a1, 0x0000fee4, 0x0001010c,
  0x0000041a, 0x000020d1, 0x0001005b, 0x00010286,
  0x0000041e, 0x000020f1, 0x00010155, 0x00010382,
  0x00000420, 0x00002101, 0x000101d2, 0x00010400,
  0x000007f0, 0x00003e04, 0x00003e84, 0x00003f21,
  0x00000fd0, 0x00007b8a, 0x00007c88, 0x00007da3,
  0x000017a0, 0x0000b893, 0x0000ba0e, 0x0000bba6,
  0x000018a0, 0x0000c063, 0x0000c1ee, 0x0000c396,
  0x000018d0, 0x0000c1da, 0x0000c368, 0x0000c513,
  0x000018f0, 0x0000c2d4, 0x0000c464, 0x0000c611,
  0x00001900, 0x0000c351, 0x0000c4e2, 0x0000c690,
  0x00001900, 0x0000c351, 0x0000c4e2, 0x0000c690,
  0x000007e0, 0x00003d87, 0x00003e06, 0x00003ea2,
  0x00000fb0, 0x00007a90, 0x00007b8c, 0x00007ca5,
  0x000010b0, 0x00008260, 0x0000836c, 0x00008495,
  0x000010e0, 0x000083d7, 0x000084e6, 0x00008612,
  0x00001100, 0x000084d1, 0x000085e2, 0x00008710,
  0x00001110, 0x0000854e, 0x00008660, 0x0000878f,
  0x00001110, 0x0000854e, 0x00008660, 0x0000878f,
  0x00001100, 0x000084d1, 0x000085e2, 0x00008710,
  0x000007d0, 0x00003d0a, 0x00003d88, 0x00003e23,
  0x000008d0, 0x000044da, 0x00004568, 0x00004613,
  0x00000900, 0x00004651, 0x000046e2, 0x00004790,
  0x00000920, 0x0000474b, 0x000047de, 0x0000488e,
  0x00000930, 0x000047c8, 0x0000485c, 0x0000490d,
  0x00000930, 0x000047c8, 0x0000485c, 0x0000490d,
  0x00000920, 0x0000474b, 0x000047de, 0x0000488e,
  0x00000900, 0x00004651, 0x000046e2, 0x00004790,
  0x00000100, 0x000007d1, 0x000007e2, 0x00000810,
  0x00000130, 0x00000948, 0x0000095c, 0x0000098d,
  0x00000150, 0x00000a42, 0x00000a58, 0x00000a8b,
  0x00000160, 0x00000abf, 0x00000ad6, 0x00000b0a,
  0x00000160, 0x00000abf, 0x00000ad6, 0x00000b0a,
  0x00000150, 0x00000a42, 0x00000a58, 0x00000a8b,
  0x00000130, 0x00000948, 0x0000095c, 0x0000098d,
  0x00000030, 0x00000178, 0x0000017c, 0x0000019d,
  0x00000030, 0x00000178, 0x0000017c, 0x0000019d,
  0x00000050, 0x00000272, 0x00000278, 0x0000029b,
  0x00000060, 0x000002ef, 0x000002f6, 0x0000031a,
  0x00000060, 0x000002ef, 0x000002f6, 0x0000031a,
  0x00000050, 0x00000272, 0x00000278, 0x0000029b,
  0x00000030, 0x00000178, 0x0000017c, 0x0000019d,
  0xffffff30, 0xfffff9a8, 0xfffff99c, 0xfffff9ad,
  0xfffff760, 0xffffbc9f, 0xffffbc16, 0xffffbbaa,
  0x00000020, 0x000000fb, 0x000000fe, 0x0000011e,
  0x00000030, 0x00000178, 0x0000017c, 0x0000019d,
  0x00000030, 0x00000178, 0x0000017c, 0x0000019d,
  0x00000020, 0x000000fb, 0x000000fe, 0x0000011e,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffffff00, 0xfffff831, 0xfffff822, 0xfffff830,
  0xfffff730, 0xffffbb28, 0xffffba9c, 0xffffba2d,
  0xffffef50, 0xffff7da2, 0xffff7c98, 0xffff7bab,
  0x00000010, 0x0000007e, 0x00000080, 0x0000009f,
  0x00000010, 0x0000007e, 0x00000080, 0x0000009f,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffffffe0, 0xffffff07, 0xffffff06, 0xffffff22,
  0xfffffee0, 0xfffff737, 0xfffff726, 0xfffff732,
  0xfffff710, 0xffffba2e, 0xffffb9a0, 0xffffb92f,
  0xffffef30, 0xffff7ca8, 0xffff7b9c, 0xffff7aad,
  0xffffe740, 0xffff3ea5, 0xffff3d1a, 0xffff3bac,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfffffff0, 0xffffff84, 0xffffff84, 0xffffffa1,
  0xffffffd0, 0xfffffe8a, 0xfffffe88, 0xfffffea3,
  0xfffffed0, 0xfffff6ba, 0xfffff6a8, 0xfffff6b3,
  0xfffff700, 0xffffb9b1, 0xffffb922, 0xffffb8b0,
  0xffffef20, 0xffff7c2b, 0xffff7b1e, 0xffff7a2e,
  0xffffe730, 0xffff3e28, 0xffff3c9c, 0xffff3b2d,
  0xfffcb400, 0xffe63e41, 0xffe60982, 0xffe5d4e0,
  0xfffffff0, 0xffffff84, 0xffffff84, 0xffffffa1,
  0xffffffd0, 0xfffffe8a, 0xfffffe88, 0xfffffea3,
  0xfffffed0, 0xfffff6ba, 0xfffff6a8, 0xfffff6b3,
  0xfffff700, 0xffffb9b1, 0xffffb922, 0xffffb8b0,
  0xffffef20, 0xffff7c2b, 0xffff7b1e, 0xffff7a2e,
  0xffffe730, 0xffff3e28, 0xffff3c9c, 0xffff3b2d,
  0xfffcb400, 0xffe63e41, 0xffe60982, 0xffe5d4e0,
  0xfff75eb0, 0xffbc93c0, 0xffbc09ac, 0xffbb7fb5,
  0xffffffe0, 0xffffff07, 0xffffff06, 0xffffff22,
  0xfffffee0, 0xfffff737, 0xfffff726, 0xfffff732,
  0xfffff710, 0xffffba2e, 0xffffb9a0, 0xffffb92f,
  0xffffef30, 0xffff7ca8, 0xffff7b9c, 0xffff7aad,
  0xffffe740, 0xffff3ea5, 0xffff3d1a, 0xffff3bac,
  0xfffcb410, 0xffe63ebe, 0xffe60a00, 0xffe5d55f,
  0xfff75ec0, 0xffbc943d, 0xffbc0a2a, 0xffbb8034,
  0xffef5ef0, 0xff7e15b4, 0xff7d0ba4, 0xff7c01b1,
  0xffffff00, 0xfffff831, 0xfffff822, 0xfffff830,
  0xfffff730, 0xffffbb28, 0xffffba9c, 0xffffba2d,
  0xffffef50, 0xffff7da2, 0xffff7c98, 0xffff7bab,
  0xffffe760, 0xffff3f9f, 0xffff3e16, 0xffff3caa,
  0xfffcb430, 0xffe63fb8, 0xffe60afc, 0xffe5d65d,
  0xfff75ee0, 0xffbc9537, 0xffbc0b26, 0xffbb8132,
  0xffef5f10, 0xff7e16ae, 0xff7d0ca0, 0xff7c02af,
  0xffe75f30, 0xff3f97a8, 0xff3e0d9c, 0xff3c83ad,
  0xfffff830, 0xffffc2f8, 0xffffc27c, 0xffffc21d,
  0xfffff050, 0xffff8572, 0xffff8478, 0xffff839b,
  0xffffe860, 0xffff476f, 0xffff45f6, 0xffff449a,
  0xfffcb530, 0xffe64788, 0xffe612dc, 0xffe5de4d,
  0xfff75fe0, 0xffbc9d07, 0xffbc1306, 0xffbb8922,
  0xffef6010, 0xff7e1e7e, 0xff7d1480, 0xff7c0a9f,
  0xffe76030, 0xff3f9f78, 0xff3e157c, 0xff3c8b9d,
  0xffdf6040, 0xff011ff5, 0xfeff15fa, 0xfefd0c1c,
  0xfffff820, 0xffffc27b, 0xffffc1fe, 0xffffc19e,
  0xfffff030, 0xffff8478, 0xffff837c, 0xffff829d,
  0xfffcbd00, 0xffe68491, 0xffe65062, 0xffe61c50,
  0xfff767b0, 0xffbcda10, 0xffbc508c, 0xffbbc725,
  0xffef67e0, 0xff7e5b87, 0xff7d5206, 0xff7c48a2,
  0xffe76800, 0xff3fdc81, 0xff3e5302, 0xff3cc9a0,
  0xffdf6810, 0xff015cfe, 0xfeff5380, 0xfefd4a1f,
  0xffe76810, 0xff3fdcfe, 0xff3e5380, 0xff3cca1f,
  0xfffff810, 0xffffc1fe, 0xffffc180, 0xffffc11f,
  0xfffcc4e0, 0xffe6c217, 0xffe68e66, 0xffe65ad2,
  0xfff76f90, 0xffbd1796, 0xffbc8e90, 0xffbc05a7,
  0xffef6fc0, 0xff7e990d, 0xff7d900a, 0xff7c8724,
  0xffe76fe0, 0xff401a07, 0xff3e9106, 0xff3d0822,
  0xffdf6ff0, 0xff019a84, 0xfeff9184, 0xfefd88a1,
  0xffe76ff0, 0xff401a84, 0xff3e9184, 0xff3d08a1,
  0xffef6fe0, 0xff7e9a07, 0xff7d9106, 0xff7c8822,
  0xfffcccd0, 0xffe7001a, 0xffe6cce8, 0xffe699d3,
  0xfff77780, 0xffbd5599, 0xffbccd12, 0xffbc44a8,
  0xffef77b0, 0xff7ed710, 0xff7dce8c, 0xff7cc625,
  0xffe777d0, 0xff40580a, 0xff3ecf88, 0xff3d4723,
  0xffdf77e0, 0xff01d887, 0xfeffd006, 0xfefdc7a2,
  0xffe777e0, 0xff405887, 0xff3ed006, 0xff3d47a2,
  0xffef77d0, 0xff7ed80a, 0xff7dcf88, 0xff7cc723,
  0xfff4cd30, 0xffa88308, 0xffa7cfdc, 0xffa71ccd,
  0xfffaaab0, 0xffd65580, 0xffd6002c, 0xffd5aaf5,
  0xfff2aae0, 0xff97d6f7, 0xff9701a6, 0xff962c72,
  0xffeaab00, 0xff5957f1, 0xff5802a2, 0xff56ad70,
  0xffe2ab10, 0xff1ad86e, 0xff190320, 0xff172def,
  0xffeaab10, 0xff59586e, 0xff580320, 0xff56adef,
  0xfff2ab00, 0xff97d7f1, 0xff9702a2, 0xff962d70,
  0xfff80060, 0xffc182ef, 0xffc102f6, 0xffc0831a,
  0xfffb33a0, 0xffda8353, 0xffda368e, 0xffd9e9e6,
  0xfff80030, 0xffc18178, 0xffc1017c, 0xffc0819d,
  0xfff00050, 0xff830272, 0xff820278, 0xff81029b,
  0xffe80060, 0xff4482ef, 0xff4302f6, 0xff41831a,
  0xfff00060, 0xff8302ef, 0xff8202f6, 0xff81031a,
  0xfff80050, 0xffc18272, 0xffc10278, 0xffc0829b,
  0xfffd55b0, 0xffeb2d70, 0xffeb02cc, 0xffead845,
  0x000088f0, 0x00042dd4, 0x00043664, 0x00043f11,
  0x000090f0, 0x00046c54, 0x00047564, 0x00047e91,
  0xfff80020, 0xffc180fb, 0xffc100fe, 0xffc0811e,
  0xfff00030, 0xff830178, 0xff82017c, 0xff81019d,
  0xfff80030, 0xffc18178, 0xffc1017c, 0xffc0819d,
  0x00000020, 0x000000fb, 0x000000fe, 0x0000011e,
  0x00055580, 0x0029abf9, 0x002a0152, 0x002a56c8,
  0x000888c0, 0x0042ac5d, 0x004334ea, 0x0043bd94,
  0x000890c0, 0x0042eadd, 0x004373ea, 0x0043fd14,
  0x000898b0, 0x004328e0, 0x0043b26c, 0x00443c15,
  0xfff80010, 0xffc1807e, 0xffc10080, 0xffc0809f,
  0x00000010, 0x0000007e, 0x00000080, 0x0000009f,
  0x00080000, 0x003e8001, 0x003f0002, 0x003f8020,
  0x000d5560, 0x00682aff, 0x00690056, 0x0069d5ca,
  0x001088a0, 0x00812b63, 0x008233ee, 0x00833c96,
  0x001090a0, 0x008169e3, 0x008272ee, 0x00837c16,
  0x00109890, 0x0081a7e6, 0x0082b170, 0x0083bb17,
  0x0010a070, 0x0081e56c, 0x0082ef74, 0x0083f999,
  0x00080000, 0x003e8001, 0x003f0002, 0x003f8020,
  0x000ffff0, 0x007cff84, 0x007dff84, 0x007effa1,
  0x00155550, 0x00a6aa82, 0x00a7ffd8, 0x00a9554b,
  0x00188890, 0x00bfaae6, 0x00c13370, 0x00c2bc17,
  0x00189090, 0x00bfe966, 0x00c17270, 0x00c2fb97,
  0x00189880, 0x00c02769, 0x00c1b0f2, 0x00c33a98,
  0x0018a060, 0x00c064ef, 0x00c1eef6, 0x00c3791a,
  0x0018a830, 0x00c0a1f8, 0x00c22c7c, 0x00c3b71d,
  0x0007fff0, 0x003e7f84, 0x003eff84, 0x003f7fa1,
  0x000d5550, 0x00682a82, 0x0068ffd8, 0x0069d54b,
  0x00108890, 0x00812ae6, 0x00823370, 0x00833c17,
  0x00109090, 0x00816966, 0x00827270, 0x00837b97,
  0x00109880, 0x0081a769, 0x0082b0f2, 0x0083ba98,
  0x0010a060, 0x0081e4ef, 0x0082eef6, 0x0083f91a,
  0x0010a830, 0x008221f8, 0x00832c7c, 0x0084371d,
  0x0010a930, 0x008229c8, 0x0083345c, 0x00843f0d,
  0x00055560, 0x0029aaff, 0x002a0056, 0x002a55ca,
  0x000888a0, 0x0042ab63, 0x004333ee, 0x0043bc96,
  0x000890a0, 0x0042e9e3, 0x004372ee, 0x0043fc16,
  0x00089890, 0x004327e6, 0x0043b170, 0x00443b17,
  0x0008a070, 0x0043656c, 0x0043ef74, 0x00447999,
  0x0008a840, 0x0043a275, 0x00442cfa, 0x0044b79c,
  0x0008a940, 0x0043aa45, 0x004434da, 0x0044bf8c,
  0x0008a970, 0x0043abbc, 0x00443654, 0x0044c109,
  0x00033340, 0x00190065, 0x0019339a, 0x001966ec,
  0x00033b40, 0x00193ee5, 0x0019729a, 0x0019a66c,
  0x00034330, 0x00197ce8, 0x0019b11c, 0x0019e56d,
  0x00034b10, 0x0019ba6e, 0x0019ef20, 0x001a23ef,
  0x000352e0, 0x0019f777, 0x001a2ca6, 0x001a61f2,
  0x000353e0, 0x0019ff47, 0x001a3486, 0x001a69e2,
  0x00035410, 0x001a00be, 0x001a3600, 0x001a6b5f,
  0x00035430, 0x001a01b8, 0x001a36fc, 0x001a6c5d,
  0x00000800, 0x00003e81, 0x00003f02, 0x00003fa0,
  0x00000ff0, 0x00007c84, 0x00007d84, 0x00007ea1,
  0x000017d0, 0x0000ba0a, 0x0000bb88, 0x0000bd23,
  0x00001fa0, 0x0000f713, 0x0000f90e, 0x0000fb26,
  0x000020a0, 0x0000fee3, 0x000100ee, 0x00010316,
  0x000020d0, 0x0001005a, 0x00010268, 0x00010493,
  0x000020f0, 0x00010154, 0x00010364, 0x00010591,
  0x00002100, 0x000101d1, 0x000103e2, 0x00010610,
  0x00003e03, 0x00003e83, 0x00003f03, 0x0019666d,
  0x00007b89, 0x00007c87, 0x00007d85, 0x00329987,
  0x0000b892, 0x0000ba0d, 0x0000bb88, 0x004b996e,
  0x0000c062, 0x0000c1ed, 0x0000c378, 0x004ecc9e,
  0x0000c1d9, 0x0000c367, 0x0000c4f5, 0x004f6637,
  0x0000c2d3, 0x0000c463, 0x0000c5f3, 0x004fcc9d,
  0x0000c350, 0x0000c4e1, 0x0000c672, 0x004fffd0,
  0x0000c350, 0x0000c4e1, 0x0000c672, 0x004fffd0,
  0x00003d86, 0x00003e05, 0x00003e84, 0x0019333a,
  0x00007a8f, 0x00007b8b, 0x00007c87, 0x00323321,
  0x0000825f, 0x0000836b, 0x00008477, 0x00356651,
  0x000083d6, 0x000084e5, 0x000085f4, 0x0035ffea,
  0x000084d0, 0x000085e1, 0x000086f2, 0x00366650,
  0x0000854d, 0x0000865f, 0x00008771, 0x00369983,
  0x0000854d, 0x0000865f, 0x00008771, 0x00369983,
  0x000084d0, 0x000085e1, 0x000086f2, 0x00366650,
  0x00003d09, 0x00003d87, 0x00003e05, 0x00190007,
  0x000044d9, 0x00004567, 0x000045f5, 0x001c3337,
  0x00004650, 0x000046e1, 0x00004772, 0x001cccd0,
  0x0000474a, 0x000047dd, 0x00004870, 0x001d3336,
  0x000047c7, 0x0000485b, 0x000048ef, 0x001d6669,
  0x000047c7, 0x0000485b, 0x000048ef, 0x001d6669,
  0x0000474a, 0x000047dd, 0x00004870, 0x001d3336,
  0x00004650, 0x000046e1, 0x00004772, 0x001cccd0,
  0x000007d0, 0x000007e1, 0x000007f2, 0x00033350,
  0x00000947, 0x0000095b, 0x0000096f, 0x0003cce9,
  0x00000a41, 0x00000a57, 0x00000a6d, 0x0004334f,
  0x00000abe, 0x00000ad5, 0x00000aec, 0x00046682,
  0x00000abe, 0x00000ad5, 0x00000aec, 0x00046682,
  0x00000a41, 0x00000a57, 0x00000a6d, 0x0004334f,
  0x00000947, 0x0000095b, 0x0000096f, 0x0003cce9,
  0x00000177, 0x0000017b, 0x0000017f, 0x000099b9,
  0x00000177, 0x0000017b, 0x0000017f, 0x000099b9,
  0x00000271, 0x00000277, 0x0000027d, 0x0001001f,
  0x000002ee, 0x000002f5, 0x000002fc, 0x00013352,
  0x000002ee, 0x000002f5, 0x000002fc, 0x00013352,
  0x00000271, 0x00000277, 0x0000027d, 0x0001001f,
  0x00000177, 0x0000017b, 0x0000017f, 0x000099b9,
  0xfffff9a7, 0xfffff99b, 0xfffff98f, 0xfffd6689,
  0xffffbc9e, 0xffffbc15, 0xffffbb8c, 0xffe466a2,
  0x000000fa, 0x000000fd, 0x00000100, 0x00006686,
  0x00000177, 0x0000017b, 0x0000017f, 0x000099b9,
  0x00000177, 0x0000017b, 0x0000017f, 0x000099b9,
  0x000000fa, 0x000000fd, 0x00000100, 0x00006686,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfffff830, 0xfffff821, 0xfffff812, 0xfffcccf0,
  0xffffbb27, 0xffffba9b, 0xffffba0f, 0xffe3cd09,
  0xffff7da1, 0xffff7c97, 0xffff7b8d, 0xffca99ef,
  0x0000007d, 0x0000007f, 0x00000081, 0x00003353,
  0x0000007d, 0x0000007f, 0x00000081, 0x00003353,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffffff06, 0xffffff05, 0xffffff04, 0xffff99ba,
  0xfffff736, 0xfffff725, 0xfffff714, 0xfffc668a,
  0xffffba2d, 0xffffb99f, 0xffffb911, 0xffe366a3,
  0xffff7ca7, 0xffff7b9b, 0xffff7a8f, 0xffca3389,
  0xffff3ea4, 0xffff3d19, 0xffff3b8e, 0xffb0cd3c,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffffff83, 0xffffff83, 0xffffff83, 0xffffcced,
  0xfffffe89, 0xfffffe87, 0xfffffe85, 0xffff6687,
  0xfffff6b9, 0xfffff6a7, 0xfffff695, 0xfffc3357,
  0xffffb9b0, 0xffffb921, 0xffffb892, 0xffe33370,
  0xffff7c2a, 0xffff7b1d, 0xffff7a10, 0xffca0056,
  0xffff3e27, 0xffff3c9b, 0xffff3b0f, 0xffb09a09,
  0xffe63e40, 0xffe60981, 0xffe5d4c2, 0xf5733de0,
  0xffffff83, 0xffffff83, 0xffffff83, 0xffffcced,
  0xfffffe89, 0xfffffe87, 0xfffffe85, 0xffff6687,
  0xfffff6b9, 0xfffff6a7, 0xfffff695, 0xfffc3357,
  0xffffb9b0, 0xffffb921, 0xffffb892, 0xffe33370,
  0xffff7c2a, 0xffff7b1d, 0xffff7a10, 0xffca0056,
  0xffff3e27, 0xffff3c9b, 0xffff3b0f, 0xffb09a09,
  0xffe63e40, 0xffe60981, 0xffe5d4c2, 0xf5733de0,
  0xffbc93bf, 0xffbc09ab, 0xffbb7f97, 0xe4624ef1,
  0xffffff06, 0xffffff05, 0xffffff04, 0xffff99ba,
  0xfffff736, 0xfffff725, 0xfffff714, 0xfffc668a,
  0xffffba2d, 0xffffb99f, 0xffffb911, 0xffe366a3,
  0xffff7ca7, 0xffff7b9b, 0xffff7a8f, 0xffca3389,
  0xffff3ea4, 0xffff3d19, 0xffff3b8e, 0xffb0cd3c,
  0xffe63ebd, 0xffe609ff, 0xffe5d541, 0xf5737113,
  0xffbc943c, 0xffbc0a29, 0xffbb8016, 0xe4628224,
  0xff7e15b3, 0xff7d0ba3, 0xff7c0193, 0xcac99bbd,
  0xfffff830, 0xfffff821, 0xfffff812, 0xfffcccf0,
  0xffffbb27, 0xffffba9b, 0xffffba0f, 0xffe3cd09,
  0xffff7da1, 0xffff7c97, 0xffff7b8d, 0xffca99ef,
  0xffff3f9e, 0xffff3e15, 0xffff3c8c, 0xffb133a2,
  0xffe63fb7, 0xffe60afb, 0xffe5d63f, 0xf573d779,
  0xffbc9536, 0xffbc0b25, 0xffbb8114, 0xe462e88a,
  0xff7e16ad, 0xff7d0c9f, 0xff7c0291, 0xcaca0223,
  0xff3f97a7, 0xff3e0d9b, 0xff3c838f, 0xb130e889,
  0xffffc2f7, 0xffffc27b, 0xffffc1ff, 0xffe70039,
  0xffff8571, 0xffff8477, 0xffff837d, 0xffcdcd1f,
  0xffff476e, 0xffff45f5, 0xffff447c, 0xffb466d2,
  0xffe64787, 0xffe612db, 0xffe5de2f, 0xf5770aa9,
  0xffbc9d06, 0xffbc1305, 0xffbb8904, 0xe4661bba,
  0xff7e1e7d, 0xff7d147f, 0xff7c0a81, 0xcacd3553,
  0xff3f9f77, 0xff3e157b, 0xff3c8b7f, 0xb1341bb9,
  0xff011ff4, 0xfeff15f9, 0xfefd0bfe, 0x979aceec,
  0xffffc27a, 0xffffc1fd, 0xffffc180, 0xffe6cd06,
  0xffff8477, 0xffff837b, 0xffff827f, 0xffcd66b9,
  0xffe68490, 0xffe65061, 0xffe61c32, 0xf5900a90,
  0xffbcda0f, 0xffbc508b, 0xffbbc707, 0xe47f1ba1,
  0xff7e5b86, 0xff7d5205, 0xff7c4884, 0xcae6353a,
  0xff3fdc80, 0xff3e5301, 0xff3cc982, 0xb14d1ba0,
  0xff015cfd, 0xfeff537f, 0xfefd4a01, 0x97b3ced3,
  0xff3fdcfd, 0xff3e537f, 0xff3cca01, 0xb14d4ed3,
  0xffffc1fd, 0xffffc17f, 0xffffc101, 0xffe699d3,
  0xffe6c216, 0xffe68e65, 0xffe65ab4, 0xf5a93daa,
  0xffbd1795, 0xffbc8e8f, 0xffbc0589, 0xe4984ebb,
  0xff7e990c, 0xff7d9009, 0xff7c8706, 0xcaff6854,
  0xff401a06, 0xff3e9105, 0xff3d0804, 0xb1664eba,
  0xff019a83, 0xfeff9183, 0xfefd8883, 0x97cd01ed,
  0xff401a83, 0xff3e9183, 0xff3d0883, 0xb16681ed,
  0xff7e9a06, 0xff7d9105, 0xff7c8804, 0xcaffceba,
  0xffe70019, 0xffe6cce7, 0xffe699b5, 0xf5c2a3f7,
  0xffbd5598, 0xffbccd11, 0xffbc448a, 0xe4b1b508,
  0xff7ed70f, 0xff7dce8b, 0xff7cc607, 0xcb18cea1,
  0xff405809, 0xff3ecf87, 0xff3d4705, 0xb17fb507,
  0xff01d886, 0xfeffd005, 0xfefdc784, 0x97e6683a,
  0xff405886, 0xff3ed005, 0xff3d4784, 0xb17fe83a,
  0xff7ed809, 0xff7dcf87, 0xff7cc705, 0xcb193507,
  0xffa88307, 0xffa7cfdb, 0xffa71caf, 0xdc2a5729,
  0xffd6557f, 0xffd6002b, 0xffd5aad7, 0xeeef1131,
  0xff97d6f6, 0xff9701a5, 0xff962c54, 0xd5562aca,
  0xff5957f0, 0xff5802a1, 0xff56ad52, 0xbbbd1130,
  0xff1ad86d, 0xff19031f, 0xff172dd1, 0xa223c463,
  0xff59586d, 0xff58031f, 0xff56add1, 0xbbbd4463,
  0xff97d7f0, 0xff9702a1, 0xff962d52, 0xd5569130,
  0xffc182ee, 0xffc102f5, 0xffc082fc, 0xe667b352,
  0xffda8352, 0xffda368d, 0xffd9e9c8, 0xf0a542ae,
  0xffc18177, 0xffc1017b, 0xffc0817f, 0xe66719b9,
  0xff830271, 0xff820277, 0xff81027d, 0xccce001f,
  0xff4482ee, 0xff4302f5, 0xff4182fc, 0xb334b352,
  0xff8302ee, 0xff8202f5, 0xff8102fc, 0xccce3352,
  0xffc18271, 0xffc10277, 0xffc0827d, 0xe667801f,
  0xffeb2d6f, 0xffeb02cb, 0xffead827, 0xf778a241,
  0x00042dd3, 0x00043663, 0x00043ef3, 0x01b6319d,
  0x00046c53, 0x00047563, 0x00047e73, 0x01cfcb1d,
  0xffc180fa, 0xffc100fd, 0xffc08100, 0xe666e686,
  0xff830177, 0xff82017b, 0xff81017f, 0xcccd99b9,
  0xffc18177, 0xffc1017b, 0xffc0817f, 0xe66719b9,
  0x000000fa, 0x000000fd, 0x00000100, 0x00006686,
  0x0029abf8, 0x002a0151, 0x002a56aa, 0x111188a8,
  0x0042ac5c, 0x004334e9, 0x0043bd76, 0x1b4f1804,
  0x0042eadc, 0x004373e9, 0x0043fcf6, 0x1b68b184,
  0x004328df, 0x0043b26b, 0x00443bf7, 0x1b8217d1,
  0xffc1807d, 0xffc1007f, 0xffc08081, 0xe666b353,
  0x0000007d, 0x0000007f, 0x00000081, 0x00003353,
  0x003e8000, 0x003f0001, 0x003f8002, 0x19998020,
  0x00682afe, 0x00690055, 0x0069d5ac, 0x2aaaa242,
  0x00812b62, 0x008233ed, 0x00833c78, 0x34e8319e,
  0x008169e2, 0x008272ed, 0x00837bf8, 0x3501cb1e,
  0x0081a7e5, 0x0082b16f, 0x0083baf9, 0x351b316b,
  0x0081e56b, 0x0082ef73, 0x0083f97b, 0x35346485,
  0x003e8000, 0x003f0001, 0x003f8002, 0x19998020,
  0x007cff83, 0x007dff83, 0x007eff83, 0x3332cced,
  0x00a6aa81, 0x00a7ffd7, 0x00a9552d, 0x4443ef0f,
  0x00bfaae5, 0x00c1336f, 0x00c2bbf9, 0x4e817e6b,
  0x00bfe965, 0x00c1726f, 0x00c2fb79, 0x4e9b17eb,
  0x00c02768, 0x00c1b0f1, 0x00c33a7a, 0x4eb47e38,
  0x00c064ee, 0x00c1eef5, 0x00c378fc, 0x4ecdb152,
  0x00c0a1f7, 0x00c22c7b, 0x00c3b6ff, 0x4ee6b139,
  0x003e7f83, 0x003eff83, 0x003f7f83, 0x19994ced,
  0x00682a81, 0x0068ffd7, 0x0069d52d, 0x2aaa6f0f,
  0x00812ae5, 0x0082336f, 0x00833bf9, 0x34e7fe6b,
  0x00816965, 0x0082726f, 0x00837b79, 0x350197eb,
  0x0081a768, 0x0082b0f1, 0x0083ba7a, 0x351afe38,
  0x0081e4ee, 0x0082eef5, 0x0083f8fc, 0x35343152,
  0x008221f7, 0x00832c7b, 0x008436ff, 0x354d3139,
  0x008229c7, 0x0083345b, 0x00843eef, 0x35506469,
  0x0029aafe, 0x002a0055, 0x002a55ac, 0x11112242,
  0x0042ab62, 0x004333ed, 0x0043bc78, 0x1b4eb19e,
  0x0042e9e2, 0x004372ed, 0x0043fbf8, 0x1b684b1e,
  0x004327e5, 0x0043b16f, 0x00443af9, 0x1b81b16b,
  0x0043656b, 0x0043ef73, 0x0044797b, 0x1b9ae485,
  0x0043a274, 0x00442cf9, 0x0044b77e, 0x1bb3e46c,
  0x0043aa44, 0x004434d9, 0x0044bf6e, 0x1bb7179c,
  0x0043abbb, 0x00443653, 0x0044c0eb, 0x1bb7b135,
  0x00190064, 0x00193399, 0x001966ce, 0x0a3d8f7c,
  0x00193ee4, 0x00197299, 0x0019a64e, 0x0a5728fc,
  0x00197ce7, 0x0019b11b, 0x0019e54f, 0x0a708f49,
  0x0019ba6d, 0x0019ef1f, 0x001a23d1, 0x0a89c263,
  0x0019f776, 0x001a2ca5, 0x001a61d4, 0x0aa2c24a,
  0x0019ff46, 0x001a3485, 0x001a69c4, 0x0aa5f57a,
  0x001a00bd, 0x001a35ff, 0x001a6b41, 0x0aa68f13,
  0x001a01b7, 0x001a36fb, 0x001a6c3f, 0x0aa6f579,
  0x00003e80, 0x00003f01, 0x00003f82, 0x001999a0,
  0x00007c83, 0x00007d83, 0x00007e83, 0x0032ffed,
  0x0000ba09, 0x0000bb87, 0x0000bd05, 0x004c3307,
  0x0000f712, 0x0000f90d, 0x0000fb08, 0x006532ee,
  0x0000fee2, 0x000100ed, 0x000102f8, 0x0068661e,
  0x00010059, 0x00010267, 0x00010475, 0x0068ffb7,
  0x00010153, 0x00010363, 0x00010573, 0x0069661d,
  0x000101d0, 0x000103e1, 0x000105f2, 0x00699950,
  0x00003e82, 0x00003f02, 0x0019664f, 0x002a554b,
  0x00007c86, 0x00007d84, 0x00329969, 0x00545521,
  0x0000ba0c, 0x0000bb87, 0x004b9950, 0x007dffa2,
  0x0000c1ec, 0x0000c377, 0x004ecc80, 0x008354f2,
  0x0000c366, 0x0000c4f4, 0x004f6619, 0x008454f1,
  0x0000c462, 0x0000c5f2, 0x004fcc7f, 0x0084ff9b,
  0x0000c4e0, 0x0000c671, 0x004fffb2, 0x008554f0,
  0x0000c4e0, 0x0000c671, 0x004fffb2, 0x008554f0,
  0x00003e04, 0x00003e83, 0x0019331c, 0x0029fff6,
  0x00007b8a, 0x00007c86, 0x00323303, 0x0053aa77,
  0x0000836a, 0x00008476, 0x00356633, 0x0058ffc7,
  0x000084e4, 0x000085f3, 0x0035ffcc, 0x0059ffc6,
  0x000085e0, 0x000086f1, 0x00366632, 0x005aaa70,
  0x0000865e, 0x00008770, 0x00369965, 0x005affc5,
  0x0000865e, 0x00008770, 0x00369965, 0x005affc5,
  0x000085e0, 0x000086f1, 0x00366632, 0x005aaa70,
  0x00003d86, 0x00003e04, 0x0018ffe9, 0x0029aaa1,
  0x00004566, 0x000045f4, 0x001c3319, 0x002efff1,
  0x000046e0, 0x00004771, 0x001cccb2, 0x002ffff0,
  0x000047dc, 0x0000486f, 0x001d3318, 0x0030aa9a,
  0x0000485a, 0x000048ee, 0x001d664b, 0x0030ffef,
  0x0000485a, 0x000048ee, 0x001d664b, 0x0030ffef,
  0x000047dc, 0x0000486f, 0x001d3318, 0x0030aa9a,
  0x000046e0, 0x00004771, 0x001cccb2, 0x002ffff0,
  0x000007e0, 0x000007f1, 0x00033332, 0x00055570,
  0x0000095a, 0x0000096e, 0x0003cccb, 0x0006556f,
  0x00000a56, 0x00000a6c, 0x00043331, 0x00070019,
  0x00000ad4, 0x00000aeb, 0x00046664, 0x0007556e,
  0x00000ad4, 0x00000aeb, 0x00046664, 0x0007556e,
  0x00000a56, 0x00000a6c, 0x00043331, 0x00070019,
  0x0000095a, 0x0000096e, 0x0003cccb, 0x0006556f,
  0x0000017a, 0x0000017e, 0x0000999b, 0x0001001f,
  0x0000017a, 0x0000017e, 0x0000999b, 0x0001001f,
  0x00000276, 0x0000027c, 0x00010001, 0x0001aac9,
  0x000002f4, 0x000002fb, 0x00013334, 0x0002001e,
  0x000002f4, 0x000002fb, 0x00013334, 0x0002001e,
  0x00000276, 0x0000027c, 0x00010001, 0x0001aac9,
  0x0000017a, 0x0000017e, 0x0000999b, 0x0001001f,
  0xfffff99a, 0xfffff98e, 0xfffd666b, 0xfffbaacf,
  0xffffbc14, 0xffffbb8b, 0xffe46684, 0xffd2004e,
  0x000000fc, 0x000000ff, 0x00006668, 0x0000aaca,
  0x0000017a, 0x0000017e, 0x0000999b, 0x0001001f,
  0x0000017a, 0x0000017e, 0x0000999b, 0x0001001f,
  0x000000fc, 0x000000ff, 0x00006668, 0x0000aaca,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfffff820, 0xfffff811, 0xfffcccd2, 0xfffaaad0,
  0xffffba9a, 0xffffba0e, 0xffe3cceb, 0xffd1004f,
  0xffff7c96, 0xffff7b8c, 0xffca99d1, 0xffa70079,
  0x0000007e, 0x00000080, 0x00003335, 0x00005575,
  0x0000007e, 0x00000080, 0x00003335, 0x00005575,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffffff04, 0xffffff03, 0xffff999c, 0xffff5576,
  0xfffff724, 0xfffff713, 0xfffc666c, 0xfffa0026,
  0xffffb99e, 0xffffb910, 0xffe36685, 0xffd055a5,
  0xffff7b9a, 0xffff7a8e, 0xffca336b, 0xffa655cf,
  0xffff3d18, 0xffff3b8d, 0xffb0cd1e, 0xff7c00a4,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffffff82, 0xffffff82, 0xffffcccf, 0xffffaacb,
  0xfffffe86, 0xfffffe84, 0xffff6669, 0xffff0021,
  0xfffff6a6, 0xfffff694, 0xfffc3339, 0xfff9aad1,
  0xffffb920, 0xffffb891, 0xffe33352, 0xffd00050,
  0xffff7b1c, 0xffff7a0f, 0xffca0038, 0xffa6007a,
  0xffff3c9a, 0xffff3b0e, 0xffb099eb, 0xff7bab4f,
  0xffe60980, 0xffe5d4c1, 0xf5733dc2, 0xee6abc60,
  0xffffff82, 0xffffff82, 0xffffcccf, 0xffffaacb,
  0xfffffe86, 0xfffffe84, 0xffff6669, 0xffff0021,
  0xfffff6a6, 0xfffff694, 0xfffc3339, 0xfff9aad1,
  0xffffb920, 0xffffb891, 0xffe33352, 0xffd00050,
  0xffff7b1c, 0xffff7a0f, 0xffca0038, 0xffa6007a,
  0xffff3c9a, 0xffff3b0e, 0xffb099eb, 0xff7bab4f,
  0xffe60980, 0xffe5d4c1, 0xf5733dc2, 0xee6abc60,
  0xffbc09aa, 0xffbb7f96, 0xe4624ed3, 0xd1f92e27,
  0xffffff04, 0xffffff03, 0xffff999c, 0xffff5576,
  0xfffff724, 0xfffff713, 0xfffc666c, 0xfffa0026,
  0xffffb99e, 0xffffb910, 0xffe36685, 0xffd055a5,
  0xffff7b9a, 0xffff7a8e, 0xffca336b, 0xffa655cf,
  0xffff3d18, 0xffff3b8d, 0xffb0cd1e, 0xff7c00a4,
  0xffe609fe, 0xffe5d540, 0xf57370f5, 0xee6b11b5,
  0xffbc0a28, 0xffbb8015, 0xe4628206, 0xd1f9837c,
  0xff7d0ba2, 0xff7c0192, 0xcac99b9f, 0xa750037b,
  0xfffff820, 0xfffff811, 0xfffcccd2, 0xfffaaad0,
  0xffffba9a, 0xffffba0e, 0xffe3cceb, 0xffd1004f,
  0xffff7c96, 0xffff7b8c, 0xffca99d1, 0xffa70079,
  0xffff3e14, 0xffff3c8b, 0xffb13384, 0xff7cab4e,
  0xffe60afa, 0xffe5d63e, 0xf573d75b, 0xee6bbc5f,
  0xffbc0b24, 0xffbb8113, 0xe462e86c, 0xd1fa2e26,
  0xff7d0c9e, 0xff7c0290, 0xcaca0205, 0xa750ae25,
  0xff3e0d9a, 0xff3c838e, 0xb130e86b, 0x7ca6d8cf,
  0xffffc27a, 0xffffc1fe, 0xffe7001b, 0xffd6559f,
  0xffff8476, 0xffff837c, 0xffcdcd01, 0xffac55c9,
  0xffff45f4, 0xffff447b, 0xffb466b4, 0xff82009e,
  0xffe612da, 0xffe5de2e, 0xf5770a8b, 0xee7111af,
  0xffbc1304, 0xffbb8903, 0xe4661b9c, 0xd1ff8376,
  0xff7d147e, 0xff7c0a80, 0xcacd3535, 0xa7560375,
  0xff3e157a, 0xff3c8b7e, 0xb1341b9b, 0x7cac2e1f,
  0xfeff15f8, 0xfefd0bfd, 0x979acece, 0x52020374,
  0xffffc1fc, 0xffffc17f, 0xffe6cce8, 0xffd6004a,
  0xffff837a, 0xffff827e, 0xffcd669b, 0xffabab1f,
  0xffe65060, 0xffe61c31, 0xf5900a72, 0xee9abc30,
  0xffbc508a, 0xffbbc706, 0xe47f1b83, 0xd2292df7,
  0xff7d5204, 0xff7c4883, 0xcae6351c, 0xa77fadf6,
  0xff3e5300, 0xff3cc981, 0xb14d1b82, 0x7cd5d8a0,
  0xfeff537e, 0xfefd4a00, 0x97b3ceb5, 0x522badf5,
  0xff3e537e, 0xff3cca00, 0xb14d4eb5, 0x7cd62df5,
  0xffffc17e, 0xffffc100, 0xffe699b5, 0xffd5aaf5,
  0xffe68e64, 0xffe65ab3, 0xf5a93d8c, 0xeec4bc06,
  0xffbc8e8e, 0xffbc0588, 0xe4984e9d, 0xd2532dcd,
  0xff7d9008, 0xff7c8705, 0xcaff6836, 0xa7a9adcc,
  0xff3e9104, 0xff3d0803, 0xb1664e9c, 0x7cffd876,
  0xfeff9182, 0xfefd8882, 0x97cd01cf, 0x5255adcb,
  0xff3e9182, 0xff3d0882, 0xb16681cf, 0x7d002dcb,
  0xff7d9104, 0xff7c8803, 0xcaffce9c, 0xa7aa5876,
  0xffe6cce6, 0xffe699b4, 0xf5c2a3d9, 0xeeef1131,
  0xffbccd10, 0xffbc4489, 0xe4b1b4ea, 0xd27d82f8,
  0xff7dce8a, 0xff7cc606, 0xcb18ce83, 0xa7d402f7,
  0xff3ecf86, 0xff3d4704, 0xb17fb4e9, 0x7d2a2da1,
  0xfeffd004, 0xfefdc783, 0x97e6681c, 0x528002f6,
  0xff3ed004, 0xff3d4783, 0xb17fe81c, 0x7d2a82f6,
  0xff7dcf86, 0xff7cc704, 0xcb1934e9, 0xa7d4ada1,
  0xffa7cfda, 0xffa71cae, 0xdc2a570b, 0xc446912f,
  0xffd6002a, 0xffd5aad6, 0xeeef1113, 0xe38e71e7,
  0xff9701a4, 0xff962c53, 0xd5562aac, 0xb8e4f1e6,
  0xff5802a0, 0xff56ad51, 0xbbbd1112, 0x8e3b1c90,
  0xff19031e, 0xff172dd0, 0xa223c445, 0x6390f1e5,
  0xff58031e, 0xff56add0, 0xbbbd4445, 0x8e3b71e5,
  0xff9702a0, 0xff962d51, 0xd5569112, 0xb8e59c90,
  0xffc102f4, 0xffc082fb, 0xe667b334, 0xd557801e,
  0xffda368c, 0xffd9e9c7, 0xf0a54290, 0xe668c462,
  0xffc1017a, 0xffc0817e, 0xe667199b, 0xd556801f,
  0xff820276, 0xff81027c, 0xccce0001, 0xaaacaac9,
  0xff4302f4, 0xff4182fb, 0xb334b334, 0x8002801e,
  0xff8202f4, 0xff8102fb, 0xccce3334, 0xaaad001e,
  0xffc10276, 0xffc0827c, 0xe6678001, 0xd5572ac9,
  0xffeb02ca, 0xffead826, 0xf778a223, 0xf1c90e57,
  0x00043662, 0x00043ef2, 0x01b6317f, 0x02da529b,
  0x00047562, 0x00047e72, 0x01cfcaff, 0x0304fd1b,
  0xffc100fc, 0xffc080ff, 0xe666e668, 0xd5562aca,
  0xff82017a, 0xff81017e, 0xcccd999b, 0xaaac001f,
  0xffc1017a, 0xffc0817e, 0xe667199b, 0xd556801f,
  0x000000fc, 0x000000ff, 0x00006668, 0x0000aaca,
  0x002a0150, 0x002a56a9, 0x1111888a, 0x1c728e58,
  0x004334e8, 0x0043bd75, 0x1b4f17e6, 0x2d83d29c,
  0x004373e8, 0x0043fcf5, 0x1b68b166, 0x2dae7d1c,
  0x0043b26a, 0x00443bf6, 0x1b8217b3, 0x2dd8d247,
  0xffc1007e, 0xffc08080, 0xe666b335, 0xd555d575,
  0x0000007e, 0x00000080, 0x00003335, 0x00005575,
  0x003f0000, 0x003f8001, 0x19998002, 0x2aaa8020,
  0x00690054, 0x0069d5ab, 0x2aaaa224, 0x471c63ae,
  0x008233ec, 0x00833c77, 0x34e83180, 0x582da7f2,
  0x008272ec, 0x00837bf7, 0x3501cb00, 0x58585272,
  0x0082b16e, 0x0083baf8, 0x351b314d, 0x5882a79d,
  0x0082ef72, 0x0083f97a, 0x35346467, 0x58aca773,
  0x003f0000, 0x003f8001, 0x19998002, 0x2aaa8020,
  0x007dff82, 0x007eff82, 0x3332cccf, 0x5554aacb,
  0x00a7ffd6, 0x00a9552c, 0x4443eef1, 0x71c68e59,
  0x00c1336e, 0x00c2bbf8, 0x4e817e4d, 0x82d7d29d,
  0x00c1726e, 0x00c2fb78, 0x4e9b17cd, 0x83027d1d,
  0x00c1b0f0, 0x00c33a79, 0x4eb47e1a, 0x832cd248,
  0x00c1eef4, 0x00c378fb, 0x4ecdb134, 0x8356d21e,
  0x00c22c7a, 0x00c3b6fe, 0x4ee6b11b, 0x83807c9f,
  0x003eff82, 0x003f7f82, 0x19994ccf, 0x2aaa2acb,
  0x0068ffd6, 0x0069d52c, 0x2aaa6ef1, 0x471c0e59,
  0x0082336e, 0x00833bf8, 0x34e7fe4d, 0x582d529d,
  0x0082726e, 0x00837b78, 0x350197cd, 0x5857fd1d,
  0x0082b0f0, 0x0083ba79, 0x351afe1a, 0x58825248,
  0x0082eef4, 0x0083f8fb, 0x35343134, 0x58ac521e,
  0x00832c7a, 0x008436fe, 0x354d311b, 0x58d5fc9f,
  0x0083345a, 0x00843eee, 0x3550644b, 0x58db51ef,
  0x002a0054, 0x002a55ab, 0x11112224, 0x1c71e3ae,
  0x004333ec, 0x0043bc77, 0x1b4eb180, 0x2d8327f2,
  0x004372ec, 0x0043fbf7, 0x1b684b00, 0x2dadd272,
  0x0043b16e, 0x00443af8, 0x1b81b14d, 0x2dd8279d,
  0x0043ef72, 0x0044797a, 0x1b9ae467, 0x2e022773,
  0x00442cf8, 0x0044b77d, 0x1bb3e44e, 0x2e2bd1f4,
  0x004434d8, 0x0044bf6d, 0x1bb7177e, 0x2e312744,
  0x00443652, 0x0044c0ea, 0x1bb7b117, 0x2e322743,
  0x00193398, 0x001966cd, 0x0a3d8f5e, 0x11114464,
  0x00197298, 0x0019a64d, 0x0a5728de, 0x113beee4,
  0x0019b11a, 0x0019e54e, 0x0a708f2b, 0x1166440f,
  0x0019ef1e, 0x001a23d0, 0x0a89c245, 0x119043e5,
  0x001a2ca4, 0x001a61d3, 0x0aa2c22c, 0x11b9ee66,
  0x001a3484, 0x001a69c3, 0x0aa5f55c, 0x11bf43b6,
  0x001a35fe, 0x001a6b40, 0x0aa68ef5, 0x11c043b5,
  0x001a36fa, 0x001a6c3e, 0x0aa6f55b, 0x11c0ee5f,
  0x00003f00, 0x00003f81, 0x00199982, 0x002aaaa0,
  0x00007d82, 0x00007e82, 0x0032ffcf, 0x0054ffcb,
  0x0000bb86, 0x0000bd04, 0x004c32e9, 0x007effa1,
  0x0000f90c, 0x0000fb07, 0x006532d0, 0x00a8aa22,
  0x000100ec, 0x000102f7, 0x00686600, 0x00adff72,
  0x00010266, 0x00010474, 0x0068ff99, 0x00aeff71,
  0x00010362, 0x00010572, 0x006965ff, 0x00afaa1b,
  0x000103e0, 0x000105f1, 0x00699932, 0x00afff70,
  0x00003f01, 0x0019664e, 0x002a552d, 0x003f7ea3,
  0x00007d83, 0x00329968, 0x00545503, 0x007e7d29,
  0x0000bb86, 0x004b994f, 0x007dff84, 0x00bcfbb2,
  0x0000c376, 0x004ecc7f, 0x008354d4, 0x00c4fb82,
  0x0000c4f3, 0x004f6618, 0x008454d3, 0x00c67b79,
  0x0000c5f1, 0x004fcc7e, 0x0084ff7d, 0x00c77b73,
  0x0000c670, 0x004fffb1, 0x008554d2, 0x00c7fb70,
  0x0000c670, 0x004fffb1, 0x008554d2, 0x00c7fb70,
  0x00003e82, 0x0019331b, 0x0029ffd8, 0x003efea6,
  0x00007c85, 0x00323302, 0x0053aa59, 0x007d7d2f,
  0x00008475, 0x00356632, 0x0058ffa9, 0x00857cff,
  0x000085f2, 0x0035ffcb, 0x0059ffa8, 0x0086fcf6,
  0x000086f0, 0x00366631, 0x005aaa52, 0x0087fcf0,
  0x0000876f, 0x00369964, 0x005affa7, 0x00887ced,
  0x0000876f, 0x00369964, 0x005affa7, 0x00887ced,
  0x000086f0, 0x00366631, 0x005aaa52, 0x0087fcf0,
  0x00003e03, 0x0018ffe8, 0x0029aa83, 0x003e7ea9,
  0x000045f3, 0x001c3318, 0x002effd3, 0x00467e79,
  0x00004770, 0x001cccb1, 0x002fffd2, 0x0047fe70,
  0x0000486e, 0x001d3317, 0x0030aa7c, 0x0048fe6a,
  0x000048ed, 0x001d664a, 0x0030ffd1, 0x00497e67,
  0x000048ed, 0x001d664a, 0x0030ffd1, 0x00497e67,
  0x0000486e, 0x001d3317, 0x0030aa7c, 0x0048fe6a,
  0x00004770, 0x001cccb1, 0x002fffd2, 0x0047fe70,
  0x000007f0, 0x00033331, 0x00055552, 0x0007fff0,
  0x0000096d, 0x0003ccca, 0x00065551, 0x00097fe7,
  0x00000a6b, 0x00043330, 0x0006fffb, 0x000a7fe1,
  0x00000aea, 0x00046663, 0x00075550, 0x000affde,
  0x00000aea, 0x00046663, 0x00075550, 0x000affde,
  0x00000a6b, 0x00043330, 0x0006fffb, 0x000a7fe1,
  0x0000096d, 0x0003ccca, 0x00065551, 0x00097fe7,
  0x0000017d, 0x0000999a, 0x00010001, 0x00018017,
  0x0000017d, 0x0000999a, 0x00010001, 0x00018017,
  0x0000027b, 0x00010000, 0x0001aaab, 0x00028011,
  0x000002fa, 0x00013333, 0x00020000, 0x0003000e,
  0x000002fa, 0x00013333, 0x00020000, 0x0003000e,
  0x0000027b, 0x00010000, 0x0001aaab, 0x00028011,
  0x0000017d, 0x0000999a, 0x00010001, 0x00018017,
  0xfffff98d, 0xfffd666a, 0xfffbaab1, 0xfff98047,
  0xffffbb8a, 0xffe46683, 0xffd20030, 0xffbb01be,
  0x000000fe, 0x00006667, 0x0000aaac, 0x0001001a,
  0x0000017d, 0x0000999a, 0x00010001, 0x00018017,
  0x0000017d, 0x0000999a, 0x00010001, 0x00018017,
  0x000000fe, 0x00006667, 0x0000aaac, 0x0001001a,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfffff810, 0xfffcccd1, 0xfffaaab2, 0xfff80050,
  0xffffba0d, 0xffe3ccea, 0xffd10031, 0xffb981c7,
  0xffff7b8b, 0xffca99d0, 0xffa7005b, 0xff7a8341,
  0x0000007f, 0x00003334, 0x00005557, 0x0000801d,
  0x0000007f, 0x00003334, 0x00005557, 0x0000801d,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffffff02, 0xffff999b, 0xffff5558, 0xffff0026,
  0xfffff712, 0xfffc666b, 0xfffa0008, 0xfff70056,
  0xffffb90f, 0xffe36684, 0xffd05587, 0xffb881cd,
  0xffff7a8d, 0xffca336a, 0xffa655b1, 0xff798347,
  0xffff3b8c, 0xffb0cd1d, 0xff7c0086, 0xff3a04c4,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffffff81, 0xffffccce, 0xffffaaad, 0xffff8023,
  0xfffffe83, 0xffff6668, 0xffff0003, 0xfffe8029,
  0xfffff693, 0xfffc3338, 0xfff9aab3, 0xfff68059,
  0xffffb890, 0xffe33351, 0xffd00032, 0xffb801d0,
  0xffff7a0e, 0xffca0037, 0xffa6005c, 0xff79034a,
  0xffff3b0d, 0xffb099ea, 0xff7bab31, 0xff3984c7,
  0xffe5d4c0, 0xf5733dc1, 0xee6abc42, 0xe5a09e60,
  0xffffff81, 0xffffccce, 0xffffaaad, 0xffff8023,
  0xfffffe83, 0xffff6668, 0xffff0003, 0xfffe8029,
  0xfffff693, 0xfffc3338, 0xfff9aab3, 0xfff68059,
  0xffffb890, 0xffe33351, 0xffd00032, 0xffb801d0,
  0xffff7a0e, 0xffca0037, 0xffa6005c, 0xff79034a,
  0xffff3b0d, 0xffb099ea, 0xff7bab31, 0xff3984c7,
  0xffe5d4c0, 0xf5733dc1, 0xee6abc42, 0xe5a09e60,
  0xffbb7f95, 0xe4624ed2, 0xd1f92e09, 0xbaf71e5f,
  0xffffff02, 0xffff999b, 0xffff5558, 0xffff0026,
  0xfffff712, 0xfffc666b, 0xfffa0008, 0xfff70056,
  0xffffb90f, 0xffe36684, 0xffd05587, 0xffb881cd,
  0xffff7a8d, 0xffca336a, 0xffa655b1, 0xff798347,
  0xffff3b8c, 0xffb0cd1d, 0xff7c0086, 0xff3a04c4,
  0xffe5d53f, 0xf57370f4, 0xee6b1197, 0xe5a11e5d,
  0xffbb8014, 0xe4628205, 0xd1f9835e, 0xbaf79e5c,
  0xff7c0191, 0xcac99b9e, 0xa750035d, 0x7afa9e53,
  0xfffff810, 0xfffcccd1, 0xfffaaab2, 0xfff80050,
  0xffffba0d, 0xffe3ccea, 0xffd10031, 0xffb981c7,
  0xffff7b8b, 0xffca99d0, 0xffa7005b, 0xff7a8341,
  0xffff3c8a, 0xffb13383, 0xff7cab30, 0xff3b04be,
  0xffe5d63d, 0xf573d75a, 0xee6bbc41, 0xe5a21e57,
  0xffbb8112, 0xe462e86b, 0xd1fa2e08, 0xbaf89e56,
  0xff7c028f, 0xcaca0204, 0xa750ae07, 0x7afb9e4d,
  0xff3c838d, 0xb130e86a, 0x7ca6d8b1, 0x3afe1e47,
  0xffffc1fd, 0xffe7001a, 0xffd65581, 0xffc18197,
  0xffff837b, 0xffcdcd00, 0xffac55ab, 0xff828311,
  0xffff447a, 0xffb466b3, 0xff820080, 0xff43048e,
  0xffe5de2d, 0xf5770a8a, 0xee711191, 0xe5aa1e27,
  0xffbb8902, 0xe4661b9b, 0xd1ff8358, 0xbb009e26,
  0xff7c0a7f, 0xcacd3534, 0xa7560357, 0x7b039e1d,
  0xff3c8b7d, 0xb1341b9a, 0x7cac2e01, 0x3b061e17,
  0xfefd0bfc, 0x979acecd, 0x52020356, 0xfb081e14,
  0xffffc17e, 0xffe6cce7, 0xffd6002c, 0xffc1019a,
  0xffff827d, 0xffcd669a, 0xffabab01, 0xff818317,
  0xffe61c30, 0xf5900a71, 0xee9abc12, 0xe5e89cb0,
  0xffbbc705, 0xe47f1b82, 0xd2292dd9, 0xbb3f1caf,
  0xff7c4882, 0xcae6351b, 0xa77fadd8, 0x7b421ca6,
  0xff3cc980, 0xb14d1b81, 0x7cd5d882, 0x3b449ca0,
  0xfefd49ff, 0x97b3ceb4, 0x522badd7, 0xfb469c9d,
  0xff3cc9ff, 0xb14d4eb4, 0x7cd62dd7, 0x3b451c9d,
  0xffffc0ff, 0xffe699b4, 0xffd5aad7, 0xffc0819d,
  0xffe65ab2, 0xf5a93d8b, 0xeec4bbe8, 0xe6279b36,
  0xffbc0587, 0xe4984e9c, 0xd2532daf, 0xbb7e1b35,
  0xff7c8704, 0xcaff6835, 0xa7a9adae, 0x7b811b2c,
  0xff3d0802, 0xb1664e9b, 0x7cffd858, 0x3b839b26,
  0xfefd8881, 0x97cd01ce, 0x5255adad, 0xfb859b23,
  0xff3d0881, 0xb16681ce, 0x7d002dad, 0x3b841b23,
  0xff7c8802, 0xcaffce9b, 0xa7aa5858, 0x7b821b26,
  0xffe699b3, 0xf5c2a3d8, 0xeeef1113, 0xe66719b9,
  0xffbc4488, 0xe4b1b4e9, 0xd27d82da, 0xbbbd99b8,
  0xff7cc605, 0xcb18ce82, 0xa7d402d9, 0x7bc099af,
  0xff3d4703, 0xb17fb4e8, 0x7d2a2d83, 0x3bc319a9,
  0xfefdc782, 0x97e6681b, 0x528002d8, 0xfbc519a6,
  0xff3d4782, 0xb17fe81b, 0x7d2a82d8, 0x3bc399a6,
  0xff7cc703, 0xcb1934e8, 0xa7d4ad83, 0x7bc199a9,
  0xffa71cad, 0xdc2a570a, 0xc4469111, 0xa66b99a7,
  0xffd5aad5, 0xeeef1112, 0xe38e71c9, 0xd556801f,
  0xff962c52, 0xd5562aab, 0xb8e4f1c8, 0x95598016,
  0xff56ad50, 0xbbbd1111, 0x8e3b1c72, 0x555c0010,
  0xff172dcf, 0xa223c444, 0x6390f1c7, 0x155e000d,
  0xff56adcf, 0xbbbd4444, 0x8e3b71c7, 0x555c800d,
  0xff962d50, 0xd5569111, 0xb8e59c72, 0x955a8010,
  0xffc082fa, 0xe667b333, 0xd5578000, 0xc004800e,
  0xffd9e9c6, 0xf0a5428f, 0xe668c444, 0xd99de672,
  0xffc0817d, 0xe667199a, 0xd5568001, 0xc0030017,
  0xff81027b, 0xccce0000, 0xaaacaaab, 0x80058011,
  0xff4182fa, 0xb334b333, 0x80028000, 0x4007800e,
  0xff8102fa, 0xccce3333, 0xaaad0000, 0x8006000e,
  0xffc0827b, 0xe6678000, 0xd5572aab, 0xc0040011,
  0xffead825, 0xf778a222, 0xf1c90e39, 0xeaae000f,
  0x00043ef1, 0x01b6317e, 0x02da527d, 0x04476673,
  0x00047e71, 0x01cfcafe, 0x0304fcfd, 0x048764f3,
  0xffc080fe, 0xe666e667, 0xd5562aac, 0xc002801a,
  0xff81017d, 0xcccd999a, 0xaaac0001, 0x80048017,
  0xffc0817d, 0xe667199a, 0xd5568001, 0xc0030017,
  0x000000fe, 0x00006667, 0x0000aaac, 0x0001001a,
  0x002a56a8, 0x11118889, 0x1c728e3a, 0x2aab0018,
  0x0043bd74, 0x1b4f17e5, 0x2d83d27e, 0x4444667c,
  0x0043fcf4, 0x1b68b165, 0x2dae7cfe, 0x448464fc,
  0x00443bf5, 0x1b8217b2, 0x2dd8d229, 0x44c3e37f,
  0xffc0807f, 0xe666b334, 0xd555d557, 0xc002001d,
  0x0000007f, 0x00003334, 0x00005557, 0x0000801d,
  0x003f8000, 0x19998001, 0x2aaa8002, 0x3ffe8020,
  0x0069d5aa, 0x2aaaa223, 0x471c6390, 0x6aa8801e,
  0x00833c76, 0x34e8317f, 0x582da7d4, 0x8441e682,
  0x00837bf6, 0x3501caff, 0x58585254, 0x8481e502,
  0x0083baf7, 0x351b314c, 0x5882a77f, 0x84c16385,
  0x0083f979, 0x35346466, 0x58aca755, 0x8500620b,
  0x003f8000, 0x19998001, 0x2aaa8002, 0x3ffe8020,
  0x007eff81, 0x3332ccce, 0x5554aaad, 0x7ffc8023,
  0x00a9552b, 0x4443eef0, 0x71c68e3b, 0xaaa68021,
  0x00c2bbf7, 0x4e817e4c, 0x82d7d27f, 0xc43fe685,
  0x00c2fb77, 0x4e9b17cc, 0x83027cff, 0xc47fe505,
  0x00c33a78, 0x4eb47e19, 0x832cd22a, 0xc4bf6388,
  0x00c378fa, 0x4ecdb133, 0x8356d200, 0xc4fe620e,
  0x00c3b6fd, 0x4ee6b11a, 0x83807c81, 0xc53ce097,
  0x003f7f81, 0x19994cce, 0x2aaa2aad, 0x3ffe0023,
  0x0069d52b, 0x2aaa6ef0, 0x471c0e3b, 0x6aa80021,
  0x00833bf7, 0x34e7fe4c, 0x582d527f, 0x84416685,
  0x00837b77, 0x350197cc, 0x5857fcff, 0x84816505,
  0x0083ba78, 0x351afe19, 0x5882522a, 0x84c0e388,
  0x0083f8fa, 0x35343133, 0x58ac5200, 0x84ffe20e,
  0x008436fd, 0x354d311a, 0x58d5fc81, 0x853e6097,
  0x00843eed, 0x3550644a, 0x58db51d1, 0x85466067,
  0x002a55aa, 0x11112223, 0x1c71e390, 0x2aaa001e,
  0x0043bc76, 0x1b4eb17f, 0x2d8327d4, 0x44436682,
  0x0043fbf6, 0x1b684aff, 0x2dadd254, 0x44836502,
  0x00443af7, 0x1b81b14c, 0x2dd8277f, 0x44c2e385,
  0x00447979, 0x1b9ae466, 0x2e022755, 0x4501e20b,
  0x0044b77c, 0x1bb3e44d, 0x2e2bd1d6, 0x45406094,
  0x0044bf6c, 0x1bb7177d, 0x2e312726, 0x45486064,
  0x0044c0e9, 0x1bb7b116, 0x2e322725, 0x4549e05b,
  0x001966cc, 0x0a3d8f5d, 0x11114446, 0x19996684,
  0x0019a64c, 0x0a5728dd, 0x113beec6, 0x19d96504,
  0x0019e54d, 0x0a708f2a, 0x116643f1, 0x1a18e387,
  0x001a23cf, 0x0a89c244, 0x119043c7, 0x1a57e20d,
  0x001a61d2, 0x0aa2c22b, 0x11b9ee48, 0x1a966096,
  0x001a69c2, 0x0aa5f55b, 0x11bf4398, 0x1a9e6066,
  0x001a6b3f, 0x0aa68ef4, 0x11c04397, 0x1a9fe05d,
  0x001a6c3d, 0x0aa6f55a, 0x11c0ee41, 0x1aa0e057,
  0x00003f80, 0x00199981, 0x002aaa82, 0x003ffea0,
  0x00007e81, 0x0032ffce, 0x0054ffad, 0x007f7d23,
  0x0000bd03, 0x004c32e8, 0x007eff83, 0x00be7ba9,
  0x0000fb06, 0x006532cf, 0x00a8aa04, 0x00fcfa32,
  0x000102f6, 0x006865ff, 0x00adff54, 0x0104fa02,
  0x00010473, 0x0068ff98, 0x00aeff53, 0x010679f9,
  0x00010571, 0x006965fe, 0x00afa9fd, 0x010779f3,
  0x000105f0, 0x00699931, 0x00afff52, 0x0107f9f0,
  0x0019664d, 0x002a552c, 0x003f7e85, 0x003f7f22,
  0x00329967, 0x00545502, 0x007e7d0b, 0x007e7e26,
  0x004b994e, 0x007dff83, 0x00bcfb94, 0x00bcfd2c,
  0x004ecc7e, 0x008354d3, 0x00c4fb64, 0x00c4fd0c,
  0x004f6617, 0x008454d2, 0x00c67b5b, 0x00c67d06,
  0x004fcc7d, 0x0084ff7c, 0x00c77b55, 0x00c77d02,
  0x004fffb0, 0x008554d1, 0x00c7fb52, 0x00c7fd00,
  0x004fffb0, 0x008554d1, 0x00c7fb52, 0x00c7fd00,
  0x0019331a, 0x0029ffd7, 0x003efe88, 0x003eff24,
  0x00323301, 0x0053aa58, 0x007d7d11, 0x007d7e2a,
  0x00356631, 0x0058ffa8, 0x00857ce1, 0x00857e0a,
  0x0035ffca, 0x0059ffa7, 0x0086fcd8, 0x0086fe04,
  0x00366630, 0x005aaa51, 0x0087fcd2, 0x0087fe00,
  0x00369963, 0x005affa6, 0x00887ccf, 0x00887dfe,
  0x00369963, 0x005affa6, 0x00887ccf, 0x00887dfe,
  0x00366630, 0x005aaa51, 0x0087fcd2, 0x0087fe00,
  0x0018ffe7, 0x0029aa82, 0x003e7e8b, 0x003e7f26,
  0x001c3317, 0x002effd2, 0x00467e5b, 0x00467f06,
  0x001cccb0, 0x002fffd1, 0x0047fe52, 0x0047ff00,
  0x001d3316, 0x0030aa7b, 0x0048fe4c, 0x0048fefc,
  0x001d6649, 0x0030ffd0, 0x00497e49, 0x00497efa,
  0x001d6649, 0x0030ffd0, 0x00497e49, 0x00497efa,
  0x001d3316, 0x0030aa7b, 0x0048fe4c, 0x0048fefc,
  0x001cccb0, 0x002fffd1, 0x0047fe52, 0x0047ff00,
  0x00033330, 0x00055551, 0x0007ffd2, 0x00080000,
  0x0003ccc9, 0x00065550, 0x00097fc9, 0x00097ffa,
  0x0004332f, 0x0006fffa, 0x000a7fc3, 0x000a7ff6,
  0x00046662, 0x0007554f, 0x000affc0, 0x000afff4,
  0x00046662, 0x0007554f, 0x000affc0, 0x000afff4,
  0x0004332f, 0x0006fffa, 0x000a7fc3, 0x000a7ff6,
  0x0003ccc9, 0x00065550, 0x00097fc9, 0x00097ffa,
  0x00009999, 0x00010000, 0x00017ff9, 0x0001801a,
  0x00009999, 0x00010000, 0x00017ff9, 0x0001801a,
  0x0000ffff, 0x0001aaaa, 0x00027ff3, 0x00028016,
  0x00013332, 0x0001ffff, 0x0002fff0, 0x00030014,
  0x00013332, 0x0001ffff, 0x0002fff0, 0x00030014,
  0x0000ffff, 0x0001aaaa, 0x00027ff3, 0x00028016,
  0x00009999, 0x00010000, 0x00017ff9, 0x0001801a,
  0xfffd6669, 0xfffbaab0, 0xfff98029, 0xfff9803a,
  0xffe46682, 0xffd2002f, 0xffbb01a0, 0xffbb0134,
  0x00006666, 0x0000aaab, 0x0000fffc, 0x0001001c,
  0x00009999, 0x00010000, 0x00017ff9, 0x0001801a,
  0x00009999, 0x00010000, 0x00017ff9, 0x0001801a,
  0x00006666, 0x0000aaab, 0x0000fffc, 0x0001001c,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfffcccd0, 0xfffaaab1, 0xfff80032, 0xfff80040,
  0xffe3cce9, 0xffd10030, 0xffb981a9, 0xffb9813a,
  0xffca99cf, 0xffa7005a, 0xff7a8323, 0xff7a8236,
  0x00003333, 0x00005556, 0x00007fff, 0x0000801e,
  0x00003333, 0x00005556, 0x00007fff, 0x0000801e,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff999a, 0xffff5557, 0xffff0008, 0xffff0024,
  0xfffc666a, 0xfffa0007, 0xfff70038, 0xfff70044,
  0xffe36683, 0xffd05586, 0xffb881af, 0xffb8813e,
  0xffca3369, 0xffa655b0, 0xff798329, 0xff79823a,
  0xffb0cd1c, 0xff7c0085, 0xff3a04a6, 0xff3a0338,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffffcccd, 0xffffaaac, 0xffff8005, 0xffff8022,
  0xffff6667, 0xffff0002, 0xfffe800b, 0xfffe8026,
  0xfffc3337, 0xfff9aab2, 0xfff6803b, 0xfff68046,
  0xffe33350, 0xffd00031, 0xffb801b2, 0xffb80140,
  0xffca0036, 0xffa6005b, 0xff79032c, 0xff79023c,
  0xffb099e9, 0xff7bab30, 0xff3984a9, 0xff39833a,
  0xf5733dc0, 0xee6abc41, 0xe5a09e42, 0xe5a069a0,
  0xffffcccd, 0xffffaaac, 0xffff8005, 0xffff8022,
  0xffff6667, 0xffff0002, 0xfffe800b, 0xfffe8026,
  0xfffc3337, 0xfff9aab2, 0xfff6803b, 0xfff68046,
  0xffe33350, 0xffd00031, 0xffb801b2, 0xffb80140,
  0xffca0036, 0xffa6005b, 0xff79032c, 0xff79023c,
  0xffb099e9, 0xff7bab30, 0xff3984a9, 0xff39833a,
  0xf5733dc0, 0xee6abc41, 0xe5a09e42, 0xe5a069a0,
  0xe4624ed1, 0xd1f92e08, 0xbaf71e41, 0xbaf6944a,
  0xffff999a, 0xffff5557, 0xffff0008, 0xffff0024,
  0xfffc666a, 0xfffa0007, 0xfff70038, 0xfff70044,
  0xffe36683, 0xffd05586, 0xffb881af, 0xffb8813e,
  0xffca3369, 0xffa655b0, 0xff798329, 0xff79823a,
  0xffb0cd1c, 0xff7c0085, 0xff3a04a6, 0xff3a0338,
  0xf57370f3, 0xee6b1196, 0xe5a11e3f, 0xe5a0e99e,
  0xe4628204, 0xd1f9835d, 0xbaf79e3e, 0xbaf71448,
  0xcac99b9d, 0xa750035c, 0x7afa9e35, 0x7af99442,
  0xfffcccd0, 0xfffaaab1, 0xfff80032, 0xfff80040,
  0xffe3cce9, 0xffd10030, 0xffb981a9, 0xffb9813a,
  0xffca99cf, 0xffa7005a, 0xff7a8323, 0xff7a8236,
  0xffb13382, 0xff7cab2f, 0xff3b04a0, 0xff3b0334,
  0xf573d759, 0xee6bbc40, 0xe5a21e39, 0xe5a1e99a,
  0xe462e86a, 0xd1fa2e07, 0xbaf89e38, 0xbaf81444,
  0xcaca0203, 0xa750ae06, 0x7afb9e2f, 0x7afa943e,
  0xb130e869, 0x7ca6d8b0, 0x3afe1e29, 0x3afc943a,
  0xffe70019, 0xffd65580, 0xffc18179, 0xffc1811a,
  0xffcdccff, 0xffac55aa, 0xff8282f3, 0xff828216,
  0xffb466b2, 0xff82007f, 0xff430470, 0xff430314,
  0xf5770a89, 0xee711190, 0xe5aa1e09, 0xe5a9e97a,
  0xe4661b9a, 0xd1ff8357, 0xbb009e08, 0xbb001424,
  0xcacd3533, 0xa7560356, 0x7b039dff, 0x7b02941e,
  0xb1341b99, 0x7cac2e00, 0x3b061df9, 0x3b04941a,
  0x979acecc, 0x52020355, 0xfb081df6, 0xfb061418,
  0xffe6cce6, 0xffd6002b, 0xffc1017c, 0xffc1011c,
  0xffcd6699, 0xffabab00, 0xff8182f9, 0xff81821a,
  0xf5900a70, 0xee9abc11, 0xe5e89c92, 0xe5e86880,
  0xe47f1b81, 0xd2292dd8, 0xbb3f1c91, 0xbb3e932a,
  0xcae6351a, 0xa77fadd7, 0x7b421c88, 0x7b411324,
  0xb14d1b80, 0x7cd5d881, 0x3b449c82, 0x3b431320,
  0x97b3ceb3, 0x522badd6, 0xfb469c7f, 0xfb44931e,
  0xb14d4eb3, 0x7cd62dd6, 0x3b451c7f, 0x3b43931e,
  0xffe699b3, 0xffd5aad6, 0xffc0817f, 0xffc0811e,
  0xf5a93d8a, 0xeec4bbe7, 0xe6279b18, 0xe6276784,
  0xe4984e9b, 0xd2532dae, 0xbb7e1b17, 0xbb7d922e,
  0xcaff6834, 0xa7a9adad, 0x7b811b0e, 0x7b801228,
  0xb1664e9a, 0x7cffd857, 0x3b839b08, 0x3b821224,
  0x97cd01cd, 0x5255adac, 0xfb859b05, 0xfb839222,
  0xb16681cd, 0x7d002dac, 0x3b841b05, 0x3b829222,
  0xcaffce9a, 0xa7aa5857, 0x7b821b08, 0x7b811224,
  0xf5c2a3d7, 0xeeef1112, 0xe667199b, 0xe666e686,
  0xe4b1b4e8, 0xd27d82d9, 0xbbbd999a, 0xbbbd1130,
  0xcb18ce81, 0xa7d402d8, 0x7bc09991, 0x7bbf912a,
  0xb17fb4e7, 0x7d2a2d82, 0x3bc3198b, 0x3bc19126,
  0x97e6681a, 0x528002d7, 0xfbc51988, 0xfbc31124,
  0xb17fe81a, 0x7d2a82d7, 0x3bc39988, 0x3bc21124,
  0xcb1934e7, 0xa7d4ad82, 0x7bc1998b, 0x7bc09126,
  0xdc2a5709, 0xc4469110, 0xa66b9989, 0xa66ae67a,
  0xeeef1111, 0xe38e71c8, 0xd5568001, 0xd5562aca,
  0xd5562aaa, 0xb8e4f1c7, 0x95597ff8, 0x9558aac4,
  0xbbbd1110, 0x8e3b1c71, 0x555bfff2, 0x555aaac0,
  0xa223c443, 0x6390f1c6, 0x155dffef, 0x155c2abe,
  0xbbbd4443, 0x8e3b71c6, 0x555c7fef, 0x555b2abe,
  0xd5569110, 0xb8e59c71, 0x955a7ff2, 0x9559aac0,
  0xe667b332, 0xd5577fff, 0xc0047ff0, 0xc0040014,
  0xf0a5428e, 0xe668c443, 0xd99de654, 0xd99d99ac,
  0xe6671999, 0xd5568000, 0xc002fff9, 0xc002801a,
  0xcccdffff, 0xaaacaaaa, 0x80057ff3, 0x80048016,
  0xb334b332, 0x80027fff, 0x40077ff0, 0x40060014,
  0xccce3332, 0xaaacffff, 0x8005fff0, 0x80050014,
  0xe6677fff, 0xd5572aaa, 0xc003fff3, 0xc0038016,
  0xf778a221, 0xf1c90e38, 0xeaadfff1, 0xeaadd56a,
  0x01b6317d, 0x02da527c, 0x04476655, 0x04476f02,
  0x01cfcafd, 0x0304fcfc, 0x048764d5, 0x04876e02,
  0xe666e666, 0xd5562aab, 0xc0027ffc, 0xc002001c,
  0xcccd9999, 0xaaac0000, 0x80047ff9, 0x8003801a,
  0xe6671999, 0xd5568000, 0xc002fff9, 0xc002801a,
  0x00006666, 0x0000aaab, 0x0000fffc, 0x0001001c,
  0x11118888, 0x1c728e39, 0x2aaafffa, 0x2aab5570,
  0x1b4f17e4, 0x2d83d27d, 0x4444665e, 0x4444ef08,
  0x1b68b164, 0x2dae7cfd, 0x448464de, 0x4484ee08,
  0x1b8217b1, 0x2dd8d228, 0x44c3e361, 0x44c46d0a,
  0xe666b333, 0xd555d556, 0xc001ffff, 0xc001801e,
  0x00003333, 0x00005556, 0x00007fff, 0x0000801e,
  0x19998000, 0x2aaa8001, 0x3ffe8002, 0x3fff0020,
  0x2aaaa222, 0x471c638f, 0x6aa88000, 0x6aa95574,
  0x34e8317e, 0x582da7d3, 0x8441e664, 0x8442ef0c,
  0x3501cafe, 0x58585253, 0x8481e4e4, 0x8482ee0c,
  0x351b314b, 0x5882a77e, 0x84c16367, 0x84c26d0e,
  0x35346465, 0x58aca754, 0x850061ed, 0x85016c12,
  0x19998000, 0x2aaa8001, 0x3ffe8002, 0x3fff0020,
  0x3332cccd, 0x5554aaac, 0x7ffc8005, 0x7ffd8022,
  0x4443eeef, 0x71c68e3a, 0xaaa68003, 0xaaa7d576,
  0x4e817e4b, 0x82d7d27e, 0xc43fe667, 0xc4416f0e,
  0x4e9b17cb, 0x83027cfe, 0xc47fe4e7, 0xc4816e0e,
  0x4eb47e18, 0x832cd229, 0xc4bf636a, 0xc4c0ed10,
  0x4ecdb132, 0x8356d1ff, 0xc4fe61f0, 0xc4ffec14,
  0x4ee6b119, 0x83807c80, 0xc53ce079, 0xc53e6b1a,
  0x19994ccd, 0x2aaa2aac, 0x3ffe0005, 0x3ffe8022,
  0x2aaa6eef, 0x471c0e3a, 0x6aa80003, 0x6aa8d576,
  0x34e7fe4b, 0x582d527e, 0x84416667, 0x84426f0e,
  0x350197cb, 0x5857fcfe, 0x848164e7, 0x84826e0e,
  0x351afe18, 0x58825229, 0x84c0e36a, 0x84c1ed10,
  0x35343132, 0x58ac51ff, 0x84ffe1f0, 0x8500ec14,
  0x354d3119, 0x58d5fc80, 0x853e6079, 0x853f6b1a,
  0x35506449, 0x58db51d0, 0x85466049, 0x85476afa,
  0x11112222, 0x1c71e38f, 0x2aaa0000, 0x2aaa5574,
  0x1b4eb17e, 0x2d8327d3, 0x44436664, 0x4443ef0c,
  0x1b684afe, 0x2dadd253, 0x448364e4, 0x4483ee0c,
  0x1b81b14b, 0x2dd8277e, 0x44c2e367, 0x44c36d0e,
  0x1b9ae465, 0x2e022754, 0x4501e1ed, 0x45026c12,
  0x1bb3e44c, 0x2e2bd1d5, 0x45406076, 0x4540eb18,
  0x1bb7177c, 0x2e312725, 0x45486046, 0x4548eaf8,
  0x1bb7b115, 0x2e322724, 0x4549e03d, 0x454a6af2,
  0x0a3d8f5c, 0x11114445, 0x19996666, 0x199999b8,
  0x0a5728dc, 0x113beec5, 0x19d964e6, 0x19d998b8,
  0x0a708f29, 0x116643f0, 0x1a18e369, 0x1a1917ba,
  0x0a89c243, 0x119043c6, 0x1a57e1ef, 0x1a5816be,
  0x0aa2c22a, 0x11b9ee47, 0x1a966078, 0x1a9695c4,
  0x0aa5f55a, 0x11bf4397, 0x1a9e6048, 0x1a9e95a4,
  0x0aa68ef3, 0x11c04396, 0x1a9fe03f, 0x1aa0159e,
  0x0aa6f559, 0x11c0ee40, 0x1aa0e039, 0x1aa1159a,
  0x00199980, 0x002aaa81, 0x003ffe82, 0x003fff20,
  0x0032ffcd, 0x0054ffac, 0x007f7d05, 0x007f7e22,
  0x004c32e7, 0x007eff82, 0x00be7b8b, 0x00be7d26,
  0x006532ce, 0x00a8aa03, 0x00fcfa14, 0x00fcfc2c,
  0x006865fe, 0x00adff53, 0x0104f9e4, 0x0104fc0c,
  0x0068ff97, 0x00aeff52, 0x010679db, 0x01067c06,
  0x006965fd, 0x00afa9fc, 0x010779d5, 0x01077c02,
  0x00699930, 0x00afff51, 0x0107f9d2, 0x0107fc00,
  0x002a552b, 0x003f7e84, 0x003f7f04, 0x003f7fa1,
  0x00545501, 0x007e7d0a, 0x007e7e08, 0x007e7f23,
  0x007dff82, 0x00bcfb93, 0x00bcfd0e, 0x00bcfea6,
  0x008354d2, 0x00c4fb63, 0x00c4fcee, 0x00c4fe96,
  0x008454d1, 0x00c67b5a, 0x00c67ce8, 0x00c67e93,
  0x0084ff7b, 0x00c77b54, 0x00c77ce4, 0x00c77e91,
  0x008554d0, 0x00c7fb51, 0x00c7fce2, 0x00c7fe90,
  0x008554d0, 0x00c7fb51, 0x00c7fce2, 0x00c7fe90,
  0x0029ffd6, 0x003efe87, 0x003eff06, 0x003effa2,
  0x0053aa57, 0x007d7d10, 0x007d7e0c, 0x007d7f25,
  0x0058ffa7, 0x00857ce0, 0x00857dec, 0x00857f15,
  0x0059ffa6, 0x0086fcd7, 0x0086fde6, 0x0086ff12,
  0x005aaa50, 0x0087fcd1, 0x0087fde2, 0x0087ff10,
  0x005affa5, 0x00887cce, 0x00887de0, 0x00887f0f,
  0x005affa5, 0x00887cce, 0x00887de0, 0x00887f0f,
  0x005aaa50, 0x0087fcd1, 0x0087fde2, 0x0087ff10,
  0x0029aa81, 0x003e7e8a, 0x003e7f08, 0x003e7fa3,
  0x002effd1, 0x00467e5a, 0x00467ee8, 0x00467f93,
  0x002fffd0, 0x0047fe51, 0x0047fee2, 0x0047ff90,
  0x0030aa7a, 0x0048fe4b, 0x0048fede, 0x0048ff8e,
  0x0030ffcf, 0x00497e48, 0x00497edc, 0x00497f8d,
  0x0030ffcf, 0x00497e48, 0x00497edc, 0x00497f8d,
  0x0030aa7a, 0x0048fe4b, 0x0048fede, 0x0048ff8e,
  0x002fffd0, 0x0047fe51, 0x0047fee2, 0x0047ff90,
  0x00055550, 0x0007ffd1, 0x0007ffe2, 0x00080010,
  0x0006554f, 0x00097fc8, 0x00097fdc, 0x0009800d,
  0x0006fff9, 0x000a7fc2, 0x000a7fd8, 0x000a800b,
  0x0007554e, 0x000affbf, 0x000affd6, 0x000b000a,
  0x0007554e, 0x000affbf, 0x000affd6, 0x000b000a,
  0x0006fff9, 0x000a7fc2, 0x000a7fd8, 0x000a800b,
  0x0006554f, 0x00097fc8, 0x00097fdc, 0x0009800d,
  0x0000ffff, 0x00017ff8, 0x00017ffc, 0x0001801d,
  0x0000ffff, 0x00017ff8, 0x00017ffc, 0x0001801d,
  0x0001aaa9, 0x00027ff2, 0x00027ff8, 0x0002801b,
  0x0001fffe, 0x0002ffef, 0x0002fff6, 0x0003001a,
  0x0001fffe, 0x0002ffef, 0x0002fff6, 0x0003001a,
  0x0001aaa9, 0x00027ff2, 0x00027ff8, 0x0002801b,
  0x0000ffff, 0x00017ff8, 0x00017ffc, 0x0001801d,
  0xfffbaaaf, 0xfff98028, 0xfff9801c, 0xfff9802d,
  0xffd2002e, 0xffbb019f, 0xffbb0116, 0xffbb00aa,
  0x0000aaaa, 0x0000fffb, 0x0000fffe, 0x0001001e,
  0x0000ffff, 0x00017ff8, 0x00017ffc, 0x0001801d,
  0x0000ffff, 0x00017ff8, 0x00017ffc, 0x0001801d,
  0x0000aaaa, 0x0000fffb, 0x0000fffe, 0x0001001e,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfffaaab0, 0xfff80031, 0xfff80022, 0xfff80030,
  0xffd1002f, 0xffb981a8, 0xffb9811c, 0xffb980ad,
  0xffa70059, 0xff7a8322, 0xff7a8218, 0xff7a812b,
  0x00005555, 0x00007ffe, 0x00008000, 0x0000801f,
  0x00005555, 0x00007ffe, 0x00008000, 0x0000801f,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff5556, 0xffff0007, 0xffff0006, 0xffff0022,
  0xfffa0006, 0xfff70037, 0xfff70026, 0xfff70032,
  0xffd05585, 0xffb881ae, 0xffb88120, 0xffb880af,
  0xffa655af, 0xff798328, 0xff79821c, 0xff79812d,
  0xff7c0084, 0xff3a04a5, 0xff3a031a, 0xff3a01ac,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffffaaab, 0xffff8004, 0xffff8004, 0xffff8021,
  0xffff0001, 0xfffe800a, 0xfffe8008, 0xfffe8023,
  0xfff9aab1, 0xfff6803a, 0xfff68028, 0xfff68033,
  0xffd00030, 0xffb801b1, 0xffb80122, 0xffb800b0,
  0xffa6005a, 0xff79032b, 0xff79021e, 0xff79012e,
  0xff7bab2f, 0xff3984a8, 0xff39831c, 0xff3981ad,
  0xee6abc40, 0xe5a09e41, 0xe5a06982, 0xe5a034e0,
  0xffffaaab, 0xffff8004, 0xffff8004, 0xffff8021,
  0xffff0001, 0xfffe800a, 0xfffe8008, 0xfffe8023,
  0xfff9aab1, 0xfff6803a, 0xfff68028, 0xfff68033,
  0xffd00030, 0xffb801b1, 0xffb80122, 0xffb800b0,
  0xffa6005a, 0xff79032b, 0xff79021e, 0xff79012e,
  0xff7bab2f, 0xff3984a8, 0xff39831c, 0xff3981ad,
  0xee6abc40, 0xe5a09e41, 0xe5a06982, 0xe5a034e0,
  0xd1f92e07, 0xbaf71e40, 0xbaf6942c, 0xbaf60a35,
  0xffff5556, 0xffff0007, 0xffff0006, 0xffff0022,
  0xfffa0006, 0xfff70037, 0xfff70026, 0xfff70032,
  0xffd05585, 0xffb881ae, 0xffb88120, 0xffb880af,
  0xffa655af, 0xff798328, 0xff79821c, 0xff79812d,
  0xff7c0084, 0xff3a04a5, 0xff3a031a, 0xff3a01ac,
  0xee6b1195, 0xe5a11e3e, 0xe5a0e980, 0xe5a0b4df,
  0xd1f9835c, 0xbaf79e3d, 0xbaf7142a, 0xbaf68a34,
  0xa750035b, 0x7afa9e34, 0x7af99424, 0x7af88a31,
  0xfffaaab0, 0xfff80031, 0xfff80022, 0xfff80030,
  0xffd1002f, 0xffb981a8, 0xffb9811c, 0xffb980ad,
  0xffa70059, 0xff7a8322, 0xff7a8218, 0xff7a812b,
  0xff7cab2e, 0xff3b049f, 0xff3b0316, 0xff3b01aa,
  0xee6bbc3f, 0xe5a21e38, 0xe5a1e97c, 0xe5a1b4dd,
  0xd1fa2e06, 0xbaf89e37, 0xbaf81426, 0xbaf78a32,
  0xa750ae05, 0x7afb9e2e, 0x7afa9420, 0x7af98a2f,
  0x7ca6d8af, 0x3afe1e28, 0x3afc941c, 0x3afb0a2d,
  0xffd6557f, 0xffc18178, 0xffc180fc, 0xffc1809d,
  0xffac55a9, 0xff8282f2, 0xff8281f8, 0xff82811b,
  0xff82007e, 0xff43046f, 0xff4302f6, 0xff43019a,
  0xee71118f, 0xe5aa1e08, 0xe5a9e95c, 0xe5a9b4cd,
  0xd1ff8356, 0xbb009e07, 0xbb001406, 0xbaff8a22,
  0xa7560355, 0x7b039dfe, 0x7b029400, 0x7b018a1f,
  0x7cac2dff, 0x3b061df8, 0x3b0493fc, 0x3b030a1d,
  0x52020354, 0xfb081df5, 0xfb0613fa, 0xfb040a1c,
  0xffd6002a, 0xffc1017b, 0xffc100fe, 0xffc1009e,
  0xffabaaff, 0xff8182f8, 0xff8181fc, 0xff81811d,
  0xee9abc10, 0xe5e89c91, 0xe5e86862, 0xe5e83450,
  0xd2292dd7, 0xbb3f1c90, 0xbb3e930c, 0xbb3e09a5,
  0xa77fadd6, 0x7b421c87, 0x7b411306, 0x7b4009a2,
  0x7cd5d880, 0x3b449c81, 0x3b431302, 0x3b4189a0,
  0x522badd5, 0xfb469c7e, 0xfb449300, 0xfb42899f,
  0x7cd62dd5, 0x3b451c7e, 0x3b439300, 0x3b42099f,
  0xffd5aad5, 0xffc0817e, 0xffc08100, 0xffc0809f,
  0xeec4bbe6, 0xe6279b17, 0xe6276766, 0xe62733d2,
  0xd2532dad, 0xbb7e1b16, 0xbb7d9210, 0xbb7d0927,
  0xa7a9adac, 0x7b811b0d, 0x7b80120a, 0x7b7f0924,
  0x7cffd856, 0x3b839b07, 0x3b821206, 0x3b808922,
  0x5255adab, 0xfb859b04, 0xfb839204, 0xfb818921,
  0x7d002dab, 0x3b841b04, 0x3b829204, 0x3b810921,
  0xa7aa5856, 0x7b821b07, 0x7b811206, 0x7b800922,
  0xeeef1111, 0xe667199a, 0xe666e668, 0xe666b353,
  0xd27d82d8, 0xbbbd9999, 0xbbbd1112, 0xbbbc88a8,
  0xa7d402d7, 0x7bc09990, 0x7bbf910c, 0x7bbe88a5,
  0x7d2a2d81, 0x3bc3198a, 0x3bc19108, 0x3bc008a3,
  0x528002d6, 0xfbc51987, 0xfbc31106, 0xfbc108a2,
  0x7d2a82d6, 0x3bc39987, 0x3bc21106, 0x3bc088a2,
  0xa7d4ad81, 0x7bc1998a, 0x7bc09108, 0x7bbf88a3,
  0xc446910f, 0xa66b9988, 0xa66ae65c, 0xa66a334d,
  0xe38e71c7, 0xd5568000, 0xd5562aac, 0xd555d575,
  0xb8e4f1c6, 0x95597ff7, 0x9558aaa6, 0x9557d572,
  0x8e3b1c70, 0x555bfff1, 0x555aaaa2, 0x55595570,
  0x6390f1c5, 0x155dffee, 0x155c2aa0, 0x155a556f,
  0x8e3b71c5, 0x555c7fee, 0x555b2aa0, 0x5559d56f,
  0xb8e59c70, 0x955a7ff1, 0x9559aaa2, 0x9558d570,
  0xd5577ffe, 0xc0047fef, 0xc003fff6, 0xc003801a,
  0xe668c442, 0xd99de653, 0xd99d998e, 0xd99d4ce6,
  0xd5567fff, 0xc002fff8, 0xc0027ffc, 0xc002001d,
  0xaaacaaa9, 0x80057ff2, 0x80047ff8, 0x8003801b,
  0x80027ffe, 0x40077fef, 0x4005fff6, 0x4004801a,
  0xaaacfffe, 0x8005ffef, 0x8004fff6, 0x8004001a,
  0xd5572aa9, 0xc003fff2, 0xc0037ff8, 0xc003001b,
  0xf1c90e37, 0xeaadfff0, 0xeaadd54c, 0xeaadaac5,
  0x02da527b, 0x04476654, 0x04476ee4, 0x04477791,
  0x0304fcfb, 0x048764d4, 0x04876de4, 0x04877711,
  0xd5562aaa, 0xc0027ffb, 0xc001fffe, 0xc001801e,
  0xaaabffff, 0x80047ff8, 0x80037ffc, 0x8002801d,
  0xd5567fff, 0xc002fff8, 0xc0027ffc, 0xc002001d,
  0x0000aaaa, 0x0000fffb, 0x0000fffe, 0x0001001e,
  0x1c728e38, 0x2aaafff9, 0x2aab5552, 0x2aabaac8,
  0x2d83d27c, 0x4444665d, 0x4444eeea, 0x44457794,
  0x2dae7cfc, 0x448464dd, 0x4484edea, 0x44857714,
  0x2dd8d227, 0x44c3e360, 0x44c46cec, 0x44c4f695,
  0xd555d555, 0xc001fffe, 0xc0018000, 0xc001001f,
  0x00005555, 0x00007ffe, 0x00008000, 0x0000801f,
  0x2aaa8000, 0x3ffe8001, 0x3fff0002, 0x3fff8020,
  0x471c638e, 0x6aa87fff, 0x6aa95556, 0x6aaa2aca,
  0x582da7d2, 0x8441e663, 0x8442eeee, 0x8443f796,
  0x58585252, 0x8481e4e3, 0x8482edee, 0x8483f716,
  0x5882a77d, 0x84c16366, 0x84c26cf0, 0x84c37697,
  0x58aca753, 0x850061ec, 0x85016bf4, 0x85027619,
  0x2aaa8000, 0x3ffe8001, 0x3fff0002, 0x3fff8020,
  0x5554aaab, 0x7ffc8004, 0x7ffd8004, 0x7ffe8021,
  0x71c68e39, 0xaaa68002, 0xaaa7d558, 0xaaa92acb,
  0x82d7d27d, 0xc43fe666, 0xc4416ef0, 0xc442f797,
  0x83027cfd, 0xc47fe4e6, 0xc4816df0, 0xc482f717,
  0x832cd228, 0xc4bf6369, 0xc4c0ecf2, 0xc4c27698,
  0x8356d1fe, 0xc4fe61ef, 0xc4ffebf6, 0xc501761a,
  0x83807c7f, 0xc53ce078, 0xc53e6afc, 0xc53ff59d,
  0x2aaa2aab, 0x3ffe0004, 0x3ffe8004, 0x3fff0021,
  0x471c0e39, 0x6aa80002, 0x6aa8d558, 0x6aa9aacb,
  0x582d527d, 0x84416666, 0x84426ef0, 0x84437797,
  0x5857fcfd, 0x848164e6, 0x84826df0, 0x84837717,
  0x58825228, 0x84c0e369, 0x84c1ecf2, 0x84c2f698,
  0x58ac51fe, 0x84ffe1ef, 0x8500ebf6, 0x8501f61a,
  0x58d5fc7f, 0x853e6078, 0x853f6afc, 0x8540759d,
  0x58db51cf, 0x85466048, 0x85476adc, 0x8548758d,
  0x1c71e38e, 0x2aa9ffff, 0x2aaa5556, 0x2aaaaaca,
  0x2d8327d2, 0x44436663, 0x4443eeee, 0x44447796,
  0x2dadd252, 0x448364e3, 0x4483edee, 0x44847716,
  0x2dd8277d, 0x44c2e366, 0x44c36cf0, 0x44c3f697,
  0x2e022753, 0x4501e1ec, 0x45026bf4, 0x4502f619,
  0x2e2bd1d4, 0x45406075, 0x4540eafa, 0x4541759c,
  0x2e312724, 0x45486045, 0x4548eada, 0x4549758c,
  0x2e322723, 0x4549e03c, 0x454a6ad4, 0x454af589,
  0x11114444, 0x19996665, 0x1999999a, 0x1999ccec,
  0x113beec4, 0x19d964e5, 0x19d9989a, 0x19d9cc6c,
  0x116643ef, 0x1a18e368, 0x1a19179c, 0x1a194bed,
  0x119043c5, 0x1a57e1ee, 0x1a5816a0, 0x1a584b6f,
  0x11b9ee46, 0x1a966077, 0x1a9695a6, 0x1a96caf2,
  0x11bf4396, 0x1a9e6047, 0x1a9e9586, 0x1a9ecae2,
  0x11c04395, 0x1a9fe03e, 0x1aa01580, 0x1aa04adf,
  0x11c0ee3f, 0x1aa0e038, 0x1aa1157c, 0x1aa14add,
  0x002aaa80, 0x003ffe81, 0x003fff02, 0x003fffa0,
  0x0054ffab, 0x007f7d04, 0x007f7e04, 0x007f7f21,
  0x007eff81, 0x00be7b8a, 0x00be7d08, 0x00be7ea3,
  0x00a8aa02, 0x00fcfa13, 0x00fcfc0e, 0x00fcfe26,
  0x00adff52, 0x0104f9e3, 0x0104fbee, 0x0104fe16,
  0x00aeff51, 0x010679da, 0x01067be8, 0x01067e13,
  0x00afa9fb, 0x010779d4, 0x01077be4, 0x01077e11,
  0x00afff50, 0x0107f9d1, 0x0107fbe2, 0x0107fe10,
  0x003f7e83, 0x003f7f03, 0x003f7f83, 0xffc08020,
  0x007e7d09, 0x007e7e07, 0x007e7f05, 0xff818020,
  0x00bcfb92, 0x00bcfd0d, 0x00bcfe88, 0xff430020,
  0x00c4fb62, 0x00c4fced, 0x00c4fe78, 0xff3b0020,
  0x00c67b59, 0x00c67ce7, 0x00c67e75, 0xff398020,
  0x00c77b53, 0x00c77ce3, 0x00c77e73, 0xff388020,
  0x00c7fb50, 0x00c7fce1, 0x00c7fe72, 0xff380020,
  0x00c7fb50, 0x00c7fce1, 0x00c7fe72, 0xff380020,
  0x003efe86, 0x003eff05, 0x003eff84, 0xffc10020,
  0x007d7d0f, 0x007d7e0b, 0x007d7f07, 0xff828020,
  0x00857cdf, 0x00857deb, 0x00857ef7, 0xff7a8020,
  0x0086fcd6, 0x0086fde5, 0x0086fef4, 0xff790020,
  0x0087fcd0, 0x0087fde1, 0x0087fef2, 0xff780020,
  0x00887ccd, 0x00887ddf, 0x00887ef1, 0xff778020,
  0x00887ccd, 0x00887ddf, 0x00887ef1, 0xff778020,
  0x0087fcd0, 0x0087fde1, 0x0087fef2, 0xff780020,
  0x003e7e89, 0x003e7f07, 0x003e7f85, 0xffc18020,
  0x00467e59, 0x00467ee7, 0x00467f75, 0xffb98020,
  0x0047fe50, 0x0047fee1, 0x0047ff72, 0xffb80020,
  0x0048fe4a, 0x0048fedd, 0x0048ff70, 0xffb70020,
  0x00497e47, 0x00497edb, 0x00497f6f, 0xffb68020,
  0x00497e47, 0x00497edb, 0x00497f6f, 0xffb68020,
  0x0048fe4a, 0x0048fedd, 0x0048ff70, 0xffb70020,
  0x0047fe50, 0x0047fee1, 0x0047ff72, 0xffb80020,
  0x0007ffd0, 0x0007ffe1, 0x0007fff2, 0xfff80020,
  0x00097fc7, 0x00097fdb, 0x00097fef, 0xfff68020,
  0x000a7fc1, 0x000a7fd7, 0x000a7fed, 0xfff58020,
  0x000affbe, 0x000affd5, 0x000affec, 0xfff50020,
  0x000affbe, 0x000affd5, 0x000affec, 0xfff50020,
  0x000a7fc1, 0x000a7fd7, 0x000a7fed, 0xfff58020,
  0x00097fc7, 0x00097fdb, 0x00097fef, 0xfff68020,
  0x00017ff7, 0x00017ffb, 0x00017fff, 0xfffe8020,
  0x00017ff7, 0x00017ffb, 0x00017fff, 0xfffe8020,
  0x00027ff1, 0x00027ff7, 0x00027ffd, 0xfffd8020,
  0x0002ffee, 0x0002fff5, 0x0002fffc, 0xfffd0020,
  0x0002ffee, 0x0002fff5, 0x0002fffc, 0xfffd0020,
  0x00027ff1, 0x00027ff7, 0x00027ffd, 0xfffd8020,
  0x00017ff7, 0x00017ffb, 0x00017fff, 0xfffe8020,
  0xfff98027, 0xfff9801b, 0xfff9800f, 0x00068020,
  0xffbb019e, 0xffbb0115, 0xffbb008c, 0x00450020,
  0x0000fffa, 0x0000fffd, 0x00010000, 0xffff0020,
  0x00017ff7, 0x00017ffb, 0x00017fff, 0xfffe8020,
  0x00017ff7, 0x00017ffb, 0x00017fff, 0xfffe8020,
  0x0000fffa, 0x0000fffd, 0x00010000, 0xffff0020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfff80030, 0xfff80021, 0xfff80012, 0x00080020,
  0xffb981a7, 0xffb9811b, 0xffb9808f, 0x00468020,
  0xff7a8321, 0xff7a8217, 0xff7a810d, 0x00858020,
  0x00007ffd, 0x00007fff, 0x00008001, 0xffff8020,
  0x00007ffd, 0x00007fff, 0x00008001, 0xffff8020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff0006, 0xffff0005, 0xffff0004, 0x00010020,
  0xfff70036, 0xfff70025, 0xfff70014, 0x00090020,
  0xffb881ad, 0xffb8811f, 0xffb88091, 0x00478020,
  0xff798327, 0xff79821b, 0xff79810f, 0x00868020,
  0xff3a04a4, 0xff3a0319, 0xff3a018e, 0x00c60020,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff8003, 0xffff8003, 0xffff8003, 0x00008020,
  0xfffe8009, 0xfffe8007, 0xfffe8005, 0x00018020,
  0xfff68039, 0xfff68027, 0xfff68015, 0x00098020,
  0xffb801b0, 0xffb80121, 0xffb80092, 0x00480020,
  0xff79032a, 0xff79021d, 0xff790110, 0x00870020,
  0xff3984a7, 0xff39831b, 0xff39818f, 0x00c68020,
  0xe5a09e40, 0xe5a06981, 0xe5a034c2, 0x1a600020,
  0xffff8003, 0xffff8003, 0xffff8003, 0x00008020,
  0xfffe8009, 0xfffe8007, 0xfffe8005, 0x00018020,
  0xfff68039, 0xfff68027, 0xfff68015, 0x00098020,
  0xffb801b0, 0xffb80121, 0xffb80092, 0x00480020,
  0xff79032a, 0xff79021d, 0xff790110, 0x00870020,
  0xff3984a7, 0xff39831b, 0xff39818f, 0x00c68020,
  0xe5a09e40, 0xe5a06981, 0xe5a034c2, 0x1a600020,
  0xbaf71e3f, 0xbaf6942b, 0xbaf60a17, 0x450a8020,
  0xffff0006, 0xffff0005, 0xffff0004, 0x00010020,
  0xfff70036, 0xfff70025, 0xfff70014, 0x00090020,
  0xffb881ad, 0xffb8811f, 0xffb88091, 0x00478020,
  0xff798327, 0xff79821b, 0xff79810f, 0x00868020,
  0xff3a04a4, 0xff3a0319, 0xff3a018e, 0x00c60020,
  0xe5a11e3d, 0xe5a0e97f, 0xe5a0b4c1, 0x1a5f8020,
  0xbaf79e3c, 0xbaf71429, 0xbaf68a16, 0x450a0020,
  0x7afa9e33, 0x7af99423, 0x7af88a13, 0x85088020,
  0xfff80030, 0xfff80021, 0xfff80012, 0x00080020,
  0xffb981a7, 0xffb9811b, 0xffb9808f, 0x00468020,
  0xff7a8321, 0xff7a8217, 0xff7a810d, 0x00858020,
  0xff3b049e, 0xff3b0315, 0xff3b018c, 0x00c50020,
  0xe5a21e37, 0xe5a1e97b, 0xe5a1b4bf, 0x1a5e8020,
  0xbaf89e36, 0xbaf81425, 0xbaf78a14, 0x45090020,
  0x7afb9e2d, 0x7afa941f, 0x7af98a11, 0x85078020,
  0x3afe1e27, 0x3afc941b, 0x3afb0a0f, 0xc5068020,
  0xffc18177, 0xffc180fb, 0xffc1807f, 0x003e8020,
  0xff8282f1, 0xff8281f7, 0xff8280fd, 0x007d8020,
  0xff43046e, 0xff4302f5, 0xff43017c, 0x00bd0020,
  0xe5aa1e07, 0xe5a9e95b, 0xe5a9b4af, 0x1a568020,
  0xbb009e06, 0xbb001405, 0xbaff8a04, 0x45010020,
  0x7b039dfd, 0x7b0293ff, 0x7b018a01, 0x84ff8020,
  0x3b061df7, 0x3b0493fb, 0x3b0309ff, 0xc4fe8020,
  0xfb081df4, 0xfb0613f9, 0xfb0409fe, 0x04fe0020,
  0xffc1017a, 0xffc100fd, 0xffc10080, 0x003f0020,
  0xff8182f7, 0xff8181fb, 0xff8180ff, 0x007e8020,
  0xe5e89c90, 0xe5e86861, 0xe5e83432, 0x1a180020,
  0xbb3f1c8f, 0xbb3e930b, 0xbb3e0987, 0x44c28020,
  0x7b421c86, 0x7b411305, 0x7b400984, 0x84c10020,
  0x3b449c80, 0x3b431301, 0x3b418982, 0xc4c00020,
  0xfb469c7d, 0xfb4492ff, 0xfb428981, 0x04bf8020,
  0x3b451c7d, 0x3b4392ff, 0x3b420981, 0xc4bf8020,
  0xffc0817d, 0xffc080ff, 0xffc08081, 0x003f8020,
  0xe6279b16, 0xe6276765, 0xe62733b4, 0x19d90020,
  0xbb7e1b15, 0xbb7d920f, 0xbb7d0909, 0x44838020,
  0x7b811b0c, 0x7b801209, 0x7b7f0906, 0x84820020,
  0x3b839b06, 0x3b821205, 0x3b808904, 0xc4810020,
  0xfb859b03, 0xfb839203, 0xfb818903, 0x04808020,
  0x3b841b03, 0x3b829203, 0x3b810903, 0xc4808020,
  0x7b821b06, 0x7b811205, 0x7b800904, 0x84810020,
  0xe6671999, 0xe666e667, 0xe666b335, 0x19998020,
  0xbbbd9998, 0xbbbd1111, 0xbbbc888a, 0x44440020,
  0x7bc0998f, 0x7bbf910b, 0x7bbe8887, 0x84428020,
  0x3bc31989, 0x3bc19107, 0x3bc00885, 0xc4418020,
  0xfbc51986, 0xfbc31105, 0xfbc10884, 0x04410020,
  0x3bc39986, 0x3bc21105, 0x3bc08884, 0xc4410020,
  0x7bc19989, 0x7bc09107, 0x7bbf8885, 0x84418020,
  0xa66b9987, 0xa66ae65b, 0xa66a332f, 0x59968020,
  0xd5567fff, 0xd5562aab, 0xd555d557, 0x2aaa8020,
  0x95597ff6, 0x9558aaa5, 0x9557d554, 0x6aa90020,
  0x555bfff0, 0x555aaaa1, 0x55595552, 0xaaa80020,
  0x155dffed, 0x155c2a9f, 0x155a5551, 0xeaa78020,
  0x555c7fed, 0x555b2a9f, 0x5559d551, 0xaaa78020,
  0x955a7ff0, 0x9559aaa1, 0x9558d552, 0x6aa80020,
  0xc0047fee, 0xc003fff5, 0xc0037ffc, 0x3ffd0020,
  0xd99de652, 0xd99d998d, 0xd99d4cc8, 0x26630020,
  0xc002fff7, 0xc0027ffb, 0xc001ffff, 0x3ffe8020,
  0x80057ff1, 0x80047ff7, 0x80037ffd, 0x7ffd8020,
  0x40077fee, 0x4005fff5, 0x40047ffc, 0xbffd0020,
  0x8005ffee, 0x8004fff5, 0x8003fffc, 0x7ffd0020,
  0xc003fff1, 0xc0037ff7, 0xc002fffd, 0x3ffd8020,
  0xeaadffef, 0xeaadd54b, 0xeaadaaa7, 0x15528020,
  0x04476653, 0x04476ee3, 0x04477773, 0xfbb88020,
  0x048764d3, 0x04876de3, 0x048776f3, 0xfb788020,
  0xc0027ffa, 0xc001fffd, 0xc0018000, 0x3fff0020,
  0x80047ff7, 0x80037ffb, 0x80027fff, 0x7ffe8020,
  0xc002fff7, 0xc0027ffb, 0xc001ffff, 0x3ffe8020,
  0x0000fffa, 0x0000fffd, 0x00010000, 0xffff0020,
  0x2aaafff8, 0x2aab5551, 0x2aabaaaa, 0xd5540020,
  0x4444665c, 0x4444eee9, 0x44457776, 0xbbba0020,
  0x448464dc, 0x4484ede9, 0x448576f6, 0xbb7a0020,
  0x44c3e35f, 0x44c46ceb, 0x44c4f677, 0xbb3a8020,
  0xc001fffd, 0xc0017fff, 0xc0010001, 0x3fff8020,
  0x00007ffd, 0x00007fff, 0x00008001, 0xffff8020,
  0x3ffe8000, 0x3fff0001, 0x3fff8002, 0xc0000020,
  0x6aa87ffe, 0x6aa95555, 0x6aaa2aac, 0x95550020,
  0x8441e662, 0x8442eeed, 0x8443f778, 0x7bbb0020,
  0x8481e4e2, 0x8482eded, 0x8483f6f8, 0x7b7b0020,
  0x84c16365, 0x84c26cef, 0x84c37679, 0x7b3b8020,
  0x850061eb, 0x85016bf3, 0x850275fb, 0x7afc8020,
  0x3ffe8000, 0x3fff0001, 0x3fff8002, 0xc0000020,
  0x7ffc8003, 0x7ffd8003, 0x7ffe8003, 0x80008020,
  0xaaa68001, 0xaaa7d557, 0xaaa92aad, 0x55558020,
  0xc43fe665, 0xc4416eef, 0xc442f779, 0x3bbb8020,
  0xc47fe4e5, 0xc4816def, 0xc482f6f9, 0x3b7b8020,
  0xc4bf6368, 0xc4c0ecf1, 0xc4c2767a, 0x3b3c0020,
  0xc4fe61ee, 0xc4ffebf5, 0xc50175fc, 0x3afd0020,
  0xc53ce077, 0xc53e6afb, 0xc53ff57f, 0x3abe8020,
  0x3ffe0003, 0x3ffe8003, 0x3fff0003, 0xc0008020,
  0x6aa80001, 0x6aa8d557, 0x6aa9aaad, 0x95558020,
  0x84416665, 0x84426eef, 0x84437779, 0x7bbb8020,
  0x848164e5, 0x84826def, 0x848376f9, 0x7b7b8020,
  0x84c0e368, 0x84c1ecf1, 0x84c2f67a, 0x7b3c0020,
  0x84ffe1ee, 0x8500ebf5, 0x8501f5fc, 0x7afd0020,
  0x853e6077, 0x853f6afb, 0x8540757f, 0x7abe8020,
  0x85466047, 0x85476adb, 0x8548756f, 0x7ab68020,
  0x2aa9fffe, 0x2aaa5555, 0x2aaaaaac, 0xd5550020,
  0x44436662, 0x4443eeed, 0x44447778, 0xbbbb0020,
  0x448364e2, 0x4483eded, 0x448476f8, 0xbb7b0020,
  0x44c2e365, 0x44c36cef, 0x44c3f679, 0xbb3b8020,
  0x4501e1eb, 0x45026bf3, 0x4502f5fb, 0xbafc8020,
  0x45406074, 0x4540eaf9, 0x4541757e, 0xbabe0020,
  0x45486044, 0x4548ead9, 0x4549756e, 0xbab60020,
  0x4549e03b, 0x454a6ad3, 0x454af56b, 0xbab48020,
  0x19996664, 0x19999999, 0x1999ccce, 0xe6660020,
  0x19d964e4, 0x19d99899, 0x19d9cc4e, 0xe6260020,
  0x1a18e367, 0x1a19179b, 0x1a194bcf, 0xe5e68020,
  0x1a57e1ed, 0x1a58169f, 0x1a584b51, 0xe5a78020,
  0x1a966076, 0x1a9695a5, 0x1a96cad4, 0xe5690020,
  0x1a9e6046, 0x1a9e9585, 0x1a9ecac4, 0xe5610020,
  0x1a9fe03d, 0x1aa0157f, 0x1aa04ac1, 0xe55f8020,
  0x1aa0e037, 0x1aa1157b, 0x1aa14abf, 0xe55e8020,
  0x003ffe80, 0x003fff01, 0x003fff82, 0xffc00020,
  0x007f7d03, 0x007f7e03, 0x007f7f03, 0xff808020,
  0x00be7b89, 0x00be7d07, 0x00be7e85, 0xff418020,
  0x00fcfa12, 0x00fcfc0d, 0x00fcfe08, 0xff030020,
  0x0104f9e2, 0x0104fbed, 0x0104fdf8, 0xfefb0020,
  0x010679d9, 0x01067be7, 0x01067df5, 0xfef98020,
  0x010779d3, 0x01077be3, 0x01077df3, 0xfef88020,
  0x0107f9d0, 0x0107fbe1, 0x0107fdf2, 0xfef80020,
  0x003f7f02, 0x003f7f82, 0xffc08002, 0xffc0809f,
  0x007e7e06, 0x007e7f04, 0xff818002, 0xff81811d,
  0x00bcfd0c, 0x00bcfe87, 0xff430002, 0xff43019a,
  0x00c4fcec, 0x00c4fe77, 0xff3b0002, 0xff3b01aa,
  0x00c67ce6, 0x00c67e74, 0xff398002, 0xff3981ad,
  0x00c77ce2, 0x00c77e72, 0xff388002, 0xff3881af,
  0x00c7fce0, 0x00c7fe71, 0xff380002, 0xff3801b0,
  0x00c7fce0, 0x00c7fe71, 0xff380002, 0xff3801b0,
  0x003eff04, 0x003eff83, 0xffc10002, 0xffc1009e,
  0x007d7e0a, 0x007d7f06, 0xff828002, 0xff82811b,
  0x00857dea, 0x00857ef6, 0xff7a8002, 0xff7a812b,
  0x0086fde4, 0x0086fef3, 0xff790002, 0xff79012e,
  0x0087fde0, 0x0087fef1, 0xff780002, 0xff780130,
  0x00887dde, 0x00887ef0, 0xff778002, 0xff778131,
  0x00887dde, 0x00887ef0, 0xff778002, 0xff778131,
  0x0087fde0, 0x0087fef1, 0xff780002, 0xff780130,
  0x003e7f06, 0x003e7f84, 0xffc18002, 0xffc1809d,
  0x00467ee6, 0x00467f74, 0xffb98002, 0xffb980ad,
  0x0047fee0, 0x0047ff71, 0xffb80002, 0xffb800b0,
  0x0048fedc, 0x0048ff6f, 0xffb70002, 0xffb700b2,
  0x00497eda, 0x00497f6e, 0xffb68002, 0xffb680b3,
  0x00497eda, 0x00497f6e, 0xffb68002, 0xffb680b3,
  0x0048fedc, 0x0048ff6f, 0xffb70002, 0xffb700b2,
  0x0047fee0, 0x0047ff71, 0xffb80002, 0xffb800b0,
  0x0007ffe0, 0x0007fff1, 0xfff80002, 0xfff80030,
  0x00097fda, 0x00097fee, 0xfff68002, 0xfff68033,
  0x000a7fd6, 0x000a7fec, 0xfff58002, 0xfff58035,
  0x000affd4, 0x000affeb, 0xfff50002, 0xfff50036,
  0x000affd4, 0x000affeb, 0xfff50002, 0xfff50036,
  0x000a7fd6, 0x000a7fec, 0xfff58002, 0xfff58035,
  0x00097fda, 0x00097fee, 0xfff68002, 0xfff68033,
  0x00017ffa, 0x00017ffe, 0xfffe8002, 0xfffe8023,
  0x00017ffa, 0x00017ffe, 0xfffe8002, 0xfffe8023,
  0x00027ff6, 0x00027ffc, 0xfffd8002, 0xfffd8025,
  0x0002fff4, 0x0002fffb, 0xfffd0002, 0xfffd0026,
  0x0002fff4, 0x0002fffb, 0xfffd0002, 0xfffd0026,
  0x00027ff6, 0x00027ffc, 0xfffd8002, 0xfffd8025,
  0x00017ffa, 0x00017ffe, 0xfffe8002, 0xfffe8023,
  0xfff9801a, 0xfff9800e, 0x00068002, 0x00068013,
  0xffbb0114, 0xffbb008b, 0x00450002, 0x0044ff96,
  0x0000fffc, 0x0000ffff, 0xffff0002, 0xffff0022,
  0x00017ffa, 0x00017ffe, 0xfffe8002, 0xfffe8023,
  0x00017ffa, 0x00017ffe, 0xfffe8002, 0xfffe8023,
  0x0000fffc, 0x0000ffff, 0xffff0002, 0xffff0022,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfff80020, 0xfff80011, 0x00080002, 0x00080010,
  0xffb9811a, 0xffb9808e, 0x00468002, 0x00467f93,
  0xff7a8216, 0xff7a810c, 0x00858002, 0x00857f15,
  0x00007ffe, 0x00008000, 0xffff8002, 0xffff8021,
  0x00007ffe, 0x00008000, 0xffff8002, 0xffff8021,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff0004, 0xffff0003, 0x00010002, 0x0001001e,
  0xfff70024, 0xfff70013, 0x00090002, 0x0009000e,
  0xffb8811e, 0xffb88090, 0x00478002, 0x00477f91,
  0xff79821a, 0xff79810e, 0x00868002, 0x00867f13,
  0xff3a0318, 0xff3a018d, 0x00c60002, 0x00c5fe94,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff8002, 0xffff8002, 0x00008002, 0x0000801f,
  0xfffe8006, 0xfffe8004, 0x00018002, 0x0001801d,
  0xfff68026, 0xfff68014, 0x00098002, 0x0009800d,
  0xffb80120, 0xffb80091, 0x00480002, 0x0047ff90,
  0xff79021c, 0xff79010f, 0x00870002, 0x0086ff12,
  0xff39831a, 0xff39818e, 0x00c68002, 0x00c67e93,
  0xe5a06980, 0xe5a034c1, 0x1a600002, 0x1a5fcb60,
  0xffff8002, 0xffff8002, 0x00008002, 0x0000801f,
  0xfffe8006, 0xfffe8004, 0x00018002, 0x0001801d,
  0xfff68026, 0xfff68014, 0x00098002, 0x0009800d,
  0xffb80120, 0xffb80091, 0x00480002, 0x0047ff90,
  0xff79021c, 0xff79010f, 0x00870002, 0x0086ff12,
  0xff39831a, 0xff39818e, 0x00c68002, 0x00c67e93,
  0xe5a06980, 0xe5a034c1, 0x1a600002, 0x1a5fcb60,
  0xbaf6942a, 0xbaf60a16, 0x450a8002, 0x4509f60b,
  0xffff0004, 0xffff0003, 0x00010002, 0x0001001e,
  0xfff70024, 0xfff70013, 0x00090002, 0x0009000e,
  0xffb8811e, 0xffb88090, 0x00478002, 0x00477f91,
  0xff79821a, 0xff79810e, 0x00868002, 0x00867f13,
  0xff3a0318, 0xff3a018d, 0x00c60002, 0x00c5fe94,
  0xe5a0e97e, 0xe5a0b4c0, 0x1a5f8002, 0x1a5f4b61,
  0xbaf71428, 0xbaf68a15, 0x450a0002, 0x4509760c,
  0x7af99422, 0x7af88a12, 0x85088002, 0x8507760f,
  0xfff80020, 0xfff80011, 0x00080002, 0x00080010,
  0xffb9811a, 0xffb9808e, 0x00468002, 0x00467f93,
  0xff7a8216, 0xff7a810c, 0x00858002, 0x00857f15,
  0xff3b0314, 0xff3b018b, 0x00c50002, 0x00c4fe96,
  0xe5a1e97a, 0xe5a1b4be, 0x1a5e8002, 0x1a5e4b63,
  0xbaf81424, 0xbaf78a13, 0x45090002, 0x4508760e,
  0x7afa941e, 0x7af98a10, 0x85078002, 0x85067611,
  0x3afc941a, 0x3afb0a0e, 0xc5068002, 0xc504f613,
  0xffc180fa, 0xffc1807e, 0x003e8002, 0x003e7fa3,
  0xff8281f6, 0xff8280fc, 0x007d8002, 0x007d7f25,
  0xff4302f4, 0xff43017b, 0x00bd0002, 0x00bcfea6,
  0xe5a9e95a, 0xe5a9b4ae, 0x1a568002, 0x1a564b73,
  0xbb001404, 0xbaff8a03, 0x45010002, 0x4500761e,
  0x7b0293fe, 0x7b018a00, 0x84ff8002, 0x84fe7621,
  0x3b0493fa, 0x3b0309fe, 0xc4fe8002, 0xc4fcf623,
  0xfb0613f8, 0xfb0409fd, 0x04fe0002, 0x04fbf624,
  0xffc100fc, 0xffc1007f, 0x003f0002, 0x003effa2,
  0xff8181fa, 0xff8180fe, 0x007e8002, 0x007e7f23,
  0xe5e86860, 0xe5e83431, 0x1a180002, 0x1a17cbf0,
  0xbb3e930a, 0xbb3e0986, 0x44c28002, 0x44c1f69b,
  0x7b411304, 0x7b400983, 0x84c10002, 0x84bff69e,
  0x3b431300, 0x3b418981, 0xc4c00002, 0xc4be76a0,
  0xfb4492fe, 0xfb428980, 0x04bf8002, 0x04bd76a1,
  0x3b4392fe, 0x3b420980, 0xc4bf8002, 0xc4bdf6a1,
  0xffc080fe, 0xffc08080, 0x003f8002, 0x003f7fa1,
  0xe6276764, 0xe62733b3, 0x19d90002, 0x19d8cc6e,
  0xbb7d920e, 0xbb7d0908, 0x44838002, 0x4482f719,
  0x7b801208, 0x7b7f0905, 0x84820002, 0x8480f71c,
  0x3b821204, 0x3b808903, 0xc4810002, 0xc47f771e,
  0xfb839202, 0xfb818902, 0x04808002, 0x047e771f,
  0x3b829202, 0x3b810902, 0xc4808002, 0xc47ef71f,
  0x7b811204, 0x7b800903, 0x84810002, 0x847ff71e,
  0xe666e666, 0xe666b334, 0x19998002, 0x19994ced,
  0xbbbd1110, 0xbbbc8889, 0x44440002, 0x44437798,
  0x7bbf910a, 0x7bbe8886, 0x84428002, 0x8441779b,
  0x3bc19106, 0x3bc00884, 0xc4418002, 0xc43ff79d,
  0xfbc31104, 0xfbc10883, 0x04410002, 0x043ef79e,
  0x3bc21104, 0x3bc08883, 0xc4410002, 0xc43f779e,
  0x7bc09106, 0x7bbf8884, 0x84418002, 0x8440779d,
  0xa66ae65a, 0xa66a332e, 0x59968002, 0x5995ccf3,
  0xd5562aaa, 0xd555d556, 0x2aaa8002, 0x2aaa2acb,
  0x9558aaa4, 0x9557d553, 0x6aa90002, 0x6aa82ace,
  0x555aaaa0, 0x55595551, 0xaaa80002, 0xaaa6aad0,
  0x155c2a9e, 0x155a5550, 0xeaa78002, 0xeaa5aad1,
  0x555b2a9e, 0x5559d550, 0xaaa78002, 0xaaa62ad1,
  0x9559aaa0, 0x9558d551, 0x6aa80002, 0x6aa72ad0,
  0xc003fff4, 0xc0037ffb, 0x3ffd0002, 0x3ffc8026,
  0xd99d998c, 0xd99d4cc7, 0x26630002, 0x2662b35a,
  0xc0027ffa, 0xc001fffe, 0x3ffe8002, 0x3ffe0023,
  0x80047ff6, 0x80037ffc, 0x7ffd8002, 0x7ffc8025,
  0x4005fff4, 0x40047ffb, 0xbffd0002, 0xbffb8026,
  0x8004fff4, 0x8003fffb, 0x7ffd0002, 0x7ffc0026,
  0xc0037ff6, 0xc002fffc, 0x3ffd8002, 0x3ffd0025,
  0xeaadd54a, 0xeaadaaa6, 0x15528002, 0x1552557b,
  0x04476ee2, 0x04477772, 0xfbb88002, 0xfbb888af,
  0x04876de2, 0x048776f2, 0xfb788002, 0xfb78892f,
  0xc001fffc, 0xc0017fff, 0x3fff0002, 0x3ffe8022,
  0x80037ffa, 0x80027ffe, 0x7ffe8002, 0x7ffd8023,
  0xc0027ffa, 0xc001fffe, 0x3ffe8002, 0x3ffe0023,
  0x0000fffc, 0x0000ffff, 0xffff0002, 0xffff0022,
  0x2aab5550, 0x2aabaaa9, 0xd5540002, 0xd5545578,
  0x4444eee8, 0x44457775, 0xbbba0002, 0xbbba88ac,
  0x4484ede8, 0x448576f5, 0xbb7a0002, 0xbb7a892c,
  0x44c46cea, 0x44c4f676, 0xbb3a8002, 0xbb3b09ab,
  0xc0017ffe, 0xc0010000, 0x3fff8002, 0x3fff0021,
  0x00007ffe, 0x00008000, 0xffff8002, 0xffff8021,
  0x3fff0000, 0x3fff8001, 0xc0000002, 0xc0008020,
  0x6aa95554, 0x6aaa2aab, 0x95550002, 0x9555d576,
  0x8442eeec, 0x8443f777, 0x7bbb0002, 0x7bbc08aa,
  0x8482edec, 0x8483f6f7, 0x7b7b0002, 0x7b7c092a,
  0x84c26cee, 0x84c37678, 0x7b3b8002, 0x7b3c89a9,
  0x85016bf2, 0x850275fa, 0x7afc8002, 0x7afd8a27,
  0x3fff0000, 0x3fff8001, 0xc0000002, 0xc0008020,
  0x7ffd8002, 0x7ffe8002, 0x80008002, 0x8001801f,
  0xaaa7d556, 0xaaa92aac, 0x55558002, 0x5556d575,
  0xc4416eee, 0xc442f778, 0x3bbb8002, 0x3bbd08a9,
  0xc4816dee, 0xc482f6f8, 0x3b7b8002, 0x3b7d0929,
  0xc4c0ecf0, 0xc4c27679, 0x3b3c0002, 0x3b3d89a8,
  0xc4ffebf4, 0xc50175fb, 0x3afd0002, 0x3afe8a26,
  0xc53e6afa, 0xc53ff57e, 0x3abe8002, 0x3ac00aa3,
  0x3ffe8002, 0x3fff0002, 0xc0008002, 0xc001001f,
  0x6aa8d556, 0x6aa9aaac, 0x95558002, 0x95565575,
  0x84426eee, 0x84437778, 0x7bbb8002, 0x7bbc88a9,
  0x84826dee, 0x848376f8, 0x7b7b8002, 0x7b7c8929,
  0x84c1ecf0, 0x84c2f679, 0x7b3c0002, 0x7b3d09a8,
  0x8500ebf4, 0x8501f5fb, 0x7afd0002, 0x7afe0a26,
  0x853f6afa, 0x8540757e, 0x7abe8002, 0x7abf8aa3,
  0x85476ada, 0x8548756e, 0x7ab68002, 0x7ab78ab3,
  0x2aaa5554, 0x2aaaaaab, 0xd5550002, 0xd5555576,
  0x4443eeec, 0x44447777, 0xbbbb0002, 0xbbbb88aa,
  0x4483edec, 0x448476f7, 0xbb7b0002, 0xbb7b892a,
  0x44c36cee, 0x44c3f678, 0xbb3b8002, 0xbb3c09a9,
  0x45026bf2, 0x4502f5fa, 0xbafc8002, 0xbafd0a27,
  0x4540eaf8, 0x4541757d, 0xbabe0002, 0xbabe8aa4,
  0x4548ead8, 0x4549756d, 0xbab60002, 0xbab68ab4,
  0x454a6ad2, 0x454af56a, 0xbab48002, 0xbab50ab7,
  0x19999998, 0x1999cccd, 0xe6660002, 0xe6663354,
  0x19d99898, 0x19d9cc4d, 0xe6260002, 0xe62633d4,
  0x1a19179a, 0x1a194bce, 0xe5e68002, 0xe5e6b453,
  0x1a58169e, 0x1a584b50, 0xe5a78002, 0xe5a7b4d1,
  0x1a9695a4, 0x1a96cad3, 0xe5690002, 0xe569354e,
  0x1a9e9584, 0x1a9ecac3, 0xe5610002, 0xe561355e,
  0x1aa0157e, 0x1aa04ac0, 0xe55f8002, 0xe55fb561,
  0x1aa1157a, 0x1aa14abe, 0xe55e8002, 0xe55eb563,
  0x003fff00, 0x003fff81, 0xffc00002, 0xffc000a0,
  0x007f7e02, 0x007f7f02, 0xff808002, 0xff80811f,
  0x00be7d06, 0x00be7e84, 0xff418002, 0xff41819d,
  0x00fcfc0c, 0x00fcfe07, 0xff030002, 0xff03021a,
  0x0104fbec, 0x0104fdf7, 0xfefb0002, 0xfefb022a,
  0x01067be6, 0x01067df4, 0xfef98002, 0xfef9822d,
  0x01077be2, 0x01077df2, 0xfef88002, 0xfef8822f,
  0x0107fbe0, 0x0107fdf1, 0xfef80002, 0xfef80230,
  0x003f7f81, 0xffc08001, 0xffc08081, 0xffd5aa76,
  0x007e7f03, 0xff818001, 0xff8180ff, 0xffabaa22,
  0x00bcfe86, 0xff430001, 0xff43017c, 0xff81ff24,
  0x00c4fe76, 0xff3b0001, 0xff3b018c, 0xff7ca9c4,
  0x00c67e73, 0xff398001, 0xff39818f, 0xff7ba9c2,
  0x00c77e71, 0xff388001, 0xff388191, 0xff7aff16,
  0x00c7fe70, 0xff380001, 0xff380192, 0xff7aa9c0,
  0x00c7fe70, 0xff380001, 0xff380192, 0xff7aa9c0,
  0x003eff82, 0xffc10001, 0xffc10080, 0xffd5ffcc,
  0x007d7f05, 0xff828001, 0xff8280fd, 0xffac54ce,
  0x00857ef5, 0xff7a8001, 0xff7a810d, 0xffa6ff6e,
  0x0086fef2, 0xff790001, 0xff790110, 0xffa5ff6c,
  0x0087fef0, 0xff780001, 0xff780112, 0xffa554c0,
  0x00887eef, 0xff778001, 0xff778113, 0xffa4ff6a,
  0x00887eef, 0xff778001, 0xff778113, 0xffa4ff6a,
  0x0087fef0, 0xff780001, 0xff780112, 0xffa554c0,
  0x003e7f83, 0xffc18001, 0xffc1807f, 0xffd65522,
  0x00467f73, 0xffb98001, 0xffb9808f, 0xffd0ffc2,
  0x0047ff70, 0xffb80001, 0xffb80092, 0xffcfffc0,
  0x0048ff6e, 0xffb70001, 0xffb70094, 0xffcf5514,
  0x00497f6d, 0xffb68001, 0xffb68095, 0xffceffbe,
  0x00497f6d, 0xffb68001, 0xffb68095, 0xffceffbe,
  0x0048ff6e, 0xffb70001, 0xffb70094, 0xffcf5514,
  0x0047ff70, 0xffb80001, 0xffb80092, 0xffcfffc0,
  0x0007fff0, 0xfff80001, 0xfff80012, 0xfffaaac0,
  0x00097fed, 0xfff68001, 0xfff68015, 0xfff9aabe,
  0x000a7feb, 0xfff58001, 0xfff58017, 0xfff90012,
  0x000affea, 0xfff50001, 0xfff50018, 0xfff8aabc,
  0x000affea, 0xfff50001, 0xfff50018, 0xfff8aabc,
  0x000a7feb, 0xfff58001, 0xfff58017, 0xfff90012,
  0x00097fed, 0xfff68001, 0xfff68015, 0xfff9aabe,
  0x00017ffd, 0xfffe8001, 0xfffe8005, 0xffff001e,
  0x00017ffd, 0xfffe8001, 0xfffe8005, 0xffff001e,
  0x00027ffb, 0xfffd8001, 0xfffd8007, 0xfffe5572,
  0x0002fffa, 0xfffd0001, 0xfffd0008, 0xfffe001c,
  0x0002fffa, 0xfffd0001, 0xfffd0008, 0xfffe001c,
  0x00027ffb, 0xfffd8001, 0xfffd8007, 0xfffe5572,
  0x00017ffd, 0xfffe8001, 0xfffe8005, 0xffff001e,
  0xfff9800d, 0x00068001, 0x00067ff5, 0x0004557e,
  0xffbb008a, 0x00450001, 0x0044ff78, 0x002e007c,
  0x0000fffe, 0xffff0001, 0xffff0004, 0xffff5574,
  0x00017ffd, 0xfffe8001, 0xfffe8005, 0xffff001e,
  0x00017ffd, 0xfffe8001, 0xfffe8005, 0xffff001e,
  0x0000fffe, 0xffff0001, 0xffff0004, 0xffff5574,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xfff80010, 0x00080001, 0x0007fff2, 0x00055580,
  0xffb9808d, 0x00468001, 0x00467f75, 0x002f007e,
  0xff7a810b, 0x00858001, 0x00857ef7, 0x005900d2,
  0x00007fff, 0xffff8001, 0xffff8003, 0xffffaaca,
  0x00007fff, 0xffff8001, 0xffff8003, 0xffffaaca,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff0002, 0x00010001, 0x00010000, 0x0000aacc,
  0xfff70012, 0x00090001, 0x0008fff0, 0x0006002c,
  0xffb8808f, 0x00478001, 0x00477f73, 0x002fab2a,
  0xff79810d, 0x00868001, 0x00867ef5, 0x0059ab7e,
  0xff3a018c, 0x00c60001, 0x00c5fe76, 0x00840128,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0xffff8001, 0x00008001, 0x00008001, 0x00005576,
  0xfffe8003, 0x00018001, 0x00017fff, 0x00010022,
  0xfff68013, 0x00098001, 0x00097fef, 0x00065582,
  0xffb80090, 0x00480001, 0x0047ff72, 0x00300080,
  0xff79010e, 0x00870001, 0x0086fef4, 0x005a00d4,
  0xff39818d, 0x00c68001, 0x00c67e75, 0x0084567e,
  0xe5a034c0, 0x1a600001, 0x1a5fcb42, 0x119578a0,
  0xffff8001, 0x00008001, 0x00008001, 0x00005576,
  0xfffe8003, 0x00018001, 0x00017fff, 0x00010022,
  0xfff68013, 0x00098001, 0x00097fef, 0x00065582,
  0xffb80090, 0x00480001, 0x0047ff72, 0x00300080,
  0xff79010e, 0x00870001, 0x0086fef4, 0x005a00d4,
  0xff39818d, 0x00c68001, 0x00c67e75, 0x0084567e,
  0xe5a034c0, 0x1a600001, 0x1a5fcb42, 0x119578a0,
  0xbaf60a15, 0x450a8001, 0x4509f5ed, 0x2e075c2e,
  0xffff0002, 0x00010001, 0x00010000, 0x0000aacc,
  0xfff70012, 0x00090001, 0x0008fff0, 0x0006002c,
  0xffb8808f, 0x00478001, 0x00477f73, 0x002fab2a,
  0xff79810d, 0x00868001, 0x00867ef5, 0x0059ab7e,
  0xff3a018c, 0x00c60001, 0x00c5fe76, 0x00840128,
  0xe5a0b4bf, 0x1a5f8001, 0x1a5f4b43, 0x1195234a,
  0xbaf68a14, 0x450a0001, 0x450975ee, 0x2e0706d8,
  0x7af88a11, 0x85088001, 0x850775f1, 0x58b106d6,
  0xfff80010, 0x00080001, 0x0007fff2, 0x00055580,
  0xffb9808d, 0x00468001, 0x00467f75, 0x002f007e,
  0xff7a810b, 0x00858001, 0x00857ef7, 0x005900d2,
  0xff3b018a, 0x00c50001, 0x00c4fe78, 0x0083567c,
  0xe5a1b4bd, 0x1a5e8001, 0x1a5e4b45, 0x1194789e,
  0xbaf78a12, 0x45090001, 0x450875f0, 0x2e065c2c,
  0x7af98a0f, 0x85078001, 0x850675f3, 0x58b05c2a,
  0x3afb0a0d, 0xc5068001, 0xc504f5f5, 0x835ab17e,
  0xffc1807d, 0x003e8001, 0x003e7f85, 0x0029ab1e,
  0xff8280fb, 0x007d8001, 0x007d7f07, 0x0053ab72,
  0xff43017a, 0x00bd0001, 0x00bcfe88, 0x007e011c,
  0xe5a9b4ad, 0x1a568001, 0x1a564b55, 0x118f233e,
  0xbaff8a02, 0x45010001, 0x45007600, 0x2e0106cc,
  0x7b0189ff, 0x84ff8001, 0x84fe7603, 0x58ab06ca,
  0x3b0309fd, 0xc4fe8001, 0xc4fcf605, 0x83555c1e,
  0xfb0409fc, 0x04fe0001, 0x04fbf606, 0xae0006c8,
  0xffc1007e, 0x003f0001, 0x003eff84, 0x002a0074,
  0xff8180fd, 0x007e8001, 0x007e7f05, 0x0054561e,
  0xe5e83430, 0x1a180001, 0x1a17cbd2, 0x11657840,
  0xbb3e0985, 0x44c28001, 0x44c1f67d, 0x2dd75bce,
  0x7b400982, 0x84c10001, 0x84bff680, 0x58815bcc,
  0x3b418980, 0xc4c00001, 0xc4be7682, 0x832bb120,
  0xfb42897f, 0x04bf8001, 0x04bd7683, 0xadd65bca,
  0x3b42097f, 0xc4bf8001, 0xc4bdf683, 0x832b5bca,
  0xffc0807f, 0x003f8001, 0x003f7f83, 0x002a55ca,
  0xe62733b2, 0x19d90001, 0x19d8cc50, 0x113b77ec,
  0xbb7d0907, 0x44838001, 0x4482f6fb, 0x2dad5b7a,
  0x7b7f0904, 0x84820001, 0x8480f6fe, 0x58575b78,
  0x3b808902, 0xc4810001, 0xc47f7700, 0x8301b0cc,
  0xfb818901, 0x04808001, 0x047e7701, 0xadac5b76,
  0x3b810901, 0xc4808001, 0xc47ef701, 0x83015b76,
  0x7b800902, 0x84810001, 0x847ff700, 0x5856b0cc,
  0xe666b333, 0x19998001, 0x19994ccf, 0x11112242,
  0xbbbc8888, 0x44440001, 0x4443777a, 0x2d8305d0,
  0x7bbe8885, 0x84428001, 0x8441777d, 0x582d05ce,
  0x3bc00883, 0xc4418001, 0xc43ff77f, 0x82d75b22,
  0xfbc10882, 0x04410001, 0x043ef780, 0xad8205cc,
  0x3bc08882, 0xc4410001, 0xc43f7780, 0x82d705cc,
  0x7bbf8883, 0x84418001, 0x8440777f, 0x582c5b22,
  0xa66a332d, 0x59968001, 0x5995ccd5, 0x3bba223e,
  0xd555d555, 0x2aaa8001, 0x2aaa2aad, 0x1c71e3ae,
  0x9557d552, 0x6aa90001, 0x6aa82ab0, 0x471be3ac,
  0x55595550, 0xaaa80001, 0xaaa6aab2, 0x71c63900,
  0x155a554f, 0xeaa78001, 0xeaa5aab3, 0x9c70e3aa,
  0x5559d54f, 0xaaa78001, 0xaaa62ab3, 0x71c5e3aa,
  0x9558d550, 0x6aa80001, 0x6aa72ab2, 0x471b3900,
  0xc0037ffa, 0x3ffd0001, 0x3ffc8008, 0x2aa9001c,
  0xd99d4cc6, 0x26630001, 0x2662b33c, 0x199788a4,
  0xc001fffd, 0x3ffe8001, 0x3ffe0005, 0x2aaa001e,
  0x80037ffb, 0x7ffd8001, 0x7ffc8007, 0x55545572,
  0x40047ffa, 0xbffd0001, 0xbffb8008, 0x7fff001c,
  0x8003fffa, 0x7ffd0001, 0x7ffc0008, 0x5554001c,
  0xc002fffb, 0x3ffd8001, 0x3ffd0007, 0x2aa95572,
  0xeaadaaa5, 0x15528001, 0x1552555d, 0x0e371c8e,
  0x04477771, 0xfbb88001, 0xfbb88891, 0xfd25a516,
  0x048776f1, 0xfb788001, 0xfb788911, 0xfcfafa16,
  0xc0017ffe, 0x3fff0001, 0x3ffe8004, 0x2aaa5574,
  0x80027ffd, 0x7ffe8001, 0x7ffd8005, 0x5555001e,
  0xc001fffd, 0x3ffe8001, 0x3ffe0005, 0x2aaa001e,
  0x0000fffe, 0xffff0001, 0xffff0004, 0xffff5574,
  0x2aabaaa8, 0xd5540001, 0xd554555a, 0xe38d1c90,
  0x44457774, 0xbbba0001, 0xbbba888e, 0xd27ba518,
  0x448576f4, 0xbb7a0001, 0xbb7a890e, 0xd250fa18,
  0x44c4f675, 0xbb3a8001, 0xbb3b098d, 0xd226a46e,
  0xc000ffff, 0x3fff8001, 0x3fff0003, 0x2aaaaaca,
  0x00007fff, 0xffff8001, 0xffff8003, 0xffffaaca,
  0x3fff8000, 0xc0000001, 0xc0008002, 0xd5550020,
  0x6aaa2aaa, 0x95550001, 0x9555d558, 0xb8e2c73c,
  0x8443f776, 0x7bbb0001, 0x7bbc088c, 0xa7d14fc4,
  0x8483f6f6, 0x7b7b0001, 0x7b7c090c, 0xa7a6a4c4,
  0x84c37677, 0x7b3b8001, 0x7b3c898b, 0xa77c4f1a,
  0x850275f9, 0x7afc8001, 0x7afd8a09, 0xa7524ec6,
  0x3fff8000, 0xc0000001, 0xc0008002, 0xd5550020,
  0x7ffe8001, 0x80008001, 0x80018001, 0xaaaa5576,
  0xaaa92aab, 0x55558001, 0x5556d557, 0x8e381c92,
  0xc442f777, 0x3bbb8001, 0x3bbd088b, 0x7d26a51a,
  0xc482f6f7, 0x3b7b8001, 0x3b7d090b, 0x7cfbfa1a,
  0xc4c27678, 0x3b3c0001, 0x3b3d898a, 0x7cd1a470,
  0xc50175fa, 0x3afd0001, 0x3afe8a08, 0x7ca7a41c,
  0xc53ff57d, 0x3abe8001, 0x3ac00a85, 0x7c7df91e,
  0x3fff0001, 0xc0008001, 0xc0010001, 0xd5555576,
  0x6aa9aaab, 0x95558001, 0x95565557, 0xb8e31c92,
  0x84437777, 0x7bbb8001, 0x7bbc888b, 0xa7d1a51a,
  0x848376f7, 0x7b7b8001, 0x7b7c890b, 0xa7a6fa1a,
  0x84c2f678, 0x7b3c0001, 0x7b3d098a, 0xa77ca470,
  0x8501f5fa, 0x7afd0001, 0x7afe0a08, 0xa752a41c,
  0x8540757d, 0x7abe8001, 0x7abf8a85, 0xa728f91e,
  0x8548756d, 0x7ab68001, 0x7ab78a95, 0xa723a3be,
  0x2aaaaaaa, 0xd5550001, 0xd5555558, 0xe38dc73c,
  0x44447776, 0xbbbb0001, 0xbbbb888c, 0xd27c4fc4,
  0x448476f6, 0xbb7b0001, 0xbb7b890c, 0xd251a4c4,
  0x44c3f677, 0xbb3b8001, 0xbb3c098b, 0xd2274f1a,
  0x4502f5f9, 0xbafc8001, 0xbafd0a09, 0xd1fd4ec6,
  0x4541757c, 0xbabe0001, 0xbabe8a86, 0xd1d3a3c8,
  0x4549756c, 0xbab60001, 0xbab68a96, 0xd1ce4e68,
  0x454af569, 0xbab48001, 0xbab50a99, 0xd1cd4e66,
  0x1999cccc, 0xe6660001, 0xe6663336, 0xeeee88a8,
  0x19d9cc4c, 0xe6260001, 0xe62633b6, 0xeec3dda8,
  0x1a194bcd, 0xe5e68001, 0xe5e6b435, 0xee9987fe,
  0x1a584b4f, 0xe5a78001, 0xe5a7b4b3, 0xee6f87aa,
  0x1a96cad2, 0xe5690001, 0xe5693530, 0xee45dcac,
  0x1a9ecac2, 0xe5610001, 0xe5613540, 0xee40874c,
  0x1aa04abf, 0xe55f8001, 0xe55fb543, 0xee3f874a,
  0x1aa14abd, 0xe55e8001, 0xe55eb545, 0xee3edc9e,
  0x003fff80, 0xffc00001, 0xffc00082, 0xffd55520,
  0x007f7f01, 0xff808001, 0xff808101, 0xffaaff76,
  0x00be7e83, 0xff418001, 0xff41817f, 0xff80ff22,
  0x00fcfe06, 0xff030001, 0xff0301fc, 0xff575424,
  0x0104fdf6, 0xfefb0001, 0xfefb020c, 0xff51fec4,
  0x01067df3, 0xfef98001, 0xfef9820f, 0xff50fec2,
  0x01077df1, 0xfef88001, 0xfef88211, 0xff505416,
  0x0107fdf0, 0xfef80001, 0xfef80212, 0xff4ffec0,
  0xffc08000, 0xffc08080, 0xffd5aa58, 0xffe69954,
  0xff818000, 0xff8180fe, 0xffabaa04, 0xffcd65bc,
  0xff430000, 0xff43017b, 0xff81ff06, 0xffb46558,
  0xff3b0000, 0xff3b018b, 0xff7ca9a6, 0xffb13218,
  0xff398000, 0xff39818e, 0xff7ba9a4, 0xffb0987c,
  0xff388000, 0xff388190, 0xff7afef8, 0xffb03214,
  0xff380000, 0xff380191, 0xff7aa9a2, 0xffaffee0,
  0xff380000, 0xff380191, 0xff7aa9a2, 0xffaffee0,
  0xffc10000, 0xffc1007f, 0xffd5ffae, 0xffe6cc88,
  0xff828000, 0xff8280fc, 0xffac54b0, 0xffcdcc24,
  0xff7a8000, 0xff7a810c, 0xffa6ff50, 0xffca98e4,
  0xff790000, 0xff79010f, 0xffa5ff4e, 0xffc9ff48,
  0xff780000, 0xff780111, 0xffa554a2, 0xffc998e0,
  0xff778000, 0xff778112, 0xffa4ff4c, 0xffc965ac,
  0xff778000, 0xff778112, 0xffa4ff4c, 0xffc965ac,
  0xff780000, 0xff780111, 0xffa554a2, 0xffc998e0,
  0xffc18000, 0xffc1807e, 0xffd65504, 0xffe6ffbc,
  0xffb98000, 0xffb9808e, 0xffd0ffa4, 0xffe3cc7c,
  0xffb80000, 0xffb80091, 0xffcfffa2, 0xffe332e0,
  0xffb70000, 0xffb70093, 0xffcf54f6, 0xffe2cc78,
  0xffb68000, 0xffb68094, 0xffceffa0, 0xffe29944,
  0xffb68000, 0xffb68094, 0xffceffa0, 0xffe29944,
  0xffb70000, 0xffb70093, 0xffcf54f6, 0xffe2cc78,
  0xffb80000, 0xffb80091, 0xffcfffa2, 0xffe332e0,
  0xfff80000, 0xfff80011, 0xfffaaaa2, 0xfffccce0,
  0xfff68000, 0xfff68014, 0xfff9aaa0, 0xfffc3344,
  0xfff58000, 0xfff58016, 0xfff8fff4, 0xfffbccdc,
  0xfff50000, 0xfff50017, 0xfff8aa9e, 0xfffb99a8,
  0xfff50000, 0xfff50017, 0xfff8aa9e, 0xfffb99a8,
  0xfff58000, 0xfff58016, 0xfff8fff4, 0xfffbccdc,
  0xfff68000, 0xfff68014, 0xfff9aaa0, 0xfffc3344,
  0xfffe8000, 0xfffe8004, 0xffff0000, 0xffff6684,
  0xfffe8000, 0xfffe8004, 0xffff0000, 0xffff6684,
  0xfffd8000, 0xfffd8006, 0xfffe5554, 0xffff001c,
  0xfffd0000, 0xfffd0007, 0xfffdfffe, 0xfffecce8,
  0xfffd0000, 0xfffd0007, 0xfffdfffe, 0xfffecce8,
  0xfffd8000, 0xfffd8006, 0xfffe5554, 0xffff001c,
  0xfffe8000, 0xfffe8004, 0xffff0000, 0xffff6684,
  0x00068000, 0x00067ff4, 0x00045560, 0x000299c4,
  0x00450000, 0x0044ff77, 0x002e005e, 0x001b9a28,
  0xffff0000, 0xffff0003, 0xffff5556, 0xffff99b8,
  0xfffe8000, 0xfffe8004, 0xffff0000, 0xffff6684,
  0xfffe8000, 0xfffe8004, 0xffff0000, 0xffff6684,
  0xffff0000, 0xffff0003, 0xffff5556, 0xffff99b8,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00080000, 0x0007fff1, 0x00055562, 0x00033360,
  0x00468000, 0x00467f74, 0x002f0060, 0x001c33c4,
  0x00858000, 0x00857ef6, 0x005900b4, 0x0035675c,
  0xffff8000, 0xffff8002, 0xffffaaac, 0xffffccec,
  0xffff8000, 0xffff8002, 0xffffaaac, 0xffffccec,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00010000, 0x0000ffff, 0x0000aaae, 0x00006688,
  0x00090000, 0x0008ffef, 0x0006000e, 0x000399c8,
  0x00478000, 0x00477f72, 0x002fab0c, 0x001c9a2c,
  0x00868000, 0x00867ef4, 0x0059ab60, 0x0035cdc4,
  0x00c60000, 0x00c5fe75, 0x0084010a, 0x004f3490,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00008000, 0x00008000, 0x00005558, 0x00003354,
  0x00018000, 0x00017ffe, 0x00010004, 0x000099bc,
  0x00098000, 0x00097fee, 0x00065564, 0x0003ccfc,
  0x00480000, 0x0047ff71, 0x00300062, 0x001ccd60,
  0x00870000, 0x0086fef3, 0x005a00b6, 0x003600f8,
  0x00c68000, 0x00c67e74, 0x00845660, 0x004f67c4,
  0x1a600000, 0x1a5fcb41, 0x11957882, 0x0a8cf720,
  0x00008000, 0x00008000, 0x00005558, 0x00003354,
  0x00018000, 0x00017ffe, 0x00010004, 0x000099bc,
  0x00098000, 0x00097fee, 0x00065564, 0x0003ccfc,
  0x00480000, 0x0047ff71, 0x00300062, 0x001ccd60,
  0x00870000, 0x0086fef3, 0x005a00b6, 0x003600f8,
  0x00c68000, 0x00c67e74, 0x00845660, 0x004f67c4,
  0x1a600000, 0x1a5fcb41, 0x11957882, 0x0a8cf720,
  0x450a8000, 0x4509f5ec, 0x2e075c10, 0x1b9e3b64,
  0x00010000, 0x0000ffff, 0x0000aaae, 0x00006688,
  0x00090000, 0x0008ffef, 0x0006000e, 0x000399c8,
  0x00478000, 0x00477f72, 0x002fab0c, 0x001c9a2c,
  0x00868000, 0x00867ef4, 0x0059ab60, 0x0035cdc4,
  0x00c60000, 0x00c5fe75, 0x0084010a, 0x004f3490,
  0x1a5f8000, 0x1a5f4b42, 0x1195232c, 0x0a8cc3ec,
  0x450a0000, 0x450975ed, 0x2e0706ba, 0x1b9e0830,
  0x85088000, 0x850775f0, 0x58b106b8, 0x35376e94,
  0x00080000, 0x0007fff1, 0x00055562, 0x00033360,
  0x00468000, 0x00467f74, 0x002f0060, 0x001c33c4,
  0x00858000, 0x00857ef6, 0x005900b4, 0x0035675c,
  0x00c50000, 0x00c4fe77, 0x0083565e, 0x004ece28,
  0x1a5e8000, 0x1a5e4b44, 0x11947880, 0x0a8c5d84,
  0x45090000, 0x450875ef, 0x2e065c0e, 0x1b9da1c8,
  0x85078000, 0x850675f2, 0x58b05c0c, 0x3537082c,
  0xc5068000, 0xc504f5f4, 0x835ab160, 0x4ed0a1c4,
  0x003e8000, 0x003e7f84, 0x0029ab00, 0x00190084,
  0x007d8000, 0x007d7f06, 0x0053ab54, 0x0032341c,
  0x00bd0000, 0x00bcfe87, 0x007e00fe, 0x004b9ae8,
  0x1a568000, 0x1a564b54, 0x118f2320, 0x0a892a44,
  0x45010000, 0x450075ff, 0x2e0106ae, 0x1b9a6e88,
  0x84ff8000, 0x84fe7602, 0x58ab06ac, 0x3533d4ec,
  0xc4fe8000, 0xc4fcf604, 0x83555c00, 0x4ecd6e84,
  0x04fe0000, 0x04fbf605, 0xae0006aa, 0x68673b50,
  0x003f0000, 0x003eff83, 0x002a0056, 0x001933b8,
  0x007e8000, 0x007e7f04, 0x00545600, 0x00329a84,
  0x1a180000, 0x1a17cbd1, 0x11657822, 0x0a7029e0,
  0x44c28000, 0x44c1f67c, 0x2dd75bb0, 0x1b816e24,
  0x84c10000, 0x84bff67f, 0x58815bae, 0x351ad488,
  0xc4c00000, 0xc4be7681, 0x832bb102, 0x4eb46e20,
  0x04bf8000, 0x04bd7682, 0xadd65bac, 0x684e3aec,
  0xc4bf8000, 0xc4bdf682, 0x832b5bac, 0x4eb43aec,
  0x003f8000, 0x003f7f82, 0x002a55ac, 0x001966ec,
  0x19d90000, 0x19d8cc4f, 0x113b77ce, 0x0a56f648,
  0x44838000, 0x4482f6fa, 0x2dad5b5c, 0x1b683a8c,
  0x84820000, 0x8480f6fd, 0x58575b5a, 0x3501a0f0,
  0xc4810000, 0xc47f76ff, 0x8301b0ae, 0x4e9b3a88,
  0x04808000, 0x047e7700, 0xadac5b58, 0x68350754,
  0xc4808000, 0xc47ef700, 0x83015b58, 0x4e9b0754,
  0x84810000, 0x847ff6ff, 0x5856b0ae, 0x35013a88,
  0x19998000, 0x19994cce, 0x11112224, 0x0a3d8f7c,
  0x44440000, 0x44437779, 0x2d8305b2, 0x1b4ed3c0,
  0x84428000, 0x8441777c, 0x582d05b0, 0x34e83a24,
  0xc4418000, 0xc43ff77e, 0x82d75b04, 0x4e81d3bc,
  0x04410000, 0x043ef77f, 0xad8205ae, 0x681ba088,
  0xc4410000, 0xc43f777f, 0x82d705ae, 0x4e81a088,
  0x84418000, 0x8440777e, 0x582c5b04, 0x34e7d3bc,
  0x59968000, 0x5995ccd4, 0x3bba2220, 0x23d65c44,
  0x2aaa8000, 0x2aaa2aac, 0x1c71e390, 0x11114464,
  0x6aa90000, 0x6aa82aaf, 0x471be38e, 0x2aaaaac8,
  0xaaa80000, 0xaaa6aab1, 0x71c638e2, 0x44444460,
  0xeaa78000, 0xeaa5aab2, 0x9c70e38c, 0x5dde112c,
  0xaaa78000, 0xaaa62ab2, 0x71c5e38c, 0x4444112c,
  0x6aa80000, 0x6aa72ab1, 0x471b38e2, 0x2aaa4460,
  0x3ffd0000, 0x3ffc8007, 0x2aa8fffe, 0x1998cce8,
  0x26630000, 0x2662b33b, 0x19978886, 0x0f5b0a58,
  0x3ffe8000, 0x3ffe0004, 0x2aaa0000, 0x19996684,
  0x7ffd8000, 0x7ffc8006, 0x55545554, 0x3333001c,
  0xbffd0000, 0xbffb8007, 0x7ffefffe, 0x4ccccce8,
  0x7ffd0000, 0x7ffc0007, 0x5553fffe, 0x3332cce8,
  0x3ffd8000, 0x3ffd0006, 0x2aa95554, 0x1999001c,
  0x15528000, 0x1552555c, 0x0e371c70, 0x088788a4,
  0xfbb88000, 0xfbb88890, 0xfd25a4f8, 0xfe49c614,
  0xfb788000, 0xfb788910, 0xfcfaf9f8, 0xfe302c14,
  0x3fff0000, 0x3ffe8003, 0x2aaa5556, 0x199999b8,
  0x7ffe8000, 0x7ffd8004, 0x55550000, 0x33336684,
  0x3ffe8000, 0x3ffe0004, 0x2aaa0000, 0x19996684,
  0xffff0000, 0xffff0003, 0xffff5556, 0xffff99b8,
  0xd5540000, 0xd5545559, 0xe38d1c72, 0xeeee2240,
  0xbbba0000, 0xbbba888d, 0xd27ba4fa, 0xe4b05fb0,
  0xbb7a0000, 0xbb7a890d, 0xd250f9fa, 0xe496c5b0,
  0xbb3a8000, 0xbb3b098c, 0xd226a450, 0xe47d5ee4,
  0x3fff8000, 0x3fff0002, 0x2aaaaaac, 0x1999ccec,
  0xffff8000, 0xffff8002, 0xffffaaac, 0xffffccec,
  0xc0000000, 0xc0008001, 0xd5550002, 0xe6660020,
  0x95550000, 0x9555d557, 0xb8e2c71e, 0xd55488a8,
  0x7bbb0000, 0x7bbc088b, 0xa7d14fa6, 0xcb16c618,
  0x7b7b0000, 0x7b7c090b, 0xa7a6a4a6, 0xcafd2c18,
  0x7b3b8000, 0x7b3c898a, 0xa77c4efc, 0xcae3c54c,
  0x7afc8000, 0x7afd8a08, 0xa7524ea8, 0xcaca91b4,
  0xc0000000, 0xc0008001, 0xd5550002, 0xe6660020,
  0x80008000, 0x80018000, 0xaaaa5558, 0xcccc3354,
  0x55558000, 0x5556d556, 0x8e381c74, 0xbbbabbdc,
  0x3bbb8000, 0x3bbd088a, 0x7d26a4fc, 0xb17cf94c,
  0x3b7b8000, 0x3b7d090a, 0x7cfbf9fc, 0xb1635f4c,
  0x3b3c0000, 0x3b3d8989, 0x7cd1a452, 0xb149f880,
  0x3afd0000, 0x3afe8a07, 0x7ca7a3fe, 0xb130c4e8,
  0x3abe8000, 0x3ac00a84, 0x7c7df900, 0xb117c484,
  0xc0008000, 0xc0010000, 0xd5555558, 0xe6663354,
  0x95558000, 0x95565556, 0xb8e31c74, 0xd554bbdc,
  0x7bbb8000, 0x7bbc888a, 0xa7d1a4fc, 0xcb16f94c,
  0x7b7b8000, 0x7b7c890a, 0xa7a6f9fc, 0xcafd5f4c,
  0x7b3c0000, 0x7b3d0989, 0xa77ca452, 0xcae3f880,
  0x7afd0000, 0x7afe0a07, 0xa752a3fe, 0xcacac4e8,
  0x7abe8000, 0x7abf8a84, 0xa728f900, 0xcab1c484,
  0x7ab68000, 0x7ab78a94, 0xa723a3a0, 0xcaae9144,
  0xd5550000, 0xd5555557, 0xe38dc71e, 0xeeee88a8,
  0xbbbb0000, 0xbbbb888b, 0xd27c4fa6, 0xe4b0c618,
  0xbb7b0000, 0xbb7b890b, 0xd251a4a6, 0xe4972c18,
  0xbb3b8000, 0xbb3c098a, 0xd2274efc, 0xe47dc54c,
  0xbafc8000, 0xbafd0a08, 0xd1fd4ea8, 0xe46491b4,
  0xbabe0000, 0xbabe8a85, 0xd1d3a3aa, 0xe44b9150,
  0xbab60000, 0xbab68a95, 0xd1ce4e4a, 0xe4485e10,
  0xbab48000, 0xbab50a98, 0xd1cd4e48, 0xe447c474,
  0xe6660000, 0xe6663335, 0xeeee888a, 0xf5c23d90,
  0xe6260000, 0xe62633b5, 0xeec3dd8a, 0xf5a8a390,
  0xe5e68000, 0xe5e6b434, 0xee9987e0, 0xf58f3cc4,
  0xe5a78000, 0xe5a7b4b2, 0xee6f878c, 0xf576092c,
  0xe5690000, 0xe569352f, 0xee45dc8e, 0xf55d08c8,
  0xe5610000, 0xe561353f, 0xee40872e, 0xf559d588,
  0xe55f8000, 0xe55fb542, 0xee3f872c, 0xf5593bec,
  0xe55e8000, 0xe55eb544, 0xee3edc80, 0xf558d584,
  0xffc00000, 0xffc00081, 0xffd55502, 0xffe66620,
  0xff808000, 0xff808100, 0xffaaff58, 0xffccff54,
  0xff418000, 0xff41817e, 0xff80ff04, 0xffb3cbbc,
  0xff030000, 0xff0301fb, 0xff575406, 0xff9acb58,
  0xfefb0000, 0xfefb020b, 0xff51fea6, 0xff979818,
  0xfef98000, 0xfef9820e, 0xff50fea4, 0xff96fe7c,
  0xfef88000, 0xfef88210, 0xff5053f8, 0xff969814,
  0xfef80000, 0xfef80211, 0xff4ffea2, 0xff9664e0,
  0xffc0807f, 0xffd5aa57, 0xffe69936, 0xffffc0a0,
  0xff8180fd, 0xffabaa03, 0xffcd659e, 0xffff81a0,
  0xff43017a, 0xff81ff05, 0xffb4653a, 0xffff4320,
  0xff3b018a, 0xff7ca9a5, 0xffb131fa, 0xffff3b20,
  0xff39818d, 0xff7ba9a3, 0xffb0985e, 0xffff39a0,
  0xff38818f, 0xff7afef7, 0xffb031f6, 0xffff38a0,
  0xff380190, 0xff7aa9a1, 0xffaffec2, 0xffff3820,
  0xff380190, 0xff7aa9a1, 0xffaffec2, 0xffff3820,
  0xffc1007e, 0xffd5ffad, 0xffe6cc6a, 0xffffc120,
  0xff8280fb, 0xffac54af, 0xffcdcc06, 0xffff82a0,
  0xff7a810b, 0xffa6ff4f, 0xffca98c6, 0xffff7aa0,
  0xff79010e, 0xffa5ff4d, 0xffc9ff2a, 0xffff7920,
  0xff780110, 0xffa554a1, 0xffc998c2, 0xffff7820,
  0xff778111, 0xffa4ff4b, 0xffc9658e, 0xffff77a0,
  0xff778111, 0xffa4ff4b, 0xffc9658e, 0xffff77a0,
  0xff780110, 0xffa554a1, 0xffc998c2, 0xffff7820,
  0xffc1807d, 0xffd65503, 0xffe6ff9e, 0xffffc1a0,
  0xffb9808d, 0xffd0ffa3, 0xffe3cc5e, 0xffffb9a0,
  0xffb80090, 0xffcfffa1, 0xffe332c2, 0xffffb820,
  0xffb70092, 0xffcf54f5, 0xffe2cc5a, 0xffffb720,
  0xffb68093, 0xffceff9f, 0xffe29926, 0xffffb6a0,
  0xffb68093, 0xffceff9f, 0xffe29926, 0xffffb6a0,
  0xffb70092, 0xffcf54f5, 0xffe2cc5a, 0xffffb720,
  0xffb80090, 0xffcfffa1, 0xffe332c2, 0xffffb820,
  0xfff80010, 0xfffaaaa1, 0xfffcccc2, 0xfffff820,
  0xfff68013, 0xfff9aa9f, 0xfffc3326, 0xfffff6a0,
  0xfff58015, 0xfff8fff3, 0xfffbccbe, 0xfffff5a0,
  0xfff50016, 0xfff8aa9d, 0xfffb998a, 0xfffff520,
  0xfff50016, 0xfff8aa9d, 0xfffb998a, 0xfffff520,
  0xfff58015, 0xfff8fff3, 0xfffbccbe, 0xfffff5a0,
  0xfff68013, 0xfff9aa9f, 0xfffc3326, 0xfffff6a0,
  0xfffe8003, 0xfffeffff, 0xffff6666, 0xfffffea0,
  0xfffe8003, 0xfffeffff, 0xffff6666, 0xfffffea0,
  0xfffd8005, 0xfffe5553, 0xfffefffe, 0xfffffda0,
  0xfffd0006, 0xfffdfffd, 0xfffeccca, 0xfffffd20,
  0xfffd0006, 0xfffdfffd, 0xfffeccca, 0xfffffd20,
  0xfffd8005, 0xfffe5553, 0xfffefffe, 0xfffffda0,
  0xfffe8003, 0xfffeffff, 0xffff6666, 0xfffffea0,
  0x00067ff3, 0x0004555f, 0x000299a6, 0x000006a0,
  0x0044ff76, 0x002e005d, 0x001b9a0a, 0x00004520,
  0xffff0002, 0xffff5555, 0xffff999a, 0xffffff20,
  0xfffe8003, 0xfffeffff, 0xffff6666, 0xfffffea0,
  0xfffe8003, 0xfffeffff, 0xffff6666, 0xfffffea0,
  0xffff0002, 0xffff5555, 0xffff999a, 0xffffff20,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x0007fff0, 0x00055561, 0x00033342, 0x00000820,
  0x00467f73, 0x002f005f, 0x001c33a6, 0x000046a0,
  0x00857ef5, 0x005900b3, 0x0035673e, 0x000085a0,
  0xffff8001, 0xffffaaab, 0xffffccce, 0xffffffa0,
  0xffff8001, 0xffffaaab, 0xffffccce, 0xffffffa0,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x0000fffe, 0x0000aaad, 0x0000666a, 0x00000120,
  0x0008ffee, 0x0006000d, 0x000399aa, 0x00000920,
  0x00477f71, 0x002fab0b, 0x001c9a0e, 0x000047a0,
  0x00867ef3, 0x0059ab5f, 0x0035cda6, 0x000086a0,
  0x00c5fe74, 0x00840109, 0x004f3472, 0x0000c620,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00007fff, 0x00005557, 0x00003336, 0x000000a0,
  0x00017ffd, 0x00010003, 0x0000999e, 0x000001a0,
  0x00097fed, 0x00065563, 0x0003ccde, 0x000009a0,
  0x0047ff70, 0x00300061, 0x001ccd42, 0x00004820,
  0x0086fef2, 0x005a00b5, 0x003600da, 0x00008720,
  0x00c67e73, 0x0084565f, 0x004f67a6, 0x0000c6a0,
  0x1a5fcb40, 0x11957881, 0x0a8cf702, 0x001a6020,
  0x00007fff, 0x00005557, 0x00003336, 0x000000a0,
  0x00017ffd, 0x00010003, 0x0000999e, 0x000001a0,
  0x00097fed, 0x00065563, 0x0003ccde, 0x000009a0,
  0x0047ff70, 0x00300061, 0x001ccd42, 0x00004820,
  0x0086fef2, 0x005a00b5, 0x003600da, 0x00008720,
  0x00c67e73, 0x0084565f, 0x004f67a6, 0x0000c6a0,
  0x1a5fcb40, 0x11957881, 0x0a8cf702, 0x001a6020,
  0x4509f5eb, 0x2e075c0f, 0x1b9e3b46, 0x00450aa0,
  0x0000fffe, 0x0000aaad, 0x0000666a, 0x00000120,
  0x0008ffee, 0x0006000d, 0x000399aa, 0x00000920,
  0x00477f71, 0x002fab0b, 0x001c9a0e, 0x000047a0,
  0x00867ef3, 0x0059ab5f, 0x0035cda6, 0x000086a0,
  0x00c5fe74, 0x00840109, 0x004f3472, 0x0000c620,
  0x1a5f4b41, 0x1195232b, 0x0a8cc3ce, 0x001a5fa0,
  0x450975ec, 0x2e0706b9, 0x1b9e0812, 0x00450a20,
  0x850775ef, 0x58b106b7, 0x35376e76, 0x008508a0,
  0x0007fff0, 0x00055561, 0x00033342, 0x00000820,
  0x00467f73, 0x002f005f, 0x001c33a6, 0x000046a0,
  0x00857ef5, 0x005900b3, 0x0035673e, 0x000085a0,
  0x00c4fe76, 0x0083565d, 0x004ece0a, 0x0000c520,
  0x1a5e4b43, 0x1194787f, 0x0a8c5d66, 0x001a5ea0,
  0x450875ee, 0x2e065c0d, 0x1b9da1aa, 0x00450920,
  0x850675f1, 0x58b05c0b, 0x3537080e, 0x008507a0,
  0xc504f5f3, 0x835ab15f, 0x4ed0a1a6, 0x00c506a0,
  0x003e7f83, 0x0029aaff, 0x00190066, 0x00003ea0,
  0x007d7f05, 0x0053ab53, 0x003233fe, 0x00007da0,
  0x00bcfe86, 0x007e00fd, 0x004b9aca, 0x0000bd20,
  0x1a564b53, 0x118f231f, 0x0a892a26, 0x001a56a0,
  0x450075fe, 0x2e0106ad, 0x1b9a6e6a, 0x00450120,
  0x84fe7601, 0x58ab06ab, 0x3533d4ce, 0x0084ffa0,
  0xc4fcf603, 0x83555bff, 0x4ecd6e66, 0x00c4fea0,
  0x04fbf604, 0xae0006a9, 0x68673b32, 0x0104fe20,
  0x003eff82, 0x002a0055, 0x0019339a, 0x00003f20,
  0x007e7f03, 0x005455ff, 0x00329a66, 0x00007ea0,
  0x1a17cbd0, 0x11657821, 0x0a7029c2, 0x001a1820,
  0x44c1f67b, 0x2dd75baf, 0x1b816e06, 0x0044c2a0,
  0x84bff67e, 0x58815bad, 0x351ad46a, 0x0084c120,
  0xc4be7680, 0x832bb101, 0x4eb46e02, 0x00c4c020,
  0x04bd7681, 0xadd65bab, 0x684e3ace, 0x0104bfa0,
  0xc4bdf681, 0x832b5bab, 0x4eb43ace, 0x00c4bfa0,
  0x003f7f81, 0x002a55ab, 0x001966ce, 0x00003fa0,
  0x19d8cc4e, 0x113b77cd, 0x0a56f62a, 0x0019d920,
  0x4482f6f9, 0x2dad5b5b, 0x1b683a6e, 0x004483a0,
  0x8480f6fc, 0x58575b59, 0x3501a0d2, 0x00848220,
  0xc47f76fe, 0x8301b0ad, 0x4e9b3a6a, 0x00c48120,
  0x047e76ff, 0xadac5b57, 0x68350736, 0x010480a0,
  0xc47ef6ff, 0x83015b57, 0x4e9b0736, 0x00c480a0,
  0x847ff6fe, 0x5856b0ad, 0x35013a6a, 0x00848120,
  0x19994ccd, 0x11112223, 0x0a3d8f5e, 0x001999a0,
  0x44437778, 0x2d8305b1, 0x1b4ed3a2, 0x00444420,
  0x8441777b, 0x582d05af, 0x34e83a06, 0x008442a0,
  0xc43ff77d, 0x82d75b03, 0x4e81d39e, 0x00c441a0,
  0x043ef77e, 0xad8205ad, 0x681ba06a, 0x01044120,
  0xc43f777e, 0x82d705ad, 0x4e81a06a, 0x00c44120,
  0x8440777d, 0x582c5b03, 0x34e7d39e, 0x008441a0,
  0x5995ccd3, 0x3bba221f, 0x23d65c26, 0x005996a0,
  0x2aaa2aab, 0x1c71e38f, 0x11114446, 0x002aaaa0,
  0x6aa82aae, 0x471be38d, 0x2aaaaaaa, 0x006aa920,
  0xaaa6aab0, 0x71c638e1, 0x44444442, 0x00aaa820,
  0xeaa5aab1, 0x9c70e38b, 0x5dde110e, 0x00eaa7a0,
  0xaaa62ab1, 0x71c5e38b, 0x4444110e, 0x00aaa7a0,
  0x6aa72ab0, 0x471b38e1, 0x2aaa4442, 0x006aa820,
  0x3ffc8006, 0x2aa8fffd, 0x1998ccca, 0x003ffd20,
  0x2662b33a, 0x19978885, 0x0f5b0a3a, 0x00266320,
  0x3ffe0003, 0x2aa9ffff, 0x19996666, 0x003ffea0,
  0x7ffc8005, 0x55545553, 0x3332fffe, 0x007ffda0,
  0xbffb8006, 0x7ffefffd, 0x4cccccca, 0x00bffd20,
  0x7ffc0006, 0x5553fffd, 0x3332ccca, 0x007ffd20,
  0x3ffd0005, 0x2aa95553, 0x1998fffe, 0x003ffda0,
  0x1552555b, 0x0e371c6f, 0x08878886, 0x001552a0,
  0xfbb8888f, 0xfd25a4f7, 0xfe49c5f6, 0xfffbb8a0,
  0xfb78890f, 0xfcfaf9f7, 0xfe302bf6, 0xfffb78a0,
  0x3ffe8002, 0x2aaa5555, 0x1999999a, 0x003fff20,
  0x7ffd8003, 0x5554ffff, 0x33336666, 0x007ffea0,
  0x3ffe0003, 0x2aa9ffff, 0x19996666, 0x003ffea0,
  0xffff0002, 0xffff5555, 0xffff999a, 0xffffff20,
  0xd5545558, 0xe38d1c71, 0xeeee2222, 0xffd55420,
  0xbbba888c, 0xd27ba4f9, 0xe4b05f92, 0xffbbba20,
  0xbb7a890c, 0xd250f9f9, 0xe496c592, 0xffbb7a20,
  0xbb3b098b, 0xd226a44f, 0xe47d5ec6, 0xffbb3aa0,
  0x3fff0001, 0x2aaaaaab, 0x1999ccce, 0x003fffa0,
  0xffff8001, 0xffffaaab, 0xffffccce, 0xffffffa0,
  0xc0008000, 0xd5550001, 0xe6660002, 0xffc00020,
  0x9555d556, 0xb8e2c71d, 0xd554888a, 0xff955520,
  0x7bbc088a, 0xa7d14fa5, 0xcb16c5fa, 0xff7bbb20,
  0x7b7c090a, 0xa7a6a4a5, 0xcafd2bfa, 0xff7b7b20,
  0x7b3c8989, 0xa77c4efb, 0xcae3c52e, 0xff7b3ba0,
  0x7afd8a07, 0xa7524ea7, 0xcaca9196, 0xff7afca0,
  0xc0008000, 0xd5550001, 0xe6660002, 0xffc00020,
  0x80017fff, 0xaaaa5557, 0xcccc3336, 0xff8000a0,
  0x5556d555, 0x8e381c73, 0xbbbabbbe, 0xff5555a0,
  0x3bbd0889, 0x7d26a4fb, 0xb17cf92e, 0xff3bbba0,
  0x3b7d0909, 0x7cfbf9fb, 0xb1635f2e, 0xff3b7ba0,
  0x3b3d8988, 0x7cd1a451, 0xb149f862, 0xff3b3c20,
  0x3afe8a06, 0x7ca7a3fd, 0xb130c4ca, 0xff3afd20,
  0x3ac00a83, 0x7c7df8ff, 0xb117c466, 0xff3abea0,
  0xc000ffff, 0xd5555557, 0xe6663336, 0xffc000a0,
  0x95565555, 0xb8e31c73, 0xd554bbbe, 0xff9555a0,
  0x7bbc8889, 0xa7d1a4fb, 0xcb16f92e, 0xff7bbba0,
  0x7b7c8909, 0xa7a6f9fb, 0xcafd5f2e, 0xff7b7ba0,
  0x7b3d0988, 0xa77ca451, 0xcae3f862, 0xff7b3c20,
  0x7afe0a06, 0xa752a3fd, 0xcacac4ca, 0xff7afd20,
  0x7abf8a83, 0xa728f8ff, 0xcab1c466, 0xff7abea0,
  0x7ab78a93, 0xa723a39f, 0xcaae9126, 0xff7ab6a0,
  0xd5555556, 0xe38dc71d, 0xeeee888a, 0xffd55520,
  0xbbbb888a, 0xd27c4fa5, 0xe4b0c5fa, 0xffbbbb20,
  0xbb7b890a, 0xd251a4a5, 0xe4972bfa, 0xffbb7b20,
  0xbb3c0989, 0xd2274efb, 0xe47dc52e, 0xffbb3ba0,
  0xbafd0a07, 0xd1fd4ea7, 0xe4649196, 0xffbafca0,
  0xbabe8a84, 0xd1d3a3a9, 0xe44b9132, 0xffbabe20,
  0xbab68a94, 0xd1ce4e49, 0xe4485df2, 0xffbab620,
  0xbab50a97, 0xd1cd4e47, 0xe447c456, 0xffbab4a0,
  0xe6663334, 0xeeee8889, 0xf5c23d72, 0xffe66620,
  0xe62633b4, 0xeec3dd89, 0xf5a8a372, 0xffe62620,
  0xe5e6b433, 0xee9987df, 0xf58f3ca6, 0xffe5e6a0,
  0xe5a7b4b1, 0xee6f878b, 0xf576090e, 0xffe5a7a0,
  0xe569352e, 0xee45dc8d, 0xf55d08aa, 0xffe56920,
  0xe561353e, 0xee40872d, 0xf559d56a, 0xffe56120,
  0xe55fb541, 0xee3f872b, 0xf5593bce, 0xffe55fa0,
  0xe55eb543, 0xee3edc7f, 0xf558d566, 0xffe55ea0,
  0xffc00080, 0xffd55501, 0xffe66602, 0xffffc020,
  0xff8080ff, 0xffaaff57, 0xffccff36, 0xffff80a0,
  0xff41817d, 0xff80ff03, 0xffb3cb9e, 0xffff41a0,
  0xff0301fa, 0xff575405, 0xff9acb3a, 0xffff0320,
  0xfefb020a, 0xff51fea5, 0xff9797fa, 0xfffefb20,
  0xfef9820d, 0xff50fea3, 0xff96fe5e, 0xfffef9a0,
  0xfef8820f, 0xff5053f7, 0xff9697f6, 0xfffef8a0,
  0xfef80210, 0xff4ffea1, 0xff9664c2, 0xfffef820,
  0xffd5aa56, 0xffe69935, 0xffffc082, 0xffffc11f,
  0xffabaa02, 0xffcd659d, 0xffff8182, 0xffff829d,
  0xff81ff04, 0xffb46539, 0xffff4302, 0xffff449a,
  0xff7ca9a4, 0xffb131f9, 0xffff3b02, 0xffff3caa,
  0xff7ba9a2, 0xffb0985d, 0xffff3982, 0xffff3b2d,
  0xff7afef6, 0xffb031f5, 0xffff3882, 0xffff3a2f,
  0xff7aa9a0, 0xffaffec1, 0xffff3802, 0xffff39b0,
  0xff7aa9a0, 0xffaffec1, 0xffff3802, 0xffff39b0,
  0xffd5ffac, 0xffe6cc69, 0xffffc102, 0xffffc19e,
  0xffac54ae, 0xffcdcc05, 0xffff8282, 0xffff839b,
  0xffa6ff4e, 0xffca98c5, 0xffff7a82, 0xffff7bab,
  0xffa5ff4c, 0xffc9ff29, 0xffff7902, 0xffff7a2e,
  0xffa554a0, 0xffc998c1, 0xffff7802, 0xffff7930,
  0xffa4ff4a, 0xffc9658d, 0xffff7782, 0xffff78b1,
  0xffa4ff4a, 0xffc9658d, 0xffff7782, 0xffff78b1,
  0xffa554a0, 0xffc998c1, 0xffff7802, 0xffff7930,
  0xffd65502, 0xffe6ff9d, 0xffffc182, 0xffffc21d,
  0xffd0ffa2, 0xffe3cc5d, 0xffffb982, 0xffffba2d,
  0xffcfffa0, 0xffe332c1, 0xffffb802, 0xffffb8b0,
  0xffcf54f4, 0xffe2cc59, 0xffffb702, 0xffffb7b2,
  0xffceff9e, 0xffe29925, 0xffffb682, 0xffffb733,
  0xffceff9e, 0xffe29925, 0xffffb682, 0xffffb733,
  0xffcf54f4, 0xffe2cc59, 0xffffb702, 0xffffb7b2,
  0xffcfffa0, 0xffe332c1, 0xffffb802, 0xffffb8b0,
  0xfffaaaa0, 0xfffcccc1, 0xfffff802, 0xfffff830,
  0xfff9aa9e, 0xfffc3325, 0xfffff682, 0xfffff6b3,
  0xfff8fff2, 0xfffbccbd, 0xfffff582, 0xfffff5b5,
  0xfff8aa9c, 0xfffb9989, 0xfffff502, 0xfffff536,
  0xfff8aa9c, 0xfffb9989, 0xfffff502, 0xfffff536,
  0xfff8fff2, 0xfffbccbd, 0xfffff582, 0xfffff5b5,
  0xfff9aa9e, 0xfffc3325, 0xfffff682, 0xfffff6b3,
  0xfffefffe, 0xffff6665, 0xfffffe82, 0xfffffea3,
  0xfffefffe, 0xffff6665, 0xfffffe82, 0xfffffea3,
  0xfffe5552, 0xfffefffd, 0xfffffd82, 0xfffffda5,
  0xfffdfffc, 0xfffeccc9, 0xfffffd02, 0xfffffd26,
  0xfffdfffc, 0xfffeccc9, 0xfffffd02, 0xfffffd26,
  0xfffe5552, 0xfffefffd, 0xfffffd82, 0xfffffda5,
  0xfffefffe, 0xffff6665, 0xfffffe82, 0xfffffea3,
  0x0004555e, 0x000299a5, 0x00000682, 0x00000693,
  0x002e005c, 0x001b9a09, 0x00004502, 0x00004496,
  0xffff5554, 0xffff9999, 0xffffff02, 0xffffff22,
  0xfffefffe, 0xffff6665, 0xfffffe82, 0xfffffea3,
  0xfffefffe, 0xffff6665, 0xfffffe82, 0xfffffea3,
  0xffff5554, 0xffff9999, 0xffffff02, 0xffffff22,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00055560, 0x00033341, 0x00000802, 0x00000810,
  0x002f005e, 0x001c33a5, 0x00004682, 0x00004613,
  0x005900b2, 0x0035673d, 0x00008582, 0x00008495,
  0xffffaaaa, 0xffffcccd, 0xffffff82, 0xffffffa1,
  0xffffaaaa, 0xffffcccd, 0xffffff82, 0xffffffa1,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x0000aaac, 0x00006669, 0x00000102, 0x0000011e,
  0x0006000c, 0x000399a9, 0x00000902, 0x0000090e,
  0x002fab0a, 0x001c9a0d, 0x00004782, 0x00004711,
  0x0059ab5e, 0x0035cda5, 0x00008682, 0x00008593,
  0x00840108, 0x004f3471, 0x0000c602, 0x0000c494,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00005556, 0x00003335, 0x00000082, 0x0000009f,
  0x00010002, 0x0000999d, 0x00000182, 0x0000019d,
  0x00065562, 0x0003ccdd, 0x00000982, 0x0000098d,
  0x00300060, 0x001ccd41, 0x00004802, 0x00004790,
  0x005a00b4, 0x003600d9, 0x00008702, 0x00008612,
  0x0084565e, 0x004f67a5, 0x0000c682, 0x0000c513,
  0x11957880, 0x0a8cf701, 0x001a6002, 0x001a2b60,
  0x00005556, 0x00003335, 0x00000082, 0x0000009f,
  0x00010002, 0x0000999d, 0x00000182, 0x0000019d,
  0x00065562, 0x0003ccdd, 0x00000982, 0x0000098d,
  0x00300060, 0x001ccd41, 0x00004802, 0x00004790,
  0x005a00b4, 0x003600d9, 0x00008702, 0x00008612,
  0x0084565e, 0x004f67a5, 0x0000c682, 0x0000c513,
  0x11957880, 0x0a8cf701, 0x001a6002, 0x001a2b60,
  0x2e075c0e, 0x1b9e3b45, 0x00450a82, 0x0044808b,
  0x0000aaac, 0x00006669, 0x00000102, 0x0000011e,
  0x0006000c, 0x000399a9, 0x00000902, 0x0000090e,
  0x002fab0a, 0x001c9a0d, 0x00004782, 0x00004711,
  0x0059ab5e, 0x0035cda5, 0x00008682, 0x00008593,
  0x00840108, 0x004f3471, 0x0000c602, 0x0000c494,
  0x1195232a, 0x0a8cc3cd, 0x001a5f82, 0x001a2ae1,
  0x2e0706b8, 0x1b9e0811, 0x00450a02, 0x0044800c,
  0x58b106b6, 0x35376e75, 0x00850882, 0x0083fe8f,
  0x00055560, 0x00033341, 0x00000802, 0x00000810,
  0x002f005e, 0x001c33a5, 0x00004682, 0x00004613,
  0x005900b2, 0x0035673d, 0x00008582, 0x00008495,
  0x0083565c, 0x004ece09, 0x0000c502, 0x0000c396,
  0x1194787e, 0x0a8c5d65, 0x001a5e82, 0x001a29e3,
  0x2e065c0c, 0x1b9da1a9, 0x00450902, 0x00447f0e,
  0x58b05c0a, 0x3537080d, 0x00850782, 0x0083fd91,
  0x835ab15e, 0x4ed0a1a5, 0x00c50682, 0x00c37c93,
  0x0029aafe, 0x00190065, 0x00003e82, 0x00003e23,
  0x0053ab52, 0x003233fd, 0x00007d82, 0x00007ca5,
  0x007e00fc, 0x004b9ac9, 0x0000bd02, 0x0000bba6,
  0x118f231e, 0x0a892a25, 0x001a5682, 0x001a21f3,
  0x2e0106ac, 0x1b9a6e69, 0x00450102, 0x0044771e,
  0x58ab06aa, 0x3533d4cd, 0x0084ff82, 0x0083f5a1,
  0x83555bfe, 0x4ecd6e65, 0x00c4fe82, 0x00c374a3,
  0xae0006a8, 0x68673b31, 0x0104fe02, 0x0102f424,
  0x002a0054, 0x00193399, 0x00003f02, 0x00003ea2,
  0x005455fe, 0x00329a65, 0x00007e82, 0x00007da3,
  0x11657820, 0x0a7029c1, 0x001a1802, 0x0019e3f0,
  0x2dd75bae, 0x1b816e05, 0x0044c282, 0x0044391b,
  0x58815bac, 0x351ad469, 0x0084c102, 0x0083b79e,
  0x832bb100, 0x4eb46e01, 0x00c4c002, 0x00c336a0,
  0xadd65baa, 0x684e3acd, 0x0104bf82, 0x0102b621,
  0x832b5baa, 0x4eb43acd, 0x00c4bf82, 0x00c33621,
  0x002a55aa, 0x001966cd, 0x00003f82, 0x00003f21,
  0x113b77cc, 0x0a56f629, 0x0019d902, 0x0019a56e,
  0x2dad5b5a, 0x1b683a6d, 0x00448382, 0x0043fa99,
  0x58575b58, 0x3501a0d1, 0x00848202, 0x0083791c,
  0x8301b0ac, 0x4e9b3a69, 0x00c48102, 0x00c2f81e,
  0xadac5b56, 0x68350735, 0x01048082, 0x0102779f,
  0x83015b56, 0x4e9b0735, 0x00c48082, 0x00c2f79f,
  0x5856b0ac, 0x35013a69, 0x00848102, 0x0083781e,
  0x11112222, 0x0a3d8f5d, 0x00199982, 0x0019666d,
  0x2d8305b0, 0x1b4ed3a1, 0x00444402, 0x0043bb98,
  0x582d05ae, 0x34e83a05, 0x00844282, 0x00833a1b,
  0x82d75b02, 0x4e81d39d, 0x00c44182, 0x00c2b91d,
  0xad8205ac, 0x681ba069, 0x01044102, 0x0102389e,
  0x82d705ac, 0x4e81a069, 0x00c44102, 0x00c2b89e,
  0x582c5b02, 0x34e7d39d, 0x00844182, 0x0083391d,
  0x3bba221e, 0x23d65c25, 0x00599682, 0x0058e373,
  0x1c71e38e, 0x11114445, 0x002aaa82, 0x002a554b,
  0x471be38c, 0x2aaaaaa9, 0x006aa902, 0x0069d3ce,
  0x71c638e0, 0x44444441, 0x00aaa802, 0x00a952d0,
  0x9c70e38a, 0x5dde110d, 0x00eaa782, 0x00e8d251,
  0x71c5e38a, 0x4444110d, 0x00aaa782, 0x00a95251,
  0x471b38e0, 0x2aaa4441, 0x006aa802, 0x0069d2d0,
  0x2aa8fffc, 0x1998ccc9, 0x003ffd02, 0x003f7d26,
  0x19978884, 0x0f5b0a39, 0x00266302, 0x0026165a,
  0x2aa9fffe, 0x19996665, 0x003ffe82, 0x003f7ea3,
  0x55545552, 0x3332fffd, 0x007ffd82, 0x007efda5,
  0x7ffefffc, 0x4cccccc9, 0x00bffd02, 0x00be7d26,
  0x5553fffc, 0x3332ccc9, 0x007ffd02, 0x007efd26,
  0x2aa95552, 0x1998fffd, 0x003ffd82, 0x003f7da5,
  0x0e371c6e, 0x08878885, 0x00155282, 0x001527fb,
  0xfd25a4f6, 0xfe49c5f5, 0xfffbb882, 0xfffbc12f,
  0xfcfaf9f6, 0xfe302bf5, 0xfffb7882, 0xfffb81af,
  0x2aaa5554, 0x19999999, 0x003fff02, 0x003f7f22,
  0x5554fffe, 0x33336665, 0x007ffe82, 0x007efea3,
  0x2aa9fffe, 0x19996665, 0x003ffe82, 0x003f7ea3,
  0xffff5554, 0xffff9999, 0xffffff02, 0xffffff22,
  0xe38d1c70, 0xeeee2221, 0xffd55402, 0xffd5a978,
  0xd27ba4f8, 0xe4b05f91, 0xffbbba02, 0xffbc42ac,
  0xd250f9f8, 0xe496c591, 0xffbb7a02, 0xffbc032c,
  0xd226a44e, 0xe47d5ec5, 0xffbb3a82, 0xffbbc42b,
  0x2aaaaaaa, 0x1999cccd, 0x003fff82, 0x003f7fa1,
  0xffffaaaa, 0xffffcccd, 0xffffff82, 0xffffffa1,
  0xd5550000, 0xe6660001, 0xffc00002, 0xffc08020,
  0xb8e2c71c, 0xd5548889, 0xff955502, 0xff962a76,
  0xa7d14fa4, 0xcb16c5f9, 0xff7bbb02, 0xff7cc3aa,
  0xa7a6a4a4, 0xcafd2bf9, 0xff7b7b02, 0xff7c842a,
  0xa77c4efa, 0xcae3c52d, 0xff7b3b82, 0xff7c4529,
  0xa7524ea6, 0xcaca9195, 0xff7afc82, 0xff7c06a7,
  0xd5550000, 0xe6660001, 0xffc00002, 0xffc08020,
  0xaaaa5556, 0xcccc3335, 0xff800082, 0xff81009f,
  0x8e381c72, 0xbbbabbbd, 0xff555582, 0xff56aaf5,
  0x7d26a4fa, 0xb17cf92d, 0xff3bbb82, 0xff3d4429,
  0x7cfbf9fa, 0xb1635f2d, 0xff3b7b82, 0xff3d04a9,
  0x7cd1a450, 0xb149f861, 0xff3b3c02, 0xff3cc5a8,
  0x7ca7a3fc, 0xb130c4c9, 0xff3afd02, 0xff3c8726,
  0x7c7df8fe, 0xb117c465, 0xff3abe82, 0xff3c4923,
  0xd5555556, 0xe6663335, 0xffc00082, 0xffc0809f,
  0xb8e31c72, 0xd554bbbd, 0xff955582, 0xff962af5,
  0xa7d1a4fa, 0xcb16f92d, 0xff7bbb82, 0xff7cc429,
  0xa7a6f9fa, 0xcafd5f2d, 0xff7b7b82, 0xff7c84a9,
  0xa77ca450, 0xcae3f861, 0xff7b3c02, 0xff7c45a8,
  0xa752a3fc, 0xcacac4c9, 0xff7afd02, 0xff7c0726,
  0xa728f8fe, 0xcab1c465, 0xff7abe82, 0xff7bc923,
  0xa723a39e, 0xcaae9125, 0xff7ab682, 0xff7bc133,
  0xe38dc71c, 0xeeee8889, 0xffd55502, 0xffd5aa76,
  0xd27c4fa4, 0xe4b0c5f9, 0xffbbbb02, 0xffbc43aa,
  0xd251a4a4, 0xe4972bf9, 0xffbb7b02, 0xffbc042a,
  0xd2274efa, 0xe47dc52d, 0xffbb3b82, 0xffbbc529,
  0xd1fd4ea6, 0xe4649195, 0xffbafc82, 0xffbb86a7,
  0xd1d3a3a8, 0xe44b9131, 0xffbabe02, 0xffbb48a4,
  0xd1ce4e48, 0xe4485df1, 0xffbab602, 0xffbb40b4,
  0xd1cd4e46, 0xe447c455, 0xffbab482, 0xffbb3f37,
  0xeeee8888, 0xf5c23d71, 0xffe66602, 0xffe69954,
  0xeec3dd88, 0xf5a8a371, 0xffe62602, 0xffe659d4,
  0xee9987de, 0xf58f3ca5, 0xffe5e682, 0xffe61ad3,
  0xee6f878a, 0xf576090d, 0xffe5a782, 0xffe5dc51,
  0xee45dc8c, 0xf55d08a9, 0xffe56902, 0xffe59e4e,
  0xee40872c, 0xf559d569, 0xffe56102, 0xffe5965e,
  0xee3f872a, 0xf5593bcd, 0xffe55f82, 0xffe594e1,
  0xee3edc7e, 0xf558d565, 0xffe55e82, 0xffe593e3,
  0xffd55500, 0xffe66601, 0xffffc002, 0xffffc0a0,
  0xffaaff56, 0xffccff35, 0xffff8082, 0xffff819f,
  0xff80ff02, 0xffb3cb9d, 0xffff4182, 0xffff431d,
  0xff575404, 0xff9acb39, 0xffff0302, 0xffff051a,
  0xff51fea4, 0xff9797f9, 0xfffefb02, 0xfffefd2a,
  0xff50fea2, 0xff96fe5d, 0xfffef982, 0xfffefbad,
  0xff5053f6, 0xff9697f5, 0xfffef882, 0xfffefaaf,
  0xff4ffea0, 0xff9664c1, 0xfffef802, 0xfffefa30,
  0xffe69934, 0xffffc081, 0xffffc101, 0xffffc19e,
  0xffcd659c, 0xffff8181, 0xffff827f, 0xffff839a,
  0xffb46538, 0xffff4301, 0xffff447c, 0xffff4614,
  0xffb131f8, 0xffff3b01, 0xffff3c8c, 0xffff3e34,
  0xffb0985c, 0xffff3981, 0xffff3b0f, 0xffff3cba,
  0xffb031f4, 0xffff3881, 0xffff3a11, 0xffff3bbe,
  0xffaffec0, 0xffff3801, 0xffff3992, 0xffff3b40,
  0xffaffec0, 0xffff3801, 0xffff3992, 0xffff3b40,
  0xffe6cc68, 0xffffc101, 0xffffc180, 0xffffc21c,
  0xffcdcc04, 0xffff8281, 0xffff837d, 0xffff8496,
  0xffca98c4, 0xffff7a81, 0xffff7b8d, 0xffff7cb6,
  0xffc9ff28, 0xffff7901, 0xffff7a10, 0xffff7b3c,
  0xffc998c0, 0xffff7801, 0xffff7912, 0xffff7a40,
  0xffc9658c, 0xffff7781, 0xffff7893, 0xffff79c2,
  0xffc9658c, 0xffff7781, 0xffff7893, 0xffff79c2,
  0xffc998c0, 0xffff7801, 0xffff7912, 0xffff7a40,
  0xffe6ff9c, 0xffffc181, 0xffffc1ff, 0xffffc29a,
  0xffe3cc5c, 0xffffb981, 0xffffba0f, 0xffffbaba,
  0xffe332c0, 0xffffb801, 0xffffb892, 0xffffb940,
  0xffe2cc58, 0xffffb701, 0xffffb794, 0xffffb844,
  0xffe29924, 0xffffb681, 0xffffb715, 0xffffb7c6,
  0xffe29924, 0xffffb681, 0xffffb715, 0xffffb7c6,
  0xffe2cc58, 0xffffb701, 0xffffb794, 0xffffb844,
  0xffe332c0, 0xffffb801, 0xffffb892, 0xffffb940,
  0xfffcccc0, 0xfffff801, 0xfffff812, 0xfffff840,
  0xfffc3324, 0xfffff681, 0xfffff695, 0xfffff6c6,
  0xfffbccbc, 0xfffff581, 0xfffff597, 0xfffff5ca,
  0xfffb9988, 0xfffff501, 0xfffff518, 0xfffff54c,
  0xfffb9988, 0xfffff501, 0xfffff518, 0xfffff54c,
  0xfffbccbc, 0xfffff581, 0xfffff597, 0xfffff5ca,
  0xfffc3324, 0xfffff681, 0xfffff695, 0xfffff6c6,
  0xffff6664, 0xfffffe81, 0xfffffe85, 0xfffffea6,
  0xffff6664, 0xfffffe81, 0xfffffe85, 0xfffffea6,
  0xfffefffc, 0xfffffd81, 0xfffffd87, 0xfffffdaa,
  0xfffeccc8, 0xfffffd01, 0xfffffd08, 0xfffffd2c,
  0xfffeccc8, 0xfffffd01, 0xfffffd08, 0xfffffd2c,
  0xfffefffc, 0xfffffd81, 0xfffffd87, 0xfffffdaa,
  0xffff6664, 0xfffffe81, 0xfffffe85, 0xfffffea6,
  0x000299a4, 0x00000681, 0x00000675, 0x00000686,
  0x001b9a08, 0x00004501, 0x00004478, 0x0000440c,
  0xffff9998, 0xffffff01, 0xffffff04, 0xffffff24,
  0xffff6664, 0xfffffe81, 0xfffffe85, 0xfffffea6,
  0xffff6664, 0xfffffe81, 0xfffffe85, 0xfffffea6,
  0xffff9998, 0xffffff01, 0xffffff04, 0xffffff24,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00033340, 0x00000801, 0x000007f2, 0x00000800,
  0x001c33a4, 0x00004681, 0x000045f5, 0x00004586,
  0x0035673c, 0x00008581, 0x00008477, 0x0000838a,
  0xffffcccc, 0xffffff81, 0xffffff83, 0xffffffa2,
  0xffffcccc, 0xffffff81, 0xffffff83, 0xffffffa2,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00006668, 0x00000101, 0x00000100, 0x0000011c,
  0x000399a8, 0x00000901, 0x000008f0, 0x000008fc,
  0x001c9a0c, 0x00004781, 0x000046f3, 0x00004682,
  0x0035cda4, 0x00008681, 0x00008575, 0x00008486,
  0x004f3470, 0x0000c601, 0x0000c476, 0x0000c308,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00003334, 0x00000081, 0x00000081, 0x0000009e,
  0x0000999c, 0x00000181, 0x0000017f, 0x0000019a,
  0x0003ccdc, 0x00000981, 0x0000096f, 0x0000097a,
  0x001ccd40, 0x00004801, 0x00004772, 0x00004700,
  0x003600d8, 0x00008701, 0x000085f4, 0x00008504,
  0x004f67a4, 0x0000c681, 0x0000c4f5, 0x0000c386,
  0x0a8cf700, 0x001a6001, 0x001a2b42, 0x0019f6a0,
  0x00003334, 0x00000081, 0x00000081, 0x0000009e,
  0x0000999c, 0x00000181, 0x0000017f, 0x0000019a,
  0x0003ccdc, 0x00000981, 0x0000096f, 0x0000097a,
  0x001ccd40, 0x00004801, 0x00004772, 0x00004700,
  0x003600d8, 0x00008701, 0x000085f4, 0x00008504,
  0x004f67a4, 0x0000c681, 0x0000c4f5, 0x0000c386,
  0x0a8cf700, 0x001a6001, 0x001a2b42, 0x0019f6a0,
  0x1b9e3b44, 0x00450a81, 0x0044806d, 0x0043f676,
  0x00006668, 0x00000101, 0x00000100, 0x0000011c,
  0x000399a8, 0x00000901, 0x000008f0, 0x000008fc,
  0x001c9a0c, 0x00004781, 0x000046f3, 0x00004682,
  0x0035cda4, 0x00008681, 0x00008575, 0x00008486,
  0x004f3470, 0x0000c601, 0x0000c476, 0x0000c308,
  0x0a8cc3cc, 0x001a5f81, 0x001a2ac3, 0x0019f622,
  0x1b9e0810, 0x00450a01, 0x00447fee, 0x0043f5f8,
  0x35376e74, 0x00850881, 0x0083fe71, 0x0082f47e,
  0x00033340, 0x00000801, 0x000007f2, 0x00000800,
  0x001c33a4, 0x00004681, 0x000045f5, 0x00004586,
  0x0035673c, 0x00008581, 0x00008477, 0x0000838a,
  0x004ece08, 0x0000c501, 0x0000c378, 0x0000c20c,
  0x0a8c5d64, 0x001a5e81, 0x001a29c5, 0x0019f526,
  0x1b9da1a8, 0x00450901, 0x00447ef0, 0x0043f4fc,
  0x3537080c, 0x00850781, 0x0083fd73, 0x0082f382,
  0x4ed0a1a4, 0x00c50681, 0x00c37c75, 0x00c1f286,
  0x00190064, 0x00003e81, 0x00003e05, 0x00003da6,
  0x003233fc, 0x00007d81, 0x00007c87, 0x00007baa,
  0x004b9ac8, 0x0000bd01, 0x0000bb88, 0x0000ba2c,
  0x0a892a24, 0x001a5681, 0x001a21d5, 0x0019ed46,
  0x1b9a6e68, 0x00450101, 0x00447700, 0x0043ed1c,
  0x3533d4cc, 0x0084ff81, 0x0083f583, 0x0082eba2,
  0x4ecd6e64, 0x00c4fe81, 0x00c37485, 0x00c1eaa6,
  0x68673b30, 0x0104fe01, 0x0102f406, 0x0100ea28,
  0x00193398, 0x00003f01, 0x00003e84, 0x00003e24,
  0x00329a64, 0x00007e81, 0x00007d85, 0x00007ca6,
  0x0a7029c0, 0x001a1801, 0x0019e3d2, 0x0019afc0,
  0x1b816e04, 0x0044c281, 0x004438fd, 0x0043af96,
  0x351ad468, 0x0084c101, 0x0083b780, 0x0082ae1c,
  0x4eb46e00, 0x00c4c001, 0x00c33682, 0x00c1ad20,
  0x684e3acc, 0x0104bf81, 0x0102b603, 0x0100aca2,
  0x4eb43acc, 0x00c4bf81, 0x00c33603, 0x00c1aca2,
  0x001966cc, 0x00003f81, 0x00003f03, 0x00003ea2,
  0x0a56f628, 0x0019d901, 0x0019a550, 0x001971bc,
  0x1b683a6c, 0x00448381, 0x0043fa7b, 0x00437192,
  0x3501a0d0, 0x00848201, 0x008378fe, 0x00827018,
  0x4e9b3a68, 0x00c48101, 0x00c2f800, 0x00c16f1c,
  0x68350734, 0x01048081, 0x01027781, 0x01006e9e,
  0x4e9b0734, 0x00c48081, 0x00c2f781, 0x00c16e9e,
  0x35013a68, 0x00848101, 0x00837800, 0x00826f1c,
  0x0a3d8f5c, 0x00199981, 0x0019664f, 0x0019333a,
  0x1b4ed3a0, 0x00444401, 0x0043bb7a, 0x00433310,
  0x34e83a04, 0x00844281, 0x008339fd, 0x00823196,
  0x4e81d39c, 0x00c44181, 0x00c2b8ff, 0x00c1309a,
  0x681ba068, 0x01044101, 0x01023880, 0x0100301c,
  0x4e81a068, 0x00c44101, 0x00c2b880, 0x00c1301c,
  0x34e7d39c, 0x00844181, 0x008338ff, 0x0082309a,
  0x23d65c24, 0x00599681, 0x0058e355, 0x00583046,
  0x11114444, 0x002aaa81, 0x002a552d, 0x0029fff6,
  0x2aaaaaa8, 0x006aa901, 0x0069d3b0, 0x0068fe7c,
  0x44444440, 0x00aaa801, 0x00a952b2, 0x00a7fd80,
  0x5dde110c, 0x00eaa781, 0x00e8d233, 0x00e6fd02,
  0x4444110c, 0x00aaa781, 0x00a95233, 0x00a7fd02,
  0x2aaa4440, 0x006aa801, 0x0069d2b2, 0x0068fd80,
  0x1998ccc8, 0x003ffd01, 0x003f7d08, 0x003efd2c,
  0x0f5b0a38, 0x00266301, 0x0026163c, 0x0025c994,
  0x19996664, 0x003ffe81, 0x003f7e85, 0x003efea6,
  0x3332fffc, 0x007ffd81, 0x007efd87, 0x007dfdaa,
  0x4cccccc8, 0x00bffd01, 0x00be7d08, 0x00bcfd2c,
  0x3332ccc8, 0x007ffd01, 0x007efd08, 0x007dfd2c,
  0x1998fffc, 0x003ffd81, 0x003f7d87, 0x003efdaa,
  0x08878884, 0x00155281, 0x001527dd, 0x0014fd56,
  0xfe49c5f4, 0xfffbb881, 0xfffbc111, 0xfffbc9be,
  0xfe302bf4, 0xfffb7881, 0xfffb8191, 0xfffb8abe,
  0x19999998, 0x003fff01, 0x003f7f04, 0x003eff24,
  0x33336664, 0x007ffe81, 0x007efe85, 0x007dfea6,
  0x19996664, 0x003ffe81, 0x003f7e85, 0x003efea6,
  0xffff9998, 0xffffff01, 0xffffff04, 0xffffff24,
  0xeeee2220, 0xffd55401, 0xffd5a95a, 0xffd5fed0,
  0xe4b05f90, 0xffbbba01, 0xffbc428e, 0xffbccb38,
  0xe496c590, 0xffbb7a01, 0xffbc030e, 0xffbc8c38,
  0xe47d5ec4, 0xffbb3a81, 0xffbbc40d, 0xffbc4db6,
  0x1999cccc, 0x003fff81, 0x003f7f83, 0x003effa2,
  0xffffcccc, 0xffffff81, 0xffffff83, 0xffffffa2,
  0xe6660000, 0xffc00001, 0xffc08002, 0xffc10020,
  0xd5548888, 0xff955501, 0xff962a58, 0xff96ffcc,
  0xcb16c5f8, 0xff7bbb01, 0xff7cc38c, 0xff7dcc34,
  0xcafd2bf8, 0xff7b7b01, 0xff7c840c, 0xff7d8d34,
  0xcae3c52c, 0xff7b3b81, 0xff7c450b, 0xff7d4eb2,
  0xcaca9194, 0xff7afc81, 0xff7c0689, 0xff7d10ae,
  0xe6660000, 0xffc00001, 0xffc08002, 0xffc10020,
  0xcccc3334, 0xff800081, 0xff810081, 0xff82009e,
  0xbbbabbbc, 0xff555581, 0xff56aad7, 0xff58004a,
  0xb17cf92c, 0xff3bbb81, 0xff3d440b, 0xff3eccb2,
  0xb1635f2c, 0xff3b7b81, 0xff3d048b, 0xff3e8db2,
  0xb149f860, 0xff3b3c01, 0xff3cc58a, 0xff3e4f30,
  0xb130c4c8, 0xff3afd01, 0xff3c8708, 0xff3e112c,
  0xb117c464, 0xff3abe81, 0xff3c4905, 0xff3dd3a6,
  0xe6663334, 0xffc00081, 0xffc08081, 0xffc1009e,
  0xd554bbbc, 0xff955581, 0xff962ad7, 0xff97004a,
  0xcb16f92c, 0xff7bbb81, 0xff7cc40b, 0xff7dccb2,
  0xcafd5f2c, 0xff7b7b81, 0xff7c848b, 0xff7d8db2,
  0xcae3f860, 0xff7b3c01, 0xff7c458a, 0xff7d4f30,
  0xcacac4c8, 0xff7afd01, 0xff7c0708, 0xff7d112c,
  0xcab1c464, 0xff7abe81, 0xff7bc905, 0xff7cd3a6,
  0xcaae9124, 0xff7ab681, 0xff7bc115, 0xff7ccbc6,
  0xeeee8888, 0xffd55501, 0xffd5aa58, 0xffd5ffcc,
  0xe4b0c5f8, 0xffbbbb01, 0xffbc438c, 0xffbccc34,
  0xe4972bf8, 0xffbb7b01, 0xffbc040c, 0xffbc8d34,
  0xe47dc52c, 0xffbb3b81, 0xffbbc50b, 0xffbc4eb2,
  0xe4649194, 0xffbafc81, 0xffbb8689, 0xffbc10ae,
  0xe44b9130, 0xffbabe01, 0xffbb4886, 0xffbbd328,
  0xe4485df0, 0xffbab601, 0xffbb4096, 0xffbbcb48,
  0xe447c454, 0xffbab481, 0xffbb3f19, 0xffbbc9ce,
  0xf5c23d70, 0xffe66601, 0xffe69936, 0xffe6cc88,
  0xf5a8a370, 0xffe62601, 0xffe659b6, 0xffe68d88,
  0xf58f3ca4, 0xffe5e681, 0xffe61ab5, 0xffe64f06,
  0xf576090c, 0xffe5a781, 0xffe5dc33, 0xffe61102,
  0xf55d08a8, 0xffe56901, 0xffe59e30, 0xffe5d37c,
  0xf559d568, 0xffe56101, 0xffe59640, 0xffe5cb9c,
  0xf5593bcc, 0xffe55f81, 0xffe594c3, 0xffe5ca22,
  0xf558d564, 0xffe55e81, 0xffe593c5, 0xffe5c926,
  0xffe66600, 0xffffc001, 0xffffc082, 0xffffc120,
  0xffccff34, 0xffff8081, 0xffff8181, 0xffff829e,
  0xffb3cb9c, 0xffff4181, 0xffff42ff, 0xffff449a,
  0xff9acb38, 0xffff0301, 0xffff04fc, 0xffff0714,
  0xff9797f8, 0xfffefb01, 0xfffefd0c, 0xfffeff34,
  0xff96fe5c, 0xfffef981, 0xfffefb8f, 0xfffefdba,
  0xff9697f4, 0xfffef881, 0xfffefa91, 0xfffefcbe,
  0xff9664c0, 0xfffef801, 0xfffefa12, 0xfffefc40,
  0xffffc080, 0xffffc100, 0xffffc180, 0xffffc21d,
  0xffff8180, 0xffff827e, 0xffff837c, 0xffff8497,
  0xffff4300, 0xffff447b, 0xffff45f6, 0xffff478e,
  0xffff3b00, 0xffff3c8b, 0xffff3e16, 0xffff3fbe,
  0xffff3980, 0xffff3b0e, 0xffff3c9c, 0xffff3e47,
  0xffff3880, 0xffff3a10, 0xffff3ba0, 0xffff3d4d,
  0xffff3800, 0xffff3991, 0xffff3b22, 0xffff3cd0,
  0xffff3800, 0xffff3991, 0xffff3b22, 0xffff3cd0,
  0xffffc100, 0xffffc17f, 0xffffc1fe, 0xffffc29a,
  0xffff8280, 0xffff837c, 0xffff8478, 0xffff8591,
  0xffff7a80, 0xffff7b8c, 0xffff7c98, 0xffff7dc1,
  0xffff7900, 0xffff7a0f, 0xffff7b1e, 0xffff7c4a,
  0xffff7800, 0xffff7911, 0xffff7a22, 0xffff7b50,
  0xffff7780, 0xffff7892, 0xffff79a4, 0xffff7ad3,
  0xffff7780, 0xffff7892, 0xffff79a4, 0xffff7ad3,
  0xffff7800, 0xffff7911, 0xffff7a22, 0xffff7b50,
  0xffffc180, 0xffffc1fe, 0xffffc27c, 0xffffc317,
  0xffffb980, 0xffffba0e, 0xffffba9c, 0xffffbb47,
  0xffffb800, 0xffffb891, 0xffffb922, 0xffffb9d0,
  0xffffb700, 0xffffb793, 0xffffb826, 0xffffb8d6,
  0xffffb680, 0xffffb714, 0xffffb7a8, 0xffffb859,
  0xffffb680, 0xffffb714, 0xffffb7a8, 0xffffb859,
  0xffffb700, 0xffffb793, 0xffffb826, 0xffffb8d6,
  0xffffb800, 0xffffb891, 0xffffb922, 0xffffb9d0,
  0xfffff800, 0xfffff811, 0xfffff822, 0xfffff850,
  0xfffff680, 0xfffff694, 0xfffff6a8, 0xfffff6d9,
  0xfffff580, 0xfffff596, 0xfffff5ac, 0xfffff5df,
  0xfffff500, 0xfffff517, 0xfffff52e, 0xfffff562,
  0xfffff500, 0xfffff517, 0xfffff52e, 0xfffff562,
  0xfffff580, 0xfffff596, 0xfffff5ac, 0xfffff5df,
  0xfffff680, 0xfffff694, 0xfffff6a8, 0xfffff6d9,
  0xfffffe80, 0xfffffe84, 0xfffffe88, 0xfffffea9,
  0xfffffe80, 0xfffffe84, 0xfffffe88, 0xfffffea9,
  0xfffffd80, 0xfffffd86, 0xfffffd8c, 0xfffffdaf,
  0xfffffd00, 0xfffffd07, 0xfffffd0e, 0xfffffd32,
  0xfffffd00, 0xfffffd07, 0xfffffd0e, 0xfffffd32,
  0xfffffd80, 0xfffffd86, 0xfffffd8c, 0xfffffdaf,
  0xfffffe80, 0xfffffe84, 0xfffffe88, 0xfffffea9,
  0x00000680, 0x00000674, 0x00000668, 0x00000679,
  0x00004500, 0x00004477, 0x000043ee, 0x00004382,
  0xffffff00, 0xffffff03, 0xffffff06, 0xffffff26,
  0xfffffe80, 0xfffffe84, 0xfffffe88, 0xfffffea9,
  0xfffffe80, 0xfffffe84, 0xfffffe88, 0xfffffea9,
  0xffffff00, 0xffffff03, 0xffffff06, 0xffffff26,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000800, 0x000007f1, 0x000007e2, 0x000007f0,
  0x00004680, 0x000045f4, 0x00004568, 0x000044f9,
  0x00008580, 0x00008476, 0x0000836c, 0x0000827f,
  0xffffff80, 0xffffff82, 0xffffff84, 0xffffffa3,
  0xffffff80, 0xffffff82, 0xffffff84, 0xffffffa3,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000100, 0x000000ff, 0x000000fe, 0x0000011a,
  0x00000900, 0x000008ef, 0x000008de, 0x000008ea,
  0x00004780, 0x000046f2, 0x00004664, 0x000045f3,
  0x00008680, 0x00008574, 0x00008468, 0x00008379,
  0x0000c600, 0x0000c475, 0x0000c2ea, 0x0000c17c,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000080, 0x00000080, 0x00000080, 0x0000009d,
  0x00000180, 0x0000017e, 0x0000017c, 0x00000197,
  0x00000980, 0x0000096e, 0x0000095c, 0x00000967,
  0x00004800, 0x00004771, 0x000046e2, 0x00004670,
  0x00008700, 0x000085f3, 0x000084e6, 0x000083f6,
  0x0000c680, 0x0000c4f4, 0x0000c368, 0x0000c1f9,
  0x001a6000, 0x001a2b41, 0x0019f682, 0x0019c1e0,
  0x00000080, 0x00000080, 0x00000080, 0x0000009d,
  0x00000180, 0x0000017e, 0x0000017c, 0x00000197,
  0x00000980, 0x0000096e, 0x0000095c, 0x00000967,
  0x00004800, 0x00004771, 0x000046e2, 0x00004670,
  0x00008700, 0x000085f3, 0x000084e6, 0x000083f6,
  0x0000c680, 0x0000c4f4, 0x0000c368, 0x0000c1f9,
  0x001a6000, 0x001a2b41, 0x0019f682, 0x0019c1e0,
  0x00450a80, 0x0044806c, 0x0043f658, 0x00436c61,
  0x00000100, 0x000000ff, 0x000000fe, 0x0000011a,
  0x00000900, 0x000008ef, 0x000008de, 0x000008ea,
  0x00004780, 0x000046f2, 0x00004664, 0x000045f3,
  0x00008680, 0x00008574, 0x00008468, 0x00008379,
  0x0000c600, 0x0000c475, 0x0000c2ea, 0x0000c17c,
  0x001a5f80, 0x001a2ac2, 0x0019f604, 0x0019c163,
  0x00450a00, 0x00447fed, 0x0043f5da, 0x00436be4,
  0x00850880, 0x0083fe70, 0x0082f460, 0x0081ea6d,
  0x00000800, 0x000007f1, 0x000007e2, 0x000007f0,
  0x00004680, 0x000045f4, 0x00004568, 0x000044f9,
  0x00008580, 0x00008476, 0x0000836c, 0x0000827f,
  0x0000c500, 0x0000c377, 0x0000c1ee, 0x0000c082,
  0x001a5e80, 0x001a29c4, 0x0019f508, 0x0019c069,
  0x00450900, 0x00447eef, 0x0043f4de, 0x00436aea,
  0x00850780, 0x0083fd72, 0x0082f364, 0x0081e973,
  0x00c50680, 0x00c37c74, 0x00c1f268, 0x00c06879,
  0x00003e80, 0x00003e04, 0x00003d88, 0x00003d29,
  0x00007d80, 0x00007c86, 0x00007b8c, 0x00007aaf,
  0x0000bd00, 0x0000bb87, 0x0000ba0e, 0x0000b8b2,
  0x001a5680, 0x001a21d4, 0x0019ed28, 0x0019b899,
  0x00450100, 0x004476ff, 0x0043ecfe, 0x0043631a,
  0x0084ff80, 0x0083f582, 0x0082eb84, 0x0081e1a3,
  0x00c4fe80, 0x00c37484, 0x00c1ea88, 0x00c060a9,
  0x0104fe00, 0x0102f405, 0x0100ea0a, 0x00fee02c,
  0x00003f00, 0x00003e83, 0x00003e06, 0x00003da6,
  0x00007e80, 0x00007d84, 0x00007c88, 0x00007ba9,
  0x001a1800, 0x0019e3d1, 0x0019afa2, 0x00197b90,
  0x0044c280, 0x004438fc, 0x0043af78, 0x00432611,
  0x0084c100, 0x0083b77f, 0x0082adfe, 0x0081a49a,
  0x00c4c000, 0x00c33681, 0x00c1ad02, 0x00c023a0,
  0x0104bf80, 0x0102b602, 0x0100ac84, 0x00fea323,
  0x00c4bf80, 0x00c33602, 0x00c1ac84, 0x00c02323,
  0x00003f80, 0x00003f02, 0x00003e84, 0x00003e23,
  0x0019d900, 0x0019a54f, 0x0019719e, 0x00193e0a,
  0x00448380, 0x0043fa7a, 0x00437174, 0x0042e88b,
  0x00848200, 0x008378fd, 0x00826ffa, 0x00816714,
  0x00c48100, 0x00c2f7ff, 0x00c16efe, 0x00bfe61a,
  0x01048080, 0x01027780, 0x01006e80, 0x00fe659d,
  0x00c48080, 0x00c2f780, 0x00c16e80, 0x00bfe59d,
  0x00848100, 0x008377ff, 0x00826efe, 0x0081661a,
  0x00199980, 0x0019664e, 0x0019331c, 0x00190007,
  0x00444400, 0x0043bb79, 0x004332f2, 0x0042aa88,
  0x00844280, 0x008339fc, 0x00823178, 0x00812911,
  0x00c44180, 0x00c2b8fe, 0x00c1307c, 0x00bfa817,
  0x01044100, 0x0102387f, 0x01002ffe, 0x00fe279a,
  0x00c44100, 0x00c2b87f, 0x00c12ffe, 0x00bfa79a,
  0x00844180, 0x008338fe, 0x0082307c, 0x00812817,
  0x00599680, 0x0058e354, 0x00583028, 0x00577d19,
  0x002aaa80, 0x002a552c, 0x0029ffd8, 0x0029aaa1,
  0x006aa900, 0x0069d3af, 0x0068fe5e, 0x0068292a,
  0x00aaa800, 0x00a952b1, 0x00a7fd62, 0x00a6a830,
  0x00eaa780, 0x00e8d232, 0x00e6fce4, 0x00e527b3,
  0x00aaa780, 0x00a95232, 0x00a7fce4, 0x00a6a7b3,
  0x006aa800, 0x0069d2b1, 0x0068fd62, 0x00682830,
  0x003ffd00, 0x003f7d07, 0x003efd0e, 0x003e7d32,
  0x00266300, 0x0026163b, 0x0025c976, 0x00257cce,
  0x003ffe80, 0x003f7e84, 0x003efe88, 0x003e7ea9,
  0x007ffd80, 0x007efd86, 0x007dfd8c, 0x007cfdaf,
  0x00bffd00, 0x00be7d07, 0x00bcfd0e, 0x00bb7d32,
  0x007ffd00, 0x007efd07, 0x007dfd0e, 0x007cfd32,
  0x003ffd80, 0x003f7d86, 0x003efd8c, 0x003e7daf,
  0x00155280, 0x001527dc, 0x0014fd38, 0x0014d2b1,
  0xfffbb880, 0xfffbc110, 0xfffbc9a0, 0xfffbd24d,
  0xfffb7880, 0xfffb8190, 0xfffb8aa0, 0xfffb93cd,
  0x003fff00, 0x003f7f03, 0x003eff06, 0x003e7f26,
  0x007ffe80, 0x007efe84, 0x007dfe88, 0x007cfea9,
  0x003ffe80, 0x003f7e84, 0x003efe88, 0x003e7ea9,
  0xffffff00, 0xffffff03, 0xffffff06, 0xffffff26,
  0xffd55400, 0xffd5a959, 0xffd5feb2, 0xffd65428,
  0xffbbba00, 0xffbc428d, 0xffbccb1a, 0xffbd53c4,
  0xffbb7a00, 0xffbc030d, 0xffbc8c1a, 0xffbd1544,
  0xffbb3a80, 0xffbbc40c, 0xffbc4d98, 0xffbcd741,
  0x003fff80, 0x003f7f82, 0x003eff84, 0x003e7fa3,
  0xffffff80, 0xffffff82, 0xffffff84, 0xffffffa3,
  0xffc00000, 0xffc08001, 0xffc10002, 0xffc18020,
  0xff955500, 0xff962a57, 0xff96ffae, 0xff97d522,
  0xff7bbb00, 0xff7cc38b, 0xff7dcc16, 0xff7ed4be,
  0xff7b7b00, 0xff7c840b, 0xff7d8d16, 0xff7e963e,
  0xff7b3b80, 0xff7c450a, 0xff7d4e94, 0xff7e583b,
  0xff7afc80, 0xff7c0688, 0xff7d1090, 0xff7e1ab5,
  0xffc00000, 0xffc08001, 0xffc10002, 0xffc18020,
  0xff800080, 0xff810080, 0xff820080, 0xff83009d,
  0xff555580, 0xff56aad6, 0xff58002c, 0xff59559f,
  0xff3bbb80, 0xff3d440a, 0xff3ecc94, 0xff40553b,
  0xff3b7b80, 0xff3d048a, 0xff3e8d94, 0xff4016bb,
  0xff3b3c00, 0xff3cc589, 0xff3e4f12, 0xff3fd8b8,
  0xff3afd00, 0xff3c8707, 0xff3e110e, 0xff3f9b32,
  0xff3abe80, 0xff3c4904, 0xff3dd388, 0xff3f5e29,
  0xffc00080, 0xffc08080, 0xffc10080, 0xffc1809d,
  0xff955580, 0xff962ad6, 0xff97002c, 0xff97d59f,
  0xff7bbb80, 0xff7cc40a, 0xff7dcc94, 0xff7ed53b,
  0xff7b7b80, 0xff7c848a, 0xff7d8d94, 0xff7e96bb,
  0xff7b3c00, 0xff7c4589, 0xff7d4f12, 0xff7e58b8,
  0xff7afd00, 0xff7c0707, 0xff7d110e, 0xff7e1b32,
  0xff7abe80, 0xff7bc904, 0xff7cd388, 0xff7dde29,
  0xff7ab680, 0xff7bc114, 0xff7ccba8, 0xff7dd659,
  0xffd55500, 0xffd5aa57, 0xffd5ffae, 0xffd65522,
  0xffbbbb00, 0xffbc438b, 0xffbccc16, 0xffbd54be,
  0xffbb7b00, 0xffbc040b, 0xffbc8d16, 0xffbd163e,
  0xffbb3b80, 0xffbbc50a, 0xffbc4e94, 0xffbcd83b,
  0xffbafc80, 0xffbb8688, 0xffbc1090, 0xffbc9ab5,
  0xffbabe00, 0xffbb4885, 0xffbbd30a, 0xffbc5dac,
  0xffbab600, 0xffbb4095, 0xffbbcb2a, 0xffbc55dc,
  0xffbab480, 0xffbb3f18, 0xffbbc9b0, 0xffbc5465,
  0xffe66600, 0xffe69935, 0xffe6cc6a, 0xffe6ffbc,
  0xffe62600, 0xffe659b5, 0xffe68d6a, 0xffe6c13c,
  0xffe5e680, 0xffe61ab4, 0xffe64ee8, 0xffe68339,
  0xffe5a780, 0xffe5dc32, 0xffe610e4, 0xffe645b3,
  0xffe56900, 0xffe59e2f, 0xffe5d35e, 0xffe608aa,
  0xffe56100, 0xffe5963f, 0xffe5cb7e, 0xffe600da,
  0xffe55f80, 0xffe594c2, 0xffe5ca04, 0xffe5ff63,
  0xffe55e80, 0xffe593c4, 0xffe5c908, 0xffe5fe69,
  0xffffc000, 0xffffc081, 0xffffc102, 0xffffc1a0,
  0xffff8080, 0xffff8180, 0xffff8280, 0xffff839d,
  0xffff4180, 0xffff42fe, 0xffff447c, 0xffff4617,
  0xffff0300, 0xffff04fb, 0xffff06f6, 0xffff090e,
  0xfffefb00, 0xfffefd0b, 0xfffeff16, 0xffff013e,
  0xfffef980, 0xfffefb8e, 0xfffefd9c, 0xfffeffc7,
  0xfffef880, 0xfffefa90, 0xfffefca0, 0xfffefecd,
  0xfffef800, 0xfffefa11, 0xfffefc22, 0xfffefe50,
  0xffffc0ff, 0xffffc17f, 0xffffc1ff, 0xfffff830,
  0xffff827d, 0xffff837b, 0xffff8479, 0xfffff050,
  0xffff447a, 0xffff45f5, 0xffff4770, 0xffffe880,
  0xffff3c8a, 0xffff3e15, 0xffff3fa0, 0xffffe780,
  0xffff3b0d, 0xffff3c9b, 0xffff3e29, 0xffffe750,
  0xffff3a0f, 0xffff3b9f, 0xffff3d2f, 0xffffe730,
  0xffff3990, 0xffff3b21, 0xffff3cb2, 0xffffe720,
  0xffff3990, 0xffff3b21, 0xffff3cb2, 0xffffe720,
  0xffffc17e, 0xffffc1fd, 0xffffc27c, 0xfffff840,
  0xffff837b, 0xffff8477, 0xffff8573, 0xfffff070,
  0xffff7b8b, 0xffff7c97, 0xffff7da3, 0xffffef70,
  0xffff7a0e, 0xffff7b1d, 0xffff7c2c, 0xffffef40,
  0xffff7910, 0xffff7a21, 0xffff7b32, 0xffffef20,
  0xffff7891, 0xffff79a3, 0xffff7ab5, 0xffffef10,
  0xffff7891, 0xffff79a3, 0xffff7ab5, 0xffffef10,
  0xffff7910, 0xffff7a21, 0xffff7b32, 0xffffef20,
  0xffffc1fd, 0xffffc27b, 0xffffc2f9, 0xfffff850,
  0xffffba0d, 0xffffba9b, 0xffffbb29, 0xfffff750,
  0xffffb890, 0xffffb921, 0xffffb9b2, 0xfffff720,
  0xffffb792, 0xffffb825, 0xffffb8b8, 0xfffff700,
  0xffffb713, 0xffffb7a7, 0xffffb83b, 0xfffff6f0,
  0xffffb713, 0xffffb7a7, 0xffffb83b, 0xfffff6f0,
  0xffffb792, 0xffffb825, 0xffffb8b8, 0xfffff700,
  0xffffb890, 0xffffb921, 0xffffb9b2, 0xfffff720,
  0xfffff810, 0xfffff821, 0xfffff832, 0xffffff20,
  0xfffff693, 0xfffff6a7, 0xfffff6bb, 0xfffffef0,
  0xfffff595, 0xfffff5ab, 0xfffff5c1, 0xfffffed0,
  0xfffff516, 0xfffff52d, 0xfffff544, 0xfffffec0,
  0xfffff516, 0xfffff52d, 0xfffff544, 0xfffffec0,
  0xfffff595, 0xfffff5ab, 0xfffff5c1, 0xfffffed0,
  0xfffff693, 0xfffff6a7, 0xfffff6bb, 0xfffffef0,
  0xfffffe83, 0xfffffe87, 0xfffffe8b, 0xfffffff0,
  0xfffffe83, 0xfffffe87, 0xfffffe8b, 0xfffffff0,
  0xfffffd85, 0xfffffd8b, 0xfffffd91, 0xffffffd0,
  0xfffffd06, 0xfffffd0d, 0xfffffd14, 0xffffffc0,
  0xfffffd06, 0xfffffd0d, 0xfffffd14, 0xffffffc0,
  0xfffffd85, 0xfffffd8b, 0xfffffd91, 0xffffffd0,
  0xfffffe83, 0xfffffe87, 0xfffffe8b, 0xfffffff0,
  0x00000673, 0x00000667, 0x0000065b, 0x000000f0,
  0x00004476, 0x000043ed, 0x00004364, 0x000008c0,
  0xffffff02, 0xffffff05, 0xffffff08, 0x00000000,
  0xfffffe83, 0xfffffe87, 0xfffffe8b, 0xfffffff0,
  0xfffffe83, 0xfffffe87, 0xfffffe8b, 0xfffffff0,
  0xffffff02, 0xffffff05, 0xffffff08, 0x00000000,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x000007f0, 0x000007e1, 0x000007d2, 0x00000120,
  0x000045f3, 0x00004567, 0x000044db, 0x000008f0,
  0x00008475, 0x0000836b, 0x00008261, 0x000010d0,
  0xffffff81, 0xffffff83, 0xffffff85, 0x00000010,
  0xffffff81, 0xffffff83, 0xffffff85, 0x00000010,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x000000fe, 0x000000fd, 0x000000fc, 0x00000040,
  0x000008ee, 0x000008dd, 0x000008cc, 0x00000140,
  0x000046f1, 0x00004663, 0x000045d5, 0x00000910,
  0x00008573, 0x00008467, 0x0000835b, 0x000010f0,
  0x0000c474, 0x0000c2e9, 0x0000c15e, 0x000018e0,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x0000007f, 0x0000007f, 0x0000007f, 0x00000030,
  0x0000017d, 0x0000017b, 0x00000179, 0x00000050,
  0x0000096d, 0x0000095b, 0x00000949, 0x00000150,
  0x00004770, 0x000046e1, 0x00004652, 0x00000920,
  0x000085f2, 0x000084e5, 0x000083d8, 0x00001100,
  0x0000c4f3, 0x0000c367, 0x0000c1db, 0x000018f0,
  0x001a2b40, 0x0019f681, 0x0019c1c2, 0x00034c20,
  0x0000007f, 0x0000007f, 0x0000007f, 0x00000030,
  0x0000017d, 0x0000017b, 0x00000179, 0x00000050,
  0x0000096d, 0x0000095b, 0x00000949, 0x00000150,
  0x00004770, 0x000046e1, 0x00004652, 0x00000920,
  0x000085f2, 0x000084e5, 0x000083d8, 0x00001100,
  0x0000c4f3, 0x0000c367, 0x0000c1db, 0x000018f0,
  0x001a2b40, 0x0019f681, 0x0019c1c2, 0x00034c20,
  0x0044806b, 0x0043f657, 0x00436c43, 0x0008a170,
  0x000000fe, 0x000000fd, 0x000000fc, 0x00000040,
  0x000008ee, 0x000008dd, 0x000008cc, 0x00000140,
  0x000046f1, 0x00004663, 0x000045d5, 0x00000910,
  0x00008573, 0x00008467, 0x0000835b, 0x000010f0,
  0x0000c474, 0x0000c2e9, 0x0000c15e, 0x000018e0,
  0x001a2ac1, 0x0019f603, 0x0019c145, 0x00034c10,
  0x00447fec, 0x0043f5d9, 0x00436bc6, 0x0008a160,
  0x0083fe6f, 0x0082f45f, 0x0081ea4f, 0x0010a130,
  0x000007f0, 0x000007e1, 0x000007d2, 0x00000120,
  0x000045f3, 0x00004567, 0x000044db, 0x000008f0,
  0x00008475, 0x0000836b, 0x00008261, 0x000010d0,
  0x0000c376, 0x0000c1ed, 0x0000c064, 0x000018c0,
  0x001a29c3, 0x0019f507, 0x0019c04b, 0x00034bf0,
  0x00447eee, 0x0043f4dd, 0x00436acc, 0x0008a140,
  0x0083fd71, 0x0082f363, 0x0081e955, 0x0010a110,
  0x00c37c73, 0x00c1f267, 0x00c0685b, 0x0018a0f0,
  0x00003e03, 0x00003d87, 0x00003d0b, 0x000007f0,
  0x00007c85, 0x00007b8b, 0x00007a91, 0x00000fd0,
  0x0000bb86, 0x0000ba0d, 0x0000b894, 0x000017c0,
  0x001a21d3, 0x0019ed27, 0x0019b87b, 0x00034af0,
  0x004476fe, 0x0043ecfd, 0x004362fc, 0x0008a040,
  0x0083f581, 0x0082eb83, 0x0081e185, 0x0010a010,
  0x00c37483, 0x00c1ea87, 0x00c0608b, 0x00189ff0,
  0x0102f404, 0x0100ea09, 0x00fee00e, 0x00209fe0,
  0x00003e82, 0x00003e05, 0x00003d88, 0x00000800,
  0x00007d83, 0x00007c87, 0x00007b8b, 0x00000ff0,
  0x0019e3d0, 0x0019afa1, 0x00197b72, 0x00034320,
  0x004438fb, 0x0043af77, 0x004325f3, 0x00089870,
  0x0083b77e, 0x0082adfd, 0x0081a47c, 0x00109840,
  0x00c33680, 0x00c1ad01, 0x00c02382, 0x00189820,
  0x0102b601, 0x0100ac83, 0x00fea305, 0x00209810,
  0x00c33601, 0x00c1ac83, 0x00c02305, 0x00189810,
  0x00003f01, 0x00003e83, 0x00003e05, 0x00000810,
  0x0019a54e, 0x0019719d, 0x00193dec, 0x00033b40,
  0x0043fa79, 0x00437173, 0x0042e86d, 0x00089090,
  0x008378fc, 0x00826ff9, 0x008166f6, 0x00109060,
  0x00c2f7fe, 0x00c16efd, 0x00bfe5fc, 0x00189040,
  0x0102777f, 0x01006e7f, 0x00fe657f, 0x00209030,
  0x00c2f77f, 0x00c16e7f, 0x00bfe57f, 0x00189030,
  0x008377fe, 0x00826efd, 0x008165fc, 0x00109040,
  0x0019664d, 0x0019331b, 0x0018ffe9, 0x00033350,
  0x0043bb78, 0x004332f1, 0x0042aa6a, 0x000888a0,
  0x008339fb, 0x00823177, 0x008128f3, 0x00108870,
  0x00c2b8fd, 0x00c1307b, 0x00bfa7f9, 0x00188850,
  0x0102387e, 0x01002ffd, 0x00fe277c, 0x00208840,
  0x00c2b87e, 0x00c12ffd, 0x00bfa77c, 0x00188840,
  0x008338fd, 0x0082307b, 0x008127f9, 0x00108850,
  0x0058e353, 0x00583027, 0x00577cfb, 0x000b32f0,
  0x002a552b, 0x0029ffd7, 0x0029aa83, 0x00055570,
  0x0069d3ae, 0x0068fe5d, 0x0068290c, 0x000d5540,
  0x00a952b0, 0x00a7fd61, 0x00a6a812, 0x00155520,
  0x00e8d231, 0x00e6fce3, 0x00e52795, 0x001d5510,
  0x00a95231, 0x00a7fce3, 0x00a6a795, 0x00155510,
  0x0069d2b0, 0x0068fd61, 0x00682812, 0x000d5520,
  0x003f7d06, 0x003efd0d, 0x003e7d14, 0x0007ffc0,
  0x0026163a, 0x0025c975, 0x00257cb0, 0x0004cc80,
  0x003f7e83, 0x003efe87, 0x003e7e8b, 0x0007fff0,
  0x007efd85, 0x007dfd8b, 0x007cfd91, 0x000fffd0,
  0x00be7d06, 0x00bcfd0d, 0x00bb7d14, 0x0017ffc0,
  0x007efd06, 0x007dfd0d, 0x007cfd14, 0x000fffc0,
  0x003f7d85, 0x003efd8b, 0x003e7d91, 0x0007ffd0,
  0x001527db, 0x0014fd37, 0x0014d293, 0x0002aa70,
  0xfffbc10f, 0xfffbc99f, 0xfffbd22f, 0xffff7730,
  0xfffb818f, 0xfffb8a9f, 0xfffb93af, 0xffff6f30,
  0x003f7f02, 0x003eff05, 0x003e7f08, 0x00080000,
  0x007efe83, 0x007dfe87, 0x007cfe8b, 0x000ffff0,
  0x003f7e83, 0x003efe87, 0x003e7e8b, 0x0007fff0,
  0xffffff02, 0xffffff05, 0xffffff08, 0x00000000,
  0xffd5a958, 0xffd5feb1, 0xffd6540a, 0xfffaaaa0,
  0xffbc428c, 0xffbccb19, 0xffbd53a6, 0xfff77760,
  0xffbc030c, 0xffbc8c19, 0xffbd1526, 0xfff76f60,
  0xffbbc40b, 0xffbc4d97, 0xffbcd723, 0xfff76770,
  0x003f7f81, 0x003eff83, 0x003e7f85, 0x00080010,
  0xffffff81, 0xffffff83, 0xffffff85, 0x00000010,
  0xffc08000, 0xffc10001, 0xffc18002, 0xfff80020,
  0xff962a56, 0xff96ffad, 0xff97d504, 0xfff2aac0,
  0xff7cc38a, 0xff7dcc15, 0xff7ed4a0, 0xffef7780,
  0xff7c840a, 0xff7d8d15, 0xff7e9620, 0xffef6f80,
  0xff7c4509, 0xff7d4e93, 0xff7e581d, 0xffef6790,
  0xff7c0687, 0xff7d108f, 0xff7e1a97, 0xffef5fb0,
  0xffc08000, 0xffc10001, 0xffc18002, 0xfff80020,
  0xff81007f, 0xff82007f, 0xff83007f, 0xfff00030,
  0xff56aad5, 0xff58002b, 0xff595581, 0xffeaaad0,
  0xff3d4409, 0xff3ecc93, 0xff40551d, 0xffe77790,
  0xff3d0489, 0xff3e8d93, 0xff40169d, 0xffe76f90,
  0xff3cc588, 0xff3e4f11, 0xff3fd89a, 0xffe767a0,
  0xff3c8706, 0xff3e110d, 0xff3f9b14, 0xffe75fc0,
  0xff3c4903, 0xff3dd387, 0xff3f5e0b, 0xffe757f0,
  0xffc0807f, 0xffc1007f, 0xffc1807f, 0xfff80030,
  0xff962ad5, 0xff97002b, 0xff97d581, 0xfff2aad0,
  0xff7cc409, 0xff7dcc93, 0xff7ed51d, 0xffef7790,
  0xff7c8489, 0xff7d8d93, 0xff7e969d, 0xffef6f90,
  0xff7c4588, 0xff7d4f11, 0xff7e589a, 0xffef67a0,
  0xff7c0706, 0xff7d110d, 0xff7e1b14, 0xffef5fc0,
  0xff7bc903, 0xff7cd387, 0xff7dde0b, 0xffef57f0,
  0xff7bc113, 0xff7ccba7, 0xff7dd63b, 0xffef56f0,
  0xffd5aa56, 0xffd5ffad, 0xffd65504, 0xfffaaac0,
  0xffbc438a, 0xffbccc15, 0xffbd54a0, 0xfff77780,
  0xffbc040a, 0xffbc8d15, 0xffbd1620, 0xfff76f80,
  0xffbbc509, 0xffbc4e93, 0xffbcd81d, 0xfff76790,
  0xffbb8687, 0xffbc108f, 0xffbc9a97, 0xfff75fb0,
  0xffbb4884, 0xffbbd309, 0xffbc5d8e, 0xfff757e0,
  0xffbb4094, 0xffbbcb29, 0xffbc55be, 0xfff756e0,
  0xffbb3f17, 0xffbbc9af, 0xffbc5447, 0xfff756b0,
  0xffe69934, 0xffe6cc69, 0xffe6ff9e, 0xfffccce0,
  0xffe659b4, 0xffe68d69, 0xffe6c11e, 0xfffcc4e0,
  0xffe61ab3, 0xffe64ee7, 0xffe6831b, 0xfffcbcf0,
  0xffe5dc31, 0xffe610e3, 0xffe64595, 0xfffcb510,
  0xffe59e2e, 0xffe5d35d, 0xffe6088c, 0xfffcad40,
  0xffe5963e, 0xffe5cb7d, 0xffe600bc, 0xfffcac40,
  0xffe594c1, 0xffe5ca03, 0xffe5ff45, 0xfffcac10,
  0xffe593c3, 0xffe5c907, 0xffe5fe4b, 0xfffcabf0,
  0xffffc080, 0xffffc101, 0xffffc182, 0xfffff820,
  0xffff817f, 0xffff827f, 0xffff837f, 0xfffff030,
  0xffff42fd, 0xffff447b, 0xffff45f9, 0xffffe850,
  0xffff04fa, 0xffff06f5, 0xffff08f0, 0xffffe080,
  0xfffefd0a, 0xfffeff15, 0xffff0120, 0xffffdf80,
  0xfffefb8d, 0xfffefd9b, 0xfffeffa9, 0xffffdf50,
  0xfffefa8f, 0xfffefc9f, 0xfffefeaf, 0xffffdf30,
  0xfffefa10, 0xfffefc21, 0xfffefe32, 0xffffdf20,
  0xffffc17e, 0xffffc1fe, 0xfffff812, 0xfffffea3,
  0xffff837a, 0xffff8478, 0xfffff032, 0xfffffd29,
  0xffff45f4, 0xffff476f, 0xffffe862, 0xfffffbb2,
  0xffff3e14, 0xffff3f9f, 0xffffe762, 0xfffffb82,
  0xffff3c9a, 0xffff3e28, 0xffffe732, 0xfffffb79,
  0xffff3b9e, 0xffff3d2e, 0xffffe712, 0xfffffb73,
  0xffff3b20, 0xffff3cb1, 0xffffe702, 0xfffffb70,
  0xffff3b20, 0xffff3cb1, 0xffffe702, 0xfffffb70,
  0xffffc1fc, 0xffffc27b, 0xfffff822, 0xfffffea6,
  0xffff8476, 0xffff8572, 0xfffff052, 0xfffffd2f,
  0xffff7c96, 0xffff7da2, 0xffffef52, 0xfffffcff,
  0xffff7b1c, 0xffff7c2b, 0xffffef22, 0xfffffcf6,
  0xffff7a20, 0xffff7b31, 0xffffef02, 0xfffffcf0,
  0xffff79a2, 0xffff7ab4, 0xffffeef2, 0xfffffced,
  0xffff79a2, 0xffff7ab4, 0xffffeef2, 0xfffffced,
  0xffff7a20, 0xffff7b31, 0xffffef02, 0xfffffcf0,
  0xffffc27a, 0xffffc2f8, 0xfffff832, 0xfffffea9,
  0xffffba9a, 0xffffbb28, 0xfffff732, 0xfffffe79,
  0xffffb920, 0xffffb9b1, 0xfffff702, 0xfffffe70,
  0xffffb824, 0xffffb8b7, 0xfffff6e2, 0xfffffe6a,
  0xffffb7a6, 0xffffb83a, 0xfffff6d2, 0xfffffe67,
  0xffffb7a6, 0xffffb83a, 0xfffff6d2, 0xfffffe67,
  0xffffb824, 0xffffb8b7, 0xfffff6e2, 0xfffffe6a,
  0xffffb920, 0xffffb9b1, 0xfffff702, 0xfffffe70,
  0xfffff820, 0xfffff831, 0xffffff02, 0xfffffff0,
  0xfffff6a6, 0xfffff6ba, 0xfffffed2, 0xffffffe7,
  0xfffff5aa, 0xfffff5c0, 0xfffffeb2, 0xffffffe1,
  0xfffff52c, 0xfffff543, 0xfffffea2, 0xffffffde,
  0xfffff52c, 0xfffff543, 0xfffffea2, 0xffffffde,
  0xfffff5aa, 0xfffff5c0, 0xfffffeb2, 0xffffffe1,
  0xfffff6a6, 0xfffff6ba, 0xfffffed2, 0xffffffe7,
  0xfffffe86, 0xfffffe8a, 0xffffffd2, 0x00000017,
  0xfffffe86, 0xfffffe8a, 0xffffffd2, 0x00000017,
  0xfffffd8a, 0xfffffd90, 0xffffffb2, 0x00000011,
  0xfffffd0c, 0xfffffd13, 0xffffffa2, 0x0000000e,
  0xfffffd0c, 0xfffffd13, 0xffffffa2, 0x0000000e,
  0xfffffd8a, 0xfffffd90, 0xffffffb2, 0x00000011,
  0xfffffe86, 0xfffffe8a, 0xffffffd2, 0x00000017,
  0x00000666, 0x0000065a, 0x000000d2, 0x00000047,
  0x000043ec, 0x00004363, 0x000008a2, 0x000001be,
  0xffffff04, 0xffffff07, 0xffffffe2, 0x0000001a,
  0xfffffe86, 0xfffffe8a, 0xffffffd2, 0x00000017,
  0xfffffe86, 0xfffffe8a, 0xffffffd2, 0x00000017,
  0xffffff04, 0xffffff07, 0xffffffe2, 0x0000001a,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x000007e0, 0x000007d1, 0x00000102, 0x00000050,
  0x00004566, 0x000044da, 0x000008d2, 0x000001c7,
  0x0000836a, 0x00008260, 0x000010b2, 0x00000341,
  0xffffff82, 0xffffff84, 0xfffffff2, 0x0000001d,
  0xffffff82, 0xffffff84, 0xfffffff2, 0x0000001d,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x000000fc, 0x000000fb, 0x00000022, 0x00000026,
  0x000008dc, 0x000008cb, 0x00000122, 0x00000056,
  0x00004662, 0x000045d4, 0x000008f2, 0x000001cd,
  0x00008466, 0x0000835a, 0x000010d2, 0x00000347,
  0x0000c2e8, 0x0000c15d, 0x000018c2, 0x000004c4,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x0000007e, 0x0000007e, 0x00000012, 0x00000023,
  0x0000017a, 0x00000178, 0x00000032, 0x00000029,
  0x0000095a, 0x00000948, 0x00000132, 0x00000059,
  0x000046e0, 0x00004651, 0x00000902, 0x000001d0,
  0x000084e4, 0x000083d7, 0x000010e2, 0x0000034a,
  0x0000c366, 0x0000c1da, 0x000018d2, 0x000004c7,
  0x0019f680, 0x0019c1c1, 0x00034c02, 0x00009e60,
  0x0000007e, 0x0000007e, 0x00000012, 0x00000023,
  0x0000017a, 0x00000178, 0x00000032, 0x00000029,
  0x0000095a, 0x00000948, 0x00000132, 0x00000059,
  0x000046e0, 0x00004651, 0x00000902, 0x000001d0,
  0x000084e4, 0x000083d7, 0x000010e2, 0x0000034a,
  0x0000c366, 0x0000c1da, 0x000018d2, 0x000004c7,
  0x0019f680, 0x0019c1c1, 0x00034c02, 0x00009e60,
  0x0043f656, 0x00436c42, 0x0008a152, 0x00019e5f,
  0x000000fc, 0x000000fb, 0x00000022, 0x00000026,
  0x000008dc, 0x000008cb, 0x00000122, 0x00000056,
  0x00004662, 0x000045d4, 0x000008f2, 0x000001cd,
  0x00008466, 0x0000835a, 0x000010d2, 0x00000347,
  0x0000c2e8, 0x0000c15d, 0x000018c2, 0x000004c4,
  0x0019f602, 0x0019c144, 0x00034bf2, 0x00009e5d,
  0x0043f5d8, 0x00436bc5, 0x0008a142, 0x00019e5c,
  0x0082f45e, 0x0081ea4e, 0x0010a112, 0x00031e53,
  0x000007e0, 0x000007d1, 0x00000102, 0x00000050,
  0x00004566, 0x000044da, 0x000008d2, 0x000001c7,
  0x0000836a, 0x00008260, 0x000010b2, 0x00000341,
  0x0000c1ec, 0x0000c063, 0x000018a2, 0x000004be,
  0x0019f506, 0x0019c04a, 0x00034bd2, 0x00009e57,
  0x0043f4dc, 0x00436acb, 0x0008a122, 0x00019e56,
  0x0082f362, 0x0081e954, 0x0010a0f2, 0x00031e4d,
  0x00c1f266, 0x00c0685a, 0x0018a0d2, 0x00049e47,
  0x00003d86, 0x00003d0a, 0x000007d2, 0x00000197,
  0x00007b8a, 0x00007a90, 0x00000fb2, 0x00000311,
  0x0000ba0c, 0x0000b893, 0x000017a2, 0x0000048e,
  0x0019ed26, 0x0019b87a, 0x00034ad2, 0x00009e27,
  0x0043ecfc, 0x004362fb, 0x0008a022, 0x00019e26,
  0x0082eb82, 0x0081e184, 0x00109ff2, 0x00031e1d,
  0x00c1ea86, 0x00c0608a, 0x00189fd2, 0x00049e17,
  0x0100ea08, 0x00fee00d, 0x00209fc2, 0x00061e14,
  0x00003e04, 0x00003d87, 0x000007e2, 0x0000019a,
  0x00007c86, 0x00007b8a, 0x00000fd2, 0x00000317,
  0x0019afa0, 0x00197b71, 0x00034302, 0x00009cb0,
  0x0043af76, 0x004325f2, 0x00089852, 0x00019caf,
  0x0082adfc, 0x0081a47b, 0x00109822, 0x00031ca6,
  0x00c1ad00, 0x00c02381, 0x00189802, 0x00049ca0,
  0x0100ac82, 0x00fea304, 0x002097f2, 0x00061c9d,
  0x00c1ac82, 0x00c02304, 0x001897f2, 0x00049c9d,
  0x00003e82, 0x00003e04, 0x000007f2, 0x0000019d,
  0x0019719c, 0x00193deb, 0x00033b22, 0x00009b36,
  0x00437172, 0x0042e86c, 0x00089072, 0x00019b35,
  0x00826ff8, 0x008166f5, 0x00109042, 0x00031b2c,
  0x00c16efc, 0x00bfe5fb, 0x00189022, 0x00049b26,
  0x01006e7e, 0x00fe657e, 0x00209012, 0x00061b23,
  0x00c16e7e, 0x00bfe57e, 0x00189012, 0x00049b23,
  0x00826efc, 0x008165fb, 0x00109022, 0x00031b26,
  0x0019331a, 0x0018ffe8, 0x00033332, 0x000099b9,
  0x004332f0, 0x0042aa69, 0x00088882, 0x000199b8,
  0x00823176, 0x008128f2, 0x00108852, 0x000319af,
  0x00c1307a, 0x00bfa7f8, 0x00188832, 0x000499a9,
  0x01002ffc, 0x00fe277b, 0x00208822, 0x000619a6,
  0x00c12ffc, 0x00bfa77b, 0x00188822, 0x000499a6,
  0x0082307a, 0x008127f8, 0x00108832, 0x000319a9,
  0x00583026, 0x00577cfa, 0x000b32d2, 0x000219a7,
  0x0029ffd6, 0x0029aa82, 0x00055552, 0x0001001f,
  0x0068fe5c, 0x0068290b, 0x000d5522, 0x00028016,
  0x00a7fd60, 0x00a6a811, 0x00155502, 0x00040010,
  0x00e6fce2, 0x00e52794, 0x001d54f2, 0x0005800d,
  0x00a7fce2, 0x00a6a794, 0x001554f2, 0x0004000d,
  0x0068fd60, 0x00682811, 0x000d5502, 0x00028010,
  0x003efd0c, 0x003e7d13, 0x0007ffa2, 0x0001800e,
  0x0025c974, 0x00257caf, 0x0004cc62, 0x0000e672,
  0x003efe86, 0x003e7e8a, 0x0007ffd2, 0x00018017,
  0x007dfd8a, 0x007cfd90, 0x000fffb2, 0x00030011,
  0x00bcfd0c, 0x00bb7d13, 0x0017ffa2, 0x0004800e,
  0x007dfd0c, 0x007cfd13, 0x000fffa2, 0x0003000e,
  0x003efd8a, 0x003e7d90, 0x0007ffb2, 0x00018011,
  0x0014fd36, 0x0014d292, 0x0002aa52, 0x0000800f,
  0xfffbc99e, 0xfffbd22e, 0xffff7712, 0xffffe673,
  0xfffb8a9e, 0xfffb93ae, 0xffff6f12, 0xffffe4f3,
  0x003eff04, 0x003e7f07, 0x0007ffe2, 0x0001801a,
  0x007dfe86, 0x007cfe8a, 0x000fffd2, 0x00030017,
  0x003efe86, 0x003e7e8a, 0x0007ffd2, 0x00018017,
  0xffffff04, 0xffffff07, 0xffffffe2, 0x0000001a,
  0xffd5feb0, 0xffd65409, 0xfffaaa82, 0xffff0018,
  0xffbccb18, 0xffbd53a5, 0xfff77742, 0xfffe667c,
  0xffbc8c18, 0xffbd1525, 0xfff76f42, 0xfffe64fc,
  0xffbc4d96, 0xffbcd722, 0xfff76752, 0xfffe637f,
  0x003eff82, 0x003e7f84, 0x0007fff2, 0x0001801d,
  0xffffff82, 0xffffff84, 0xfffffff2, 0x0000001d,
  0xffc10000, 0xffc18001, 0xfff80002, 0xfffe8020,
  0xff96ffac, 0xff97d503, 0xfff2aaa2, 0xfffd801e,
  0xff7dcc14, 0xff7ed49f, 0xffef7762, 0xfffce682,
  0xff7d8d14, 0xff7e961f, 0xffef6f62, 0xfffce502,
  0xff7d4e92, 0xff7e581c, 0xffef6772, 0xfffce385,
  0xff7d108e, 0xff7e1a96, 0xffef5f92, 0xfffce20b,
  0xffc10000, 0xffc18001, 0xfff80002, 0xfffe8020,
  0xff82007e, 0xff83007e, 0xfff00012, 0xfffd0023,
  0xff58002a, 0xff595580, 0xffeaaab2, 0xfffc0021,
  0xff3ecc92, 0xff40551c, 0xffe77772, 0xfffb6685,
  0xff3e8d92, 0xff40169c, 0xffe76f72, 0xfffb6505,
  0xff3e4f10, 0xff3fd899, 0xffe76782, 0xfffb6388,
  0xff3e110c, 0xff3f9b13, 0xffe75fa2, 0xfffb620e,
  0xff3dd386, 0xff3f5e0a, 0xffe757d2, 0xfffb6097,
  0xffc1007e, 0xffc1807e, 0xfff80012, 0xfffe8023,
  0xff97002a, 0xff97d580, 0xfff2aab2, 0xfffd8021,
  0xff7dcc92, 0xff7ed51c, 0xffef7772, 0xfffce685,
  0xff7d8d92, 0xff7e969c, 0xffef6f72, 0xfffce505,
  0xff7d4f10, 0xff7e5899, 0xffef6782, 0xfffce388,
  0xff7d110c, 0xff7e1b13, 0xffef5fa2, 0xfffce20e,
  0xff7cd386, 0xff7dde0a, 0xffef57d2, 0xfffce097,
  0xff7ccba6, 0xff7dd63a, 0xffef56d2, 0xfffce067,
  0xffd5ffac, 0xffd65503, 0xfffaaaa2, 0xffff001e,
  0xffbccc14, 0xffbd549f, 0xfff77762, 0xfffe6682,
  0xffbc8d14, 0xffbd161f, 0xfff76f62, 0xfffe6502,
  0xffbc4e92, 0xffbcd81c, 0xfff76772, 0xfffe6385,
  0xffbc108e, 0xffbc9a96, 0xfff75f92, 0xfffe620b,
  0xffbbd308, 0xffbc5d8d, 0xfff757c2, 0xfffe6094,
  0xffbbcb28, 0xffbc55bd, 0xfff756c2, 0xfffe6064,
  0xffbbc9ae, 0xffbc5446, 0xfff75692, 0xfffe605b,
  0xffe6cc68, 0xffe6ff9d, 0xfffcccc2, 0xffff6684,
  0xffe68d68, 0xffe6c11d, 0xfffcc4c2, 0xffff6504,
  0xffe64ee6, 0xffe6831a, 0xfffcbcd2, 0xffff6387,
  0xffe610e2, 0xffe64594, 0xfffcb4f2, 0xffff620d,
  0xffe5d35c, 0xffe6088b, 0xfffcad22, 0xffff6096,
  0xffe5cb7c, 0xffe600bb, 0xfffcac22, 0xffff6066,
  0xffe5ca02, 0xffe5ff44, 0xfffcabf2, 0xffff605d,
  0xffe5c906, 0xffe5fe4a, 0xfffcabd2, 0xffff6057,
  0xffffc100, 0xffffc181, 0xfffff802, 0xfffffea0,
  0xffff827e, 0xffff837e, 0xfffff012, 0xfffffd23,
  0xffff447a, 0xffff45f8, 0xffffe832, 0xfffffba9,
  0xffff06f4, 0xffff08ef, 0xffffe062, 0xfffffa32,
  0xfffeff14, 0xffff011f, 0xffffdf62, 0xfffffa02,
  0xfffefd9a, 0xfffeffa8, 0xffffdf32, 0xfffff9f9,
  0xfffefc9e, 0xfffefeae, 0xffffdf12, 0xfffff9f3,
  0xfffefc20, 0xfffefe31, 0xffffdf02, 0xfffff9f0,
  0xffffc1fd, 0xfffff811, 0xfffffe85, 0xffffff22,
  0xffff8477, 0xfffff031, 0xfffffd0b, 0xfffffe26,
  0xffff476e, 0xffffe861, 0xfffffb94, 0xfffffd2c,
  0xffff3f9e, 0xffffe761, 0xfffffb64, 0xfffffd0c,
  0xffff3e27, 0xffffe731, 0xfffffb5b, 0xfffffd06,
  0xffff3d2d, 0xffffe711, 0xfffffb55, 0xfffffd02,
  0xffff3cb0, 0xffffe701, 0xfffffb52, 0xfffffd00,
  0xffff3cb0, 0xffffe701, 0xfffffb52, 0xfffffd00,
  0xffffc27a, 0xfffff821, 0xfffffe88, 0xffffff24,
  0xffff8571, 0xfffff051, 0xfffffd11, 0xfffffe2a,
  0xffff7da1, 0xffffef51, 0xfffffce1, 0xfffffe0a,
  0xffff7c2a, 0xffffef21, 0xfffffcd8, 0xfffffe04,
  0xffff7b30, 0xffffef01, 0xfffffcd2, 0xfffffe00,
  0xffff7ab3, 0xffffeef1, 0xfffffccf, 0xfffffdfe,
  0xffff7ab3, 0xffffeef1, 0xfffffccf, 0xfffffdfe,
  0xffff7b30, 0xffffef01, 0xfffffcd2, 0xfffffe00,
  0xffffc2f7, 0xfffff831, 0xfffffe8b, 0xffffff26,
  0xffffbb27, 0xfffff731, 0xfffffe5b, 0xffffff06,
  0xffffb9b0, 0xfffff701, 0xfffffe52, 0xffffff00,
  0xffffb8b6, 0xfffff6e1, 0xfffffe4c, 0xfffffefc,
  0xffffb839, 0xfffff6d1, 0xfffffe49, 0xfffffefa,
  0xffffb839, 0xfffff6d1, 0xfffffe49, 0xfffffefa,
  0xffffb8b6, 0xfffff6e1, 0xfffffe4c, 0xfffffefc,
  0xffffb9b0, 0xfffff701, 0xfffffe52, 0xffffff00,
  0xfffff830, 0xffffff01, 0xffffffd2, 0x00000000,
  0xfffff6b9, 0xfffffed1, 0xffffffc9, 0xfffffffa,
  0xfffff5bf, 0xfffffeb1, 0xffffffc3, 0xfffffff6,
  0xfffff542, 0xfffffea1, 0xffffffc0, 0xfffffff4,
  0xfffff542, 0xfffffea1, 0xffffffc0, 0xfffffff4,
  0xfffff5bf, 0xfffffeb1, 0xffffffc3, 0xfffffff6,
  0xfffff6b9, 0xfffffed1, 0xffffffc9, 0xfffffffa,
  0xfffffe89, 0xffffffd1, 0xfffffff9, 0x0000001a,
  0xfffffe89, 0xffffffd1, 0xfffffff9, 0x0000001a,
  0xfffffd8f, 0xffffffb1, 0xfffffff3, 0x00000016,
  0xfffffd12, 0xffffffa1, 0xfffffff0, 0x00000014,
  0xfffffd12, 0xffffffa1, 0xfffffff0, 0x00000014,
  0xfffffd8f, 0xffffffb1, 0xfffffff3, 0x00000016,
  0xfffffe89, 0xffffffd1, 0xfffffff9, 0x0000001a,
  0x00000659, 0x000000d1, 0x00000029, 0x0000003a,
  0x00004362, 0x000008a1, 0x000001a0, 0x00000134,
  0xffffff06, 0xffffffe1, 0xfffffffc, 0x0000001c,
  0xfffffe89, 0xffffffd1, 0xfffffff9, 0x0000001a,
  0xfffffe89, 0xffffffd1, 0xfffffff9, 0x0000001a,
  0xffffff06, 0xffffffe1, 0xfffffffc, 0x0000001c,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x000007d0, 0x00000101, 0x00000032, 0x00000040,
  0x000044d9, 0x000008d1, 0x000001a9, 0x0000013a,
  0x0000825f, 0x000010b1, 0x00000323, 0x00000236,
  0xffffff83, 0xfffffff1, 0xffffffff, 0x0000001e,
  0xffffff83, 0xfffffff1, 0xffffffff, 0x0000001e,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x000000fa, 0x00000021, 0x00000008, 0x00000024,
  0x000008ca, 0x00000121, 0x00000038, 0x00000044,
  0x000045d3, 0x000008f1, 0x000001af, 0x0000013e,
  0x00008359, 0x000010d1, 0x00000329, 0x0000023a,
  0x0000c15c, 0x000018c1, 0x000004a6, 0x00000338,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x0000007d, 0x00000011, 0x00000005, 0x00000022,
  0x00000177, 0x00000031, 0x0000000b, 0x00000026,
  0x00000947, 0x00000131, 0x0000003b, 0x00000046,
  0x00004650, 0x00000901, 0x000001b2, 0x00000140,
  0x000083d6, 0x000010e1, 0x0000032c, 0x0000023c,
  0x0000c1d9, 0x000018d1, 0x000004a9, 0x0000033a,
  0x0019c1c0, 0x00034c01, 0x00009e42, 0x000069a0,
  0x0000007d, 0x00000011, 0x00000005, 0x00000022,
  0x00000177, 0x00000031, 0x0000000b, 0x00000026,
  0x00000947, 0x00000131, 0x0000003b, 0x00000046,
  0x00004650, 0x00000901, 0x000001b2, 0x00000140,
  0x000083d6, 0x000010e1, 0x0000032c, 0x0000023c,
  0x0000c1d9, 0x000018d1, 0x000004a9, 0x0000033a,
  0x0019c1c0, 0x00034c01, 0x00009e42, 0x000069a0,
  0x00436c41, 0x0008a151, 0x00019e41, 0x0001144a,
  0x000000fa, 0x00000021, 0x00000008, 0x00000024,
  0x000008ca, 0x00000121, 0x00000038, 0x00000044,
  0x000045d3, 0x000008f1, 0x000001af, 0x0000013e,
  0x00008359, 0x000010d1, 0x00000329, 0x0000023a,
  0x0000c15c, 0x000018c1, 0x000004a6, 0x00000338,
  0x0019c143, 0x00034bf1, 0x00009e3f, 0x0000699e,
  0x00436bc4, 0x0008a141, 0x00019e3e, 0x00011448,
  0x0081ea4d, 0x0010a111, 0x00031e35, 0x00021442,
  0x000007d0, 0x00000101, 0x00000032, 0x00000040,
  0x000044d9, 0x000008d1, 0x000001a9, 0x0000013a,
  0x0000825f, 0x000010b1, 0x00000323, 0x00000236,
  0x0000c062, 0x000018a1, 0x000004a0, 0x00000334,
  0x0019c049, 0x00034bd1, 0x00009e39, 0x0000699a,
  0x00436aca, 0x0008a121, 0x00019e38, 0x00011444,
  0x0081e953, 0x0010a0f1, 0x00031e2f, 0x0002143e,
  0x00c06859, 0x0018a0d1, 0x00049e29, 0x0003143a,
  0x00003d09, 0x000007d1, 0x00000179, 0x0000011a,
  0x00007a8f, 0x00000fb1, 0x000002f3, 0x00000216,
  0x0000b892, 0x000017a1, 0x00000470, 0x00000314,
  0x0019b879, 0x00034ad1, 0x00009e09, 0x0000697a,
  0x004362fa, 0x0008a021, 0x00019e08, 0x00011424,
  0x0081e183, 0x00109ff1, 0x00031dff, 0x0002141e,
  0x00c06089, 0x00189fd1, 0x00049df9, 0x0003141a,
  0x00fee00c, 0x00209fc1, 0x00061df6, 0x00041418,
  0x00003d86, 0x000007e1, 0x0000017c, 0x0000011c,
  0x00007b89, 0x00000fd1, 0x000002f9, 0x0000021a,
  0x00197b70, 0x00034301, 0x00009c92, 0x00006880,
  0x004325f1, 0x00089851, 0x00019c91, 0x0001132a,
  0x0081a47a, 0x00109821, 0x00031c88, 0x00021324,
  0x00c02380, 0x00189801, 0x00049c82, 0x00031320,
  0x00fea303, 0x002097f1, 0x00061c7f, 0x0004131e,
  0x00c02303, 0x001897f1, 0x00049c7f, 0x0003131e,
  0x00003e03, 0x000007f1, 0x0000017f, 0x0000011e,
  0x00193dea, 0x00033b21, 0x00009b18, 0x00006784,
  0x0042e86b, 0x00089071, 0x00019b17, 0x0001122e,
  0x008166f4, 0x00109041, 0x00031b0e, 0x00021228,
  0x00bfe5fa, 0x00189021, 0x00049b08, 0x00031224,
  0x00fe657d, 0x00209011, 0x00061b05, 0x00041222,
  0x00bfe57d, 0x00189011, 0x00049b05, 0x00031222,
  0x008165fa, 0x00109021, 0x00031b08, 0x00021224,
  0x0018ffe7, 0x00033331, 0x0000999b, 0x00006686,
  0x0042aa68, 0x00088881, 0x0001999a, 0x00011130,
  0x008128f1, 0x00108851, 0x00031991, 0x0002112a,
  0x00bfa7f7, 0x00188831, 0x0004998b, 0x00031126,
  0x00fe277a, 0x00208821, 0x00061988, 0x00041124,
  0x00bfa77a, 0x00188821, 0x00049988, 0x00031124,
  0x008127f7, 0x00108831, 0x0003198b, 0x00021126,
  0x00577cf9, 0x000b32d1, 0x00021989, 0x0001667a,
  0x0029aa81, 0x00055551, 0x00010001, 0x0000aaca,
  0x0068290a, 0x000d5521, 0x00027ff8, 0x0001aac4,
  0x00a6a810, 0x00155501, 0x0003fff2, 0x0002aac0,
  0x00e52793, 0x001d54f1, 0x00057fef, 0x0003aabe,
  0x00a6a793, 0x001554f1, 0x0003ffef, 0x0002aabe,
  0x00682810, 0x000d5501, 0x00027ff2, 0x0001aac0,
  0x003e7d12, 0x0007ffa1, 0x00017ff0, 0x00010014,
  0x00257cae, 0x0004cc61, 0x0000e654, 0x000099ac,
  0x003e7e89, 0x0007ffd1, 0x00017ff9, 0x0001001a,
  0x007cfd8f, 0x000fffb1, 0x0002fff3, 0x00020016,
  0x00bb7d12, 0x0017ffa1, 0x00047ff0, 0x00030014,
  0x007cfd12, 0x000fffa1, 0x0002fff0, 0x00020014,
  0x003e7d8f, 0x0007ffb1, 0x00017ff3, 0x00010016,
  0x0014d291, 0x0002aa51, 0x00007ff1, 0x0000556a,
  0xfffbd22d, 0xffff7711, 0xffffe655, 0xffffef02,
  0xfffb93ad, 0xffff6f11, 0xffffe4d5, 0xffffee02,
  0x003e7f06, 0x0007ffe1, 0x00017ffc, 0x0001001c,
  0x007cfe89, 0x000fffd1, 0x0002fff9, 0x0002001a,
  0x003e7e89, 0x0007ffd1, 0x00017ff9, 0x0001001a,
  0xffffff06, 0xffffffe1, 0xfffffffc, 0x0000001c,
  0xffd65408, 0xfffaaa81, 0xfffefffa, 0xffff5570,
  0xffbd53a4, 0xfff77741, 0xfffe665e, 0xfffeef08,
  0xffbd1524, 0xfff76f41, 0xfffe64de, 0xfffeee08,
  0xffbcd721, 0xfff76751, 0xfffe6361, 0xfffeed0a,
  0x003e7f83, 0x0007fff1, 0x00017fff, 0x0001001e,
  0xffffff83, 0xfffffff1, 0xffffffff, 0x0000001e,
  0xffc18000, 0xfff80001, 0xfffe8002, 0xffff0020,
  0xff97d502, 0xfff2aaa1, 0xfffd8000, 0xfffe5574,
  0xff7ed49e, 0xffef7761, 0xfffce664, 0xfffdef0c,
  0xff7e961e, 0xffef6f61, 0xfffce4e4, 0xfffdee0c,
  0xff7e581b, 0xffef6771, 0xfffce367, 0xfffded0e,
  0xff7e1a95, 0xffef5f91, 0xfffce1ed, 0xfffdec12,
  0xffc18000, 0xfff80001, 0xfffe8002, 0xffff0020,
  0xff83007d, 0xfff00011, 0xfffd0005, 0xfffe0022,
  0xff59557f, 0xffeaaab1, 0xfffc0003, 0xfffd5576,
  0xff40551b, 0xffe77771, 0xfffb6667, 0xfffcef0e,
  0xff40169b, 0xffe76f71, 0xfffb64e7, 0xfffcee0e,
  0xff3fd898, 0xffe76781, 0xfffb636a, 0xfffced10,
  0xff3f9b12, 0xffe75fa1, 0xfffb61f0, 0xfffcec14,
  0xff3f5e09, 0xffe757d1, 0xfffb6079, 0xfffceb1a,
  0xffc1807d, 0xfff80011, 0xfffe8005, 0xffff0022,
  0xff97d57f, 0xfff2aab1, 0xfffd8003, 0xfffe5576,
  0xff7ed51b, 0xffef7771, 0xfffce667, 0xfffdef0e,
  0xff7e969b, 0xffef6f71, 0xfffce4e7, 0xfffdee0e,
  0xff7e5898, 0xffef6781, 0xfffce36a, 0xfffded10,
  0xff7e1b12, 0xffef5fa1, 0xfffce1f0, 0xfffdec14,
  0xff7dde09, 0xffef57d1, 0xfffce079, 0xfffdeb1a,
  0xff7dd639, 0xffef56d1, 0xfffce049, 0xfffdeafa,
  0xffd65502, 0xfffaaaa1, 0xffff0000, 0xffff5574,
  0xffbd549e, 0xfff77761, 0xfffe6664, 0xfffeef0c,
  0xffbd161e, 0xfff76f61, 0xfffe64e4, 0xfffeee0c,
  0xffbcd81b, 0xfff76771, 0xfffe6367, 0xfffeed0e,
  0xffbc9a95, 0xfff75f91, 0xfffe61ed, 0xfffeec12,
  0xffbc5d8c, 0xfff757c1, 0xfffe6076, 0xfffeeb18,
  0xffbc55bc, 0xfff756c1, 0xfffe6046, 0xfffeeaf8,
  0xffbc5445, 0xfff75691, 0xfffe603d, 0xfffeeaf2,
  0xffe6ff9c, 0xfffcccc1, 0xffff6666, 0xffff99b8,
  0xffe6c11c, 0xfffcc4c1, 0xffff64e6, 0xffff98b8,
  0xffe68319, 0xfffcbcd1, 0xffff6369, 0xffff97ba,
  0xffe64593, 0xfffcb4f1, 0xffff61ef, 0xffff96be,
  0xffe6088a, 0xfffcad21, 0xffff6078, 0xffff95c4,
  0xffe600ba, 0xfffcac21, 0xffff6048, 0xffff95a4,
  0xffe5ff43, 0xfffcabf1, 0xffff603f, 0xffff959e,
  0xffe5fe49, 0xfffcabd1, 0xffff6039, 0xffff959a,
  0xffffc180, 0xfffff801, 0xfffffe82, 0xffffff20,
  0xffff837d, 0xfffff011, 0xfffffd05, 0xfffffe22,
  0xffff45f7, 0xffffe831, 0xfffffb8b, 0xfffffd26,
  0xffff08ee, 0xffffe061, 0xfffffa14, 0xfffffc2c,
  0xffff011e, 0xffffdf61, 0xfffff9e4, 0xfffffc0c,
  0xfffeffa7, 0xffffdf31, 0xfffff9db, 0xfffffc06,
  0xfffefead, 0xffffdf11, 0xfffff9d5, 0xfffffc02,
  0xfffefe30, 0xffffdf01, 0xfffff9d2, 0xfffffc00,
  0xfffff810, 0xfffffe84, 0xffffff04, 0xffffffa1,
  0xfffff030, 0xfffffd0a, 0xfffffe08, 0xffffff23,
  0xffffe860, 0xfffffb93, 0xfffffd0e, 0xfffffea6,
  0xffffe760, 0xfffffb63, 0xfffffcee, 0xfffffe96,
  0xffffe730, 0xfffffb5a, 0xfffffce8, 0xfffffe93,
  0xffffe710, 0xfffffb54, 0xfffffce4, 0xfffffe91,
  0xffffe700, 0xfffffb51, 0xfffffce2, 0xfffffe90,
  0xffffe700, 0xfffffb51, 0xfffffce2, 0xfffffe90,
  0xfffff820, 0xfffffe87, 0xffffff06, 0xffffffa2,
  0xfffff050, 0xfffffd10, 0xfffffe0c, 0xffffff25,
  0xffffef50, 0xfffffce0, 0xfffffdec, 0xffffff15,
  0xffffef20, 0xfffffcd7, 0xfffffde6, 0xffffff12,
  0xffffef00, 0xfffffcd1, 0xfffffde2, 0xffffff10,
  0xffffeef0, 0xfffffcce, 0xfffffde0, 0xffffff0f,
  0xffffeef0, 0xfffffcce, 0xfffffde0, 0xffffff0f,
  0xffffef00, 0xfffffcd1, 0xfffffde2, 0xffffff10,
  0xfffff830, 0xfffffe8a, 0xffffff08, 0xffffffa3,
  0xfffff730, 0xfffffe5a, 0xfffffee8, 0xffffff93,
  0xfffff700, 0xfffffe51, 0xfffffee2, 0xffffff90,
  0xfffff6e0, 0xfffffe4b, 0xfffffede, 0xffffff8e,
  0xfffff6d0, 0xfffffe48, 0xfffffedc, 0xffffff8d,
  0xfffff6d0, 0xfffffe48, 0xfffffedc, 0xffffff8d,
  0xfffff6e0, 0xfffffe4b, 0xfffffede, 0xffffff8e,
  0xfffff700, 0xfffffe51, 0xfffffee2, 0xffffff90,
  0xffffff00, 0xffffffd1, 0xffffffe2, 0x00000010,
  0xfffffed0, 0xffffffc8, 0xffffffdc, 0x0000000d,
  0xfffffeb0, 0xffffffc2, 0xffffffd8, 0x0000000b,
  0xfffffea0, 0xffffffbf, 0xffffffd6, 0x0000000a,
  0xfffffea0, 0xffffffbf, 0xffffffd6, 0x0000000a,
  0xfffffeb0, 0xffffffc2, 0xffffffd8, 0x0000000b,
  0xfffffed0, 0xffffffc8, 0xffffffdc, 0x0000000d,
  0xffffffd0, 0xfffffff8, 0xfffffffc, 0x0000001d,
  0xffffffd0, 0xfffffff8, 0xfffffffc, 0x0000001d,
  0xffffffb0, 0xfffffff2, 0xfffffff8, 0x0000001b,
  0xffffffa0, 0xffffffef, 0xfffffff6, 0x0000001a,
  0xffffffa0, 0xffffffef, 0xfffffff6, 0x0000001a,
  0xffffffb0, 0xfffffff2, 0xfffffff8, 0x0000001b,
  0xffffffd0, 0xfffffff8, 0xfffffffc, 0x0000001d,
  0x000000d0, 0x00000028, 0x0000001c, 0x0000002d,
  0x000008a0, 0x0000019f, 0x00000116, 0x000000aa,
  0xffffffe0, 0xfffffffb, 0xfffffffe, 0x0000001e,
  0xffffffd0, 0xfffffff8, 0xfffffffc, 0x0000001d,
  0xffffffd0, 0xfffffff8, 0xfffffffc, 0x0000001d,
  0xffffffe0, 0xfffffffb, 0xfffffffe, 0x0000001e,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000100, 0x00000031, 0x00000022, 0x00000030,
  0x000008d0, 0x000001a8, 0x0000011c, 0x000000ad,
  0x000010b0, 0x00000322, 0x00000218, 0x0000012b,
  0xfffffff0, 0xfffffffe, 0x00000000, 0x0000001f,
  0xfffffff0, 0xfffffffe, 0x00000000, 0x0000001f,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000020, 0x00000007, 0x00000006, 0x00000022,
  0x00000120, 0x00000037, 0x00000026, 0x00000032,
  0x000008f0, 0x000001ae, 0x00000120, 0x000000af,
  0x000010d0, 0x00000328, 0x0000021c, 0x0000012d,
  0x000018c0, 0x000004a5, 0x0000031a, 0x000001ac,
  0x00000000, 0x00000001, 0x00000002, 0x00000020,
  0x00000010, 0x00000004, 0x00000004, 0x00000021,
  0x00000030, 0x0000000a, 0x00000008, 0x00000023,
  0x00000130, 0x0000003a, 0x00000028, 0x00000033,
  0x00000900, 0x000001b1, 0x00000122, 0x000000b0,
  0x000010e0, 0x0000032b, 0x0000021e, 0x0000012e,
  0x000018d0, 0x000004a8, 0x0000031c, 0x000001ad,
  0x00034c00, 0x00009e41, 0x00006982, 0x000034e0,
  0x00000010, 0x00000004, 0x00000004, 0x00000021,
  0x00000030, 0x0000000a, 0x00000008, 0x00000023,
  0x00000130, 0x0000003a, 0x00000028, 0x00000033,
  0x00000900, 0x000001b1, 0x00000122, 0x000000b0,
  0x000010e0, 0x0000032b, 0x0000021e, 0x0000012e,
  0x000018d0, 0x000004a8, 0x0000031c, 0x000001ad,
  0x00034c00, 0x00009e41, 0x00006982, 0x000034e0,
  0x0008a150, 0x00019e40, 0x0001142c, 0x00008a35,
  0x00000020, 0x00000007, 0x00000006, 0x00000022,
  0x00000120, 0x00000037, 0x00000026, 0x00000032,
  0x000008f0, 0x000001ae, 0x00000120, 0x000000af,
  0x000010d0, 0x00000328, 0x0000021c, 0x0000012d,
  0x000018c0, 0x000004a5, 0x0000031a, 0x000001ac,
  0x00034bf0, 0x00009e3e, 0x00006980, 0x000034df,
  0x0008a140, 0x00019e3d, 0x0001142a, 0x00008a34,
  0x0010a110, 0x00031e34, 0x00021424, 0x00010a31,
  0x00000100, 0x00000031, 0x00000022, 0x00000030,
  0x000008d0, 0x000001a8, 0x0000011c, 0x000000ad,
  0x000010b0, 0x00000322, 0x00000218, 0x0000012b,
  0x000018a0, 0x0000049f, 0x00000316, 0x000001aa,
  0x00034bd0, 0x00009e38, 0x0000697c, 0x000034dd,
  0x0008a120, 0x00019e37, 0x00011426, 0x00008a32,
  0x0010a0f0, 0x00031e2e, 0x00021420, 0x00010a2f,
  0x0018a0d0, 0x00049e28, 0x0003141c, 0x00018a2d,
  0x000007d0, 0x00000178, 0x000000fc, 0x0000009d,
  0x00000fb0, 0x000002f2, 0x000001f8, 0x0000011b,
  0x000017a0, 0x0000046f, 0x000002f6, 0x0000019a,
  0x00034ad0, 0x00009e08, 0x0000695c, 0x000034cd,
  0x0008a020, 0x00019e07, 0x00011406, 0x00008a22,
  0x00109ff0, 0x00031dfe, 0x00021400, 0x00010a1f,
  0x00189fd0, 0x00049df8, 0x000313fc, 0x00018a1d,
  0x00209fc0, 0x00061df5, 0x000413fa, 0x00020a1c,
  0x000007e0, 0x0000017b, 0x000000fe, 0x0000009e,
  0x00000fd0, 0x000002f8, 0x000001fc, 0x0000011d,
  0x00034300, 0x00009c91, 0x00006862, 0x00003450,
  0x00089850, 0x00019c90, 0x0001130c, 0x000089a5,
  0x00109820, 0x00031c87, 0x00021306, 0x000109a2,
  0x00189800, 0x00049c81, 0x00031302, 0x000189a0,
  0x002097f0, 0x00061c7e, 0x00041300, 0x0002099f,
  0x001897f0, 0x00049c7e, 0x00031300, 0x0001899f,
  0x000007f0, 0x0000017e, 0x00000100, 0x0000009f,
  0x00033b20, 0x00009b17, 0x00006766, 0x000033d2,
  0x00089070, 0x00019b16, 0x00011210, 0x00008927,
  0x00109040, 0x00031b0d, 0x0002120a, 0x00010924,
  0x00189020, 0x00049b07, 0x00031206, 0x00018922,
  0x00209010, 0x00061b04, 0x00041204, 0x00020921,
  0x00189010, 0x00049b04, 0x00031204, 0x00018921,
  0x00109020, 0x00031b07, 0x00021206, 0x00010922,
  0x00033330, 0x0000999a, 0x00006668, 0x00003353,
  0x00088880, 0x00019999, 0x00011112, 0x000088a8,
  0x00108850, 0x00031990, 0x0002110c, 0x000108a5,
  0x00188830, 0x0004998a, 0x00031108, 0x000188a3,
  0x00208820, 0x00061987, 0x00041106, 0x000208a2,
  0x00188820, 0x00049987, 0x00031106, 0x000188a2,
  0x00108830, 0x0003198a, 0x00021108, 0x000108a3,
  0x000b32d0, 0x00021988, 0x0001665c, 0x0000b34d,
  0x00055550, 0x00010000, 0x0000aaac, 0x00005575,
  0x000d5520, 0x00027ff7, 0x0001aaa6, 0x0000d572,
  0x00155500, 0x0003fff1, 0x0002aaa2, 0x00015570,
  0x001d54f0, 0x00057fee, 0x0003aaa0, 0x0001d56f,
  0x001554f0, 0x0003ffee, 0x0002aaa0, 0x0001556f,
  0x000d5500, 0x00027ff1, 0x0001aaa2, 0x0000d570,
  0x0007ffa0, 0x00017fef, 0x0000fff6, 0x0000801a,
  0x0004cc60, 0x0000e653, 0x0000998e, 0x00004ce6,
  0x0007ffd0, 0x00017ff8, 0x0000fffc, 0x0000801d,
  0x000fffb0, 0x0002fff2, 0x0001fff8, 0x0001001b,
  0x0017ffa0, 0x00047fef, 0x0002fff6, 0x0001801a,
  0x000fffa0, 0x0002ffef, 0x0001fff6, 0x0001001a,
  0x0007ffb0, 0x00017ff2, 0x0000fff8, 0x0000801b,
  0x0002aa50, 0x00007ff0, 0x0000554c, 0x00002ac5,
  0xffff7710, 0xffffe654, 0xffffeee4, 0xfffff791,
  0xffff6f10, 0xffffe4d4, 0xffffede4, 0xfffff711,
  0x0007ffe0, 0x00017ffb, 0x0000fffe, 0x0000801e,
  0x000fffd0, 0x0002fff8, 0x0001fffc, 0x0001001d,
  0x0007ffd0, 0x00017ff8, 0x0000fffc, 0x0000801d,
  0xffffffe0, 0xfffffffb, 0xfffffffe, 0x0000001e,
  0xfffaaa80, 0xfffefff9, 0xffff5552, 0xffffaac8,
  0xfff77740, 0xfffe665d, 0xfffeeeea, 0xffff7794,
  0xfff76f40, 0xfffe64dd, 0xfffeedea, 0xffff7714,
  0xfff76750, 0xfffe6360, 0xfffeecec, 0xffff7695,
  0x0007fff0, 0x00017ffe, 0x00010000, 0x0000801f,
  0xfffffff0, 0xfffffffe, 0x00000000, 0x0000001f,
  0xfff80000, 0xfffe8001, 0xffff0002, 0xffff8020,
  0xfff2aaa0, 0xfffd7fff, 0xfffe5556, 0xffff2aca,
  0xffef7760, 0xfffce663, 0xfffdeeee, 0xfffef796,
  0xffef6f60, 0xfffce4e3, 0xfffdedee, 0xfffef716,
  0xffef6770, 0xfffce366, 0xfffdecf0, 0xfffef697,
  0xffef5f90, 0xfffce1ec, 0xfffdebf4, 0xfffef619,
  0xfff80000, 0xfffe8001, 0xffff0002, 0xffff8020,
  0xfff00010, 0xfffd0004, 0xfffe0004, 0xffff0021,
  0xffeaaab0, 0xfffc0002, 0xfffd5558, 0xfffeaacb,
  0xffe77770, 0xfffb6666, 0xfffceef0, 0xfffe7797,
  0xffe76f70, 0xfffb64e6, 0xfffcedf0, 0xfffe7717,
  0xffe76780, 0xfffb6369, 0xfffcecf2, 0xfffe7698,
  0xffe75fa0, 0xfffb61ef, 0xfffcebf6, 0xfffe761a,
  0xffe757d0, 0xfffb6078, 0xfffceafc, 0xfffe759d,
  0xfff80010, 0xfffe8004, 0xffff0004, 0xffff8021,
  0xfff2aab0, 0xfffd8002, 0xfffe5558, 0xffff2acb,
  0xffef7770, 0xfffce666, 0xfffdeef0, 0xfffef797,
  0xffef6f70, 0xfffce4e6, 0xfffdedf0, 0xfffef717,
  0xffef6780, 0xfffce369, 0xfffdecf2, 0xfffef698,
  0xffef5fa0, 0xfffce1ef, 0xfffdebf6, 0xfffef61a,
  0xffef57d0, 0xfffce078, 0xfffdeafc, 0xfffef59d,
  0xffef56d0, 0xfffce048, 0xfffdeadc, 0xfffef58d,
  0xfffaaaa0, 0xfffeffff, 0xffff5556, 0xffffaaca,
  0xfff77760, 0xfffe6663, 0xfffeeeee, 0xffff7796,
  0xfff76f60, 0xfffe64e3, 0xfffeedee, 0xffff7716,
  0xfff76770, 0xfffe6366, 0xfffeecf0, 0xffff7697,
  0xfff75f90, 0xfffe61ec, 0xfffeebf4, 0xffff7619,
  0xfff757c0, 0xfffe6075, 0xfffeeafa, 0xffff759c,
  0xfff756c0, 0xfffe6045, 0xfffeeada, 0xffff758c,
  0xfff75690, 0xfffe603c, 0xfffeead4, 0xffff7589,
  0xfffcccc0, 0xffff6665, 0xffff999a, 0xffffccec,
  0xfffcc4c0, 0xffff64e5, 0xffff989a, 0xffffcc6c,
  0xfffcbcd0, 0xffff6368, 0xffff979c, 0xffffcbed,
  0xfffcb4f0, 0xffff61ee, 0xffff96a0, 0xffffcb6f,
  0xfffcad20, 0xffff6077, 0xffff95a6, 0xffffcaf2,
  0xfffcac20, 0xffff6047, 0xffff9586, 0xffffcae2,
  0xfffcabf0, 0xffff603e, 0xffff9580, 0xffffcadf,
  0xfffcabd0, 0xffff6038, 0xffff957c, 0xffffcadd,
  0xfffff800, 0xfffffe81, 0xffffff02, 0xffffffa0,
  0xfffff010, 0xfffffd04, 0xfffffe04, 0xffffff21,
  0xffffe830, 0xfffffb8a, 0xfffffd08, 0xfffffea3,
  0xffffe060, 0xfffffa13, 0xfffffc0e, 0xfffffe26,
  0xffffdf60, 0xfffff9e3, 0xfffffbee, 0xfffffe16,
  0xffffdf30, 0xfffff9da, 0xfffffbe8, 0xfffffe13,
  0xffffdf10, 0xfffff9d4, 0xfffffbe4, 0xfffffe11,
  0xffffdf00, 0xfffff9d1, 0xfffffbe2, 0xfffffe10,
};
const unsigned kExpectedCount_NEON_smlsl2_4S_8H_H = 4608;

#endif  // VIXL_SIM_SMLSL2_4S_8H_H_TRACE_AARCH64_H_
