// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_MUL_4S_TRACE_AARCH64_H_
#define VIXL_SIM_MUL_4S_TRACE_AARCH64_H_

const uint32_t kExpected_NEON_mul_4S[] = {
  0x3e040000, 0x3f010000, 0x00090000, 0x00000000,
  0x3e820000, 0x7e830000, 0x00000000, 0x00000000,
  0xfe860000, 0x00000000, 0x007ffd00, 0x00000000,
  0x00000000, 0x00007f00, 0x00fffa00, 0x00000000,
  0x00007e00, 0x0000fe00, 0x0fffa000, 0x00000000,
  0x0000fc00, 0x000fe000, 0x3e7e8900, 0x00000000,
  0x000fc000, 0x003e0300, 0x3efe8600, 0x00000000,
  0x003d8600, 0x003e8200, 0x3f7e8300, 0x00000000,
  0x003e0400, 0x003f0100, 0xfd000900, 0x00000000,
  0x003e8200, 0x3f7e8300, 0xfd800600, 0x00000000,
  0x3efe8600, 0x3f7f0200, 0xfe000300, 0x00000000,
  0x3eff0400, 0x3f7f8100, 0xffe66700, 0x00000000,
  0x3eff8200, 0x66664d00, 0xaa800100, 0x00000000,
  0x33331a00, 0x55552b00, 0xfe800900, 0x00000000,
  0xffffd600, 0xfffe8300, 0xff000600, 0x00000000,
  0xfffe8600, 0xffff0200, 0xff800300, 0x00000000,
  0xffff0400, 0xffff8100, 0x00000000, 0x00000000,
  0xffff8200, 0x00000000, 0x007ffd00, 0x00000000,
  0x00000000, 0x00007f00, 0x55000200, 0x00000000,
  0x00007e00, 0xaaaa5600, 0xff999c00, 0x00000000,
  0xffffac00, 0x99993400, 0x01800000, 0x00000000,
  0xcccc6800, 0xc0800000, 0x01fffd00, 0x00000000,
  0xc1000000, 0xc0807f00, 0x027ffa00, 0x00000000,
  0xc1007e00, 0xc080fe00, 0x02fff700, 0x00000000,
  0xc100fc00, 0xc0817d00, 0xc0018000, 0x00000000,
  0xc1017a00, 0xffc08000, 0xc0817d00, 0x00000000,
  0xffc10000, 0xffc0ff00, 0xc1017a00, 0x00000000,
  0xffc17e00, 0xffc17e00, 0xc1817700, 0x00000000,
  0xffc1fc00, 0xffc1fd00, 0xf0006000, 0x00000000,
  0xffc27a00, 0xfff02000, 0xfe800900, 0x00000000,
  0xfff04000, 0xfffe8300, 0xff000600, 0x00000000,
  0xfffe8300, 0xff000600, 0x00000000, 0x00000000,
  0xffff0200, 0xff800300, 0x00000000, 0x00000001,
  0xffff8100, 0x00000000, 0x00000000, 0x00000002,
  0x00000000, 0x007ffd00, 0x00000000, 0x00000020,
  0x00007f00, 0x00fffa00, 0x00000000, 0x0000007d,
  0x0000fe00, 0x0fffa000, 0x00000000, 0x0000007e,
  0x000fe000, 0x3e7e8900, 0x00000000, 0x0000007f,
  0x003e0300, 0x3efe8600, 0x00000000, 0x00007ffd,
  0x003e8200, 0x3f7e8300, 0x00000000, 0x00007ffe,
  0x003f0100, 0xfd000900, 0x00000000, 0x00007fff,
  0x3f7e8300, 0xfd800600, 0x00000000, 0x33333333,
  0x3f7f0200, 0xfe000300, 0x00000000, 0x55555555,
  0x3f7f8100, 0xffe66700, 0x00000000, 0x7ffffffd,
  0x66664d00, 0xaa800100, 0x00000000, 0x7ffffffe,
  0x55552b00, 0xfe800900, 0x00000000, 0x7fffffff,
  0xfffe8300, 0xff000600, 0x00000000, 0x80000000,
  0xffff0200, 0xff800300, 0x00000000, 0x80000001,
  0xffff8100, 0x00000000, 0x00000000, 0xaaaaaaaa,
  0x00000000, 0x007ffd00, 0x00000000, 0xcccccccc,
  0x00007f00, 0x55000200, 0x00000000, 0xffff8000,
  0xaaaa5600, 0xff999c00, 0x00000000, 0xffff8001,
  0x99993400, 0x01800000, 0x00000000, 0xffff8002,
  0xc0800000, 0x01fffd00, 0x00000000, 0xffff8003,
  0xc0807f00, 0x027ffa00, 0x00000000, 0xffffff80,
  0xc080fe00, 0x02fff700, 0x00000000, 0xffffff81,
  0xc0817d00, 0xc0018000, 0x00000000, 0xffffff82,
  0xffc08000, 0xc0817d00, 0x00000000, 0xffffff83,
  0xffc0ff00, 0xc1017a00, 0x00000000, 0xffffffe0,
  0xffc17e00, 0xc1817700, 0x00000000, 0xfffffffd,
  0xffc1fd00, 0xf0006000, 0x00000000, 0xfffffffe,
  0xfff02000, 0xfe800900, 0x00000000, 0xffffffff,
  0xfe800900, 0x00000000, 0xffffffff, 0x00000000,
  0xff000600, 0x00000000, 0x00000000, 0x00000002,
  0xff800300, 0x00000000, 0x00000001, 0x00000004,
  0x00000000, 0x00000000, 0x00000002, 0x00000040,
  0x007ffd00, 0x00000000, 0x00000020, 0x000000fa,
  0x00fffa00, 0x00000000, 0x0000007d, 0x000000fc,
  0x0fffa000, 0x00000000, 0x0000007e, 0x000000fe,
  0x3e7e8900, 0x00000000, 0x0000007f, 0x0000fffa,
  0x3efe8600, 0x00000000, 0x00007ffd, 0x0000fffc,
  0x3f7e8300, 0x00000000, 0x00007ffe, 0x0000fffe,
  0xfd000900, 0x00000000, 0x00007fff, 0x66666666,
  0xfd800600, 0x00000000, 0x33333333, 0xaaaaaaaa,
  0xfe000300, 0x00000000, 0x55555555, 0xfffffffa,
  0xffe66700, 0x00000000, 0x7ffffffd, 0xfffffffc,
  0xaa800100, 0x00000000, 0x7ffffffe, 0xfffffffe,
  0xfe800900, 0x00000000, 0x7fffffff, 0x00000000,
  0xff000600, 0x00000000, 0x80000000, 0x00000002,
  0xff800300, 0x00000000, 0x80000001, 0x55555554,
  0x00000000, 0x00000000, 0xaaaaaaaa, 0x99999998,
  0x007ffd00, 0x00000000, 0xcccccccc, 0xffff0000,
  0x55000200, 0x00000000, 0xffff8000, 0xffff0002,
  0xff999c00, 0x00000000, 0xffff8001, 0xffff0004,
  0x01800000, 0x00000000, 0xffff8002, 0xffff0006,
  0x01fffd00, 0x00000000, 0xffff8003, 0xffffff00,
  0x027ffa00, 0x00000000, 0xffffff80, 0xffffff02,
  0x02fff700, 0x00000000, 0xffffff81, 0xffffff04,
  0xc0018000, 0x00000000, 0xffffff82, 0xffffff06,
  0xc0817d00, 0x00000000, 0xffffff83, 0xffffffc0,
  0xc1017a00, 0x00000000, 0xffffffe0, 0xfffffffa,
  0xc1817700, 0x00000000, 0xfffffffd, 0xfffffffc,
  0xf0006000, 0x00000000, 0xfffffffe, 0xfffffffe,
  0x00000000, 0xfffffffe, 0xfffffffe, 0x00000000,
  0x00000000, 0xffffffff, 0x00000000, 0x00000020,
  0x00000000, 0x00000000, 0x00000002, 0x00000040,
  0x00000000, 0x00000001, 0x00000004, 0x00000400,
  0x00000000, 0x00000002, 0x00000040, 0x00000fa0,
  0x00000000, 0x00000020, 0x000000fa, 0x00000fc0,
  0x00000000, 0x0000007d, 0x000000fc, 0x00000fe0,
  0x00000000, 0x0000007e, 0x000000fe, 0x000fffa0,
  0x00000000, 0x0000007f, 0x0000fffa, 0x000fffc0,
  0x00000000, 0x00007ffd, 0x0000fffc, 0x000fffe0,
  0x00000000, 0x00007ffe, 0x0000fffe, 0x66666660,
  0x00000000, 0x00007fff, 0x66666666, 0xaaaaaaa0,
  0x00000000, 0x33333333, 0xaaaaaaaa, 0xffffffa0,
  0x00000000, 0x55555555, 0xfffffffa, 0xffffffc0,
  0x00000000, 0x7ffffffd, 0xfffffffc, 0xffffffe0,
  0x00000000, 0x7ffffffe, 0xfffffffe, 0x00000000,
  0x00000000, 0x7fffffff, 0x00000000, 0x00000020,
  0x00000000, 0x80000000, 0x00000002, 0x55555540,
  0x00000000, 0x80000001, 0x55555554, 0x99999980,
  0x00000000, 0xaaaaaaaa, 0x99999998, 0xfff00000,
  0x00000000, 0xcccccccc, 0xffff0000, 0xfff00020,
  0x00000000, 0xffff8000, 0xffff0002, 0xfff00040,
  0x00000000, 0xffff8001, 0xffff0004, 0xfff00060,
  0x00000000, 0xffff8002, 0xffff0006, 0xfffff000,
  0x00000000, 0xffff8003, 0xffffff00, 0xfffff020,
  0x00000000, 0xffffff80, 0xffffff02, 0xfffff040,
  0x00000000, 0xffffff81, 0xffffff04, 0xfffff060,
  0x00000000, 0xffffff82, 0xffffff06, 0xfffffc00,
  0x00000000, 0xffffff83, 0xffffffc0, 0xffffffa0,
  0x00000000, 0xffffffe0, 0xfffffffa, 0xffffffc0,
  0x00000000, 0xfffffffd, 0xfffffffc, 0xffffffe0,
  0xfffffffd, 0xfffffffc, 0xffffffe0, 0x00000000,
  0xfffffffe, 0xfffffffe, 0x00000000, 0x0000007d,
  0xffffffff, 0x00000000, 0x00000020, 0x000000fa,
  0x00000000, 0x00000002, 0x00000040, 0x00000fa0,
  0x00000001, 0x00000004, 0x00000400, 0x00003d09,
  0x00000002, 0x00000040, 0x00000fa0, 0x00003d86,
  0x00000020, 0x000000fa, 0x00000fc0, 0x00003e03,
  0x0000007d, 0x000000fc, 0x00000fe0, 0x003e7e89,
  0x0000007e, 0x000000fe, 0x000fffa0, 0x003e7f06,
  0x0000007f, 0x0000fffa, 0x000fffc0, 0x003e7f83,
  0x00007ffd, 0x0000fffc, 0x000fffe0, 0xffffffe7,
  0x00007ffe, 0x0000fffe, 0x66666660, 0xaaaaaa81,
  0x00007fff, 0x66666666, 0xaaaaaaa0, 0x7ffffe89,
  0x33333333, 0xaaaaaaaa, 0xffffffa0, 0x7fffff06,
  0x55555555, 0xfffffffa, 0xffffffc0, 0x7fffff83,
  0x7ffffffd, 0xfffffffc, 0xffffffe0, 0x80000000,
  0x7ffffffe, 0xfffffffe, 0x00000000, 0x8000007d,
  0x7fffffff, 0x00000000, 0x00000020, 0x55555502,
  0x80000000, 0x00000002, 0x55555540, 0xffffff9c,
  0x80000001, 0x55555554, 0x99999980, 0xffc18000,
  0xaaaaaaaa, 0x99999998, 0xfff00000, 0xffc1807d,
  0xcccccccc, 0xffff0000, 0xfff00020, 0xffc180fa,
  0xffff8000, 0xffff0002, 0xfff00040, 0xffc18177,
  0xffff8001, 0xffff0004, 0xfff00060, 0xffffc180,
  0xffff8002, 0xffff0006, 0xfffff000, 0xffffc1fd,
  0xffff8003, 0xffffff00, 0xfffff020, 0xffffc27a,
  0xffffff80, 0xffffff02, 0xfffff040, 0xffffc2f7,
  0xffffff81, 0xffffff04, 0xfffff060, 0xfffff060,
  0xffffff82, 0xffffff06, 0xfffffc00, 0xfffffe89,
  0xffffff83, 0xffffffc0, 0xffffffa0, 0xffffff06,
  0xffffffe0, 0xfffffffa, 0xffffffc0, 0xffffff83,
  0xfffffffa, 0xffffffc0, 0xffffff83, 0x00000000,
  0xfffffffc, 0xffffffe0, 0x00000000, 0x0000007e,
  0xfffffffe, 0x00000000, 0x0000007d, 0x000000fc,
  0x00000000, 0x00000020, 0x000000fa, 0x00000fc0,
  0x00000002, 0x00000040, 0x00000fa0, 0x00003d86,
  0x00000004, 0x00000400, 0x00003d09, 0x00003e04,
  0x00000040, 0x00000fa0, 0x00003d86, 0x00003e82,
  0x000000fa, 0x00000fc0, 0x00003e03, 0x003efe86,
  0x000000fc, 0x00000fe0, 0x003e7e89, 0x003eff04,
  0x000000fe, 0x000fffa0, 0x003e7f06, 0x003eff82,
  0x0000fffa, 0x000fffc0, 0x003e7f83, 0x3333331a,
  0x0000fffc, 0x000fffe0, 0xffffffe7, 0xffffffd6,
  0x0000fffe, 0x66666660, 0xaaaaaa81, 0xfffffe86,
  0x66666666, 0xaaaaaaa0, 0x7ffffe89, 0xffffff04,
  0xaaaaaaaa, 0xffffffa0, 0x7fffff06, 0xffffff82,
  0xfffffffa, 0xffffffc0, 0x7fffff83, 0x00000000,
  0xfffffffc, 0xffffffe0, 0x80000000, 0x0000007e,
  0xfffffffe, 0x00000000, 0x8000007d, 0xffffffac,
  0x00000000, 0x00000020, 0x55555502, 0xcccccc68,
  0x00000002, 0x55555540, 0xffffff9c, 0xffc10000,
  0x55555554, 0x99999980, 0xffc18000, 0xffc1007e,
  0x99999998, 0xfff00000, 0xffc1807d, 0xffc100fc,
  0xffff0000, 0xfff00020, 0xffc180fa, 0xffc1017a,
  0xffff0002, 0xfff00040, 0xffc18177, 0xffffc100,
  0xffff0004, 0xfff00060, 0xffffc180, 0xffffc17e,
  0xffff0006, 0xfffff000, 0xffffc1fd, 0xffffc1fc,
  0xffffff00, 0xfffff020, 0xffffc27a, 0xffffc27a,
  0xffffff02, 0xfffff040, 0xffffc2f7, 0xfffff040,
  0xffffff04, 0xfffff060, 0xfffff060, 0xfffffe86,
  0xffffff06, 0xfffffc00, 0xfffffe89, 0xffffff04,
  0xffffffc0, 0xffffffa0, 0xffffff06, 0xffffff82,
  0xffffffa0, 0xffffff06, 0xffffff82, 0x00000000,
  0xffffffc0, 0xffffff83, 0x00000000, 0x0000007f,
  0xffffffe0, 0x00000000, 0x0000007e, 0x000000fe,
  0x00000000, 0x0000007d, 0x000000fc, 0x00000fe0,
  0x00000020, 0x000000fa, 0x00000fc0, 0x00003e03,
  0x00000040, 0x00000fa0, 0x00003d86, 0x00003e82,
  0x00000400, 0x00003d09, 0x00003e04, 0x00003f01,
  0x00000fa0, 0x00003d86, 0x00003e82, 0x003f7e83,
  0x00000fc0, 0x00003e03, 0x003efe86, 0x003f7f02,
  0x00000fe0, 0x003e7e89, 0x003eff04, 0x003f7f81,
  0x000fffa0, 0x003e7f06, 0x003eff82, 0x6666664d,
  0x000fffc0, 0x003e7f83, 0x3333331a, 0x5555552b,
  0x000fffe0, 0xffffffe7, 0xffffffd6, 0x7ffffe83,
  0x66666660, 0xaaaaaa81, 0xfffffe86, 0x7fffff02,
  0xaaaaaaa0, 0x7ffffe89, 0xffffff04, 0x7fffff81,
  0xffffffa0, 0x7fffff06, 0xffffff82, 0x80000000,
  0xffffffc0, 0x7fffff83, 0x00000000, 0x8000007f,
  0xffffffe0, 0x80000000, 0x0000007e, 0xaaaaaa56,
  0x00000000, 0x8000007d, 0xffffffac, 0x99999934,
  0x00000020, 0x55555502, 0xcccccc68, 0xffc08000,
  0x55555540, 0xffffff9c, 0xffc10000, 0xffc0807f,
  0x99999980, 0xffc18000, 0xffc1007e, 0xffc080fe,
  0xfff00000, 0xffc1807d, 0xffc100fc, 0xffc0817d,
  0xfff00020, 0xffc180fa, 0xffc1017a, 0xffffc080,
  0xfff00040, 0xffc18177, 0xffffc100, 0xffffc0ff,
  0xfff00060, 0xffffc180, 0xffffc17e, 0xffffc17e,
  0xfffff000, 0xffffc1fd, 0xffffc1fc, 0xffffc1fd,
  0xfffff020, 0xffffc27a, 0xffffc27a, 0xfffff020,
  0xfffff040, 0xffffc2f7, 0xfffff040, 0xfffffe83,
  0xfffff060, 0xfffff060, 0xfffffe86, 0xffffff02,
  0xfffffc00, 0xfffffe89, 0xffffff04, 0xffffff81,
  0xfffffe89, 0xffffff04, 0xffffff81, 0x00000000,
  0xffffff06, 0xffffff82, 0x00000000, 0x00007ffd,
  0xffffff83, 0x00000000, 0x0000007f, 0x0000fffa,
  0x00000000, 0x0000007e, 0x000000fe, 0x000fffa0,
  0x0000007d, 0x000000fc, 0x00000fe0, 0x003e7e89,
  0x000000fa, 0x00000fc0, 0x00003e03, 0x003efe86,
  0x00000fa0, 0x00003d86, 0x00003e82, 0x003f7e83,
  0x00003d09, 0x00003e04, 0x00003f01, 0x3ffd0009,
  0x00003d86, 0x00003e82, 0x003f7e83, 0x3ffd8006,
  0x00003e03, 0x003efe86, 0x003f7f02, 0x3ffe0003,
  0x003e7e89, 0x003eff04, 0x003f7f81, 0xffffe667,
  0x003e7f06, 0x003eff82, 0x6666664d, 0xaaaa8001,
  0x003e7f83, 0x3333331a, 0x5555552b, 0x7ffe8009,
  0xffffffe7, 0xffffffd6, 0x7ffffe83, 0x7fff0006,
  0xaaaaaa81, 0xfffffe86, 0x7fffff02, 0x7fff8003,
  0x7ffffe89, 0xffffff04, 0x7fffff81, 0x80000000,
  0x7fffff06, 0xffffff82, 0x80000000, 0x80007ffd,
  0x7fffff83, 0x00000000, 0x8000007f, 0x55550002,
  0x80000000, 0x0000007e, 0xaaaaaa56, 0xffff999c,
  0x8000007d, 0xffffffac, 0x99999934, 0xc0018000,
  0x55555502, 0xcccccc68, 0xffc08000, 0xc001fffd,
  0xffffff9c, 0xffc10000, 0xffc0807f, 0xc0027ffa,
  0xffc18000, 0xffc1007e, 0xffc080fe, 0xc002fff7,
  0xffc1807d, 0xffc100fc, 0xffc0817d, 0xffc00180,
  0xffc180fa, 0xffc1017a, 0xffffc080, 0xffc0817d,
  0xffc18177, 0xffffc100, 0xffffc0ff, 0xffc1017a,
  0xffffc180, 0xffffc17e, 0xffffc17e, 0xffc18177,
  0xffffc1fd, 0xffffc1fc, 0xffffc1fd, 0xfff00060,
  0xffffc27a, 0xffffc27a, 0xfffff020, 0xfffe8009,
  0xffffc2f7, 0xfffff040, 0xfffffe83, 0xffff0006,
  0xfffff060, 0xfffffe86, 0xffffff02, 0xffff8003,
  0xfffffe86, 0xffffff02, 0xffff8003, 0x00000000,
  0xffffff04, 0xffffff81, 0x00000000, 0x00007ffe,
  0xffffff82, 0x00000000, 0x00007ffd, 0x0000fffc,
  0x00000000, 0x0000007f, 0x0000fffa, 0x000fffc0,
  0x0000007e, 0x000000fe, 0x000fffa0, 0x003e7f06,
  0x000000fc, 0x00000fe0, 0x003e7e89, 0x003eff04,
  0x00000fc0, 0x00003e03, 0x003efe86, 0x003f7f02,
  0x00003d86, 0x00003e82, 0x003f7e83, 0x3ffd8006,
  0x00003e04, 0x00003f01, 0x3ffd0009, 0x3ffe0004,
  0x00003e82, 0x003f7e83, 0x3ffd8006, 0x3ffe8002,
  0x003efe86, 0x003f7f02, 0x3ffe0003, 0x3333199a,
  0x003eff04, 0x003f7f81, 0xffffe667, 0xffffd556,
  0x003eff82, 0x6666664d, 0xaaaa8001, 0xfffe8006,
  0x3333331a, 0x5555552b, 0x7ffe8009, 0xffff0004,
  0xffffffd6, 0x7ffffe83, 0x7fff0006, 0xffff8002,
  0xfffffe86, 0x7fffff02, 0x7fff8003, 0x00000000,
  0xffffff04, 0x7fffff81, 0x80000000, 0x00007ffe,
  0xffffff82, 0x80000000, 0x80007ffd, 0xffffaaac,
  0x00000000, 0x8000007f, 0x55550002, 0xcccc6668,
  0x0000007e, 0xaaaaaa56, 0xffff999c, 0xc0010000,
  0xffffffac, 0x99999934, 0xc0018000, 0xc0017ffe,
  0xcccccc68, 0xffc08000, 0xc001fffd, 0xc001fffc,
  0xffc10000, 0xffc0807f, 0xc0027ffa, 0xc0027ffa,
  0xffc1007e, 0xffc080fe, 0xc002fff7, 0xffc00100,
  0xffc100fc, 0xffc0817d, 0xffc00180, 0xffc080fe,
  0xffc1017a, 0xffffc080, 0xffc0817d, 0xffc100fc,
  0xffffc100, 0xffffc0ff, 0xffc1017a, 0xffc180fa,
  0xffffc17e, 0xffffc17e, 0xffc18177, 0xfff00040,
  0xffffc1fc, 0xffffc1fd, 0xfff00060, 0xfffe8006,
  0xffffc27a, 0xfffff020, 0xfffe8009, 0xffff0004,
  0xfffff040, 0xfffffe83, 0xffff0006, 0xffff8002,
  0xfffffe83, 0xffff0006, 0xffff8002, 0x00000000,
  0xffffff02, 0xffff8003, 0x00000000, 0x00007fff,
  0xffffff81, 0x00000000, 0x00007ffe, 0x0000fffe,
  0x00000000, 0x00007ffd, 0x0000fffc, 0x000fffe0,
  0x0000007f, 0x0000fffa, 0x000fffc0, 0x003e7f83,
  0x000000fe, 0x000fffa0, 0x003e7f06, 0x003eff82,
  0x00000fe0, 0x003e7e89, 0x003eff04, 0x003f7f81,
  0x00003e03, 0x003efe86, 0x003f7f02, 0x3ffe0003,
  0x00003e82, 0x003f7e83, 0x3ffd8006, 0x3ffe8002,
  0x00003f01, 0x3ffd0009, 0x3ffe0004, 0x3fff0001,
  0x003f7e83, 0x3ffd8006, 0x3ffe8002, 0x66664ccd,
  0x003f7f02, 0x3ffe0003, 0x3333199a, 0x55552aab,
  0x003f7f81, 0xffffe667, 0xffffd556, 0x7ffe8003,
  0x6666664d, 0xaaaa8001, 0xfffe8006, 0x7fff0002,
  0x5555552b, 0x7ffe8009, 0xffff0004, 0x7fff8001,
  0x7ffffe83, 0x7fff0006, 0xffff8002, 0x80000000,
  0x7fffff02, 0x7fff8003, 0x00000000, 0x80007fff,
  0x7fffff81, 0x80000000, 0x00007ffe, 0xaaaa5556,
  0x80000000, 0x80007ffd, 0xffffaaac, 0x99993334,
  0x8000007f, 0x55550002, 0xcccc6668, 0xc0008000,
  0xaaaaaa56, 0xffff999c, 0xc0010000, 0xc000ffff,
  0x99999934, 0xc0018000, 0xc0017ffe, 0xc0017ffe,
  0xffc08000, 0xc001fffd, 0xc001fffc, 0xc001fffd,
  0xffc0807f, 0xc0027ffa, 0xc0027ffa, 0xffc00080,
  0xffc080fe, 0xc002fff7, 0xffc00100, 0xffc0807f,
  0xffc0817d, 0xffc00180, 0xffc080fe, 0xffc1007e,
  0xffffc080, 0xffc0817d, 0xffc100fc, 0xffc1807d,
  0xffffc0ff, 0xffc1017a, 0xffc180fa, 0xfff00020,
  0xffffc17e, 0xffc18177, 0xfff00040, 0xfffe8003,
  0xffffc1fd, 0xfff00060, 0xfffe8006, 0xffff0002,
  0xfffff020, 0xfffe8009, 0xffff0004, 0xffff8001,
  0xfffe8009, 0xffff0004, 0xffff8001, 0x00000000,
  0xffff0006, 0xffff8002, 0x00000000, 0x33333333,
  0xffff8003, 0x00000000, 0x00007fff, 0x66666666,
  0x00000000, 0x00007ffe, 0x0000fffe, 0x66666660,
  0x00007ffd, 0x0000fffc, 0x000fffe0, 0xffffffe7,
  0x0000fffa, 0x000fffc0, 0x003e7f83, 0x3333331a,
  0x000fffa0, 0x003e7f06, 0x003eff82, 0x6666664d,
  0x003e7e89, 0x003eff04, 0x003f7f81, 0xffffe667,
  0x003efe86, 0x003f7f02, 0x3ffe0003, 0x3333199a,
  0x003f7e83, 0x3ffd8006, 0x3ffe8002, 0x66664ccd,
  0x3ffd0009, 0x3ffe0004, 0x3fff0001, 0xc28f5c29,
  0x3ffd8006, 0x3ffe8002, 0x66664ccd, 0xeeeeeeef,
  0x3ffe0003, 0x3333199a, 0x55552aab, 0xe6666667,
  0xffffe667, 0xffffd556, 0x7ffe8003, 0x1999999a,
  0xaaaa8001, 0xfffe8006, 0x7fff0002, 0x4ccccccd,
  0x7ffe8009, 0xffff0004, 0x7fff8001, 0x80000000,
  0x7fff0006, 0xffff8002, 0x80000000, 0xb3333333,
  0x7fff8003, 0x00000000, 0x80007fff, 0xddddddde,
  0x80000000, 0x00007ffe, 0xaaaa5556, 0x0a3d70a4,
  0x80007ffd, 0xffffaaac, 0x99993334, 0x66668000,
  0x55550002, 0xcccc6668, 0xc0008000, 0x9999b333,
  0xffff999c, 0xc0010000, 0xc000ffff, 0xcccce666,
  0xc0018000, 0xc0017ffe, 0xc0017ffe, 0x00001999,
  0xc001fffd, 0xc001fffc, 0xc001fffd, 0x66666680,
  0xc0027ffa, 0xc0027ffa, 0xffc00080, 0x999999b3,
  0xc002fff7, 0xffc00100, 0xffc0807f, 0xcccccce6,
  0xffc00180, 0xffc080fe, 0xffc1007e, 0x00000019,
  0xffc0817d, 0xffc100fc, 0xffc1807d, 0x999999a0,
  0xffc1017a, 0xffc180fa, 0xfff00020, 0x66666667,
  0xffc18177, 0xfff00040, 0xfffe8003, 0x9999999a,
  0xfff00060, 0xfffe8006, 0xffff0002, 0xcccccccd,
  0xfffe8006, 0xffff0002, 0xcccccccd, 0x00000000,
  0xffff0004, 0xffff8001, 0x00000000, 0x55555555,
  0xffff8002, 0x00000000, 0x33333333, 0xaaaaaaaa,
  0x00000000, 0x00007fff, 0x66666666, 0xaaaaaaa0,
  0x00007ffe, 0x0000fffe, 0x66666660, 0xaaaaaa81,
  0x0000fffc, 0x000fffe0, 0xffffffe7, 0xffffffd6,
  0x000fffc0, 0x003e7f83, 0x3333331a, 0x5555552b,
  0x003e7f06, 0x003eff82, 0x6666664d, 0xaaaa8001,
  0x003eff04, 0x003f7f81, 0xffffe667, 0xffffd556,
  0x003f7f02, 0x3ffe0003, 0x3333199a, 0x55552aab,
  0x3ffd8006, 0x3ffe8002, 0x66664ccd, 0xeeeeeeef,
  0x3ffe0004, 0x3fff0001, 0xc28f5c29, 0x38e38e39,
  0x3ffe8002, 0x66664ccd, 0xeeeeeeef, 0x80000001,
  0x3333199a, 0x55552aab, 0xe6666667, 0xd5555556,
  0xffffd556, 0x7ffe8003, 0x1999999a, 0x2aaaaaab,
  0xfffe8006, 0x7fff0002, 0x4ccccccd, 0x80000000,
  0xffff0004, 0x7fff8001, 0x80000000, 0xd5555555,
  0xffff8002, 0x80000000, 0xb3333333, 0x71c71c72,
  0x00000000, 0x80007fff, 0xddddddde, 0xbbbbbbbc,
  0x00007ffe, 0xaaaa5556, 0x0a3d70a4, 0x55558000,
  0xffffaaac, 0x99993334, 0x66668000, 0xaaaad555,
  0xcccc6668, 0xc0008000, 0x9999b333, 0x00002aaa,
  0xc0010000, 0xc000ffff, 0xcccce666, 0x55557fff,
  0xc0017ffe, 0xc0017ffe, 0x00001999, 0x55555580,
  0xc001fffc, 0xc001fffd, 0x66666680, 0xaaaaaad5,
  0xc0027ffa, 0xffc00080, 0x999999b3, 0x0000002a,
  0xffc00100, 0xffc0807f, 0xcccccce6, 0x5555557f,
  0xffc080fe, 0xffc1007e, 0x00000019, 0x55555560,
  0xffc100fc, 0xffc1807d, 0x999999a0, 0x00000001,
  0xffc180fa, 0xfff00020, 0x66666667, 0x55555556,
  0xfff00040, 0xfffe8003, 0x9999999a, 0xaaaaaaab,
  0xfffe8003, 0x9999999a, 0xaaaaaaab, 0x00000000,
  0xffff0002, 0xcccccccd, 0x00000000, 0x7ffffffd,
  0xffff8001, 0x00000000, 0x55555555, 0xfffffffa,
  0x00000000, 0x33333333, 0xaaaaaaaa, 0xffffffa0,
  0x00007fff, 0x66666666, 0xaaaaaaa0, 0x7ffffe89,
  0x0000fffe, 0x66666660, 0xaaaaaa81, 0xfffffe86,
  0x000fffe0, 0xffffffe7, 0xffffffd6, 0x7ffffe83,
  0x003e7f83, 0x3333331a, 0x5555552b, 0x7ffe8009,
  0x003eff82, 0x6666664d, 0xaaaa8001, 0xfffe8006,
  0x003f7f81, 0xffffe667, 0xffffd556, 0x7ffe8003,
  0x3ffe0003, 0x3333199a, 0x55552aab, 0xe6666667,
  0x3ffe8002, 0x66664ccd, 0xeeeeeeef, 0x80000001,
  0x3fff0001, 0xc28f5c29, 0x38e38e39, 0x00000009,
  0x66664ccd, 0xeeeeeeef, 0x80000001, 0x80000006,
  0x55552aab, 0xe6666667, 0xd5555556, 0x00000003,
  0x7ffe8003, 0x1999999a, 0x2aaaaaab, 0x80000000,
  0x7fff0002, 0x4ccccccd, 0x80000000, 0xfffffffd,
  0x7fff8001, 0x80000000, 0xd5555555, 0x00000002,
  0x80000000, 0xb3333333, 0x71c71c72, 0x9999999c,
  0x80007fff, 0xddddddde, 0xbbbbbbbc, 0x00018000,
  0xaaaa5556, 0x0a3d70a4, 0x55558000, 0x80017ffd,
  0x99993334, 0x66668000, 0xaaaad555, 0x00017ffa,
  0xc0008000, 0x9999b333, 0x00002aaa, 0x80017ff7,
  0xc000ffff, 0xcccce666, 0x55557fff, 0x00000180,
  0xc0017ffe, 0x00001999, 0x55555580, 0x8000017d,
  0xc001fffd, 0x66666680, 0xaaaaaad5, 0x0000017a,
  0xffc00080, 0x999999b3, 0x0000002a, 0x80000177,
  0xffc0807f, 0xcccccce6, 0x5555557f, 0x00000060,
  0xffc1007e, 0x00000019, 0x55555560, 0x80000009,
  0xffc1807d, 0x999999a0, 0x00000001, 0x00000006,
  0xfff00020, 0x66666667, 0x55555556, 0x80000003,
  0x66666667, 0x55555556, 0x80000003, 0x00000000,
  0x9999999a, 0xaaaaaaab, 0x00000000, 0x7ffffffe,
  0xcccccccd, 0x00000000, 0x7ffffffd, 0xfffffffc,
  0x00000000, 0x55555555, 0xfffffffa, 0xffffffc0,
  0x33333333, 0xaaaaaaaa, 0xffffffa0, 0x7fffff06,
  0x66666666, 0xaaaaaaa0, 0x7ffffe89, 0xffffff04,
  0x66666660, 0xaaaaaa81, 0xfffffe86, 0x7fffff02,
  0xffffffe7, 0xffffffd6, 0x7ffffe83, 0x7fff0006,
  0x3333331a, 0x5555552b, 0x7ffe8009, 0xffff0004,
  0x6666664d, 0xaaaa8001, 0xfffe8006, 0x7fff0002,
  0xffffe667, 0xffffd556, 0x7ffe8003, 0x1999999a,
  0x3333199a, 0x55552aab, 0xe6666667, 0xd5555556,
  0x66664ccd, 0xeeeeeeef, 0x80000001, 0x80000006,
  0xc28f5c29, 0x38e38e39, 0x00000009, 0x00000004,
  0xeeeeeeef, 0x80000001, 0x80000006, 0x80000002,
  0xe6666667, 0xd5555556, 0x00000003, 0x00000000,
  0x1999999a, 0x2aaaaaab, 0x80000000, 0x7ffffffe,
  0x4ccccccd, 0x80000000, 0xfffffffd, 0xaaaaaaac,
  0x80000000, 0xd5555555, 0x00000002, 0x66666668,
  0xb3333333, 0x71c71c72, 0x9999999c, 0x00010000,
  0xddddddde, 0xbbbbbbbc, 0x00018000, 0x8000fffe,
  0x0a3d70a4, 0x55558000, 0x80017ffd, 0x0000fffc,
  0x66668000, 0xaaaad555, 0x00017ffa, 0x8000fffa,
  0x9999b333, 0x00002aaa, 0x80017ff7, 0x00000100,
  0xcccce666, 0x55557fff, 0x00000180, 0x800000fe,
  0x00001999, 0x55555580, 0x8000017d, 0x000000fc,
  0x66666680, 0xaaaaaad5, 0x0000017a, 0x800000fa,
  0x999999b3, 0x0000002a, 0x80000177, 0x00000040,
  0xcccccce6, 0x5555557f, 0x00000060, 0x80000006,
  0x00000019, 0x55555560, 0x80000009, 0x00000004,
  0x999999a0, 0x00000001, 0x00000006, 0x80000002,
  0x00000001, 0x00000006, 0x80000002, 0x00000000,
  0x55555556, 0x80000003, 0x00000000, 0x7fffffff,
  0xaaaaaaab, 0x00000000, 0x7ffffffe, 0xfffffffe,
  0x00000000, 0x7ffffffd, 0xfffffffc, 0xffffffe0,
  0x55555555, 0xfffffffa, 0xffffffc0, 0x7fffff83,
  0xaaaaaaaa, 0xffffffa0, 0x7fffff06, 0xffffff82,
  0xaaaaaaa0, 0x7ffffe89, 0xffffff04, 0x7fffff81,
  0xaaaaaa81, 0xfffffe86, 0x7fffff02, 0x7fff8003,
  0xffffffd6, 0x7ffffe83, 0x7fff0006, 0xffff8002,
  0x5555552b, 0x7ffe8009, 0xffff0004, 0x7fff8001,
  0xaaaa8001, 0xfffe8006, 0x7fff0002, 0x4ccccccd,
  0xffffd556, 0x7ffe8003, 0x1999999a, 0x2aaaaaab,
  0x55552aab, 0xe6666667, 0xd5555556, 0x00000003,
  0xeeeeeeef, 0x80000001, 0x80000006, 0x80000002,
  0x38e38e39, 0x00000009, 0x00000004, 0x00000001,
  0x80000001, 0x80000006, 0x80000002, 0x80000000,
  0xd5555556, 0x00000003, 0x00000000, 0xffffffff,
  0x2aaaaaab, 0x80000000, 0x7ffffffe, 0x55555556,
  0x80000000, 0xfffffffd, 0xaaaaaaac, 0x33333334,
  0xd5555555, 0x00000002, 0x66666668, 0x00008000,
  0x71c71c72, 0x9999999c, 0x00010000, 0x80007fff,
  0xbbbbbbbc, 0x00018000, 0x8000fffe, 0x00007ffe,
  0x55558000, 0x80017ffd, 0x0000fffc, 0x80007ffd,
  0xaaaad555, 0x00017ffa, 0x8000fffa, 0x00000080,
  0x00002aaa, 0x80017ff7, 0x00000100, 0x8000007f,
  0x55557fff, 0x00000180, 0x800000fe, 0x0000007e,
  0x55555580, 0x8000017d, 0x000000fc, 0x8000007d,
  0xaaaaaad5, 0x0000017a, 0x800000fa, 0x00000020,
  0x0000002a, 0x80000177, 0x00000040, 0x80000003,
  0x5555557f, 0x00000060, 0x80000006, 0x00000002,
  0x55555560, 0x80000009, 0x00000004, 0x80000001,
  0x80000009, 0x00000004, 0x80000001, 0x00000000,
  0x00000006, 0x80000002, 0x00000000, 0x80000000,
  0x80000003, 0x00000000, 0x7fffffff, 0x00000000,
  0x00000000, 0x7ffffffe, 0xfffffffe, 0x00000000,
  0x7ffffffd, 0xfffffffc, 0xffffffe0, 0x80000000,
  0xfffffffa, 0xffffffc0, 0x7fffff83, 0x00000000,
  0xffffffa0, 0x7fffff06, 0xffffff82, 0x80000000,
  0x7ffffe89, 0xffffff04, 0x7fffff81, 0x80000000,
  0xfffffe86, 0x7fffff02, 0x7fff8003, 0x00000000,
  0x7ffffe83, 0x7fff0006, 0xffff8002, 0x80000000,
  0x7ffe8009, 0xffff0004, 0x7fff8001, 0x80000000,
  0xfffe8006, 0x7fff0002, 0x4ccccccd, 0x80000000,
  0x7ffe8003, 0x1999999a, 0x2aaaaaab, 0x80000000,
  0xe6666667, 0xd5555556, 0x00000003, 0x00000000,
  0x80000001, 0x80000006, 0x80000002, 0x80000000,
  0x00000009, 0x00000004, 0x00000001, 0x00000000,
  0x80000006, 0x80000002, 0x80000000, 0x80000000,
  0x00000003, 0x00000000, 0xffffffff, 0x00000000,
  0x80000000, 0x7ffffffe, 0x55555556, 0x00000000,
  0xfffffffd, 0xaaaaaaac, 0x33333334, 0x00000000,
  0x00000002, 0x66666668, 0x00008000, 0x80000000,
  0x9999999c, 0x00010000, 0x80007fff, 0x00000000,
  0x00018000, 0x8000fffe, 0x00007ffe, 0x80000000,
  0x80017ffd, 0x0000fffc, 0x80007ffd, 0x00000000,
  0x00017ffa, 0x8000fffa, 0x00000080, 0x80000000,
  0x80017ff7, 0x00000100, 0x8000007f, 0x00000000,
  0x00000180, 0x800000fe, 0x0000007e, 0x80000000,
  0x8000017d, 0x000000fc, 0x8000007d, 0x00000000,
  0x0000017a, 0x800000fa, 0x00000020, 0x80000000,
  0x80000177, 0x00000040, 0x80000003, 0x00000000,
  0x00000060, 0x80000006, 0x00000002, 0x80000000,
  0x80000006, 0x00000002, 0x80000000, 0x00000000,
  0x00000004, 0x80000001, 0x00000000, 0x80000001,
  0x80000002, 0x00000000, 0x80000000, 0x00000002,
  0x00000000, 0x7fffffff, 0x00000000, 0x00000020,
  0x7ffffffe, 0xfffffffe, 0x00000000, 0x8000007d,
  0xfffffffc, 0xffffffe0, 0x80000000, 0x0000007e,
  0xffffffc0, 0x7fffff83, 0x00000000, 0x8000007f,
  0x7fffff06, 0xffffff82, 0x80000000, 0x80007ffd,
  0xffffff04, 0x7fffff81, 0x80000000, 0x00007ffe,
  0x7fffff02, 0x7fff8003, 0x00000000, 0x80007fff,
  0x7fff0006, 0xffff8002, 0x80000000, 0xb3333333,
  0xffff0004, 0x7fff8001, 0x80000000, 0xd5555555,
  0x7fff0002, 0x4ccccccd, 0x80000000, 0xfffffffd,
  0x1999999a, 0x2aaaaaab, 0x80000000, 0x7ffffffe,
  0xd5555556, 0x00000003, 0x00000000, 0xffffffff,
  0x80000006, 0x80000002, 0x80000000, 0x80000000,
  0x00000004, 0x00000001, 0x00000000, 0x00000001,
  0x80000002, 0x80000000, 0x80000000, 0xaaaaaaaa,
  0x00000000, 0xffffffff, 0x00000000, 0xcccccccc,
  0x7ffffffe, 0x55555556, 0x00000000, 0xffff8000,
  0xaaaaaaac, 0x33333334, 0x00000000, 0x7fff8001,
  0x66666668, 0x00008000, 0x80000000, 0xffff8002,
  0x00010000, 0x80007fff, 0x00000000, 0x7fff8003,
  0x8000fffe, 0x00007ffe, 0x80000000, 0xffffff80,
  0x0000fffc, 0x80007ffd, 0x00000000, 0x7fffff81,
  0x8000fffa, 0x00000080, 0x80000000, 0xffffff82,
  0x00000100, 0x8000007f, 0x00000000, 0x7fffff83,
  0x800000fe, 0x0000007e, 0x80000000, 0xffffffe0,
  0x000000fc, 0x8000007d, 0x00000000, 0x7ffffffd,
  0x800000fa, 0x00000020, 0x80000000, 0xfffffffe,
  0x00000040, 0x80000003, 0x00000000, 0x7fffffff,
  0x80000003, 0x00000000, 0x7fffffff, 0x00000000,
  0x00000002, 0x80000000, 0x00000000, 0xaaaaaaaa,
  0x80000001, 0x00000000, 0x80000001, 0x55555554,
  0x00000000, 0x80000000, 0x00000002, 0x55555540,
  0x7fffffff, 0x00000000, 0x00000020, 0x55555502,
  0xfffffffe, 0x00000000, 0x8000007d, 0xffffffac,
  0xffffffe0, 0x80000000, 0x0000007e, 0xaaaaaa56,
  0x7fffff83, 0x00000000, 0x8000007f, 0x55550002,
  0xffffff82, 0x80000000, 0x80007ffd, 0xffffaaac,
  0x7fffff81, 0x80000000, 0x00007ffe, 0xaaaa5556,
  0x7fff8003, 0x00000000, 0x80007fff, 0xddddddde,
  0xffff8002, 0x80000000, 0xb3333333, 0x71c71c72,
  0x7fff8001, 0x80000000, 0xd5555555, 0x00000002,
  0x4ccccccd, 0x80000000, 0xfffffffd, 0xaaaaaaac,
  0x2aaaaaab, 0x80000000, 0x7ffffffe, 0x55555556,
  0x00000003, 0x00000000, 0xffffffff, 0x00000000,
  0x80000002, 0x80000000, 0x80000000, 0xaaaaaaaa,
  0x00000001, 0x00000000, 0x00000001, 0xe38e38e4,
  0x80000000, 0x80000000, 0xaaaaaaaa, 0x77777778,
  0xffffffff, 0x00000000, 0xcccccccc, 0xaaab0000,
  0x55555556, 0x00000000, 0xffff8000, 0x5555aaaa,
  0x33333334, 0x00000000, 0x7fff8001, 0x00005554,
  0x00008000, 0x80000000, 0xffff8002, 0xaaaafffe,
  0x80007fff, 0x00000000, 0x7fff8003, 0xaaaaab00,
  0x00007ffe, 0x80000000, 0xffffff80, 0x555555aa,
  0x80007ffd, 0x00000000, 0x7fffff81, 0x00000054,
  0x00000080, 0x80000000, 0xffffff82, 0xaaaaaafe,
  0x8000007f, 0x00000000, 0x7fffff83, 0xaaaaaac0,
  0x0000007e, 0x80000000, 0xffffffe0, 0x00000002,
  0x8000007d, 0x00000000, 0x7ffffffd, 0xaaaaaaac,
  0x00000020, 0x80000000, 0xfffffffe, 0x55555556,
  0x80000000, 0xfffffffe, 0x55555556, 0x00000000,
  0x00000000, 0x7fffffff, 0x00000000, 0xcccccccc,
  0x80000000, 0x00000000, 0xaaaaaaaa, 0x99999998,
  0x00000000, 0x80000001, 0x55555554, 0x99999980,
  0x80000000, 0x00000002, 0x55555540, 0xffffff9c,
  0x00000000, 0x00000020, 0x55555502, 0xcccccc68,
  0x00000000, 0x8000007d, 0xffffffac, 0x99999934,
  0x80000000, 0x0000007e, 0xaaaaaa56, 0xffff999c,
  0x00000000, 0x8000007f, 0x55550002, 0xcccc6668,
  0x80000000, 0x80007ffd, 0xffffaaac, 0x99993334,
  0x80000000, 0x00007ffe, 0xaaaa5556, 0x0a3d70a4,
  0x00000000, 0x80007fff, 0xddddddde, 0xbbbbbbbc,
  0x80000000, 0xb3333333, 0x71c71c72, 0x9999999c,
  0x80000000, 0xd5555555, 0x00000002, 0x66666668,
  0x80000000, 0xfffffffd, 0xaaaaaaac, 0x33333334,
  0x80000000, 0x7ffffffe, 0x55555556, 0x00000000,
  0x00000000, 0xffffffff, 0x00000000, 0xcccccccc,
  0x80000000, 0x80000000, 0xaaaaaaaa, 0x77777778,
  0x00000000, 0x00000001, 0xe38e38e4, 0x28f5c290,
  0x80000000, 0xaaaaaaaa, 0x77777778, 0x999a0000,
  0x00000000, 0xcccccccc, 0xaaab0000, 0x6666cccc,
  0x00000000, 0xffff8000, 0x5555aaaa, 0x33339998,
  0x00000000, 0x7fff8001, 0x00005554, 0x00006664,
  0x80000000, 0xffff8002, 0xaaaafffe, 0x99999a00,
  0x00000000, 0x7fff8003, 0xaaaaab00, 0x666666cc,
  0x80000000, 0xffffff80, 0x555555aa, 0x33333398,
  0x00000000, 0x7fffff81, 0x00000054, 0x00000064,
  0x80000000, 0xffffff82, 0xaaaaaafe, 0x66666680,
  0x00000000, 0x7fffff83, 0xaaaaaac0, 0x9999999c,
  0x80000000, 0xffffffe0, 0x00000002, 0x66666668,
  0x00000000, 0x7ffffffd, 0xaaaaaaac, 0x33333334,
  0x7ffffffd, 0xaaaaaaac, 0x33333334, 0x00000000,
  0xfffffffe, 0x55555556, 0x00000000, 0xffff8000,
  0x7fffffff, 0x00000000, 0xcccccccc, 0xffff0000,
  0x00000000, 0xaaaaaaaa, 0x99999998, 0xfff00000,
  0x80000001, 0x55555554, 0x99999980, 0xffc18000,
  0x00000002, 0x55555540, 0xffffff9c, 0xffc10000,
  0x00000020, 0x55555502, 0xcccccc68, 0xffc08000,
  0x8000007d, 0xffffffac, 0x99999934, 0xc0018000,
  0x0000007e, 0xaaaaaa56, 0xffff999c, 0xc0010000,
  0x8000007f, 0x55550002, 0xcccc6668, 0xc0008000,
  0x80007ffd, 0xffffaaac, 0x99993334, 0x66668000,
  0x00007ffe, 0xaaaa5556, 0x0a3d70a4, 0x55558000,
  0x80007fff, 0xddddddde, 0xbbbbbbbc, 0x00018000,
  0xb3333333, 0x71c71c72, 0x9999999c, 0x00010000,
  0xd5555555, 0x00000002, 0x66666668, 0x00008000,
  0xfffffffd, 0xaaaaaaac, 0x33333334, 0x00000000,
  0x7ffffffe, 0x55555556, 0x00000000, 0xffff8000,
  0xffffffff, 0x00000000, 0xcccccccc, 0xaaab0000,
  0x80000000, 0xaaaaaaaa, 0x77777778, 0x999a0000,
  0x00000001, 0xe38e38e4, 0x28f5c290, 0x40000000,
  0xaaaaaaaa, 0x77777778, 0x999a0000, 0x3fff8000,
  0xcccccccc, 0xaaab0000, 0x6666cccc, 0x3fff0000,
  0xffff8000, 0x5555aaaa, 0x33339998, 0x3ffe8000,
  0x7fff8001, 0x00005554, 0x00006664, 0x00400000,
  0xffff8002, 0xaaaafffe, 0x99999a00, 0x003f8000,
  0x7fff8003, 0xaaaaab00, 0x666666cc, 0x003f0000,
  0xffffff80, 0x555555aa, 0x33333398, 0x003e8000,
  0x7fffff81, 0x00000054, 0x00000064, 0x00100000,
  0xffffff82, 0xaaaaaafe, 0x66666680, 0x00018000,
  0x7fffff83, 0xaaaaaac0, 0x9999999c, 0x00010000,
  0xffffffe0, 0x00000002, 0x66666668, 0x00008000,
  0x00000002, 0x66666668, 0x00008000, 0x00000000,
  0xaaaaaaac, 0x33333334, 0x00000000, 0xffff8001,
  0x55555556, 0x00000000, 0xffff8000, 0xffff0002,
  0x00000000, 0xcccccccc, 0xffff0000, 0xfff00020,
  0xaaaaaaaa, 0x99999998, 0xfff00000, 0xffc1807d,
  0x55555554, 0x99999980, 0xffc18000, 0xffc1007e,
  0x55555540, 0xffffff9c, 0xffc10000, 0xffc0807f,
  0x55555502, 0xcccccc68, 0xffc08000, 0xc001fffd,
  0xffffffac, 0x99999934, 0xc0018000, 0xc0017ffe,
  0xaaaaaa56, 0xffff999c, 0xc0010000, 0xc000ffff,
  0x55550002, 0xcccc6668, 0xc0008000, 0x9999b333,
  0xffffaaac, 0x99993334, 0x66668000, 0xaaaad555,
  0xaaaa5556, 0x0a3d70a4, 0x55558000, 0x80017ffd,
  0xddddddde, 0xbbbbbbbc, 0x00018000, 0x8000fffe,
  0x71c71c72, 0x9999999c, 0x00010000, 0x80007fff,
  0x00000002, 0x66666668, 0x00008000, 0x80000000,
  0xaaaaaaac, 0x33333334, 0x00000000, 0x7fff8001,
  0x55555556, 0x00000000, 0xffff8000, 0x5555aaaa,
  0x00000000, 0xcccccccc, 0xaaab0000, 0x6666cccc,
  0xaaaaaaaa, 0x77777778, 0x999a0000, 0x3fff8000,
  0xe38e38e4, 0x28f5c290, 0x40000000, 0x3fff0001,
  0x77777778, 0x999a0000, 0x3fff8000, 0x3ffe8002,
  0xaaab0000, 0x6666cccc, 0x3fff0000, 0x3ffe0003,
  0x5555aaaa, 0x33339998, 0x3ffe8000, 0x003fff80,
  0x00005554, 0x00006664, 0x00400000, 0x003f7f81,
  0xaaaafffe, 0x99999a00, 0x003f8000, 0x003eff82,
  0xaaaaab00, 0x666666cc, 0x003f0000, 0x003e7f83,
  0x555555aa, 0x33333398, 0x003e8000, 0x000fffe0,
  0x00000054, 0x00000064, 0x00100000, 0x00017ffd,
  0xaaaaaafe, 0x66666680, 0x00018000, 0x0000fffe,
  0xaaaaaac0, 0x9999999c, 0x00010000, 0x00007fff,
  0x9999999c, 0x00010000, 0x00007fff, 0x00000000,
  0x66666668, 0x00008000, 0x00000000, 0xffff8002,
  0x33333334, 0x00000000, 0xffff8001, 0xffff0004,
  0x00000000, 0xffff8000, 0xffff0002, 0xfff00040,
  0xcccccccc, 0xffff0000, 0xfff00020, 0xffc180fa,
  0x99999998, 0xfff00000, 0xffc1807d, 0xffc100fc,
  0x99999980, 0xffc18000, 0xffc1007e, 0xffc080fe,
  0xffffff9c, 0xffc10000, 0xffc0807f, 0xc0027ffa,
  0xcccccc68, 0xffc08000, 0xc001fffd, 0xc001fffc,
  0x99999934, 0xc0018000, 0xc0017ffe, 0xc0017ffe,
  0xffff999c, 0xc0010000, 0xc000ffff, 0xcccce666,
  0xcccc6668, 0xc0008000, 0x9999b333, 0x00002aaa,
  0x99993334, 0x66668000, 0xaaaad555, 0x00017ffa,
  0x0a3d70a4, 0x55558000, 0x80017ffd, 0x0000fffc,
  0xbbbbbbbc, 0x00018000, 0x8000fffe, 0x00007ffe,
  0x9999999c, 0x00010000, 0x80007fff, 0x00000000,
  0x66666668, 0x00008000, 0x80000000, 0xffff8002,
  0x33333334, 0x00000000, 0x7fff8001, 0x00005554,
  0x00000000, 0xffff8000, 0x5555aaaa, 0x33339998,
  0xcccccccc, 0xaaab0000, 0x6666cccc, 0x3fff0000,
  0x77777778, 0x999a0000, 0x3fff8000, 0x3ffe8002,
  0x28f5c290, 0x40000000, 0x3fff0001, 0x3ffe0004,
  0x999a0000, 0x3fff8000, 0x3ffe8002, 0x3ffd8006,
  0x6666cccc, 0x3fff0000, 0x3ffe0003, 0x003fff00,
  0x33339998, 0x3ffe8000, 0x003fff80, 0x003f7f02,
  0x00006664, 0x00400000, 0x003f7f81, 0x003eff04,
  0x99999a00, 0x003f8000, 0x003eff82, 0x003e7f06,
  0x666666cc, 0x003f0000, 0x003e7f83, 0x000fffc0,
  0x33333398, 0x003e8000, 0x000fffe0, 0x00017ffa,
  0x00000064, 0x00100000, 0x00017ffd, 0x0000fffc,
  0x66666680, 0x00018000, 0x0000fffe, 0x00007ffe,
  0x00018000, 0x0000fffe, 0x00007ffe, 0x00000000,
  0x00010000, 0x00007fff, 0x00000000, 0xffff8003,
  0x00008000, 0x00000000, 0xffff8002, 0xffff0006,
  0x00000000, 0xffff8001, 0xffff0004, 0xfff00060,
  0xffff8000, 0xffff0002, 0xfff00040, 0xffc18177,
  0xffff0000, 0xfff00020, 0xffc180fa, 0xffc1017a,
  0xfff00000, 0xffc1807d, 0xffc100fc, 0xffc0817d,
  0xffc18000, 0xffc1007e, 0xffc080fe, 0xc002fff7,
  0xffc10000, 0xffc0807f, 0xc0027ffa, 0xc0027ffa,
  0xffc08000, 0xc001fffd, 0xc001fffc, 0xc001fffd,
  0xc0018000, 0xc0017ffe, 0xc0017ffe, 0x00001999,
  0xc0010000, 0xc000ffff, 0xcccce666, 0x55557fff,
  0xc0008000, 0x9999b333, 0x00002aaa, 0x80017ff7,
  0x66668000, 0xaaaad555, 0x00017ffa, 0x8000fffa,
  0x55558000, 0x80017ffd, 0x0000fffc, 0x80007ffd,
  0x00018000, 0x8000fffe, 0x00007ffe, 0x80000000,
  0x00010000, 0x80007fff, 0x00000000, 0x7fff8003,
  0x00008000, 0x80000000, 0xffff8002, 0xaaaafffe,
  0x00000000, 0x7fff8001, 0x00005554, 0x00006664,
  0xffff8000, 0x5555aaaa, 0x33339998, 0x3ffe8000,
  0xaaab0000, 0x6666cccc, 0x3fff0000, 0x3ffe0003,
  0x999a0000, 0x3fff8000, 0x3ffe8002, 0x3ffd8006,
  0x40000000, 0x3fff0001, 0x3ffe0004, 0x3ffd0009,
  0x3fff8000, 0x3ffe8002, 0x3ffd8006, 0x003ffe80,
  0x3fff0000, 0x3ffe0003, 0x003fff00, 0x003f7e83,
  0x3ffe8000, 0x003fff80, 0x003f7f02, 0x003efe86,
  0x00400000, 0x003f7f81, 0x003eff04, 0x003e7e89,
  0x003f8000, 0x003eff82, 0x003e7f06, 0x000fffa0,
  0x003f0000, 0x003e7f83, 0x000fffc0, 0x00017ff7,
  0x003e8000, 0x000fffe0, 0x00017ffa, 0x0000fffa,
  0x00100000, 0x00017ffd, 0x0000fffc, 0x00007ffd,
  0x00017ffd, 0x0000fffc, 0x00007ffd, 0x00000000,
  0x0000fffe, 0x00007ffe, 0x00000000, 0xffffff80,
  0x00007fff, 0x00000000, 0xffff8003, 0xffffff00,
  0x00000000, 0xffff8002, 0xffff0006, 0xfffff000,
  0xffff8001, 0xffff0004, 0xfff00060, 0xffffc180,
  0xffff0002, 0xfff00040, 0xffc18177, 0xffffc100,
  0xfff00020, 0xffc180fa, 0xffc1017a, 0xffffc080,
  0xffc1807d, 0xffc100fc, 0xffc0817d, 0xffc00180,
  0xffc1007e, 0xffc080fe, 0xc002fff7, 0xffc00100,
  0xffc0807f, 0xc0027ffa, 0xc0027ffa, 0xffc00080,
  0xc001fffd, 0xc001fffc, 0xc001fffd, 0x66666680,
  0xc0017ffe, 0xc0017ffe, 0x00001999, 0x55555580,
  0xc000ffff, 0xcccce666, 0x55557fff, 0x00000180,
  0x9999b333, 0x00002aaa, 0x80017ff7, 0x00000100,
  0xaaaad555, 0x00017ffa, 0x8000fffa, 0x00000080,
  0x80017ffd, 0x0000fffc, 0x80007ffd, 0x00000000,
  0x8000fffe, 0x00007ffe, 0x80000000, 0xffffff80,
  0x80007fff, 0x00000000, 0x7fff8003, 0xaaaaab00,
  0x80000000, 0xffff8002, 0xaaaafffe, 0x99999a00,
  0x7fff8001, 0x00005554, 0x00006664, 0x00400000,
  0x5555aaaa, 0x33339998, 0x3ffe8000, 0x003fff80,
  0x6666cccc, 0x3fff0000, 0x3ffe0003, 0x003fff00,
  0x3fff8000, 0x3ffe8002, 0x3ffd8006, 0x003ffe80,
  0x3fff0001, 0x3ffe0004, 0x3ffd0009, 0x00004000,
  0x3ffe8002, 0x3ffd8006, 0x003ffe80, 0x00003f80,
  0x3ffe0003, 0x003fff00, 0x003f7e83, 0x00003f00,
  0x003fff80, 0x003f7f02, 0x003efe86, 0x00003e80,
  0x003f7f81, 0x003eff04, 0x003e7e89, 0x00001000,
  0x003eff82, 0x003e7f06, 0x000fffa0, 0x00000180,
  0x003e7f83, 0x000fffc0, 0x00017ff7, 0x00000100,
  0x000fffe0, 0x00017ffa, 0x0000fffa, 0x00000080,
  0x00017ffa, 0x0000fffa, 0x00000080, 0x00000000,
  0x0000fffc, 0x00007ffd, 0x00000000, 0xffffff81,
  0x00007ffe, 0x00000000, 0xffffff80, 0xffffff02,
  0x00000000, 0xffff8003, 0xffffff00, 0xfffff020,
  0xffff8002, 0xffff0006, 0xfffff000, 0xffffc1fd,
  0xffff0004, 0xfff00060, 0xffffc180, 0xffffc17e,
  0xfff00040, 0xffc18177, 0xffffc100, 0xffffc0ff,
  0xffc180fa, 0xffc1017a, 0xffffc080, 0xffc0817d,
  0xffc100fc, 0xffc0817d, 0xffc00180, 0xffc080fe,
  0xffc080fe, 0xc002fff7, 0xffc00100, 0xffc0807f,
  0xc0027ffa, 0xc0027ffa, 0xffc00080, 0x999999b3,
  0xc001fffc, 0xc001fffd, 0x66666680, 0xaaaaaad5,
  0xc0017ffe, 0x00001999, 0x55555580, 0x8000017d,
  0xcccce666, 0x55557fff, 0x00000180, 0x800000fe,
  0x00002aaa, 0x80017ff7, 0x00000100, 0x8000007f,
  0x00017ffa, 0x8000fffa, 0x00000080, 0x80000000,
  0x0000fffc, 0x80007ffd, 0x00000000, 0x7fffff81,
  0x00007ffe, 0x80000000, 0xffffff80, 0x555555aa,
  0x00000000, 0x7fff8003, 0xaaaaab00, 0x666666cc,
  0xffff8002, 0xaaaafffe, 0x99999a00, 0x003f8000,
  0x00005554, 0x00006664, 0x00400000, 0x003f7f81,
  0x33339998, 0x3ffe8000, 0x003fff80, 0x003f7f02,
  0x3fff0000, 0x3ffe0003, 0x003fff00, 0x003f7e83,
  0x3ffe8002, 0x3ffd8006, 0x003ffe80, 0x00003f80,
  0x3ffe0004, 0x3ffd0009, 0x00004000, 0x00003f01,
  0x3ffd8006, 0x003ffe80, 0x00003f80, 0x00003e82,
  0x003fff00, 0x003f7e83, 0x00003f00, 0x00003e03,
  0x003f7f02, 0x003efe86, 0x00003e80, 0x00000fe0,
  0x003eff04, 0x003e7e89, 0x00001000, 0x0000017d,
  0x003e7f06, 0x000fffa0, 0x00000180, 0x000000fe,
  0x000fffc0, 0x00017ff7, 0x00000100, 0x0000007f,
  0x00017ff7, 0x00000100, 0x0000007f, 0x00000000,
  0x0000fffa, 0x00000080, 0x00000000, 0xffffff82,
  0x00007ffd, 0x00000000, 0xffffff81, 0xffffff04,
  0x00000000, 0xffffff80, 0xffffff02, 0xfffff040,
  0xffff8003, 0xffffff00, 0xfffff020, 0xffffc27a,
  0xffff0006, 0xfffff000, 0xffffc1fd, 0xffffc1fc,
  0xfff00060, 0xffffc180, 0xffffc17e, 0xffffc17e,
  0xffc18177, 0xffffc100, 0xffffc0ff, 0xffc1017a,
  0xffc1017a, 0xffffc080, 0xffc0817d, 0xffc100fc,
  0xffc0817d, 0xffc00180, 0xffc080fe, 0xffc1007e,
  0xc002fff7, 0xffc00100, 0xffc0807f, 0xcccccce6,
  0xc0027ffa, 0xffc00080, 0x999999b3, 0x0000002a,
  0xc001fffd, 0x66666680, 0xaaaaaad5, 0x0000017a,
  0x00001999, 0x55555580, 0x8000017d, 0x000000fc,
  0x55557fff, 0x00000180, 0x800000fe, 0x0000007e,
  0x80017ff7, 0x00000100, 0x8000007f, 0x00000000,
  0x8000fffa, 0x00000080, 0x80000000, 0xffffff82,
  0x80007ffd, 0x00000000, 0x7fffff81, 0x00000054,
  0x80000000, 0xffffff80, 0x555555aa, 0x33333398,
  0x7fff8003, 0xaaaaab00, 0x666666cc, 0x003f0000,
  0xaaaafffe, 0x99999a00, 0x003f8000, 0x003eff82,
  0x00006664, 0x00400000, 0x003f7f81, 0x003eff04,
  0x3ffe8000, 0x003fff80, 0x003f7f02, 0x003efe86,
  0x3ffe0003, 0x003fff00, 0x003f7e83, 0x00003f00,
  0x3ffd8006, 0x003ffe80, 0x00003f80, 0x00003e82,
  0x3ffd0009, 0x00004000, 0x00003f01, 0x00003e04,
  0x003ffe80, 0x00003f80, 0x00003e82, 0x00003d86,
  0x003f7e83, 0x00003f00, 0x00003e03, 0x00000fc0,
  0x003efe86, 0x00003e80, 0x00000fe0, 0x0000017a,
  0x003e7e89, 0x00001000, 0x0000017d, 0x000000fc,
  0x000fffa0, 0x00000180, 0x000000fe, 0x0000007e,
  0x00000180, 0x000000fe, 0x0000007e, 0x00000000,
  0x00000100, 0x0000007f, 0x00000000, 0xffffff83,
  0x00000080, 0x00000000, 0xffffff82, 0xffffff06,
  0x00000000, 0xffffff81, 0xffffff04, 0xfffff060,
  0xffffff80, 0xffffff02, 0xfffff040, 0xffffc2f7,
  0xffffff00, 0xfffff020, 0xffffc27a, 0xffffc27a,
  0xfffff000, 0xffffc1fd, 0xffffc1fc, 0xffffc1fd,
  0xffffc180, 0xffffc17e, 0xffffc17e, 0xffc18177,
  0xffffc100, 0xffffc0ff, 0xffc1017a, 0xffc180fa,
  0xffffc080, 0xffc0817d, 0xffc100fc, 0xffc1807d,
  0xffc00180, 0xffc080fe, 0xffc1007e, 0x00000019,
  0xffc00100, 0xffc0807f, 0xcccccce6, 0x5555557f,
  0xffc00080, 0x999999b3, 0x0000002a, 0x80000177,
  0x66666680, 0xaaaaaad5, 0x0000017a, 0x800000fa,
  0x55555580, 0x8000017d, 0x000000fc, 0x8000007d,
  0x00000180, 0x800000fe, 0x0000007e, 0x80000000,
  0x00000100, 0x8000007f, 0x00000000, 0x7fffff83,
  0x00000080, 0x80000000, 0xffffff82, 0xaaaaaafe,
  0x00000000, 0x7fffff81, 0x00000054, 0x00000064,
  0xffffff80, 0x555555aa, 0x33333398, 0x003e8000,
  0xaaaaab00, 0x666666cc, 0x003f0000, 0x003e7f83,
  0x99999a00, 0x003f8000, 0x003eff82, 0x003e7f06,
  0x00400000, 0x003f7f81, 0x003eff04, 0x003e7e89,
  0x003fff80, 0x003f7f02, 0x003efe86, 0x00003e80,
  0x003fff00, 0x003f7e83, 0x00003f00, 0x00003e03,
  0x003ffe80, 0x00003f80, 0x00003e82, 0x00003d86,
  0x00004000, 0x00003f01, 0x00003e04, 0x00003d09,
  0x00003f80, 0x00003e82, 0x00003d86, 0x00000fa0,
  0x00003f00, 0x00003e03, 0x00000fc0, 0x00000177,
  0x00003e80, 0x00000fe0, 0x0000017a, 0x000000fa,
  0x00001000, 0x0000017d, 0x000000fc, 0x0000007d,
  0x0000017d, 0x000000fc, 0x0000007d, 0x00000000,
  0x000000fe, 0x0000007e, 0x00000000, 0xffffffe0,
  0x0000007f, 0x00000000, 0xffffff83, 0xffffffc0,
  0x00000000, 0xffffff82, 0xffffff06, 0xfffffc00,
  0xffffff81, 0xffffff04, 0xfffff060, 0xfffff060,
  0xffffff02, 0xfffff040, 0xffffc2f7, 0xfffff040,
  0xfffff020, 0xffffc27a, 0xffffc27a, 0xfffff020,
  0xffffc1fd, 0xffffc1fc, 0xffffc1fd, 0xfff00060,
  0xffffc17e, 0xffffc17e, 0xffc18177, 0xfff00040,
  0xffffc0ff, 0xffc1017a, 0xffc180fa, 0xfff00020,
  0xffc0817d, 0xffc100fc, 0xffc1807d, 0x999999a0,
  0xffc080fe, 0xffc1007e, 0x00000019, 0x55555560,
  0xffc0807f, 0xcccccce6, 0x5555557f, 0x00000060,
  0x999999b3, 0x0000002a, 0x80000177, 0x00000040,
  0xaaaaaad5, 0x0000017a, 0x800000fa, 0x00000020,
  0x8000017d, 0x000000fc, 0x8000007d, 0x00000000,
  0x800000fe, 0x0000007e, 0x80000000, 0xffffffe0,
  0x8000007f, 0x00000000, 0x7fffff83, 0xaaaaaac0,
  0x80000000, 0xffffff82, 0xaaaaaafe, 0x66666680,
  0x7fffff81, 0x00000054, 0x00000064, 0x00100000,
  0x555555aa, 0x33333398, 0x003e8000, 0x000fffe0,
  0x666666cc, 0x003f0000, 0x003e7f83, 0x000fffc0,
  0x003f8000, 0x003eff82, 0x003e7f06, 0x000fffa0,
  0x003f7f81, 0x003eff04, 0x003e7e89, 0x00001000,
  0x003f7f02, 0x003efe86, 0x00003e80, 0x00000fe0,
  0x003f7e83, 0x00003f00, 0x00003e03, 0x00000fc0,
  0x00003f80, 0x00003e82, 0x00003d86, 0x00000fa0,
  0x00003f01, 0x00003e04, 0x00003d09, 0x00000400,
  0x00003e82, 0x00003d86, 0x00000fa0, 0x00000060,
  0x00003e03, 0x00000fc0, 0x00000177, 0x00000040,
  0x00000fe0, 0x0000017a, 0x000000fa, 0x00000020,
  0x0000017a, 0x000000fa, 0x00000020, 0x00000000,
  0x000000fc, 0x0000007d, 0x00000000, 0xfffffffd,
  0x0000007e, 0x00000000, 0xffffffe0, 0xfffffffa,
  0x00000000, 0xffffff83, 0xffffffc0, 0xffffffa0,
  0xffffff82, 0xffffff06, 0xfffffc00, 0xfffffe89,
  0xffffff04, 0xfffff060, 0xfffff060, 0xfffffe86,
  0xfffff040, 0xffffc2f7, 0xfffff040, 0xfffffe83,
  0xffffc27a, 0xffffc27a, 0xfffff020, 0xfffe8009,
  0xffffc1fc, 0xffffc1fd, 0xfff00060, 0xfffe8006,
  0xffffc17e, 0xffc18177, 0xfff00040, 0xfffe8003,
  0xffc1017a, 0xffc180fa, 0xfff00020, 0x66666667,
  0xffc100fc, 0xffc1807d, 0x999999a0, 0x00000001,
  0xffc1007e, 0x00000019, 0x55555560, 0x80000009,
  0xcccccce6, 0x5555557f, 0x00000060, 0x80000006,
  0x0000002a, 0x80000177, 0x00000040, 0x80000003,
  0x0000017a, 0x800000fa, 0x00000020, 0x80000000,
  0x000000fc, 0x8000007d, 0x00000000, 0x7ffffffd,
  0x0000007e, 0x80000000, 0xffffffe0, 0x00000002,
  0x00000000, 0x7fffff83, 0xaaaaaac0, 0x9999999c,
  0xffffff82, 0xaaaaaafe, 0x66666680, 0x00018000,
  0x00000054, 0x00000064, 0x00100000, 0x00017ffd,
  0x33333398, 0x003e8000, 0x000fffe0, 0x00017ffa,
  0x003f0000, 0x003e7f83, 0x000fffc0, 0x00017ff7,
  0x003eff82, 0x003e7f06, 0x000fffa0, 0x00000180,
  0x003eff04, 0x003e7e89, 0x00001000, 0x0000017d,
  0x003efe86, 0x00003e80, 0x00000fe0, 0x0000017a,
  0x00003f00, 0x00003e03, 0x00000fc0, 0x00000177,
  0x00003e82, 0x00003d86, 0x00000fa0, 0x00000060,
  0x00003e04, 0x00003d09, 0x00000400, 0x00000009,
  0x00003d86, 0x00000fa0, 0x00000060, 0x00000006,
  0x00000fc0, 0x00000177, 0x00000040, 0x00000003,
  0x00000177, 0x00000040, 0x00000003, 0x00000000,
  0x000000fa, 0x00000020, 0x00000000, 0xfffffffe,
  0x0000007d, 0x00000000, 0xfffffffd, 0xfffffffc,
  0x00000000, 0xffffffe0, 0xfffffffa, 0xffffffc0,
  0xffffff83, 0xffffffc0, 0xffffffa0, 0xffffff06,
  0xffffff06, 0xfffffc00, 0xfffffe89, 0xffffff04,
  0xfffff060, 0xfffff060, 0xfffffe86, 0xffffff02,
  0xffffc2f7, 0xfffff040, 0xfffffe83, 0xffff0006,
  0xffffc27a, 0xfffff020, 0xfffe8009, 0xffff0004,
  0xffffc1fd, 0xfff00060, 0xfffe8006, 0xffff0002,
  0xffc18177, 0xfff00040, 0xfffe8003, 0x9999999a,
  0xffc180fa, 0xfff00020, 0x66666667, 0x55555556,
  0xffc1807d, 0x999999a0, 0x00000001, 0x00000006,
  0x00000019, 0x55555560, 0x80000009, 0x00000004,
  0x5555557f, 0x00000060, 0x80000006, 0x00000002,
  0x80000177, 0x00000040, 0x80000003, 0x00000000,
  0x800000fa, 0x00000020, 0x80000000, 0xfffffffe,
  0x8000007d, 0x00000000, 0x7ffffffd, 0xaaaaaaac,
  0x80000000, 0xffffffe0, 0x00000002, 0x66666668,
  0x7fffff83, 0xaaaaaac0, 0x9999999c, 0x00010000,
  0xaaaaaafe, 0x66666680, 0x00018000, 0x0000fffe,
  0x00000064, 0x00100000, 0x00017ffd, 0x0000fffc,
  0x003e8000, 0x000fffe0, 0x00017ffa, 0x0000fffa,
  0x003e7f83, 0x000fffc0, 0x00017ff7, 0x00000100,
  0x003e7f06, 0x000fffa0, 0x00000180, 0x000000fe,
  0x003e7e89, 0x00001000, 0x0000017d, 0x000000fc,
  0x00003e80, 0x00000fe0, 0x0000017a, 0x000000fa,
  0x00003e03, 0x00000fc0, 0x00000177, 0x00000040,
  0x00003d86, 0x00000fa0, 0x00000060, 0x00000006,
  0x00003d09, 0x00000400, 0x00000009, 0x00000004,
  0x00000fa0, 0x00000060, 0x00000006, 0x00000002,
  0x00000060, 0x00000006, 0x00000002, 0x00000000,
  0x00000040, 0x00000003, 0x00000000, 0xffffffff,
  0x00000020, 0x00000000, 0xfffffffe, 0xfffffffe,
  0x00000000, 0xfffffffd, 0xfffffffc, 0xffffffe0,
  0xffffffe0, 0xfffffffa, 0xffffffc0, 0xffffff83,
  0xffffffc0, 0xffffffa0, 0xffffff06, 0xffffff82,
  0xfffffc00, 0xfffffe89, 0xffffff04, 0xffffff81,
  0xfffff060, 0xfffffe86, 0xffffff02, 0xffff8003,
  0xfffff040, 0xfffffe83, 0xffff0006, 0xffff8002,
  0xfffff020, 0xfffe8009, 0xffff0004, 0xffff8001,
  0xfff00060, 0xfffe8006, 0xffff0002, 0xcccccccd,
  0xfff00040, 0xfffe8003, 0x9999999a, 0xaaaaaaab,
  0xfff00020, 0x66666667, 0x55555556, 0x80000003,
  0x999999a0, 0x00000001, 0x00000006, 0x80000002,
  0x55555560, 0x80000009, 0x00000004, 0x80000001,
  0x00000060, 0x80000006, 0x00000002, 0x80000000,
  0x00000040, 0x80000003, 0x00000000, 0x7fffffff,
  0x00000020, 0x80000000, 0xfffffffe, 0x55555556,
  0x00000000, 0x7ffffffd, 0xaaaaaaac, 0x33333334,
  0xffffffe0, 0x00000002, 0x66666668, 0x00008000,
  0xaaaaaac0, 0x9999999c, 0x00010000, 0x00007fff,
  0x66666680, 0x00018000, 0x0000fffe, 0x00007ffe,
  0x00100000, 0x00017ffd, 0x0000fffc, 0x00007ffd,
  0x000fffe0, 0x00017ffa, 0x0000fffa, 0x00000080,
  0x000fffc0, 0x00017ff7, 0x00000100, 0x0000007f,
  0x000fffa0, 0x00000180, 0x000000fe, 0x0000007e,
  0x00001000, 0x0000017d, 0x000000fc, 0x0000007d,
  0x00000fe0, 0x0000017a, 0x000000fa, 0x00000020,
  0x00000fc0, 0x00000177, 0x00000040, 0x00000003,
  0x00000fa0, 0x00000060, 0x00000006, 0x00000002,
  0x00000400, 0x00000009, 0x00000004, 0x00000001,
};
const unsigned kExpectedCount_NEON_mul_4S = 961;

#endif  // VIXL_SIM_MUL_4S_TRACE_AARCH64_H_
