// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_ASSEMBLER_COND_RD_RN_OPERAND_RM_ADCS_A32_H_
#define VIXL_ASSEMBLER_COND_RD_RN_OPERAND_RM_ADCS_A32_H_

const byte kInstruction_adcs_le_r4_r5_r14[] = {
  0x0e, 0x40, 0xb5, 0xd0 // adcs le r4 r5 r14
};
const byte kInstruction_adcs_ge_r5_r11_r10[] = {
  0x0a, 0x50, 0xbb, 0xa0 // adcs ge r5 r11 r10
};
const byte kInstruction_adcs_ls_r0_r9_r9[] = {
  0x09, 0x00, 0xb9, 0x90 // adcs ls r0 r9 r9
};
const byte kInstruction_adcs_le_r8_r7_r2[] = {
  0x02, 0x80, 0xb7, 0xd0 // adcs le r8 r7 r2
};
const byte kInstruction_adcs_eq_r1_r10_r13[] = {
  0x0d, 0x10, 0xba, 0x00 // adcs eq r1 r10 r13
};
const byte kInstruction_adcs_le_r9_r12_r2[] = {
  0x02, 0x90, 0xbc, 0xd0 // adcs le r9 r12 r2
};
const byte kInstruction_adcs_pl_r6_r1_r5[] = {
  0x05, 0x60, 0xb1, 0x50 // adcs pl r6 r1 r5
};
const byte kInstruction_adcs_ge_r1_r12_r6[] = {
  0x06, 0x10, 0xbc, 0xa0 // adcs ge r1 r12 r6
};
const byte kInstruction_adcs_cc_r13_r12_r3[] = {
  0x03, 0xd0, 0xbc, 0x30 // adcs cc r13 r12 r3
};
const byte kInstruction_adcs_gt_r2_r4_r9[] = {
  0x09, 0x20, 0xb4, 0xc0 // adcs gt r2 r4 r9
};
const byte kInstruction_adcs_le_r3_r9_r10[] = {
  0x0a, 0x30, 0xb9, 0xd0 // adcs le r3 r9 r10
};
const byte kInstruction_adcs_gt_r11_r1_r9[] = {
  0x09, 0xb0, 0xb1, 0xc0 // adcs gt r11 r1 r9
};
const byte kInstruction_adcs_cc_r8_r6_r11[] = {
  0x0b, 0x80, 0xb6, 0x30 // adcs cc r8 r6 r11
};
const byte kInstruction_adcs_cs_r12_r9_r3[] = {
  0x03, 0xc0, 0xb9, 0x20 // adcs cs r12 r9 r3
};
const byte kInstruction_adcs_eq_r9_r14_r10[] = {
  0x0a, 0x90, 0xbe, 0x00 // adcs eq r9 r14 r10
};
const byte kInstruction_adcs_gt_r9_r0_r1[] = {
  0x01, 0x90, 0xb0, 0xc0 // adcs gt r9 r0 r1
};
const byte kInstruction_adcs_pl_r11_r8_r2[] = {
  0x02, 0xb0, 0xb8, 0x50 // adcs pl r11 r8 r2
};
const byte kInstruction_adcs_mi_r7_r1_r2[] = {
  0x02, 0x70, 0xb1, 0x40 // adcs mi r7 r1 r2
};
const byte kInstruction_adcs_vs_r8_r6_r7[] = {
  0x07, 0x80, 0xb6, 0x60 // adcs vs r8 r6 r7
};
const byte kInstruction_adcs_ne_r14_r2_r13[] = {
  0x0d, 0xe0, 0xb2, 0x10 // adcs ne r14 r2 r13
};
const byte kInstruction_adcs_hi_r3_r3_r8[] = {
  0x08, 0x30, 0xb3, 0x80 // adcs hi r3 r3 r8
};
const byte kInstruction_adcs_vc_r10_r8_r14[] = {
  0x0e, 0xa0, 0xb8, 0x70 // adcs vc r10 r8 r14
};
const byte kInstruction_adcs_ls_r2_r11_r0[] = {
  0x00, 0x20, 0xbb, 0x90 // adcs ls r2 r11 r0
};
const byte kInstruction_adcs_ge_r8_r10_r0[] = {
  0x00, 0x80, 0xba, 0xa0 // adcs ge r8 r10 r0
};
const byte kInstruction_adcs_mi_r8_r10_r5[] = {
  0x05, 0x80, 0xba, 0x40 // adcs mi r8 r10 r5
};
const byte kInstruction_adcs_pl_r1_r0_r9[] = {
  0x09, 0x10, 0xb0, 0x50 // adcs pl r1 r0 r9
};
const byte kInstruction_adcs_gt_r6_r7_r3[] = {
  0x03, 0x60, 0xb7, 0xc0 // adcs gt r6 r7 r3
};
const byte kInstruction_adcs_vs_r7_r9_r9[] = {
  0x09, 0x70, 0xb9, 0x60 // adcs vs r7 r9 r9
};
const byte kInstruction_adcs_al_r9_r4_r2[] = {
  0x02, 0x90, 0xb4, 0xe0 // adcs al r9 r4 r2
};
const byte kInstruction_adcs_le_r3_r1_r2[] = {
  0x02, 0x30, 0xb1, 0xd0 // adcs le r3 r1 r2
};
const byte kInstruction_adcs_mi_r6_r14_r0[] = {
  0x00, 0x60, 0xbe, 0x40 // adcs mi r6 r14 r0
};
const byte kInstruction_adcs_vc_r7_r10_r11[] = {
  0x0b, 0x70, 0xba, 0x70 // adcs vc r7 r10 r11
};
const byte kInstruction_adcs_hi_r13_r2_r10[] = {
  0x0a, 0xd0, 0xb2, 0x80 // adcs hi r13 r2 r10
};
const byte kInstruction_adcs_cs_r5_r4_r12[] = {
  0x0c, 0x50, 0xb4, 0x20 // adcs cs r5 r4 r12
};
const byte kInstruction_adcs_ls_r13_r9_r11[] = {
  0x0b, 0xd0, 0xb9, 0x90 // adcs ls r13 r9 r11
};
const byte kInstruction_adcs_ne_r2_r10_r12[] = {
  0x0c, 0x20, 0xba, 0x10 // adcs ne r2 r10 r12
};
const byte kInstruction_adcs_vc_r4_r6_r8[] = {
  0x08, 0x40, 0xb6, 0x70 // adcs vc r4 r6 r8
};
const byte kInstruction_adcs_lt_r13_r0_r13[] = {
  0x0d, 0xd0, 0xb0, 0xb0 // adcs lt r13 r0 r13
};
const byte kInstruction_adcs_pl_r11_r14_r5[] = {
  0x05, 0xb0, 0xbe, 0x50 // adcs pl r11 r14 r5
};
const byte kInstruction_adcs_cs_r8_r11_r3[] = {
  0x03, 0x80, 0xbb, 0x20 // adcs cs r8 r11 r3
};
const byte kInstruction_adcs_cs_r4_r1_r7[] = {
  0x07, 0x40, 0xb1, 0x20 // adcs cs r4 r1 r7
};
const byte kInstruction_adcs_al_r0_r12_r13[] = {
  0x0d, 0x00, 0xbc, 0xe0 // adcs al r0 r12 r13
};
const byte kInstruction_adcs_gt_r3_r6_r0[] = {
  0x00, 0x30, 0xb6, 0xc0 // adcs gt r3 r6 r0
};
const byte kInstruction_adcs_vc_r6_r9_r0[] = {
  0x00, 0x60, 0xb9, 0x70 // adcs vc r6 r9 r0
};
const byte kInstruction_adcs_cc_r2_r2_r12[] = {
  0x0c, 0x20, 0xb2, 0x30 // adcs cc r2 r2 r12
};
const byte kInstruction_adcs_cs_r4_r13_r1[] = {
  0x01, 0x40, 0xbd, 0x20 // adcs cs r4 r13 r1
};
const byte kInstruction_adcs_mi_r12_r12_r10[] = {
  0x0a, 0xc0, 0xbc, 0x40 // adcs mi r12 r12 r10
};
const byte kInstruction_adcs_hi_r8_r9_r14[] = {
  0x0e, 0x80, 0xb9, 0x80 // adcs hi r8 r9 r14
};
const byte kInstruction_adcs_hi_r4_r3_r7[] = {
  0x07, 0x40, 0xb3, 0x80 // adcs hi r4 r3 r7
};
const byte kInstruction_adcs_ne_r11_r10_r1[] = {
  0x01, 0xb0, 0xba, 0x10 // adcs ne r11 r10 r1
};
const byte kInstruction_adcs_cc_r2_r6_r3[] = {
  0x03, 0x20, 0xb6, 0x30 // adcs cc r2 r6 r3
};
const byte kInstruction_adcs_cs_r6_r6_r0[] = {
  0x00, 0x60, 0xb6, 0x20 // adcs cs r6 r6 r0
};
const byte kInstruction_adcs_vc_r13_r2_r9[] = {
  0x09, 0xd0, 0xb2, 0x70 // adcs vc r13 r2 r9
};
const byte kInstruction_adcs_vc_r7_r13_r14[] = {
  0x0e, 0x70, 0xbd, 0x70 // adcs vc r7 r13 r14
};
const byte kInstruction_adcs_pl_r11_r14_r4[] = {
  0x04, 0xb0, 0xbe, 0x50 // adcs pl r11 r14 r4
};
const byte kInstruction_adcs_lt_r12_r14_r8[] = {
  0x08, 0xc0, 0xbe, 0xb0 // adcs lt r12 r14 r8
};
const byte kInstruction_adcs_cs_r2_r11_r14[] = {
  0x0e, 0x20, 0xbb, 0x20 // adcs cs r2 r11 r14
};
const byte kInstruction_adcs_le_r12_r13_r2[] = {
  0x02, 0xc0, 0xbd, 0xd0 // adcs le r12 r13 r2
};
const byte kInstruction_adcs_le_r5_r6_r14[] = {
  0x0e, 0x50, 0xb6, 0xd0 // adcs le r5 r6 r14
};
const byte kInstruction_adcs_vc_r3_r14_r8[] = {
  0x08, 0x30, 0xbe, 0x70 // adcs vc r3 r14 r8
};
const byte kInstruction_adcs_lt_r7_r6_r14[] = {
  0x0e, 0x70, 0xb6, 0xb0 // adcs lt r7 r6 r14
};
const byte kInstruction_adcs_ls_r0_r13_r12[] = {
  0x0c, 0x00, 0xbd, 0x90 // adcs ls r0 r13 r12
};
const byte kInstruction_adcs_ge_r10_r9_r14[] = {
  0x0e, 0xa0, 0xb9, 0xa0 // adcs ge r10 r9 r14
};
const byte kInstruction_adcs_le_r11_r12_r1[] = {
  0x01, 0xb0, 0xbc, 0xd0 // adcs le r11 r12 r1
};
const byte kInstruction_adcs_al_r2_r12_r14[] = {
  0x0e, 0x20, 0xbc, 0xe0 // adcs al r2 r12 r14
};
const byte kInstruction_adcs_cs_r6_r4_r0[] = {
  0x00, 0x60, 0xb4, 0x20 // adcs cs r6 r4 r0
};
const byte kInstruction_adcs_vs_r5_r0_r3[] = {
  0x03, 0x50, 0xb0, 0x60 // adcs vs r5 r0 r3
};
const byte kInstruction_adcs_le_r8_r8_r0[] = {
  0x00, 0x80, 0xb8, 0xd0 // adcs le r8 r8 r0
};
const byte kInstruction_adcs_gt_r1_r5_r4[] = {
  0x04, 0x10, 0xb5, 0xc0 // adcs gt r1 r5 r4
};
const byte kInstruction_adcs_le_r4_r3_r4[] = {
  0x04, 0x40, 0xb3, 0xd0 // adcs le r4 r3 r4
};
const byte kInstruction_adcs_pl_r9_r7_r10[] = {
  0x0a, 0x90, 0xb7, 0x50 // adcs pl r9 r7 r10
};
const byte kInstruction_adcs_ls_r8_r7_r14[] = {
  0x0e, 0x80, 0xb7, 0x90 // adcs ls r8 r7 r14
};
const byte kInstruction_adcs_vc_r9_r10_r6[] = {
  0x06, 0x90, 0xba, 0x70 // adcs vc r9 r10 r6
};
const byte kInstruction_adcs_hi_r2_r4_r9[] = {
  0x09, 0x20, 0xb4, 0x80 // adcs hi r2 r4 r9
};
const byte kInstruction_adcs_cs_r0_r2_r13[] = {
  0x0d, 0x00, 0xb2, 0x20 // adcs cs r0 r2 r13
};
const byte kInstruction_adcs_vs_r3_r6_r12[] = {
  0x0c, 0x30, 0xb6, 0x60 // adcs vs r3 r6 r12
};
const byte kInstruction_adcs_cc_r14_r14_r7[] = {
  0x07, 0xe0, 0xbe, 0x30 // adcs cc r14 r14 r7
};
const byte kInstruction_adcs_vc_r10_r6_r4[] = {
  0x04, 0xa0, 0xb6, 0x70 // adcs vc r10 r6 r4
};
const byte kInstruction_adcs_cc_r1_r6_r10[] = {
  0x0a, 0x10, 0xb6, 0x30 // adcs cc r1 r6 r10
};
const byte kInstruction_adcs_vs_r13_r10_r11[] = {
  0x0b, 0xd0, 0xba, 0x60 // adcs vs r13 r10 r11
};
const byte kInstruction_adcs_ls_r5_r7_r12[] = {
  0x0c, 0x50, 0xb7, 0x90 // adcs ls r5 r7 r12
};
const byte kInstruction_adcs_eq_r6_r4_r3[] = {
  0x03, 0x60, 0xb4, 0x00 // adcs eq r6 r4 r3
};
const byte kInstruction_adcs_mi_r5_r9_r2[] = {
  0x02, 0x50, 0xb9, 0x40 // adcs mi r5 r9 r2
};
const byte kInstruction_adcs_lt_r7_r1_r9[] = {
  0x09, 0x70, 0xb1, 0xb0 // adcs lt r7 r1 r9
};
const byte kInstruction_adcs_ne_r12_r7_r0[] = {
  0x00, 0xc0, 0xb7, 0x10 // adcs ne r12 r7 r0
};
const byte kInstruction_adcs_eq_r0_r6_r7[] = {
  0x07, 0x00, 0xb6, 0x00 // adcs eq r0 r6 r7
};
const byte kInstruction_adcs_pl_r7_r3_r9[] = {
  0x09, 0x70, 0xb3, 0x50 // adcs pl r7 r3 r9
};
const byte kInstruction_adcs_pl_r11_r11_r13[] = {
  0x0d, 0xb0, 0xbb, 0x50 // adcs pl r11 r11 r13
};
const byte kInstruction_adcs_gt_r0_r10_r5[] = {
  0x05, 0x00, 0xba, 0xc0 // adcs gt r0 r10 r5
};
const byte kInstruction_adcs_mi_r14_r1_r10[] = {
  0x0a, 0xe0, 0xb1, 0x40 // adcs mi r14 r1 r10
};
const byte kInstruction_adcs_mi_r5_r14_r0[] = {
  0x00, 0x50, 0xbe, 0x40 // adcs mi r5 r14 r0
};
const byte kInstruction_adcs_ne_r12_r9_r13[] = {
  0x0d, 0xc0, 0xb9, 0x10 // adcs ne r12 r9 r13
};
const byte kInstruction_adcs_hi_r8_r5_r11[] = {
  0x0b, 0x80, 0xb5, 0x80 // adcs hi r8 r5 r11
};
const byte kInstruction_adcs_ls_r7_r0_r5[] = {
  0x05, 0x70, 0xb0, 0x90 // adcs ls r7 r0 r5
};
const byte kInstruction_adcs_lt_r5_r1_r7[] = {
  0x07, 0x50, 0xb1, 0xb0 // adcs lt r5 r1 r7
};
const byte kInstruction_adcs_cc_r2_r8_r4[] = {
  0x04, 0x20, 0xb8, 0x30 // adcs cc r2 r8 r4
};
const byte kInstruction_adcs_lt_r3_r0_r5[] = {
  0x05, 0x30, 0xb0, 0xb0 // adcs lt r3 r0 r5
};
const byte kInstruction_adcs_pl_r4_r9_r7[] = {
  0x07, 0x40, 0xb9, 0x50 // adcs pl r4 r9 r7
};
const byte kInstruction_adcs_eq_r13_r8_r10[] = {
  0x0a, 0xd0, 0xb8, 0x00 // adcs eq r13 r8 r10
};
const byte kInstruction_adcs_ge_r6_r10_r10[] = {
  0x0a, 0x60, 0xba, 0xa0 // adcs ge r6 r10 r10
};
const byte kInstruction_adcs_lt_r5_r5_r7[] = {
  0x07, 0x50, 0xb5, 0xb0 // adcs lt r5 r5 r7
};
const byte kInstruction_adcs_hi_r6_r3_r9[] = {
  0x09, 0x60, 0xb3, 0x80 // adcs hi r6 r3 r9
};
const byte kInstruction_adcs_hi_r14_r12_r10[] = {
  0x0a, 0xe0, 0xbc, 0x80 // adcs hi r14 r12 r10
};
const byte kInstruction_adcs_lt_r9_r13_r14[] = {
  0x0e, 0x90, 0xbd, 0xb0 // adcs lt r9 r13 r14
};
const byte kInstruction_adcs_al_r0_r12_r7[] = {
  0x07, 0x00, 0xbc, 0xe0 // adcs al r0 r12 r7
};
const byte kInstruction_adcs_eq_r14_r8_r11[] = {
  0x0b, 0xe0, 0xb8, 0x00 // adcs eq r14 r8 r11
};
const byte kInstruction_adcs_ne_r9_r11_r1[] = {
  0x01, 0x90, 0xbb, 0x10 // adcs ne r9 r11 r1
};
const byte kInstruction_adcs_ge_r5_r0_r3[] = {
  0x03, 0x50, 0xb0, 0xa0 // adcs ge r5 r0 r3
};
const byte kInstruction_adcs_pl_r12_r0_r1[] = {
  0x01, 0xc0, 0xb0, 0x50 // adcs pl r12 r0 r1
};
const byte kInstruction_adcs_lt_r13_r7_r11[] = {
  0x0b, 0xd0, 0xb7, 0xb0 // adcs lt r13 r7 r11
};
const byte kInstruction_adcs_eq_r4_r6_r6[] = {
  0x06, 0x40, 0xb6, 0x00 // adcs eq r4 r6 r6
};
const byte kInstruction_adcs_cs_r1_r14_r0[] = {
  0x00, 0x10, 0xbe, 0x20 // adcs cs r1 r14 r0
};
const byte kInstruction_adcs_hi_r7_r7_r6[] = {
  0x06, 0x70, 0xb7, 0x80 // adcs hi r7 r7 r6
};
const byte kInstruction_adcs_hi_r1_r0_r3[] = {
  0x03, 0x10, 0xb0, 0x80 // adcs hi r1 r0 r3
};
const byte kInstruction_adcs_pl_r12_r2_r0[] = {
  0x00, 0xc0, 0xb2, 0x50 // adcs pl r12 r2 r0
};
const byte kInstruction_adcs_mi_r3_r0_r3[] = {
  0x03, 0x30, 0xb0, 0x40 // adcs mi r3 r0 r3
};
const byte kInstruction_adcs_al_r14_r4_r3[] = {
  0x03, 0xe0, 0xb4, 0xe0 // adcs al r14 r4 r3
};
const byte kInstruction_adcs_vs_r4_r2_r9[] = {
  0x09, 0x40, 0xb2, 0x60 // adcs vs r4 r2 r9
};
const byte kInstruction_adcs_vs_r1_r9_r12[] = {
  0x0c, 0x10, 0xb9, 0x60 // adcs vs r1 r9 r12
};
const byte kInstruction_adcs_vs_r3_r6_r9[] = {
  0x09, 0x30, 0xb6, 0x60 // adcs vs r3 r6 r9
};
const byte kInstruction_adcs_cc_r4_r1_r8[] = {
  0x08, 0x40, 0xb1, 0x30 // adcs cc r4 r1 r8
};
const byte kInstruction_adcs_ls_r10_r11_r14[] = {
  0x0e, 0xa0, 0xbb, 0x90 // adcs ls r10 r11 r14
};
const byte kInstruction_adcs_le_r11_r7_r2[] = {
  0x02, 0xb0, 0xb7, 0xd0 // adcs le r11 r7 r2
};
const byte kInstruction_adcs_le_r6_r9_r14[] = {
  0x0e, 0x60, 0xb9, 0xd0 // adcs le r6 r9 r14
};
const byte kInstruction_adcs_al_r1_r3_r11[] = {
  0x0b, 0x10, 0xb3, 0xe0 // adcs al r1 r3 r11
};
const byte kInstruction_adcs_lt_r0_r2_r2[] = {
  0x02, 0x00, 0xb2, 0xb0 // adcs lt r0 r2 r2
};
const byte kInstruction_adcs_eq_r11_r6_r8[] = {
  0x08, 0xb0, 0xb6, 0x00 // adcs eq r11 r6 r8
};
const byte kInstruction_adcs_ls_r7_r12_r5[] = {
  0x05, 0x70, 0xbc, 0x90 // adcs ls r7 r12 r5
};
const byte kInstruction_adcs_vc_r4_r11_r0[] = {
  0x00, 0x40, 0xbb, 0x70 // adcs vc r4 r11 r0
};
const byte kInstruction_adcs_ls_r7_r14_r2[] = {
  0x02, 0x70, 0xbe, 0x90 // adcs ls r7 r14 r2
};
const byte kInstruction_adcs_le_r7_r12_r1[] = {
  0x01, 0x70, 0xbc, 0xd0 // adcs le r7 r12 r1
};
const byte kInstruction_adcs_le_r1_r14_r13[] = {
  0x0d, 0x10, 0xbe, 0xd0 // adcs le r1 r14 r13
};
const byte kInstruction_adcs_le_r11_r3_r9[] = {
  0x09, 0xb0, 0xb3, 0xd0 // adcs le r11 r3 r9
};
const byte kInstruction_adcs_ne_r14_r13_r1[] = {
  0x01, 0xe0, 0xbd, 0x10 // adcs ne r14 r13 r1
};
const byte kInstruction_adcs_ne_r5_r1_r10[] = {
  0x0a, 0x50, 0xb1, 0x10 // adcs ne r5 r1 r10
};
const byte kInstruction_adcs_cc_r7_r4_r3[] = {
  0x03, 0x70, 0xb4, 0x30 // adcs cc r7 r4 r3
};
const byte kInstruction_adcs_lt_r8_r1_r1[] = {
  0x01, 0x80, 0xb1, 0xb0 // adcs lt r8 r1 r1
};
const byte kInstruction_adcs_al_r5_r0_r1[] = {
  0x01, 0x50, 0xb0, 0xe0 // adcs al r5 r0 r1
};
const byte kInstruction_adcs_ge_r11_r13_r9[] = {
  0x09, 0xb0, 0xbd, 0xa0 // adcs ge r11 r13 r9
};
const byte kInstruction_adcs_gt_r5_r9_r5[] = {
  0x05, 0x50, 0xb9, 0xc0 // adcs gt r5 r9 r5
};
const byte kInstruction_adcs_cc_r2_r8_r3[] = {
  0x03, 0x20, 0xb8, 0x30 // adcs cc r2 r8 r3
};
const byte kInstruction_adcs_eq_r6_r6_r12[] = {
  0x0c, 0x60, 0xb6, 0x00 // adcs eq r6 r6 r12
};
const byte kInstruction_adcs_vc_r3_r10_r13[] = {
  0x0d, 0x30, 0xba, 0x70 // adcs vc r3 r10 r13
};
const byte kInstruction_adcs_vc_r9_r13_r1[] = {
  0x01, 0x90, 0xbd, 0x70 // adcs vc r9 r13 r1
};
const byte kInstruction_adcs_lt_r7_r0_r0[] = {
  0x00, 0x70, 0xb0, 0xb0 // adcs lt r7 r0 r0
};
const byte kInstruction_adcs_cc_r6_r6_r1[] = {
  0x01, 0x60, 0xb6, 0x30 // adcs cc r6 r6 r1
};
const byte kInstruction_adcs_mi_r8_r1_r9[] = {
  0x09, 0x80, 0xb1, 0x40 // adcs mi r8 r1 r9
};
const byte kInstruction_adcs_ls_r14_r10_r10[] = {
  0x0a, 0xe0, 0xba, 0x90 // adcs ls r14 r10 r10
};
const byte kInstruction_adcs_ge_r7_r13_r1[] = {
  0x01, 0x70, 0xbd, 0xa0 // adcs ge r7 r13 r1
};
const byte kInstruction_adcs_le_r0_r4_r3[] = {
  0x03, 0x00, 0xb4, 0xd0 // adcs le r0 r4 r3
};
const byte kInstruction_adcs_cc_r12_r10_r10[] = {
  0x0a, 0xc0, 0xba, 0x30 // adcs cc r12 r10 r10
};
const byte kInstruction_adcs_ge_r5_r0_r10[] = {
  0x0a, 0x50, 0xb0, 0xa0 // adcs ge r5 r0 r10
};
const byte kInstruction_adcs_vs_r8_r3_r10[] = {
  0x0a, 0x80, 0xb3, 0x60 // adcs vs r8 r3 r10
};
const byte kInstruction_adcs_ge_r11_r12_r2[] = {
  0x02, 0xb0, 0xbc, 0xa0 // adcs ge r11 r12 r2
};
const byte kInstruction_adcs_ne_r14_r4_r8[] = {
  0x08, 0xe0, 0xb4, 0x10 // adcs ne r14 r4 r8
};
const byte kInstruction_adcs_mi_r3_r0_r4[] = {
  0x04, 0x30, 0xb0, 0x40 // adcs mi r3 r0 r4
};
const byte kInstruction_adcs_gt_r13_r9_r6[] = {
  0x06, 0xd0, 0xb9, 0xc0 // adcs gt r13 r9 r6
};
const byte kInstruction_adcs_ls_r1_r14_r2[] = {
  0x02, 0x10, 0xbe, 0x90 // adcs ls r1 r14 r2
};
const byte kInstruction_adcs_eq_r11_r3_r12[] = {
  0x0c, 0xb0, 0xb3, 0x00 // adcs eq r11 r3 r12
};
const byte kInstruction_adcs_ge_r4_r13_r4[] = {
  0x04, 0x40, 0xbd, 0xa0 // adcs ge r4 r13 r4
};
const byte kInstruction_adcs_al_r5_r9_r7[] = {
  0x07, 0x50, 0xb9, 0xe0 // adcs al r5 r9 r7
};
const byte kInstruction_adcs_le_r11_r9_r0[] = {
  0x00, 0xb0, 0xb9, 0xd0 // adcs le r11 r9 r0
};
const byte kInstruction_adcs_mi_r13_r10_r12[] = {
  0x0c, 0xd0, 0xba, 0x40 // adcs mi r13 r10 r12
};
const byte kInstruction_adcs_hi_r5_r5_r10[] = {
  0x0a, 0x50, 0xb5, 0x80 // adcs hi r5 r5 r10
};
const byte kInstruction_adcs_ge_r4_r6_r14[] = {
  0x0e, 0x40, 0xb6, 0xa0 // adcs ge r4 r6 r14
};
const byte kInstruction_adcs_le_r5_r5_r7[] = {
  0x07, 0x50, 0xb5, 0xd0 // adcs le r5 r5 r7
};
const byte kInstruction_adcs_pl_r12_r2_r8[] = {
  0x08, 0xc0, 0xb2, 0x50 // adcs pl r12 r2 r8
};
const byte kInstruction_adcs_al_r7_r8_r10[] = {
  0x0a, 0x70, 0xb8, 0xe0 // adcs al r7 r8 r10
};
const byte kInstruction_adcs_vc_r8_r11_r13[] = {
  0x0d, 0x80, 0xbb, 0x70 // adcs vc r8 r11 r13
};
const byte kInstruction_adcs_ne_r14_r2_r12[] = {
  0x0c, 0xe0, 0xb2, 0x10 // adcs ne r14 r2 r12
};
const byte kInstruction_adcs_eq_r10_r4_r2[] = {
  0x02, 0xa0, 0xb4, 0x00 // adcs eq r10 r4 r2
};
const byte kInstruction_adcs_al_r6_r2_r5[] = {
  0x05, 0x60, 0xb2, 0xe0 // adcs al r6 r2 r5
};
const byte kInstruction_adcs_al_r1_r6_r2[] = {
  0x02, 0x10, 0xb6, 0xe0 // adcs al r1 r6 r2
};
const byte kInstruction_adcs_vs_r0_r7_r14[] = {
  0x0e, 0x00, 0xb7, 0x60 // adcs vs r0 r7 r14
};
const byte kInstruction_adcs_hi_r9_r7_r0[] = {
  0x00, 0x90, 0xb7, 0x80 // adcs hi r9 r7 r0
};
const byte kInstruction_adcs_ne_r8_r11_r13[] = {
  0x0d, 0x80, 0xbb, 0x10 // adcs ne r8 r11 r13
};
const byte kInstruction_adcs_ne_r9_r8_r12[] = {
  0x0c, 0x90, 0xb8, 0x10 // adcs ne r9 r8 r12
};
const byte kInstruction_adcs_al_r14_r8_r6[] = {
  0x06, 0xe0, 0xb8, 0xe0 // adcs al r14 r8 r6
};
const byte kInstruction_adcs_vc_r8_r0_r3[] = {
  0x03, 0x80, 0xb0, 0x70 // adcs vc r8 r0 r3
};
const byte kInstruction_adcs_pl_r11_r9_r0[] = {
  0x00, 0xb0, 0xb9, 0x50 // adcs pl r11 r9 r0
};
const byte kInstruction_adcs_al_r7_r9_r9[] = {
  0x09, 0x70, 0xb9, 0xe0 // adcs al r7 r9 r9
};
const byte kInstruction_adcs_ls_r0_r8_r3[] = {
  0x03, 0x00, 0xb8, 0x90 // adcs ls r0 r8 r3
};
const byte kInstruction_adcs_lt_r5_r13_r6[] = {
  0x06, 0x50, 0xbd, 0xb0 // adcs lt r5 r13 r6
};
const byte kInstruction_adcs_ge_r6_r5_r13[] = {
  0x0d, 0x60, 0xb5, 0xa0 // adcs ge r6 r5 r13
};
const byte kInstruction_adcs_cs_r11_r7_r3[] = {
  0x03, 0xb0, 0xb7, 0x20 // adcs cs r11 r7 r3
};
const byte kInstruction_adcs_vs_r8_r0_r6[] = {
  0x06, 0x80, 0xb0, 0x60 // adcs vs r8 r0 r6
};
const byte kInstruction_adcs_hi_r0_r12_r6[] = {
  0x06, 0x00, 0xbc, 0x80 // adcs hi r0 r12 r6
};
const byte kInstruction_adcs_eq_r14_r5_r12[] = {
  0x0c, 0xe0, 0xb5, 0x00 // adcs eq r14 r5 r12
};
const byte kInstruction_adcs_lt_r1_r4_r13[] = {
  0x0d, 0x10, 0xb4, 0xb0 // adcs lt r1 r4 r13
};
const byte kInstruction_adcs_hi_r6_r4_r2[] = {
  0x02, 0x60, 0xb4, 0x80 // adcs hi r6 r4 r2
};
const byte kInstruction_adcs_lt_r10_r10_r9[] = {
  0x09, 0xa0, 0xba, 0xb0 // adcs lt r10 r10 r9
};
const byte kInstruction_adcs_pl_r14_r7_r4[] = {
  0x04, 0xe0, 0xb7, 0x50 // adcs pl r14 r7 r4
};
const byte kInstruction_adcs_ge_r8_r3_r4[] = {
  0x04, 0x80, 0xb3, 0xa0 // adcs ge r8 r3 r4
};
const byte kInstruction_adcs_al_r11_r1_r14[] = {
  0x0e, 0xb0, 0xb1, 0xe0 // adcs al r11 r1 r14
};
const byte kInstruction_adcs_ge_r7_r8_r9[] = {
  0x09, 0x70, 0xb8, 0xa0 // adcs ge r7 r8 r9
};
const byte kInstruction_adcs_le_r10_r10_r8[] = {
  0x08, 0xa0, 0xba, 0xd0 // adcs le r10 r10 r8
};
const byte kInstruction_adcs_hi_r3_r3_r7[] = {
  0x07, 0x30, 0xb3, 0x80 // adcs hi r3 r3 r7
};
const byte kInstruction_adcs_cc_r3_r0_r14[] = {
  0x0e, 0x30, 0xb0, 0x30 // adcs cc r3 r0 r14
};
const byte kInstruction_adcs_al_r8_r9_r1[] = {
  0x01, 0x80, 0xb9, 0xe0 // adcs al r8 r9 r1
};
const byte kInstruction_adcs_gt_r6_r13_r7[] = {
  0x07, 0x60, 0xbd, 0xc0 // adcs gt r6 r13 r7
};
const byte kInstruction_adcs_ls_r11_r3_r1[] = {
  0x01, 0xb0, 0xb3, 0x90 // adcs ls r11 r3 r1
};
const byte kInstruction_adcs_cc_r14_r0_r13[] = {
  0x0d, 0xe0, 0xb0, 0x30 // adcs cc r14 r0 r13
};
const byte kInstruction_adcs_gt_r4_r4_r4[] = {
  0x04, 0x40, 0xb4, 0xc0 // adcs gt r4 r4 r4
};
const byte kInstruction_adcs_al_r8_r13_r1[] = {
  0x01, 0x80, 0xbd, 0xe0 // adcs al r8 r13 r1
};
const byte kInstruction_adcs_mi_r8_r4_r6[] = {
  0x06, 0x80, 0xb4, 0x40 // adcs mi r8 r4 r6
};
const byte kInstruction_adcs_vc_r12_r7_r11[] = {
  0x0b, 0xc0, 0xb7, 0x70 // adcs vc r12 r7 r11
};
const byte kInstruction_adcs_cs_r0_r1_r0[] = {
  0x00, 0x00, 0xb1, 0x20 // adcs cs r0 r1 r0
};
const byte kInstruction_adcs_cc_r13_r14_r0[] = {
  0x00, 0xd0, 0xbe, 0x30 // adcs cc r13 r14 r0
};
const byte kInstruction_adcs_eq_r4_r7_r11[] = {
  0x0b, 0x40, 0xb7, 0x00 // adcs eq r4 r7 r11
};
const byte kInstruction_adcs_ls_r11_r2_r0[] = {
  0x00, 0xb0, 0xb2, 0x90 // adcs ls r11 r2 r0
};
const byte kInstruction_adcs_gt_r10_r2_r3[] = {
  0x03, 0xa0, 0xb2, 0xc0 // adcs gt r10 r2 r3
};
const byte kInstruction_adcs_al_r6_r1_r7[] = {
  0x07, 0x60, 0xb1, 0xe0 // adcs al r6 r1 r7
};
const byte kInstruction_adcs_cs_r10_r13_r0[] = {
  0x00, 0xa0, 0xbd, 0x20 // adcs cs r10 r13 r0
};
const byte kInstruction_adcs_lt_r11_r2_r6[] = {
  0x06, 0xb0, 0xb2, 0xb0 // adcs lt r11 r2 r6
};
const byte kInstruction_adcs_pl_r4_r13_r6[] = {
  0x06, 0x40, 0xbd, 0x50 // adcs pl r4 r13 r6
};
const byte kInstruction_adcs_cs_r3_r0_r9[] = {
  0x09, 0x30, 0xb0, 0x20 // adcs cs r3 r0 r9
};
const byte kInstruction_adcs_gt_r4_r6_r14[] = {
  0x0e, 0x40, 0xb6, 0xc0 // adcs gt r4 r6 r14
};
const byte kInstruction_adcs_eq_r6_r8_r0[] = {
  0x00, 0x60, 0xb8, 0x00 // adcs eq r6 r8 r0
};
const byte kInstruction_adcs_cc_r5_r5_r2[] = {
  0x02, 0x50, 0xb5, 0x30 // adcs cc r5 r5 r2
};
const byte kInstruction_adcs_al_r9_r3_r7[] = {
  0x07, 0x90, 0xb3, 0xe0 // adcs al r9 r3 r7
};
const byte kInstruction_adcs_cc_r12_r0_r8[] = {
  0x08, 0xc0, 0xb0, 0x30 // adcs cc r12 r0 r8
};
const byte kInstruction_adcs_le_r4_r1_r7[] = {
  0x07, 0x40, 0xb1, 0xd0 // adcs le r4 r1 r7
};
const byte kInstruction_adcs_gt_r3_r12_r7[] = {
  0x07, 0x30, 0xbc, 0xc0 // adcs gt r3 r12 r7
};
const byte kInstruction_adcs_vc_r4_r3_r14[] = {
  0x0e, 0x40, 0xb3, 0x70 // adcs vc r4 r3 r14
};
const byte kInstruction_adcs_le_r0_r7_r10[] = {
  0x0a, 0x00, 0xb7, 0xd0 // adcs le r0 r7 r10
};
const byte kInstruction_adcs_vs_r14_r8_r13[] = {
  0x0d, 0xe0, 0xb8, 0x60 // adcs vs r14 r8 r13
};
const byte kInstruction_adcs_hi_r9_r0_r11[] = {
  0x0b, 0x90, 0xb0, 0x80 // adcs hi r9 r0 r11
};
const byte kInstruction_adcs_eq_r8_r13_r0[] = {
  0x00, 0x80, 0xbd, 0x00 // adcs eq r8 r13 r0
};
const byte kInstruction_adcs_vc_r10_r9_r2[] = {
  0x02, 0xa0, 0xb9, 0x70 // adcs vc r10 r9 r2
};
const byte kInstruction_adcs_al_r0_r13_r10[] = {
  0x0a, 0x00, 0xbd, 0xe0 // adcs al r0 r13 r10
};
const byte kInstruction_adcs_ne_r5_r4_r6[] = {
  0x06, 0x50, 0xb4, 0x10 // adcs ne r5 r4 r6
};
const byte kInstruction_adcs_cc_r7_r13_r1[] = {
  0x01, 0x70, 0xbd, 0x30 // adcs cc r7 r13 r1
};
const byte kInstruction_adcs_lt_r1_r14_r11[] = {
  0x0b, 0x10, 0xbe, 0xb0 // adcs lt r1 r14 r11
};
const byte kInstruction_adcs_vc_r13_r10_r14[] = {
  0x0e, 0xd0, 0xba, 0x70 // adcs vc r13 r10 r14
};
const byte kInstruction_adcs_le_r3_r0_r4[] = {
  0x04, 0x30, 0xb0, 0xd0 // adcs le r3 r0 r4
};
const byte kInstruction_adcs_al_r11_r4_r5[] = {
  0x05, 0xb0, 0xb4, 0xe0 // adcs al r11 r4 r5
};
const byte kInstruction_adcs_lt_r0_r8_r8[] = {
  0x08, 0x00, 0xb8, 0xb0 // adcs lt r0 r8 r8
};
const byte kInstruction_adcs_al_r13_r12_r7[] = {
  0x07, 0xd0, 0xbc, 0xe0 // adcs al r13 r12 r7
};
const byte kInstruction_adcs_ls_r12_r13_r13[] = {
  0x0d, 0xc0, 0xbd, 0x90 // adcs ls r12 r13 r13
};
const byte kInstruction_adcs_vc_r8_r2_r9[] = {
  0x09, 0x80, 0xb2, 0x70 // adcs vc r8 r2 r9
};
const byte kInstruction_adcs_ne_r14_r9_r3[] = {
  0x03, 0xe0, 0xb9, 0x10 // adcs ne r14 r9 r3
};
const byte kInstruction_adcs_pl_r12_r11_r6[] = {
  0x06, 0xc0, 0xbb, 0x50 // adcs pl r12 r11 r6
};
const byte kInstruction_adcs_eq_r0_r3_r5[] = {
  0x05, 0x00, 0xb3, 0x00 // adcs eq r0 r3 r5
};
const byte kInstruction_adcs_hi_r11_r3_r14[] = {
  0x0e, 0xb0, 0xb3, 0x80 // adcs hi r11 r3 r14
};
const byte kInstruction_adcs_le_r3_r7_r4[] = {
  0x04, 0x30, 0xb7, 0xd0 // adcs le r3 r7 r4
};
const byte kInstruction_adcs_ne_r6_r9_r8[] = {
  0x08, 0x60, 0xb9, 0x10 // adcs ne r6 r9 r8
};
const byte kInstruction_adcs_vc_r11_r11_r11[] = {
  0x0b, 0xb0, 0xbb, 0x70 // adcs vc r11 r11 r11
};
const byte kInstruction_adcs_ge_r3_r1_r10[] = {
  0x0a, 0x30, 0xb1, 0xa0 // adcs ge r3 r1 r10
};
const byte kInstruction_adcs_gt_r5_r14_r13[] = {
  0x0d, 0x50, 0xbe, 0xc0 // adcs gt r5 r14 r13
};
const byte kInstruction_adcs_le_r7_r0_r13[] = {
  0x0d, 0x70, 0xb0, 0xd0 // adcs le r7 r0 r13
};
const byte kInstruction_adcs_lt_r8_r5_r1[] = {
  0x01, 0x80, 0xb5, 0xb0 // adcs lt r8 r5 r1
};
const byte kInstruction_adcs_le_r3_r4_r8[] = {
  0x08, 0x30, 0xb4, 0xd0 // adcs le r3 r4 r8
};
const byte kInstruction_adcs_ne_r5_r11_r13[] = {
  0x0d, 0x50, 0xbb, 0x10 // adcs ne r5 r11 r13
};
const byte kInstruction_adcs_ge_r9_r8_r2[] = {
  0x02, 0x90, 0xb8, 0xa0 // adcs ge r9 r8 r2
};
const byte kInstruction_adcs_gt_r9_r5_r12[] = {
  0x0c, 0x90, 0xb5, 0xc0 // adcs gt r9 r5 r12
};
const byte kInstruction_adcs_pl_r9_r8_r1[] = {
  0x01, 0x90, 0xb8, 0x50 // adcs pl r9 r8 r1
};
const byte kInstruction_adcs_le_r3_r12_r4[] = {
  0x04, 0x30, 0xbc, 0xd0 // adcs le r3 r12 r4
};
const byte kInstruction_adcs_eq_r5_r6_r9[] = {
  0x09, 0x50, 0xb6, 0x00 // adcs eq r5 r6 r9
};
const byte kInstruction_adcs_ne_r14_r4_r13[] = {
  0x0d, 0xe0, 0xb4, 0x10 // adcs ne r14 r4 r13
};
const byte kInstruction_adcs_ge_r3_r9_r2[] = {
  0x02, 0x30, 0xb9, 0xa0 // adcs ge r3 r9 r2
};
const byte kInstruction_adcs_ls_r13_r0_r10[] = {
  0x0a, 0xd0, 0xb0, 0x90 // adcs ls r13 r0 r10
};
const byte kInstruction_adcs_mi_r14_r0_r2[] = {
  0x02, 0xe0, 0xb0, 0x40 // adcs mi r14 r0 r2
};
const byte kInstruction_adcs_cs_r11_r1_r3[] = {
  0x03, 0xb0, 0xb1, 0x20 // adcs cs r11 r1 r3
};
const byte kInstruction_adcs_ne_r8_r9_r10[] = {
  0x0a, 0x80, 0xb9, 0x10 // adcs ne r8 r9 r10
};
const byte kInstruction_adcs_gt_r9_r10_r4[] = {
  0x04, 0x90, 0xba, 0xc0 // adcs gt r9 r10 r4
};
const byte kInstruction_adcs_le_r2_r8_r4[] = {
  0x04, 0x20, 0xb8, 0xd0 // adcs le r2 r8 r4
};
const byte kInstruction_adcs_al_r6_r14_r11[] = {
  0x0b, 0x60, 0xbe, 0xe0 // adcs al r6 r14 r11
};
const byte kInstruction_adcs_eq_r3_r14_r14[] = {
  0x0e, 0x30, 0xbe, 0x00 // adcs eq r3 r14 r14
};
const byte kInstruction_adcs_pl_r9_r9_r3[] = {
  0x03, 0x90, 0xb9, 0x50 // adcs pl r9 r9 r3
};
const byte kInstruction_adcs_ge_r5_r13_r12[] = {
  0x0c, 0x50, 0xbd, 0xa0 // adcs ge r5 r13 r12
};
const byte kInstruction_adcs_mi_r10_r6_r5[] = {
  0x05, 0xa0, 0xb6, 0x40 // adcs mi r10 r6 r5
};
const byte kInstruction_adcs_ls_r14_r13_r12[] = {
  0x0c, 0xe0, 0xbd, 0x90 // adcs ls r14 r13 r12
};
const byte kInstruction_adcs_lt_r10_r9_r10[] = {
  0x0a, 0xa0, 0xb9, 0xb0 // adcs lt r10 r9 r10
};
const byte kInstruction_adcs_ls_r7_r4_r9[] = {
  0x09, 0x70, 0xb4, 0x90 // adcs ls r7 r4 r9
};
const byte kInstruction_adcs_cs_r9_r10_r7[] = {
  0x07, 0x90, 0xba, 0x20 // adcs cs r9 r10 r7
};
const byte kInstruction_adcs_eq_r4_r2_r2[] = {
  0x02, 0x40, 0xb2, 0x00 // adcs eq r4 r2 r2
};
const byte kInstruction_adcs_lt_r14_r13_r4[] = {
  0x04, 0xe0, 0xbd, 0xb0 // adcs lt r14 r13 r4
};
const byte kInstruction_adcs_al_r0_r3_r5[] = {
  0x05, 0x00, 0xb3, 0xe0 // adcs al r0 r3 r5
};
const byte kInstruction_adcs_vs_r9_r6_r7[] = {
  0x07, 0x90, 0xb6, 0x60 // adcs vs r9 r6 r7
};
const byte kInstruction_adcs_ls_r0_r6_r4[] = {
  0x04, 0x00, 0xb6, 0x90 // adcs ls r0 r6 r4
};
const byte kInstruction_adcs_ne_r7_r10_r14[] = {
  0x0e, 0x70, 0xba, 0x10 // adcs ne r7 r10 r14
};
const byte kInstruction_adcs_le_r2_r12_r1[] = {
  0x01, 0x20, 0xbc, 0xd0 // adcs le r2 r12 r1
};
const byte kInstruction_adcs_cs_r1_r5_r0[] = {
  0x00, 0x10, 0xb5, 0x20 // adcs cs r1 r5 r0
};
const byte kInstruction_adcs_pl_r0_r9_r1[] = {
  0x01, 0x00, 0xb9, 0x50 // adcs pl r0 r9 r1
};
const byte kInstruction_adcs_mi_r2_r2_r5[] = {
  0x05, 0x20, 0xb2, 0x40 // adcs mi r2 r2 r5
};
const byte kInstruction_adcs_hi_r5_r1_r12[] = {
  0x0c, 0x50, 0xb1, 0x80 // adcs hi r5 r1 r12
};
const byte kInstruction_adcs_ls_r13_r14_r7[] = {
  0x07, 0xd0, 0xbe, 0x90 // adcs ls r13 r14 r7
};
const byte kInstruction_adcs_lt_r0_r4_r3[] = {
  0x03, 0x00, 0xb4, 0xb0 // adcs lt r0 r4 r3
};
const byte kInstruction_adcs_cc_r8_r13_r2[] = {
  0x02, 0x80, 0xbd, 0x30 // adcs cc r8 r13 r2
};
const byte kInstruction_adcs_ls_r7_r8_r14[] = {
  0x0e, 0x70, 0xb8, 0x90 // adcs ls r7 r8 r14
};
const byte kInstruction_adcs_hi_r13_r11_r13[] = {
  0x0d, 0xd0, 0xbb, 0x80 // adcs hi r13 r11 r13
};
const byte kInstruction_adcs_ge_r13_r7_r6[] = {
  0x06, 0xd0, 0xb7, 0xa0 // adcs ge r13 r7 r6
};
const byte kInstruction_adcs_mi_r3_r2_r0[] = {
  0x00, 0x30, 0xb2, 0x40 // adcs mi r3 r2 r0
};
const byte kInstruction_adcs_cs_r12_r0_r10[] = {
  0x0a, 0xc0, 0xb0, 0x20 // adcs cs r12 r0 r10
};
const byte kInstruction_adcs_vs_r9_r10_r8[] = {
  0x08, 0x90, 0xba, 0x60 // adcs vs r9 r10 r8
};
const byte kInstruction_adcs_ls_r2_r8_r8[] = {
  0x08, 0x20, 0xb8, 0x90 // adcs ls r2 r8 r8
};
const byte kInstruction_adcs_ge_r1_r11_r3[] = {
  0x03, 0x10, 0xbb, 0xa0 // adcs ge r1 r11 r3
};
const byte kInstruction_adcs_ge_r12_r3_r3[] = {
  0x03, 0xc0, 0xb3, 0xa0 // adcs ge r12 r3 r3
};
const byte kInstruction_adcs_gt_r3_r8_r6[] = {
  0x06, 0x30, 0xb8, 0xc0 // adcs gt r3 r8 r6
};
const byte kInstruction_adcs_ne_r13_r2_r9[] = {
  0x09, 0xd0, 0xb2, 0x10 // adcs ne r13 r2 r9
};
const byte kInstruction_adcs_ls_r14_r9_r1[] = {
  0x01, 0xe0, 0xb9, 0x90 // adcs ls r14 r9 r1
};
const byte kInstruction_adcs_cc_r2_r10_r2[] = {
  0x02, 0x20, 0xba, 0x30 // adcs cc r2 r10 r2
};
const byte kInstruction_adcs_le_r9_r12_r1[] = {
  0x01, 0x90, 0xbc, 0xd0 // adcs le r9 r12 r1
};
const byte kInstruction_adcs_cs_r11_r10_r0[] = {
  0x00, 0xb0, 0xba, 0x20 // adcs cs r11 r10 r0
};
const byte kInstruction_adcs_eq_r7_r0_r5[] = {
  0x05, 0x70, 0xb0, 0x00 // adcs eq r7 r0 r5
};
const byte kInstruction_adcs_ne_r10_r4_r4[] = {
  0x04, 0xa0, 0xb4, 0x10 // adcs ne r10 r4 r4
};
const byte kInstruction_adcs_pl_r13_r9_r6[] = {
  0x06, 0xd0, 0xb9, 0x50 // adcs pl r13 r9 r6
};
const byte kInstruction_adcs_vc_r11_r3_r3[] = {
  0x03, 0xb0, 0xb3, 0x70 // adcs vc r11 r3 r3
};
const byte kInstruction_adcs_al_r1_r13_r9[] = {
  0x09, 0x10, 0xbd, 0xe0 // adcs al r1 r13 r9
};
const byte kInstruction_adcs_cc_r13_r9_r14[] = {
  0x0e, 0xd0, 0xb9, 0x30 // adcs cc r13 r9 r14
};
const byte kInstruction_adcs_vc_r5_r2_r3[] = {
  0x03, 0x50, 0xb2, 0x70 // adcs vc r5 r2 r3
};
const byte kInstruction_adcs_ne_r12_r8_r10[] = {
  0x0a, 0xc0, 0xb8, 0x10 // adcs ne r12 r8 r10
};
const byte kInstruction_adcs_cs_r11_r13_r6[] = {
  0x06, 0xb0, 0xbd, 0x20 // adcs cs r11 r13 r6
};
const byte kInstruction_adcs_al_r1_r11_r10[] = {
  0x0a, 0x10, 0xbb, 0xe0 // adcs al r1 r11 r10
};
const byte kInstruction_adcs_ne_r14_r6_r11[] = {
  0x0b, 0xe0, 0xb6, 0x10 // adcs ne r14 r6 r11
};
const byte kInstruction_adcs_cs_r1_r14_r5[] = {
  0x05, 0x10, 0xbe, 0x20 // adcs cs r1 r14 r5
};
const byte kInstruction_adcs_al_r11_r11_r6[] = {
  0x06, 0xb0, 0xbb, 0xe0 // adcs al r11 r11 r6
};
const byte kInstruction_adcs_pl_r3_r6_r2[] = {
  0x02, 0x30, 0xb6, 0x50 // adcs pl r3 r6 r2
};
const byte kInstruction_adcs_ne_r3_r9_r4[] = {
  0x04, 0x30, 0xb9, 0x10 // adcs ne r3 r9 r4
};
const byte kInstruction_adcs_mi_r11_r4_r9[] = {
  0x09, 0xb0, 0xb4, 0x40 // adcs mi r11 r4 r9
};
const byte kInstruction_adcs_al_r10_r1_r3[] = {
  0x03, 0xa0, 0xb1, 0xe0 // adcs al r10 r1 r3
};
const byte kInstruction_adcs_vc_r2_r14_r11[] = {
  0x0b, 0x20, 0xbe, 0x70 // adcs vc r2 r14 r11
};
const byte kInstruction_adcs_mi_r9_r3_r0[] = {
  0x00, 0x90, 0xb3, 0x40 // adcs mi r9 r3 r0
};
const byte kInstruction_adcs_vs_r9_r8_r1[] = {
  0x01, 0x90, 0xb8, 0x60 // adcs vs r9 r8 r1
};
const byte kInstruction_adcs_lt_r2_r12_r5[] = {
  0x05, 0x20, 0xbc, 0xb0 // adcs lt r2 r12 r5
};
const byte kInstruction_adcs_al_r9_r8_r12[] = {
  0x0c, 0x90, 0xb8, 0xe0 // adcs al r9 r8 r12
};
const byte kInstruction_adcs_vc_r3_r8_r0[] = {
  0x00, 0x30, 0xb8, 0x70 // adcs vc r3 r8 r0
};
const byte kInstruction_adcs_mi_r10_r5_r1[] = {
  0x01, 0xa0, 0xb5, 0x40 // adcs mi r10 r5 r1
};
const byte kInstruction_adcs_vc_r7_r14_r2[] = {
  0x02, 0x70, 0xbe, 0x70 // adcs vc r7 r14 r2
};
const byte kInstruction_adcs_ls_r0_r9_r7[] = {
  0x07, 0x00, 0xb9, 0x90 // adcs ls r0 r9 r7
};
const byte kInstruction_adcs_cs_r3_r0_r10[] = {
  0x0a, 0x30, 0xb0, 0x20 // adcs cs r3 r0 r10
};
const byte kInstruction_adcs_cc_r10_r8_r10[] = {
  0x0a, 0xa0, 0xb8, 0x30 // adcs cc r10 r8 r10
};
const byte kInstruction_adcs_eq_r5_r4_r1[] = {
  0x01, 0x50, 0xb4, 0x00 // adcs eq r5 r4 r1
};
const byte kInstruction_adcs_vc_r11_r13_r1[] = {
  0x01, 0xb0, 0xbd, 0x70 // adcs vc r11 r13 r1
};
const byte kInstruction_adcs_hi_r6_r5_r8[] = {
  0x08, 0x60, 0xb5, 0x80 // adcs hi r6 r5 r8
};
const byte kInstruction_adcs_ne_r10_r5_r6[] = {
  0x06, 0xa0, 0xb5, 0x10 // adcs ne r10 r5 r6
};
const byte kInstruction_adcs_al_r10_r12_r9[] = {
  0x09, 0xa0, 0xbc, 0xe0 // adcs al r10 r12 r9
};
const byte kInstruction_adcs_eq_r5_r1_r12[] = {
  0x0c, 0x50, 0xb1, 0x00 // adcs eq r5 r1 r12
};
const byte kInstruction_adcs_le_r0_r14_r10[] = {
  0x0a, 0x00, 0xbe, 0xd0 // adcs le r0 r14 r10
};
const byte kInstruction_adcs_eq_r4_r2_r5[] = {
  0x05, 0x40, 0xb2, 0x00 // adcs eq r4 r2 r5
};
const byte kInstruction_adcs_pl_r5_r8_r2[] = {
  0x02, 0x50, 0xb8, 0x50 // adcs pl r5 r8 r2
};
const byte kInstruction_adcs_hi_r5_r14_r4[] = {
  0x04, 0x50, 0xbe, 0x80 // adcs hi r5 r14 r4
};
const byte kInstruction_adcs_le_r2_r7_r9[] = {
  0x09, 0x20, 0xb7, 0xd0 // adcs le r2 r7 r9
};
const byte kInstruction_adcs_pl_r5_r12_r6[] = {
  0x06, 0x50, 0xbc, 0x50 // adcs pl r5 r12 r6
};
const byte kInstruction_adcs_vs_r11_r4_r14[] = {
  0x0e, 0xb0, 0xb4, 0x60 // adcs vs r11 r4 r14
};
const byte kInstruction_adcs_eq_r0_r7_r14[] = {
  0x0e, 0x00, 0xb7, 0x00 // adcs eq r0 r7 r14
};
const byte kInstruction_adcs_pl_r5_r2_r5[] = {
  0x05, 0x50, 0xb2, 0x50 // adcs pl r5 r2 r5
};
const byte kInstruction_adcs_ne_r5_r11_r7[] = {
  0x07, 0x50, 0xbb, 0x10 // adcs ne r5 r11 r7
};
const byte kInstruction_adcs_pl_r7_r9_r10[] = {
  0x0a, 0x70, 0xb9, 0x50 // adcs pl r7 r9 r10
};
const byte kInstruction_adcs_hi_r4_r2_r2[] = {
  0x02, 0x40, 0xb2, 0x80 // adcs hi r4 r2 r2
};
const byte kInstruction_adcs_pl_r14_r9_r2[] = {
  0x02, 0xe0, 0xb9, 0x50 // adcs pl r14 r9 r2
};
const byte kInstruction_adcs_le_r4_r11_r13[] = {
  0x0d, 0x40, 0xbb, 0xd0 // adcs le r4 r11 r13
};
const byte kInstruction_adcs_pl_r8_r8_r8[] = {
  0x08, 0x80, 0xb8, 0x50 // adcs pl r8 r8 r8
};
const byte kInstruction_adcs_ge_r0_r6_r10[] = {
  0x0a, 0x00, 0xb6, 0xa0 // adcs ge r0 r6 r10
};
const byte kInstruction_adcs_vc_r4_r4_r10[] = {
  0x0a, 0x40, 0xb4, 0x70 // adcs vc r4 r4 r10
};
const byte kInstruction_adcs_cc_r11_r9_r12[] = {
  0x0c, 0xb0, 0xb9, 0x30 // adcs cc r11 r9 r12
};
const byte kInstruction_adcs_pl_r14_r4_r12[] = {
  0x0c, 0xe0, 0xb4, 0x50 // adcs pl r14 r4 r12
};
const byte kInstruction_adcs_vs_r8_r8_r8[] = {
  0x08, 0x80, 0xb8, 0x60 // adcs vs r8 r8 r8
};
const byte kInstruction_adcs_ge_r14_r2_r12[] = {
  0x0c, 0xe0, 0xb2, 0xa0 // adcs ge r14 r2 r12
};
const byte kInstruction_adcs_ge_r8_r2_r13[] = {
  0x0d, 0x80, 0xb2, 0xa0 // adcs ge r8 r2 r13
};
const byte kInstruction_adcs_vs_r10_r0_r11[] = {
  0x0b, 0xa0, 0xb0, 0x60 // adcs vs r10 r0 r11
};
const byte kInstruction_adcs_eq_r5_r1_r2[] = {
  0x02, 0x50, 0xb1, 0x00 // adcs eq r5 r1 r2
};
const byte kInstruction_adcs_vs_r10_r11_r3[] = {
  0x03, 0xa0, 0xbb, 0x60 // adcs vs r10 r11 r3
};
const byte kInstruction_adcs_lt_r13_r13_r7[] = {
  0x07, 0xd0, 0xbd, 0xb0 // adcs lt r13 r13 r7
};
const byte kInstruction_adcs_le_r12_r7_r6[] = {
  0x06, 0xc0, 0xb7, 0xd0 // adcs le r12 r7 r6
};
const byte kInstruction_adcs_eq_r4_r3_r3[] = {
  0x03, 0x40, 0xb3, 0x00 // adcs eq r4 r3 r3
};
const byte kInstruction_adcs_pl_r0_r5_r8[] = {
  0x08, 0x00, 0xb5, 0x50 // adcs pl r0 r5 r8
};
const byte kInstruction_adcs_vs_r10_r5_r3[] = {
  0x03, 0xa0, 0xb5, 0x60 // adcs vs r10 r5 r3
};
const byte kInstruction_adcs_gt_r0_r11_r9[] = {
  0x09, 0x00, 0xbb, 0xc0 // adcs gt r0 r11 r9
};
const byte kInstruction_adcs_cc_r8_r5_r9[] = {
  0x09, 0x80, 0xb5, 0x30 // adcs cc r8 r5 r9
};
const byte kInstruction_adcs_cs_r9_r12_r11[] = {
  0x0b, 0x90, 0xbc, 0x20 // adcs cs r9 r12 r11
};
const byte kInstruction_adcs_gt_r3_r4_r8[] = {
  0x08, 0x30, 0xb4, 0xc0 // adcs gt r3 r4 r8
};
const byte kInstruction_adcs_ls_r8_r3_r10[] = {
  0x0a, 0x80, 0xb3, 0x90 // adcs ls r8 r3 r10
};
const byte kInstruction_adcs_eq_r8_r14_r12[] = {
  0x0c, 0x80, 0xbe, 0x00 // adcs eq r8 r14 r12
};
const byte kInstruction_adcs_gt_r7_r1_r3[] = {
  0x03, 0x70, 0xb1, 0xc0 // adcs gt r7 r1 r3
};
const byte kInstruction_adcs_al_r4_r4_r8[] = {
  0x08, 0x40, 0xb4, 0xe0 // adcs al r4 r4 r8
};
const byte kInstruction_adcs_gt_r9_r14_r10[] = {
  0x0a, 0x90, 0xbe, 0xc0 // adcs gt r9 r14 r10
};
const byte kInstruction_adcs_lt_r3_r13_r2[] = {
  0x02, 0x30, 0xbd, 0xb0 // adcs lt r3 r13 r2
};
const byte kInstruction_adcs_le_r4_r11_r14[] = {
  0x0e, 0x40, 0xbb, 0xd0 // adcs le r4 r11 r14
};
const byte kInstruction_adcs_ge_r2_r14_r0[] = {
  0x00, 0x20, 0xbe, 0xa0 // adcs ge r2 r14 r0
};
const byte kInstruction_adcs_pl_r1_r8_r8[] = {
  0x08, 0x10, 0xb8, 0x50 // adcs pl r1 r8 r8
};
const byte kInstruction_adcs_pl_r9_r2_r5[] = {
  0x05, 0x90, 0xb2, 0x50 // adcs pl r9 r2 r5
};
const byte kInstruction_adcs_vs_r13_r13_r1[] = {
  0x01, 0xd0, 0xbd, 0x60 // adcs vs r13 r13 r1
};
const byte kInstruction_adcs_ge_r12_r14_r3[] = {
  0x03, 0xc0, 0xbe, 0xa0 // adcs ge r12 r14 r3
};
const byte kInstruction_adcs_vc_r0_r11_r4[] = {
  0x04, 0x00, 0xbb, 0x70 // adcs vc r0 r11 r4
};
const byte kInstruction_adcs_ge_r0_r2_r9[] = {
  0x09, 0x00, 0xb2, 0xa0 // adcs ge r0 r2 r9
};
const byte kInstruction_adcs_vc_r12_r1_r6[] = {
  0x06, 0xc0, 0xb1, 0x70 // adcs vc r12 r1 r6
};
const byte kInstruction_adcs_ne_r1_r3_r7[] = {
  0x07, 0x10, 0xb3, 0x10 // adcs ne r1 r3 r7
};
const byte kInstruction_adcs_vs_r10_r3_r9[] = {
  0x09, 0xa0, 0xb3, 0x60 // adcs vs r10 r3 r9
};
const byte kInstruction_adcs_cc_r14_r4_r1[] = {
  0x01, 0xe0, 0xb4, 0x30 // adcs cc r14 r4 r1
};
const byte kInstruction_adcs_le_r9_r3_r7[] = {
  0x07, 0x90, 0xb3, 0xd0 // adcs le r9 r3 r7
};
const byte kInstruction_adcs_le_r1_r0_r14[] = {
  0x0e, 0x10, 0xb0, 0xd0 // adcs le r1 r0 r14
};
const byte kInstruction_adcs_le_r0_r14_r4[] = {
  0x04, 0x00, 0xbe, 0xd0 // adcs le r0 r14 r4
};
const byte kInstruction_adcs_hi_r13_r8_r11[] = {
  0x0b, 0xd0, 0xb8, 0x80 // adcs hi r13 r8 r11
};
const byte kInstruction_adcs_cc_r10_r6_r11[] = {
  0x0b, 0xa0, 0xb6, 0x30 // adcs cc r10 r6 r11
};
const byte kInstruction_adcs_cc_r0_r10_r14[] = {
  0x0e, 0x00, 0xba, 0x30 // adcs cc r0 r10 r14
};
const byte kInstruction_adcs_le_r4_r4_r0[] = {
  0x00, 0x40, 0xb4, 0xd0 // adcs le r4 r4 r0
};
const byte kInstruction_adcs_pl_r8_r14_r12[] = {
  0x0c, 0x80, 0xbe, 0x50 // adcs pl r8 r14 r12
};
const byte kInstruction_adcs_ge_r13_r12_r2[] = {
  0x02, 0xd0, 0xbc, 0xa0 // adcs ge r13 r12 r2
};
const byte kInstruction_adcs_al_r11_r11_r7[] = {
  0x07, 0xb0, 0xbb, 0xe0 // adcs al r11 r11 r7
};
const byte kInstruction_adcs_ls_r11_r12_r1[] = {
  0x01, 0xb0, 0xbc, 0x90 // adcs ls r11 r12 r1
};
const byte kInstruction_adcs_vs_r10_r14_r14[] = {
  0x0e, 0xa0, 0xbe, 0x60 // adcs vs r10 r14 r14
};
const byte kInstruction_adcs_pl_r2_r8_r12[] = {
  0x0c, 0x20, 0xb8, 0x50 // adcs pl r2 r8 r12
};
const byte kInstruction_adcs_pl_r12_r7_r11[] = {
  0x0b, 0xc0, 0xb7, 0x50 // adcs pl r12 r7 r11
};
const byte kInstruction_adcs_eq_r5_r8_r13[] = {
  0x0d, 0x50, 0xb8, 0x00 // adcs eq r5 r8 r13
};
const byte kInstruction_adcs_vc_r6_r6_r6[] = {
  0x06, 0x60, 0xb6, 0x70 // adcs vc r6 r6 r6
};
const byte kInstruction_adcs_vs_r0_r12_r1[] = {
  0x01, 0x00, 0xbc, 0x60 // adcs vs r0 r12 r1
};
const byte kInstruction_adcs_cs_r6_r0_r8[] = {
  0x08, 0x60, 0xb0, 0x20 // adcs cs r6 r0 r8
};
const byte kInstruction_adcs_cc_r3_r4_r1[] = {
  0x01, 0x30, 0xb4, 0x30 // adcs cc r3 r4 r1
};
const byte kInstruction_adcs_lt_r1_r10_r14[] = {
  0x0e, 0x10, 0xba, 0xb0 // adcs lt r1 r10 r14
};
const byte kInstruction_adcs_le_r1_r3_r5[] = {
  0x05, 0x10, 0xb3, 0xd0 // adcs le r1 r3 r5
};
const byte kInstruction_adcs_cc_r11_r1_r1[] = {
  0x01, 0xb0, 0xb1, 0x30 // adcs cc r11 r1 r1
};
const byte kInstruction_adcs_vc_r1_r8_r7[] = {
  0x07, 0x10, 0xb8, 0x70 // adcs vc r1 r8 r7
};
const byte kInstruction_adcs_eq_r3_r10_r13[] = {
  0x0d, 0x30, 0xba, 0x00 // adcs eq r3 r10 r13
};
const byte kInstruction_adcs_hi_r14_r12_r12[] = {
  0x0c, 0xe0, 0xbc, 0x80 // adcs hi r14 r12 r12
};
const byte kInstruction_adcs_eq_r10_r1_r14[] = {
  0x0e, 0xa0, 0xb1, 0x00 // adcs eq r10 r1 r14
};
const byte kInstruction_adcs_lt_r3_r1_r6[] = {
  0x06, 0x30, 0xb1, 0xb0 // adcs lt r3 r1 r6
};
const byte kInstruction_adcs_cc_r9_r12_r10[] = {
  0x0a, 0x90, 0xbc, 0x30 // adcs cc r9 r12 r10
};
const byte kInstruction_adcs_lt_r13_r14_r14[] = {
  0x0e, 0xd0, 0xbe, 0xb0 // adcs lt r13 r14 r14
};
const byte kInstruction_adcs_ge_r2_r6_r9[] = {
  0x09, 0x20, 0xb6, 0xa0 // adcs ge r2 r6 r9
};
const byte kInstruction_adcs_vs_r3_r9_r1[] = {
  0x01, 0x30, 0xb9, 0x60 // adcs vs r3 r9 r1
};
const byte kInstruction_adcs_cc_r1_r9_r12[] = {
  0x0c, 0x10, 0xb9, 0x30 // adcs cc r1 r9 r12
};
const byte kInstruction_adcs_ls_r5_r0_r6[] = {
  0x06, 0x50, 0xb0, 0x90 // adcs ls r5 r0 r6
};
const byte kInstruction_adcs_hi_r6_r14_r10[] = {
  0x0a, 0x60, 0xbe, 0x80 // adcs hi r6 r14 r10
};
const byte kInstruction_adcs_al_r11_r10_r3[] = {
  0x03, 0xb0, 0xba, 0xe0 // adcs al r11 r10 r3
};
const byte kInstruction_adcs_ne_r13_r4_r1[] = {
  0x01, 0xd0, 0xb4, 0x10 // adcs ne r13 r4 r1
};
const byte kInstruction_adcs_hi_r13_r5_r14[] = {
  0x0e, 0xd0, 0xb5, 0x80 // adcs hi r13 r5 r14
};
const byte kInstruction_adcs_ne_r8_r9_r11[] = {
  0x0b, 0x80, 0xb9, 0x10 // adcs ne r8 r9 r11
};
const byte kInstruction_adcs_eq_r0_r13_r13[] = {
  0x0d, 0x00, 0xbd, 0x00 // adcs eq r0 r13 r13
};
const byte kInstruction_adcs_ne_r14_r11_r0[] = {
  0x00, 0xe0, 0xbb, 0x10 // adcs ne r14 r11 r0
};
const byte kInstruction_adcs_mi_r6_r8_r7[] = {
  0x07, 0x60, 0xb8, 0x40 // adcs mi r6 r8 r7
};
const byte kInstruction_adcs_eq_r1_r7_r5[] = {
  0x05, 0x10, 0xb7, 0x00 // adcs eq r1 r7 r5
};
const byte kInstruction_adcs_pl_r12_r9_r12[] = {
  0x0c, 0xc0, 0xb9, 0x50 // adcs pl r12 r9 r12
};
const byte kInstruction_adcs_al_r4_r5_r14[] = {
  0x0e, 0x40, 0xb5, 0xe0 // adcs al r4 r5 r14
};
const byte kInstruction_adcs_pl_r7_r0_r12[] = {
  0x0c, 0x70, 0xb0, 0x50 // adcs pl r7 r0 r12
};
const byte kInstruction_adcs_mi_r5_r0_r13[] = {
  0x0d, 0x50, 0xb0, 0x40 // adcs mi r5 r0 r13
};
const byte kInstruction_adcs_al_r10_r7_r11[] = {
  0x0b, 0xa0, 0xb7, 0xe0 // adcs al r10 r7 r11
};
const byte kInstruction_adcs_gt_r2_r10_r0[] = {
  0x00, 0x20, 0xba, 0xc0 // adcs gt r2 r10 r0
};
const byte kInstruction_adcs_ge_r11_r11_r8[] = {
  0x08, 0xb0, 0xbb, 0xa0 // adcs ge r11 r11 r8
};
const byte kInstruction_adcs_eq_r14_r7_r3[] = {
  0x03, 0xe0, 0xb7, 0x00 // adcs eq r14 r7 r3
};
const byte kInstruction_adcs_ls_r0_r12_r4[] = {
  0x04, 0x00, 0xbc, 0x90 // adcs ls r0 r12 r4
};
const byte kInstruction_adcs_ne_r10_r1_r7[] = {
  0x07, 0xa0, 0xb1, 0x10 // adcs ne r10 r1 r7
};
const byte kInstruction_adcs_hi_r14_r3_r13[] = {
  0x0d, 0xe0, 0xb3, 0x80 // adcs hi r14 r3 r13
};
const byte kInstruction_adcs_le_r1_r5_r12[] = {
  0x0c, 0x10, 0xb5, 0xd0 // adcs le r1 r5 r12
};
const byte kInstruction_adcs_ne_r8_r5_r11[] = {
  0x0b, 0x80, 0xb5, 0x10 // adcs ne r8 r5 r11
};
const byte kInstruction_adcs_le_r5_r13_r0[] = {
  0x00, 0x50, 0xbd, 0xd0 // adcs le r5 r13 r0
};
const byte kInstruction_adcs_gt_r8_r12_r7[] = {
  0x07, 0x80, 0xbc, 0xc0 // adcs gt r8 r12 r7
};
const byte kInstruction_adcs_eq_r9_r14_r3[] = {
  0x03, 0x90, 0xbe, 0x00 // adcs eq r9 r14 r3
};
const byte kInstruction_adcs_cs_r10_r9_r9[] = {
  0x09, 0xa0, 0xb9, 0x20 // adcs cs r10 r9 r9
};
const byte kInstruction_adcs_vc_r5_r13_r8[] = {
  0x08, 0x50, 0xbd, 0x70 // adcs vc r5 r13 r8
};
const byte kInstruction_adcs_eq_r4_r1_r8[] = {
  0x08, 0x40, 0xb1, 0x00 // adcs eq r4 r1 r8
};
const byte kInstruction_adcs_lt_r12_r14_r9[] = {
  0x09, 0xc0, 0xbe, 0xb0 // adcs lt r12 r14 r9
};
const byte kInstruction_adcs_cc_r8_r8_r0[] = {
  0x00, 0x80, 0xb8, 0x30 // adcs cc r8 r8 r0
};
const byte kInstruction_adcs_hi_r0_r14_r12[] = {
  0x0c, 0x00, 0xbe, 0x80 // adcs hi r0 r14 r12
};
const byte kInstruction_adcs_hi_r4_r1_r10[] = {
  0x0a, 0x40, 0xb1, 0x80 // adcs hi r4 r1 r10
};
const byte kInstruction_adcs_gt_r2_r14_r12[] = {
  0x0c, 0x20, 0xbe, 0xc0 // adcs gt r2 r14 r12
};
const byte kInstruction_adcs_vs_r1_r8_r14[] = {
  0x0e, 0x10, 0xb8, 0x60 // adcs vs r1 r8 r14
};
const byte kInstruction_adcs_cs_r4_r1_r6[] = {
  0x06, 0x40, 0xb1, 0x20 // adcs cs r4 r1 r6
};
const byte kInstruction_adcs_hi_r7_r8_r7[] = {
  0x07, 0x70, 0xb8, 0x80 // adcs hi r7 r8 r7
};
const byte kInstruction_adcs_hi_r3_r11_r8[] = {
  0x08, 0x30, 0xbb, 0x80 // adcs hi r3 r11 r8
};
const byte kInstruction_adcs_lt_r1_r12_r9[] = {
  0x09, 0x10, 0xbc, 0xb0 // adcs lt r1 r12 r9
};
const byte kInstruction_adcs_cs_r13_r4_r12[] = {
  0x0c, 0xd0, 0xb4, 0x20 // adcs cs r13 r4 r12
};
const byte kInstruction_adcs_eq_r10_r10_r5[] = {
  0x05, 0xa0, 0xba, 0x00 // adcs eq r10 r10 r5
};
const byte kInstruction_adcs_ge_r10_r14_r0[] = {
  0x00, 0xa0, 0xbe, 0xa0 // adcs ge r10 r14 r0
};
const byte kInstruction_adcs_lt_r3_r3_r2[] = {
  0x02, 0x30, 0xb3, 0xb0 // adcs lt r3 r3 r2
};
const byte kInstruction_adcs_vs_r2_r13_r2[] = {
  0x02, 0x20, 0xbd, 0x60 // adcs vs r2 r13 r2
};
const byte kInstruction_adcs_ls_r6_r2_r12[] = {
  0x0c, 0x60, 0xb2, 0x90 // adcs ls r6 r2 r12
};
const byte kInstruction_adcs_gt_r5_r11_r12[] = {
  0x0c, 0x50, 0xbb, 0xc0 // adcs gt r5 r11 r12
};
const byte kInstruction_adcs_al_r11_r10_r6[] = {
  0x06, 0xb0, 0xba, 0xe0 // adcs al r11 r10 r6
};
const byte kInstruction_adcs_hi_r12_r14_r14[] = {
  0x0e, 0xc0, 0xbe, 0x80 // adcs hi r12 r14 r14
};
const byte kInstruction_adcs_ge_r12_r10_r6[] = {
  0x06, 0xc0, 0xba, 0xa0 // adcs ge r12 r10 r6
};
const byte kInstruction_adcs_eq_r8_r3_r9[] = {
  0x09, 0x80, 0xb3, 0x00 // adcs eq r8 r3 r9
};
const byte kInstruction_adcs_cc_r7_r5_r1[] = {
  0x01, 0x70, 0xb5, 0x30 // adcs cc r7 r5 r1
};
const byte kInstruction_adcs_lt_r3_r0_r6[] = {
  0x06, 0x30, 0xb0, 0xb0 // adcs lt r3 r0 r6
};
const byte kInstruction_adcs_le_r14_r4_r12[] = {
  0x0c, 0xe0, 0xb4, 0xd0 // adcs le r14 r4 r12
};
const byte kInstruction_adcs_le_r9_r6_r4[] = {
  0x04, 0x90, 0xb6, 0xd0 // adcs le r9 r6 r4
};
const byte kInstruction_adcs_hi_r6_r11_r0[] = {
  0x00, 0x60, 0xbb, 0x80 // adcs hi r6 r11 r0
};
const byte kInstruction_adcs_al_r3_r7_r6[] = {
  0x06, 0x30, 0xb7, 0xe0 // adcs al r3 r7 r6
};
const byte kInstruction_adcs_lt_r10_r9_r12[] = {
  0x0c, 0xa0, 0xb9, 0xb0 // adcs lt r10 r9 r12
};
const byte kInstruction_adcs_al_r14_r8_r4[] = {
  0x04, 0xe0, 0xb8, 0xe0 // adcs al r14 r8 r4
};
const byte kInstruction_adcs_le_r14_r11_r14[] = {
  0x0e, 0xe0, 0xbb, 0xd0 // adcs le r14 r11 r14
};
const byte kInstruction_adcs_al_r14_r13_r8[] = {
  0x08, 0xe0, 0xbd, 0xe0 // adcs al r14 r13 r8
};
const byte kInstruction_adcs_ge_r5_r9_r10[] = {
  0x0a, 0x50, 0xb9, 0xa0 // adcs ge r5 r9 r10
};
const byte kInstruction_adcs_eq_r1_r9_r4[] = {
  0x04, 0x10, 0xb9, 0x00 // adcs eq r1 r9 r4
};
const byte kInstruction_adcs_cc_r5_r13_r8[] = {
  0x08, 0x50, 0xbd, 0x30 // adcs cc r5 r13 r8
};
const byte kInstruction_adcs_ne_r10_r0_r14[] = {
  0x0e, 0xa0, 0xb0, 0x10 // adcs ne r10 r0 r14
};
const byte kInstruction_adcs_al_r2_r0_r10[] = {
  0x0a, 0x20, 0xb0, 0xe0 // adcs al r2 r0 r10
};
const byte kInstruction_adcs_pl_r4_r0_r11[] = {
  0x0b, 0x40, 0xb0, 0x50 // adcs pl r4 r0 r11
};
const byte kInstruction_adcs_gt_r13_r5_r12[] = {
  0x0c, 0xd0, 0xb5, 0xc0 // adcs gt r13 r5 r12
};
const byte kInstruction_adcs_al_r2_r13_r8[] = {
  0x08, 0x20, 0xbd, 0xe0 // adcs al r2 r13 r8
};
const byte kInstruction_adcs_mi_r11_r3_r4[] = {
  0x04, 0xb0, 0xb3, 0x40 // adcs mi r11 r3 r4
};
const byte kInstruction_adcs_le_r11_r8_r1[] = {
  0x01, 0xb0, 0xb8, 0xd0 // adcs le r11 r8 r1
};
const byte kInstruction_adcs_hi_r12_r11_r1[] = {
  0x01, 0xc0, 0xbb, 0x80 // adcs hi r12 r11 r1
};
const byte kInstruction_adcs_ls_r6_r7_r2[] = {
  0x02, 0x60, 0xb7, 0x90 // adcs ls r6 r7 r2
};
const byte kInstruction_adcs_cs_r7_r11_r2[] = {
  0x02, 0x70, 0xbb, 0x20 // adcs cs r7 r11 r2
};
const byte kInstruction_adcs_vc_r11_r13_r7[] = {
  0x07, 0xb0, 0xbd, 0x70 // adcs vc r11 r13 r7
};
const byte kInstruction_adcs_cs_r13_r0_r1[] = {
  0x01, 0xd0, 0xb0, 0x20 // adcs cs r13 r0 r1
};
const byte kInstruction_adcs_cc_r5_r4_r6[] = {
  0x06, 0x50, 0xb4, 0x30 // adcs cc r5 r4 r6
};
const byte kInstruction_adcs_gt_r4_r4_r13[] = {
  0x0d, 0x40, 0xb4, 0xc0 // adcs gt r4 r4 r13
};
const byte kInstruction_adcs_al_r14_r8_r2[] = {
  0x02, 0xe0, 0xb8, 0xe0 // adcs al r14 r8 r2
};
const TestResult kReferenceadcs[] = {
  {
    ARRAY_SIZE(kInstruction_adcs_le_r4_r5_r14),
    kInstruction_adcs_le_r4_r5_r14,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ge_r5_r11_r10),
    kInstruction_adcs_ge_r5_r11_r10,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ls_r0_r9_r9),
    kInstruction_adcs_ls_r0_r9_r9,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_le_r8_r7_r2),
    kInstruction_adcs_le_r8_r7_r2,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_eq_r1_r10_r13),
    kInstruction_adcs_eq_r1_r10_r13,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_le_r9_r12_r2),
    kInstruction_adcs_le_r9_r12_r2,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_pl_r6_r1_r5),
    kInstruction_adcs_pl_r6_r1_r5,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ge_r1_r12_r6),
    kInstruction_adcs_ge_r1_r12_r6,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cc_r13_r12_r3),
    kInstruction_adcs_cc_r13_r12_r3,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_gt_r2_r4_r9),
    kInstruction_adcs_gt_r2_r4_r9,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_le_r3_r9_r10),
    kInstruction_adcs_le_r3_r9_r10,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_gt_r11_r1_r9),
    kInstruction_adcs_gt_r11_r1_r9,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cc_r8_r6_r11),
    kInstruction_adcs_cc_r8_r6_r11,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cs_r12_r9_r3),
    kInstruction_adcs_cs_r12_r9_r3,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_eq_r9_r14_r10),
    kInstruction_adcs_eq_r9_r14_r10,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_gt_r9_r0_r1),
    kInstruction_adcs_gt_r9_r0_r1,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_pl_r11_r8_r2),
    kInstruction_adcs_pl_r11_r8_r2,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_mi_r7_r1_r2),
    kInstruction_adcs_mi_r7_r1_r2,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vs_r8_r6_r7),
    kInstruction_adcs_vs_r8_r6_r7,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ne_r14_r2_r13),
    kInstruction_adcs_ne_r14_r2_r13,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_hi_r3_r3_r8),
    kInstruction_adcs_hi_r3_r3_r8,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vc_r10_r8_r14),
    kInstruction_adcs_vc_r10_r8_r14,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ls_r2_r11_r0),
    kInstruction_adcs_ls_r2_r11_r0,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ge_r8_r10_r0),
    kInstruction_adcs_ge_r8_r10_r0,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_mi_r8_r10_r5),
    kInstruction_adcs_mi_r8_r10_r5,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_pl_r1_r0_r9),
    kInstruction_adcs_pl_r1_r0_r9,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_gt_r6_r7_r3),
    kInstruction_adcs_gt_r6_r7_r3,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vs_r7_r9_r9),
    kInstruction_adcs_vs_r7_r9_r9,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_al_r9_r4_r2),
    kInstruction_adcs_al_r9_r4_r2,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_le_r3_r1_r2),
    kInstruction_adcs_le_r3_r1_r2,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_mi_r6_r14_r0),
    kInstruction_adcs_mi_r6_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vc_r7_r10_r11),
    kInstruction_adcs_vc_r7_r10_r11,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_hi_r13_r2_r10),
    kInstruction_adcs_hi_r13_r2_r10,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cs_r5_r4_r12),
    kInstruction_adcs_cs_r5_r4_r12,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ls_r13_r9_r11),
    kInstruction_adcs_ls_r13_r9_r11,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ne_r2_r10_r12),
    kInstruction_adcs_ne_r2_r10_r12,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vc_r4_r6_r8),
    kInstruction_adcs_vc_r4_r6_r8,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_lt_r13_r0_r13),
    kInstruction_adcs_lt_r13_r0_r13,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_pl_r11_r14_r5),
    kInstruction_adcs_pl_r11_r14_r5,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cs_r8_r11_r3),
    kInstruction_adcs_cs_r8_r11_r3,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cs_r4_r1_r7),
    kInstruction_adcs_cs_r4_r1_r7,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_al_r0_r12_r13),
    kInstruction_adcs_al_r0_r12_r13,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_gt_r3_r6_r0),
    kInstruction_adcs_gt_r3_r6_r0,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vc_r6_r9_r0),
    kInstruction_adcs_vc_r6_r9_r0,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cc_r2_r2_r12),
    kInstruction_adcs_cc_r2_r2_r12,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cs_r4_r13_r1),
    kInstruction_adcs_cs_r4_r13_r1,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_mi_r12_r12_r10),
    kInstruction_adcs_mi_r12_r12_r10,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_hi_r8_r9_r14),
    kInstruction_adcs_hi_r8_r9_r14,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_hi_r4_r3_r7),
    kInstruction_adcs_hi_r4_r3_r7,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ne_r11_r10_r1),
    kInstruction_adcs_ne_r11_r10_r1,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cc_r2_r6_r3),
    kInstruction_adcs_cc_r2_r6_r3,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cs_r6_r6_r0),
    kInstruction_adcs_cs_r6_r6_r0,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vc_r13_r2_r9),
    kInstruction_adcs_vc_r13_r2_r9,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vc_r7_r13_r14),
    kInstruction_adcs_vc_r7_r13_r14,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_pl_r11_r14_r4),
    kInstruction_adcs_pl_r11_r14_r4,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_lt_r12_r14_r8),
    kInstruction_adcs_lt_r12_r14_r8,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cs_r2_r11_r14),
    kInstruction_adcs_cs_r2_r11_r14,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_le_r12_r13_r2),
    kInstruction_adcs_le_r12_r13_r2,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_le_r5_r6_r14),
    kInstruction_adcs_le_r5_r6_r14,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vc_r3_r14_r8),
    kInstruction_adcs_vc_r3_r14_r8,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_lt_r7_r6_r14),
    kInstruction_adcs_lt_r7_r6_r14,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ls_r0_r13_r12),
    kInstruction_adcs_ls_r0_r13_r12,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ge_r10_r9_r14),
    kInstruction_adcs_ge_r10_r9_r14,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_le_r11_r12_r1),
    kInstruction_adcs_le_r11_r12_r1,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_al_r2_r12_r14),
    kInstruction_adcs_al_r2_r12_r14,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cs_r6_r4_r0),
    kInstruction_adcs_cs_r6_r4_r0,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vs_r5_r0_r3),
    kInstruction_adcs_vs_r5_r0_r3,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_le_r8_r8_r0),
    kInstruction_adcs_le_r8_r8_r0,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_gt_r1_r5_r4),
    kInstruction_adcs_gt_r1_r5_r4,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_le_r4_r3_r4),
    kInstruction_adcs_le_r4_r3_r4,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_pl_r9_r7_r10),
    kInstruction_adcs_pl_r9_r7_r10,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ls_r8_r7_r14),
    kInstruction_adcs_ls_r8_r7_r14,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vc_r9_r10_r6),
    kInstruction_adcs_vc_r9_r10_r6,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_hi_r2_r4_r9),
    kInstruction_adcs_hi_r2_r4_r9,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cs_r0_r2_r13),
    kInstruction_adcs_cs_r0_r2_r13,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vs_r3_r6_r12),
    kInstruction_adcs_vs_r3_r6_r12,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cc_r14_r14_r7),
    kInstruction_adcs_cc_r14_r14_r7,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vc_r10_r6_r4),
    kInstruction_adcs_vc_r10_r6_r4,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cc_r1_r6_r10),
    kInstruction_adcs_cc_r1_r6_r10,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vs_r13_r10_r11),
    kInstruction_adcs_vs_r13_r10_r11,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ls_r5_r7_r12),
    kInstruction_adcs_ls_r5_r7_r12,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_eq_r6_r4_r3),
    kInstruction_adcs_eq_r6_r4_r3,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_mi_r5_r9_r2),
    kInstruction_adcs_mi_r5_r9_r2,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_lt_r7_r1_r9),
    kInstruction_adcs_lt_r7_r1_r9,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ne_r12_r7_r0),
    kInstruction_adcs_ne_r12_r7_r0,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_eq_r0_r6_r7),
    kInstruction_adcs_eq_r0_r6_r7,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_pl_r7_r3_r9),
    kInstruction_adcs_pl_r7_r3_r9,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_pl_r11_r11_r13),
    kInstruction_adcs_pl_r11_r11_r13,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_gt_r0_r10_r5),
    kInstruction_adcs_gt_r0_r10_r5,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_mi_r14_r1_r10),
    kInstruction_adcs_mi_r14_r1_r10,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_mi_r5_r14_r0),
    kInstruction_adcs_mi_r5_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ne_r12_r9_r13),
    kInstruction_adcs_ne_r12_r9_r13,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_hi_r8_r5_r11),
    kInstruction_adcs_hi_r8_r5_r11,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ls_r7_r0_r5),
    kInstruction_adcs_ls_r7_r0_r5,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_lt_r5_r1_r7),
    kInstruction_adcs_lt_r5_r1_r7,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cc_r2_r8_r4),
    kInstruction_adcs_cc_r2_r8_r4,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_lt_r3_r0_r5),
    kInstruction_adcs_lt_r3_r0_r5,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_pl_r4_r9_r7),
    kInstruction_adcs_pl_r4_r9_r7,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_eq_r13_r8_r10),
    kInstruction_adcs_eq_r13_r8_r10,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ge_r6_r10_r10),
    kInstruction_adcs_ge_r6_r10_r10,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_lt_r5_r5_r7),
    kInstruction_adcs_lt_r5_r5_r7,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_hi_r6_r3_r9),
    kInstruction_adcs_hi_r6_r3_r9,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_hi_r14_r12_r10),
    kInstruction_adcs_hi_r14_r12_r10,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_lt_r9_r13_r14),
    kInstruction_adcs_lt_r9_r13_r14,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_al_r0_r12_r7),
    kInstruction_adcs_al_r0_r12_r7,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_eq_r14_r8_r11),
    kInstruction_adcs_eq_r14_r8_r11,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ne_r9_r11_r1),
    kInstruction_adcs_ne_r9_r11_r1,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ge_r5_r0_r3),
    kInstruction_adcs_ge_r5_r0_r3,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_pl_r12_r0_r1),
    kInstruction_adcs_pl_r12_r0_r1,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_lt_r13_r7_r11),
    kInstruction_adcs_lt_r13_r7_r11,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_eq_r4_r6_r6),
    kInstruction_adcs_eq_r4_r6_r6,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cs_r1_r14_r0),
    kInstruction_adcs_cs_r1_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_hi_r7_r7_r6),
    kInstruction_adcs_hi_r7_r7_r6,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_hi_r1_r0_r3),
    kInstruction_adcs_hi_r1_r0_r3,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_pl_r12_r2_r0),
    kInstruction_adcs_pl_r12_r2_r0,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_mi_r3_r0_r3),
    kInstruction_adcs_mi_r3_r0_r3,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_al_r14_r4_r3),
    kInstruction_adcs_al_r14_r4_r3,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vs_r4_r2_r9),
    kInstruction_adcs_vs_r4_r2_r9,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vs_r1_r9_r12),
    kInstruction_adcs_vs_r1_r9_r12,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vs_r3_r6_r9),
    kInstruction_adcs_vs_r3_r6_r9,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cc_r4_r1_r8),
    kInstruction_adcs_cc_r4_r1_r8,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ls_r10_r11_r14),
    kInstruction_adcs_ls_r10_r11_r14,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_le_r11_r7_r2),
    kInstruction_adcs_le_r11_r7_r2,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_le_r6_r9_r14),
    kInstruction_adcs_le_r6_r9_r14,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_al_r1_r3_r11),
    kInstruction_adcs_al_r1_r3_r11,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_lt_r0_r2_r2),
    kInstruction_adcs_lt_r0_r2_r2,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_eq_r11_r6_r8),
    kInstruction_adcs_eq_r11_r6_r8,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ls_r7_r12_r5),
    kInstruction_adcs_ls_r7_r12_r5,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vc_r4_r11_r0),
    kInstruction_adcs_vc_r4_r11_r0,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ls_r7_r14_r2),
    kInstruction_adcs_ls_r7_r14_r2,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_le_r7_r12_r1),
    kInstruction_adcs_le_r7_r12_r1,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_le_r1_r14_r13),
    kInstruction_adcs_le_r1_r14_r13,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_le_r11_r3_r9),
    kInstruction_adcs_le_r11_r3_r9,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ne_r14_r13_r1),
    kInstruction_adcs_ne_r14_r13_r1,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ne_r5_r1_r10),
    kInstruction_adcs_ne_r5_r1_r10,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cc_r7_r4_r3),
    kInstruction_adcs_cc_r7_r4_r3,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_lt_r8_r1_r1),
    kInstruction_adcs_lt_r8_r1_r1,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_al_r5_r0_r1),
    kInstruction_adcs_al_r5_r0_r1,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ge_r11_r13_r9),
    kInstruction_adcs_ge_r11_r13_r9,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_gt_r5_r9_r5),
    kInstruction_adcs_gt_r5_r9_r5,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cc_r2_r8_r3),
    kInstruction_adcs_cc_r2_r8_r3,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_eq_r6_r6_r12),
    kInstruction_adcs_eq_r6_r6_r12,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vc_r3_r10_r13),
    kInstruction_adcs_vc_r3_r10_r13,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vc_r9_r13_r1),
    kInstruction_adcs_vc_r9_r13_r1,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_lt_r7_r0_r0),
    kInstruction_adcs_lt_r7_r0_r0,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cc_r6_r6_r1),
    kInstruction_adcs_cc_r6_r6_r1,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_mi_r8_r1_r9),
    kInstruction_adcs_mi_r8_r1_r9,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ls_r14_r10_r10),
    kInstruction_adcs_ls_r14_r10_r10,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ge_r7_r13_r1),
    kInstruction_adcs_ge_r7_r13_r1,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_le_r0_r4_r3),
    kInstruction_adcs_le_r0_r4_r3,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cc_r12_r10_r10),
    kInstruction_adcs_cc_r12_r10_r10,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ge_r5_r0_r10),
    kInstruction_adcs_ge_r5_r0_r10,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vs_r8_r3_r10),
    kInstruction_adcs_vs_r8_r3_r10,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ge_r11_r12_r2),
    kInstruction_adcs_ge_r11_r12_r2,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ne_r14_r4_r8),
    kInstruction_adcs_ne_r14_r4_r8,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_mi_r3_r0_r4),
    kInstruction_adcs_mi_r3_r0_r4,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_gt_r13_r9_r6),
    kInstruction_adcs_gt_r13_r9_r6,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ls_r1_r14_r2),
    kInstruction_adcs_ls_r1_r14_r2,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_eq_r11_r3_r12),
    kInstruction_adcs_eq_r11_r3_r12,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ge_r4_r13_r4),
    kInstruction_adcs_ge_r4_r13_r4,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_al_r5_r9_r7),
    kInstruction_adcs_al_r5_r9_r7,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_le_r11_r9_r0),
    kInstruction_adcs_le_r11_r9_r0,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_mi_r13_r10_r12),
    kInstruction_adcs_mi_r13_r10_r12,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_hi_r5_r5_r10),
    kInstruction_adcs_hi_r5_r5_r10,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ge_r4_r6_r14),
    kInstruction_adcs_ge_r4_r6_r14,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_le_r5_r5_r7),
    kInstruction_adcs_le_r5_r5_r7,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_pl_r12_r2_r8),
    kInstruction_adcs_pl_r12_r2_r8,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_al_r7_r8_r10),
    kInstruction_adcs_al_r7_r8_r10,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vc_r8_r11_r13),
    kInstruction_adcs_vc_r8_r11_r13,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ne_r14_r2_r12),
    kInstruction_adcs_ne_r14_r2_r12,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_eq_r10_r4_r2),
    kInstruction_adcs_eq_r10_r4_r2,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_al_r6_r2_r5),
    kInstruction_adcs_al_r6_r2_r5,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_al_r1_r6_r2),
    kInstruction_adcs_al_r1_r6_r2,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vs_r0_r7_r14),
    kInstruction_adcs_vs_r0_r7_r14,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_hi_r9_r7_r0),
    kInstruction_adcs_hi_r9_r7_r0,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ne_r8_r11_r13),
    kInstruction_adcs_ne_r8_r11_r13,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ne_r9_r8_r12),
    kInstruction_adcs_ne_r9_r8_r12,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_al_r14_r8_r6),
    kInstruction_adcs_al_r14_r8_r6,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vc_r8_r0_r3),
    kInstruction_adcs_vc_r8_r0_r3,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_pl_r11_r9_r0),
    kInstruction_adcs_pl_r11_r9_r0,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_al_r7_r9_r9),
    kInstruction_adcs_al_r7_r9_r9,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ls_r0_r8_r3),
    kInstruction_adcs_ls_r0_r8_r3,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_lt_r5_r13_r6),
    kInstruction_adcs_lt_r5_r13_r6,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ge_r6_r5_r13),
    kInstruction_adcs_ge_r6_r5_r13,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cs_r11_r7_r3),
    kInstruction_adcs_cs_r11_r7_r3,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vs_r8_r0_r6),
    kInstruction_adcs_vs_r8_r0_r6,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_hi_r0_r12_r6),
    kInstruction_adcs_hi_r0_r12_r6,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_eq_r14_r5_r12),
    kInstruction_adcs_eq_r14_r5_r12,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_lt_r1_r4_r13),
    kInstruction_adcs_lt_r1_r4_r13,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_hi_r6_r4_r2),
    kInstruction_adcs_hi_r6_r4_r2,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_lt_r10_r10_r9),
    kInstruction_adcs_lt_r10_r10_r9,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_pl_r14_r7_r4),
    kInstruction_adcs_pl_r14_r7_r4,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ge_r8_r3_r4),
    kInstruction_adcs_ge_r8_r3_r4,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_al_r11_r1_r14),
    kInstruction_adcs_al_r11_r1_r14,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ge_r7_r8_r9),
    kInstruction_adcs_ge_r7_r8_r9,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_le_r10_r10_r8),
    kInstruction_adcs_le_r10_r10_r8,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_hi_r3_r3_r7),
    kInstruction_adcs_hi_r3_r3_r7,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cc_r3_r0_r14),
    kInstruction_adcs_cc_r3_r0_r14,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_al_r8_r9_r1),
    kInstruction_adcs_al_r8_r9_r1,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_gt_r6_r13_r7),
    kInstruction_adcs_gt_r6_r13_r7,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ls_r11_r3_r1),
    kInstruction_adcs_ls_r11_r3_r1,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cc_r14_r0_r13),
    kInstruction_adcs_cc_r14_r0_r13,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_gt_r4_r4_r4),
    kInstruction_adcs_gt_r4_r4_r4,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_al_r8_r13_r1),
    kInstruction_adcs_al_r8_r13_r1,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_mi_r8_r4_r6),
    kInstruction_adcs_mi_r8_r4_r6,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vc_r12_r7_r11),
    kInstruction_adcs_vc_r12_r7_r11,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cs_r0_r1_r0),
    kInstruction_adcs_cs_r0_r1_r0,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cc_r13_r14_r0),
    kInstruction_adcs_cc_r13_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_eq_r4_r7_r11),
    kInstruction_adcs_eq_r4_r7_r11,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ls_r11_r2_r0),
    kInstruction_adcs_ls_r11_r2_r0,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_gt_r10_r2_r3),
    kInstruction_adcs_gt_r10_r2_r3,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_al_r6_r1_r7),
    kInstruction_adcs_al_r6_r1_r7,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cs_r10_r13_r0),
    kInstruction_adcs_cs_r10_r13_r0,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_lt_r11_r2_r6),
    kInstruction_adcs_lt_r11_r2_r6,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_pl_r4_r13_r6),
    kInstruction_adcs_pl_r4_r13_r6,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cs_r3_r0_r9),
    kInstruction_adcs_cs_r3_r0_r9,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_gt_r4_r6_r14),
    kInstruction_adcs_gt_r4_r6_r14,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_eq_r6_r8_r0),
    kInstruction_adcs_eq_r6_r8_r0,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cc_r5_r5_r2),
    kInstruction_adcs_cc_r5_r5_r2,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_al_r9_r3_r7),
    kInstruction_adcs_al_r9_r3_r7,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cc_r12_r0_r8),
    kInstruction_adcs_cc_r12_r0_r8,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_le_r4_r1_r7),
    kInstruction_adcs_le_r4_r1_r7,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_gt_r3_r12_r7),
    kInstruction_adcs_gt_r3_r12_r7,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vc_r4_r3_r14),
    kInstruction_adcs_vc_r4_r3_r14,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_le_r0_r7_r10),
    kInstruction_adcs_le_r0_r7_r10,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vs_r14_r8_r13),
    kInstruction_adcs_vs_r14_r8_r13,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_hi_r9_r0_r11),
    kInstruction_adcs_hi_r9_r0_r11,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_eq_r8_r13_r0),
    kInstruction_adcs_eq_r8_r13_r0,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vc_r10_r9_r2),
    kInstruction_adcs_vc_r10_r9_r2,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_al_r0_r13_r10),
    kInstruction_adcs_al_r0_r13_r10,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ne_r5_r4_r6),
    kInstruction_adcs_ne_r5_r4_r6,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cc_r7_r13_r1),
    kInstruction_adcs_cc_r7_r13_r1,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_lt_r1_r14_r11),
    kInstruction_adcs_lt_r1_r14_r11,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vc_r13_r10_r14),
    kInstruction_adcs_vc_r13_r10_r14,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_le_r3_r0_r4),
    kInstruction_adcs_le_r3_r0_r4,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_al_r11_r4_r5),
    kInstruction_adcs_al_r11_r4_r5,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_lt_r0_r8_r8),
    kInstruction_adcs_lt_r0_r8_r8,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_al_r13_r12_r7),
    kInstruction_adcs_al_r13_r12_r7,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ls_r12_r13_r13),
    kInstruction_adcs_ls_r12_r13_r13,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vc_r8_r2_r9),
    kInstruction_adcs_vc_r8_r2_r9,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ne_r14_r9_r3),
    kInstruction_adcs_ne_r14_r9_r3,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_pl_r12_r11_r6),
    kInstruction_adcs_pl_r12_r11_r6,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_eq_r0_r3_r5),
    kInstruction_adcs_eq_r0_r3_r5,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_hi_r11_r3_r14),
    kInstruction_adcs_hi_r11_r3_r14,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_le_r3_r7_r4),
    kInstruction_adcs_le_r3_r7_r4,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ne_r6_r9_r8),
    kInstruction_adcs_ne_r6_r9_r8,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vc_r11_r11_r11),
    kInstruction_adcs_vc_r11_r11_r11,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ge_r3_r1_r10),
    kInstruction_adcs_ge_r3_r1_r10,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_gt_r5_r14_r13),
    kInstruction_adcs_gt_r5_r14_r13,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_le_r7_r0_r13),
    kInstruction_adcs_le_r7_r0_r13,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_lt_r8_r5_r1),
    kInstruction_adcs_lt_r8_r5_r1,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_le_r3_r4_r8),
    kInstruction_adcs_le_r3_r4_r8,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ne_r5_r11_r13),
    kInstruction_adcs_ne_r5_r11_r13,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ge_r9_r8_r2),
    kInstruction_adcs_ge_r9_r8_r2,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_gt_r9_r5_r12),
    kInstruction_adcs_gt_r9_r5_r12,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_pl_r9_r8_r1),
    kInstruction_adcs_pl_r9_r8_r1,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_le_r3_r12_r4),
    kInstruction_adcs_le_r3_r12_r4,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_eq_r5_r6_r9),
    kInstruction_adcs_eq_r5_r6_r9,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ne_r14_r4_r13),
    kInstruction_adcs_ne_r14_r4_r13,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ge_r3_r9_r2),
    kInstruction_adcs_ge_r3_r9_r2,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ls_r13_r0_r10),
    kInstruction_adcs_ls_r13_r0_r10,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_mi_r14_r0_r2),
    kInstruction_adcs_mi_r14_r0_r2,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cs_r11_r1_r3),
    kInstruction_adcs_cs_r11_r1_r3,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ne_r8_r9_r10),
    kInstruction_adcs_ne_r8_r9_r10,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_gt_r9_r10_r4),
    kInstruction_adcs_gt_r9_r10_r4,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_le_r2_r8_r4),
    kInstruction_adcs_le_r2_r8_r4,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_al_r6_r14_r11),
    kInstruction_adcs_al_r6_r14_r11,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_eq_r3_r14_r14),
    kInstruction_adcs_eq_r3_r14_r14,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_pl_r9_r9_r3),
    kInstruction_adcs_pl_r9_r9_r3,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ge_r5_r13_r12),
    kInstruction_adcs_ge_r5_r13_r12,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_mi_r10_r6_r5),
    kInstruction_adcs_mi_r10_r6_r5,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ls_r14_r13_r12),
    kInstruction_adcs_ls_r14_r13_r12,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_lt_r10_r9_r10),
    kInstruction_adcs_lt_r10_r9_r10,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ls_r7_r4_r9),
    kInstruction_adcs_ls_r7_r4_r9,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cs_r9_r10_r7),
    kInstruction_adcs_cs_r9_r10_r7,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_eq_r4_r2_r2),
    kInstruction_adcs_eq_r4_r2_r2,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_lt_r14_r13_r4),
    kInstruction_adcs_lt_r14_r13_r4,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_al_r0_r3_r5),
    kInstruction_adcs_al_r0_r3_r5,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vs_r9_r6_r7),
    kInstruction_adcs_vs_r9_r6_r7,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ls_r0_r6_r4),
    kInstruction_adcs_ls_r0_r6_r4,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ne_r7_r10_r14),
    kInstruction_adcs_ne_r7_r10_r14,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_le_r2_r12_r1),
    kInstruction_adcs_le_r2_r12_r1,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cs_r1_r5_r0),
    kInstruction_adcs_cs_r1_r5_r0,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_pl_r0_r9_r1),
    kInstruction_adcs_pl_r0_r9_r1,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_mi_r2_r2_r5),
    kInstruction_adcs_mi_r2_r2_r5,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_hi_r5_r1_r12),
    kInstruction_adcs_hi_r5_r1_r12,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ls_r13_r14_r7),
    kInstruction_adcs_ls_r13_r14_r7,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_lt_r0_r4_r3),
    kInstruction_adcs_lt_r0_r4_r3,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cc_r8_r13_r2),
    kInstruction_adcs_cc_r8_r13_r2,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ls_r7_r8_r14),
    kInstruction_adcs_ls_r7_r8_r14,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_hi_r13_r11_r13),
    kInstruction_adcs_hi_r13_r11_r13,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ge_r13_r7_r6),
    kInstruction_adcs_ge_r13_r7_r6,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_mi_r3_r2_r0),
    kInstruction_adcs_mi_r3_r2_r0,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cs_r12_r0_r10),
    kInstruction_adcs_cs_r12_r0_r10,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vs_r9_r10_r8),
    kInstruction_adcs_vs_r9_r10_r8,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ls_r2_r8_r8),
    kInstruction_adcs_ls_r2_r8_r8,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ge_r1_r11_r3),
    kInstruction_adcs_ge_r1_r11_r3,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ge_r12_r3_r3),
    kInstruction_adcs_ge_r12_r3_r3,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_gt_r3_r8_r6),
    kInstruction_adcs_gt_r3_r8_r6,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ne_r13_r2_r9),
    kInstruction_adcs_ne_r13_r2_r9,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ls_r14_r9_r1),
    kInstruction_adcs_ls_r14_r9_r1,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cc_r2_r10_r2),
    kInstruction_adcs_cc_r2_r10_r2,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_le_r9_r12_r1),
    kInstruction_adcs_le_r9_r12_r1,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cs_r11_r10_r0),
    kInstruction_adcs_cs_r11_r10_r0,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_eq_r7_r0_r5),
    kInstruction_adcs_eq_r7_r0_r5,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ne_r10_r4_r4),
    kInstruction_adcs_ne_r10_r4_r4,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_pl_r13_r9_r6),
    kInstruction_adcs_pl_r13_r9_r6,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vc_r11_r3_r3),
    kInstruction_adcs_vc_r11_r3_r3,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_al_r1_r13_r9),
    kInstruction_adcs_al_r1_r13_r9,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cc_r13_r9_r14),
    kInstruction_adcs_cc_r13_r9_r14,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vc_r5_r2_r3),
    kInstruction_adcs_vc_r5_r2_r3,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ne_r12_r8_r10),
    kInstruction_adcs_ne_r12_r8_r10,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cs_r11_r13_r6),
    kInstruction_adcs_cs_r11_r13_r6,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_al_r1_r11_r10),
    kInstruction_adcs_al_r1_r11_r10,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ne_r14_r6_r11),
    kInstruction_adcs_ne_r14_r6_r11,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cs_r1_r14_r5),
    kInstruction_adcs_cs_r1_r14_r5,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_al_r11_r11_r6),
    kInstruction_adcs_al_r11_r11_r6,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_pl_r3_r6_r2),
    kInstruction_adcs_pl_r3_r6_r2,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ne_r3_r9_r4),
    kInstruction_adcs_ne_r3_r9_r4,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_mi_r11_r4_r9),
    kInstruction_adcs_mi_r11_r4_r9,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_al_r10_r1_r3),
    kInstruction_adcs_al_r10_r1_r3,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vc_r2_r14_r11),
    kInstruction_adcs_vc_r2_r14_r11,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_mi_r9_r3_r0),
    kInstruction_adcs_mi_r9_r3_r0,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vs_r9_r8_r1),
    kInstruction_adcs_vs_r9_r8_r1,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_lt_r2_r12_r5),
    kInstruction_adcs_lt_r2_r12_r5,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_al_r9_r8_r12),
    kInstruction_adcs_al_r9_r8_r12,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vc_r3_r8_r0),
    kInstruction_adcs_vc_r3_r8_r0,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_mi_r10_r5_r1),
    kInstruction_adcs_mi_r10_r5_r1,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vc_r7_r14_r2),
    kInstruction_adcs_vc_r7_r14_r2,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ls_r0_r9_r7),
    kInstruction_adcs_ls_r0_r9_r7,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cs_r3_r0_r10),
    kInstruction_adcs_cs_r3_r0_r10,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cc_r10_r8_r10),
    kInstruction_adcs_cc_r10_r8_r10,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_eq_r5_r4_r1),
    kInstruction_adcs_eq_r5_r4_r1,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vc_r11_r13_r1),
    kInstruction_adcs_vc_r11_r13_r1,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_hi_r6_r5_r8),
    kInstruction_adcs_hi_r6_r5_r8,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ne_r10_r5_r6),
    kInstruction_adcs_ne_r10_r5_r6,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_al_r10_r12_r9),
    kInstruction_adcs_al_r10_r12_r9,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_eq_r5_r1_r12),
    kInstruction_adcs_eq_r5_r1_r12,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_le_r0_r14_r10),
    kInstruction_adcs_le_r0_r14_r10,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_eq_r4_r2_r5),
    kInstruction_adcs_eq_r4_r2_r5,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_pl_r5_r8_r2),
    kInstruction_adcs_pl_r5_r8_r2,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_hi_r5_r14_r4),
    kInstruction_adcs_hi_r5_r14_r4,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_le_r2_r7_r9),
    kInstruction_adcs_le_r2_r7_r9,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_pl_r5_r12_r6),
    kInstruction_adcs_pl_r5_r12_r6,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vs_r11_r4_r14),
    kInstruction_adcs_vs_r11_r4_r14,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_eq_r0_r7_r14),
    kInstruction_adcs_eq_r0_r7_r14,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_pl_r5_r2_r5),
    kInstruction_adcs_pl_r5_r2_r5,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ne_r5_r11_r7),
    kInstruction_adcs_ne_r5_r11_r7,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_pl_r7_r9_r10),
    kInstruction_adcs_pl_r7_r9_r10,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_hi_r4_r2_r2),
    kInstruction_adcs_hi_r4_r2_r2,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_pl_r14_r9_r2),
    kInstruction_adcs_pl_r14_r9_r2,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_le_r4_r11_r13),
    kInstruction_adcs_le_r4_r11_r13,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_pl_r8_r8_r8),
    kInstruction_adcs_pl_r8_r8_r8,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ge_r0_r6_r10),
    kInstruction_adcs_ge_r0_r6_r10,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vc_r4_r4_r10),
    kInstruction_adcs_vc_r4_r4_r10,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cc_r11_r9_r12),
    kInstruction_adcs_cc_r11_r9_r12,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_pl_r14_r4_r12),
    kInstruction_adcs_pl_r14_r4_r12,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vs_r8_r8_r8),
    kInstruction_adcs_vs_r8_r8_r8,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ge_r14_r2_r12),
    kInstruction_adcs_ge_r14_r2_r12,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ge_r8_r2_r13),
    kInstruction_adcs_ge_r8_r2_r13,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vs_r10_r0_r11),
    kInstruction_adcs_vs_r10_r0_r11,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_eq_r5_r1_r2),
    kInstruction_adcs_eq_r5_r1_r2,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vs_r10_r11_r3),
    kInstruction_adcs_vs_r10_r11_r3,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_lt_r13_r13_r7),
    kInstruction_adcs_lt_r13_r13_r7,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_le_r12_r7_r6),
    kInstruction_adcs_le_r12_r7_r6,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_eq_r4_r3_r3),
    kInstruction_adcs_eq_r4_r3_r3,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_pl_r0_r5_r8),
    kInstruction_adcs_pl_r0_r5_r8,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vs_r10_r5_r3),
    kInstruction_adcs_vs_r10_r5_r3,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_gt_r0_r11_r9),
    kInstruction_adcs_gt_r0_r11_r9,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cc_r8_r5_r9),
    kInstruction_adcs_cc_r8_r5_r9,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cs_r9_r12_r11),
    kInstruction_adcs_cs_r9_r12_r11,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_gt_r3_r4_r8),
    kInstruction_adcs_gt_r3_r4_r8,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ls_r8_r3_r10),
    kInstruction_adcs_ls_r8_r3_r10,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_eq_r8_r14_r12),
    kInstruction_adcs_eq_r8_r14_r12,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_gt_r7_r1_r3),
    kInstruction_adcs_gt_r7_r1_r3,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_al_r4_r4_r8),
    kInstruction_adcs_al_r4_r4_r8,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_gt_r9_r14_r10),
    kInstruction_adcs_gt_r9_r14_r10,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_lt_r3_r13_r2),
    kInstruction_adcs_lt_r3_r13_r2,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_le_r4_r11_r14),
    kInstruction_adcs_le_r4_r11_r14,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ge_r2_r14_r0),
    kInstruction_adcs_ge_r2_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_pl_r1_r8_r8),
    kInstruction_adcs_pl_r1_r8_r8,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_pl_r9_r2_r5),
    kInstruction_adcs_pl_r9_r2_r5,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vs_r13_r13_r1),
    kInstruction_adcs_vs_r13_r13_r1,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ge_r12_r14_r3),
    kInstruction_adcs_ge_r12_r14_r3,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vc_r0_r11_r4),
    kInstruction_adcs_vc_r0_r11_r4,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ge_r0_r2_r9),
    kInstruction_adcs_ge_r0_r2_r9,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vc_r12_r1_r6),
    kInstruction_adcs_vc_r12_r1_r6,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ne_r1_r3_r7),
    kInstruction_adcs_ne_r1_r3_r7,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vs_r10_r3_r9),
    kInstruction_adcs_vs_r10_r3_r9,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cc_r14_r4_r1),
    kInstruction_adcs_cc_r14_r4_r1,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_le_r9_r3_r7),
    kInstruction_adcs_le_r9_r3_r7,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_le_r1_r0_r14),
    kInstruction_adcs_le_r1_r0_r14,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_le_r0_r14_r4),
    kInstruction_adcs_le_r0_r14_r4,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_hi_r13_r8_r11),
    kInstruction_adcs_hi_r13_r8_r11,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cc_r10_r6_r11),
    kInstruction_adcs_cc_r10_r6_r11,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cc_r0_r10_r14),
    kInstruction_adcs_cc_r0_r10_r14,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_le_r4_r4_r0),
    kInstruction_adcs_le_r4_r4_r0,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_pl_r8_r14_r12),
    kInstruction_adcs_pl_r8_r14_r12,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ge_r13_r12_r2),
    kInstruction_adcs_ge_r13_r12_r2,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_al_r11_r11_r7),
    kInstruction_adcs_al_r11_r11_r7,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ls_r11_r12_r1),
    kInstruction_adcs_ls_r11_r12_r1,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vs_r10_r14_r14),
    kInstruction_adcs_vs_r10_r14_r14,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_pl_r2_r8_r12),
    kInstruction_adcs_pl_r2_r8_r12,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_pl_r12_r7_r11),
    kInstruction_adcs_pl_r12_r7_r11,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_eq_r5_r8_r13),
    kInstruction_adcs_eq_r5_r8_r13,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vc_r6_r6_r6),
    kInstruction_adcs_vc_r6_r6_r6,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vs_r0_r12_r1),
    kInstruction_adcs_vs_r0_r12_r1,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cs_r6_r0_r8),
    kInstruction_adcs_cs_r6_r0_r8,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cc_r3_r4_r1),
    kInstruction_adcs_cc_r3_r4_r1,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_lt_r1_r10_r14),
    kInstruction_adcs_lt_r1_r10_r14,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_le_r1_r3_r5),
    kInstruction_adcs_le_r1_r3_r5,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cc_r11_r1_r1),
    kInstruction_adcs_cc_r11_r1_r1,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vc_r1_r8_r7),
    kInstruction_adcs_vc_r1_r8_r7,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_eq_r3_r10_r13),
    kInstruction_adcs_eq_r3_r10_r13,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_hi_r14_r12_r12),
    kInstruction_adcs_hi_r14_r12_r12,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_eq_r10_r1_r14),
    kInstruction_adcs_eq_r10_r1_r14,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_lt_r3_r1_r6),
    kInstruction_adcs_lt_r3_r1_r6,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cc_r9_r12_r10),
    kInstruction_adcs_cc_r9_r12_r10,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_lt_r13_r14_r14),
    kInstruction_adcs_lt_r13_r14_r14,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ge_r2_r6_r9),
    kInstruction_adcs_ge_r2_r6_r9,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vs_r3_r9_r1),
    kInstruction_adcs_vs_r3_r9_r1,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cc_r1_r9_r12),
    kInstruction_adcs_cc_r1_r9_r12,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ls_r5_r0_r6),
    kInstruction_adcs_ls_r5_r0_r6,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_hi_r6_r14_r10),
    kInstruction_adcs_hi_r6_r14_r10,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_al_r11_r10_r3),
    kInstruction_adcs_al_r11_r10_r3,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ne_r13_r4_r1),
    kInstruction_adcs_ne_r13_r4_r1,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_hi_r13_r5_r14),
    kInstruction_adcs_hi_r13_r5_r14,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ne_r8_r9_r11),
    kInstruction_adcs_ne_r8_r9_r11,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_eq_r0_r13_r13),
    kInstruction_adcs_eq_r0_r13_r13,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ne_r14_r11_r0),
    kInstruction_adcs_ne_r14_r11_r0,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_mi_r6_r8_r7),
    kInstruction_adcs_mi_r6_r8_r7,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_eq_r1_r7_r5),
    kInstruction_adcs_eq_r1_r7_r5,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_pl_r12_r9_r12),
    kInstruction_adcs_pl_r12_r9_r12,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_al_r4_r5_r14),
    kInstruction_adcs_al_r4_r5_r14,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_pl_r7_r0_r12),
    kInstruction_adcs_pl_r7_r0_r12,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_mi_r5_r0_r13),
    kInstruction_adcs_mi_r5_r0_r13,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_al_r10_r7_r11),
    kInstruction_adcs_al_r10_r7_r11,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_gt_r2_r10_r0),
    kInstruction_adcs_gt_r2_r10_r0,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ge_r11_r11_r8),
    kInstruction_adcs_ge_r11_r11_r8,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_eq_r14_r7_r3),
    kInstruction_adcs_eq_r14_r7_r3,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ls_r0_r12_r4),
    kInstruction_adcs_ls_r0_r12_r4,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ne_r10_r1_r7),
    kInstruction_adcs_ne_r10_r1_r7,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_hi_r14_r3_r13),
    kInstruction_adcs_hi_r14_r3_r13,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_le_r1_r5_r12),
    kInstruction_adcs_le_r1_r5_r12,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ne_r8_r5_r11),
    kInstruction_adcs_ne_r8_r5_r11,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_le_r5_r13_r0),
    kInstruction_adcs_le_r5_r13_r0,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_gt_r8_r12_r7),
    kInstruction_adcs_gt_r8_r12_r7,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_eq_r9_r14_r3),
    kInstruction_adcs_eq_r9_r14_r3,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cs_r10_r9_r9),
    kInstruction_adcs_cs_r10_r9_r9,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vc_r5_r13_r8),
    kInstruction_adcs_vc_r5_r13_r8,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_eq_r4_r1_r8),
    kInstruction_adcs_eq_r4_r1_r8,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_lt_r12_r14_r9),
    kInstruction_adcs_lt_r12_r14_r9,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cc_r8_r8_r0),
    kInstruction_adcs_cc_r8_r8_r0,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_hi_r0_r14_r12),
    kInstruction_adcs_hi_r0_r14_r12,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_hi_r4_r1_r10),
    kInstruction_adcs_hi_r4_r1_r10,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_gt_r2_r14_r12),
    kInstruction_adcs_gt_r2_r14_r12,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vs_r1_r8_r14),
    kInstruction_adcs_vs_r1_r8_r14,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cs_r4_r1_r6),
    kInstruction_adcs_cs_r4_r1_r6,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_hi_r7_r8_r7),
    kInstruction_adcs_hi_r7_r8_r7,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_hi_r3_r11_r8),
    kInstruction_adcs_hi_r3_r11_r8,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_lt_r1_r12_r9),
    kInstruction_adcs_lt_r1_r12_r9,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cs_r13_r4_r12),
    kInstruction_adcs_cs_r13_r4_r12,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_eq_r10_r10_r5),
    kInstruction_adcs_eq_r10_r10_r5,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ge_r10_r14_r0),
    kInstruction_adcs_ge_r10_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_lt_r3_r3_r2),
    kInstruction_adcs_lt_r3_r3_r2,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vs_r2_r13_r2),
    kInstruction_adcs_vs_r2_r13_r2,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ls_r6_r2_r12),
    kInstruction_adcs_ls_r6_r2_r12,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_gt_r5_r11_r12),
    kInstruction_adcs_gt_r5_r11_r12,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_al_r11_r10_r6),
    kInstruction_adcs_al_r11_r10_r6,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_hi_r12_r14_r14),
    kInstruction_adcs_hi_r12_r14_r14,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ge_r12_r10_r6),
    kInstruction_adcs_ge_r12_r10_r6,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_eq_r8_r3_r9),
    kInstruction_adcs_eq_r8_r3_r9,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cc_r7_r5_r1),
    kInstruction_adcs_cc_r7_r5_r1,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_lt_r3_r0_r6),
    kInstruction_adcs_lt_r3_r0_r6,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_le_r14_r4_r12),
    kInstruction_adcs_le_r14_r4_r12,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_le_r9_r6_r4),
    kInstruction_adcs_le_r9_r6_r4,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_hi_r6_r11_r0),
    kInstruction_adcs_hi_r6_r11_r0,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_al_r3_r7_r6),
    kInstruction_adcs_al_r3_r7_r6,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_lt_r10_r9_r12),
    kInstruction_adcs_lt_r10_r9_r12,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_al_r14_r8_r4),
    kInstruction_adcs_al_r14_r8_r4,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_le_r14_r11_r14),
    kInstruction_adcs_le_r14_r11_r14,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_al_r14_r13_r8),
    kInstruction_adcs_al_r14_r13_r8,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ge_r5_r9_r10),
    kInstruction_adcs_ge_r5_r9_r10,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_eq_r1_r9_r4),
    kInstruction_adcs_eq_r1_r9_r4,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cc_r5_r13_r8),
    kInstruction_adcs_cc_r5_r13_r8,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ne_r10_r0_r14),
    kInstruction_adcs_ne_r10_r0_r14,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_al_r2_r0_r10),
    kInstruction_adcs_al_r2_r0_r10,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_pl_r4_r0_r11),
    kInstruction_adcs_pl_r4_r0_r11,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_gt_r13_r5_r12),
    kInstruction_adcs_gt_r13_r5_r12,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_al_r2_r13_r8),
    kInstruction_adcs_al_r2_r13_r8,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_mi_r11_r3_r4),
    kInstruction_adcs_mi_r11_r3_r4,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_le_r11_r8_r1),
    kInstruction_adcs_le_r11_r8_r1,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_hi_r12_r11_r1),
    kInstruction_adcs_hi_r12_r11_r1,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_ls_r6_r7_r2),
    kInstruction_adcs_ls_r6_r7_r2,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cs_r7_r11_r2),
    kInstruction_adcs_cs_r7_r11_r2,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_vc_r11_r13_r7),
    kInstruction_adcs_vc_r11_r13_r7,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cs_r13_r0_r1),
    kInstruction_adcs_cs_r13_r0_r1,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_cc_r5_r4_r6),
    kInstruction_adcs_cc_r5_r4_r6,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_gt_r4_r4_r13),
    kInstruction_adcs_gt_r4_r4_r13,
  },
  {
    ARRAY_SIZE(kInstruction_adcs_al_r14_r8_r2),
    kInstruction_adcs_al_r14_r8_r2,
  },
};

#endif  // VIXL_ASSEMBLER_COND_RD_RN_OPERAND_RM_ADCS_A32_H_
