/* This file is generated by venus-protocol.  See vn_protocol_renderer.h. */

/*
 * Copyright 2020 Google LLC
 * SPDX-License-Identifier: MIT
 */

#ifndef VN_PROTOCOL_RENDERER_IMAGE_H
#define VN_PROTOCOL_RENDERER_IMAGE_H

#include "vn_protocol_renderer_structs.h"

#pragma GCC diagnostic push
#if !defined(__clang__) && defined(__GNUC__) && __GNUC__ >= 12
#pragma GCC diagnostic ignored "-Wdangling-pointer"
#endif
#pragma GCC diagnostic ignored "-Wpointer-arith"
#pragma GCC diagnostic ignored "-Wunused-parameter"

/* struct VkSparseImageMemoryRequirements */

static inline void
vn_encode_VkSparseImageMemoryRequirements(struct vn_cs_encoder *enc, const VkSparseImageMemoryRequirements *val)
{
    vn_encode_VkSparseImageFormatProperties(enc, &val->formatProperties);
    vn_encode_uint32_t(enc, &val->imageMipTailFirstLod);
    vn_encode_VkDeviceSize(enc, &val->imageMipTailSize);
    vn_encode_VkDeviceSize(enc, &val->imageMipTailOffset);
    vn_encode_VkDeviceSize(enc, &val->imageMipTailStride);
}

static inline void
vn_decode_VkSparseImageMemoryRequirements_partial_temp(struct vn_cs_decoder *dec, VkSparseImageMemoryRequirements *val)
{
    vn_decode_VkSparseImageFormatProperties_partial_temp(dec, &val->formatProperties);
    /* skip val->imageMipTailFirstLod */
    /* skip val->imageMipTailSize */
    /* skip val->imageMipTailOffset */
    /* skip val->imageMipTailStride */
}

/* struct VkExternalMemoryImageCreateInfo chain */

static inline void *
vn_decode_VkExternalMemoryImageCreateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkExternalMemoryImageCreateInfo_self_temp(struct vn_cs_decoder *dec, VkExternalMemoryImageCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->handleTypes);
}

static inline void
vn_decode_VkExternalMemoryImageCreateInfo_temp(struct vn_cs_decoder *dec, VkExternalMemoryImageCreateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkExternalMemoryImageCreateInfo_pnext_temp(dec);
    vn_decode_VkExternalMemoryImageCreateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkExternalMemoryImageCreateInfo_handle_self(VkExternalMemoryImageCreateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->handleTypes */
}

static inline void
vn_replace_VkExternalMemoryImageCreateInfo_handle(VkExternalMemoryImageCreateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO:
            vn_replace_VkExternalMemoryImageCreateInfo_handle_self((VkExternalMemoryImageCreateInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkImageDrmFormatModifierListCreateInfoEXT chain */

static inline void *
vn_decode_VkImageDrmFormatModifierListCreateInfoEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkImageDrmFormatModifierListCreateInfoEXT_self_temp(struct vn_cs_decoder *dec, VkImageDrmFormatModifierListCreateInfoEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->drmFormatModifierCount);
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, val->drmFormatModifierCount);
        val->pDrmFormatModifiers = vn_cs_decoder_alloc_temp_array(dec, sizeof(*val->pDrmFormatModifiers), array_size);
        if (!val->pDrmFormatModifiers) return;
        vn_decode_uint64_t_array(dec, (uint64_t *)val->pDrmFormatModifiers, array_size);
    } else {
        vn_decode_array_size(dec, val->drmFormatModifierCount);
        val->pDrmFormatModifiers = NULL;
    }
}

static inline void
vn_decode_VkImageDrmFormatModifierListCreateInfoEXT_temp(struct vn_cs_decoder *dec, VkImageDrmFormatModifierListCreateInfoEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_LIST_CREATE_INFO_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkImageDrmFormatModifierListCreateInfoEXT_pnext_temp(dec);
    vn_decode_VkImageDrmFormatModifierListCreateInfoEXT_self_temp(dec, val);
}

static inline void
vn_replace_VkImageDrmFormatModifierListCreateInfoEXT_handle_self(VkImageDrmFormatModifierListCreateInfoEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->drmFormatModifierCount */
    /* skip val->pDrmFormatModifiers */
}

static inline void
vn_replace_VkImageDrmFormatModifierListCreateInfoEXT_handle(VkImageDrmFormatModifierListCreateInfoEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_LIST_CREATE_INFO_EXT:
            vn_replace_VkImageDrmFormatModifierListCreateInfoEXT_handle_self((VkImageDrmFormatModifierListCreateInfoEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkSubresourceLayout */

static inline void
vn_encode_VkSubresourceLayout(struct vn_cs_encoder *enc, const VkSubresourceLayout *val)
{
    vn_encode_VkDeviceSize(enc, &val->offset);
    vn_encode_VkDeviceSize(enc, &val->size);
    vn_encode_VkDeviceSize(enc, &val->rowPitch);
    vn_encode_VkDeviceSize(enc, &val->arrayPitch);
    vn_encode_VkDeviceSize(enc, &val->depthPitch);
}

static inline void
vn_decode_VkSubresourceLayout_temp(struct vn_cs_decoder *dec, VkSubresourceLayout *val)
{
    vn_decode_VkDeviceSize(dec, &val->offset);
    vn_decode_VkDeviceSize(dec, &val->size);
    vn_decode_VkDeviceSize(dec, &val->rowPitch);
    vn_decode_VkDeviceSize(dec, &val->arrayPitch);
    vn_decode_VkDeviceSize(dec, &val->depthPitch);
}

static inline void
vn_decode_VkSubresourceLayout_partial_temp(struct vn_cs_decoder *dec, VkSubresourceLayout *val)
{
    /* skip val->offset */
    /* skip val->size */
    /* skip val->rowPitch */
    /* skip val->arrayPitch */
    /* skip val->depthPitch */
}

static inline void
vn_replace_VkSubresourceLayout_handle(VkSubresourceLayout *val)
{
    /* skip val->offset */
    /* skip val->size */
    /* skip val->rowPitch */
    /* skip val->arrayPitch */
    /* skip val->depthPitch */
}

/* struct VkImageDrmFormatModifierExplicitCreateInfoEXT chain */

static inline void *
vn_decode_VkImageDrmFormatModifierExplicitCreateInfoEXT_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkImageDrmFormatModifierExplicitCreateInfoEXT_self_temp(struct vn_cs_decoder *dec, VkImageDrmFormatModifierExplicitCreateInfoEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint64_t(dec, &val->drmFormatModifier);
    vn_decode_uint32_t(dec, &val->drmFormatModifierPlaneCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->drmFormatModifierPlaneCount);
        val->pPlaneLayouts = vn_cs_decoder_alloc_temp_array(dec, sizeof(*val->pPlaneLayouts), iter_count);
        if (!val->pPlaneLayouts) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkSubresourceLayout_temp(dec, &((VkSubresourceLayout *)val->pPlaneLayouts)[i]);
    } else {
        vn_decode_array_size(dec, val->drmFormatModifierPlaneCount);
        val->pPlaneLayouts = NULL;
    }
}

static inline void
vn_decode_VkImageDrmFormatModifierExplicitCreateInfoEXT_temp(struct vn_cs_decoder *dec, VkImageDrmFormatModifierExplicitCreateInfoEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_EXPLICIT_CREATE_INFO_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkImageDrmFormatModifierExplicitCreateInfoEXT_pnext_temp(dec);
    vn_decode_VkImageDrmFormatModifierExplicitCreateInfoEXT_self_temp(dec, val);
}

static inline void
vn_replace_VkImageDrmFormatModifierExplicitCreateInfoEXT_handle_self(VkImageDrmFormatModifierExplicitCreateInfoEXT *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->drmFormatModifier */
    /* skip val->drmFormatModifierPlaneCount */
    if (val->pPlaneLayouts) {
       for (uint32_t i = 0; i < val->drmFormatModifierPlaneCount; i++)
            vn_replace_VkSubresourceLayout_handle(&((VkSubresourceLayout *)val->pPlaneLayouts)[i]);
    }
}

static inline void
vn_replace_VkImageDrmFormatModifierExplicitCreateInfoEXT_handle(VkImageDrmFormatModifierExplicitCreateInfoEXT *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_EXPLICIT_CREATE_INFO_EXT:
            vn_replace_VkImageDrmFormatModifierExplicitCreateInfoEXT_handle_self((VkImageDrmFormatModifierExplicitCreateInfoEXT *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkImageCreateInfo chain */

static inline void *
vn_decode_VkImageCreateInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkExternalMemoryImageCreateInfo));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkImageCreateInfo_pnext_temp(dec);
            vn_decode_VkExternalMemoryImageCreateInfo_self_temp(dec, (VkExternalMemoryImageCreateInfo *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkImageFormatListCreateInfo));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkImageCreateInfo_pnext_temp(dec);
            vn_decode_VkImageFormatListCreateInfo_self_temp(dec, (VkImageFormatListCreateInfo *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_LIST_CREATE_INFO_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkImageDrmFormatModifierListCreateInfoEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkImageCreateInfo_pnext_temp(dec);
            vn_decode_VkImageDrmFormatModifierListCreateInfoEXT_self_temp(dec, (VkImageDrmFormatModifierListCreateInfoEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_EXPLICIT_CREATE_INFO_EXT:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkImageDrmFormatModifierExplicitCreateInfoEXT));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkImageCreateInfo_pnext_temp(dec);
            vn_decode_VkImageDrmFormatModifierExplicitCreateInfoEXT_self_temp(dec, (VkImageDrmFormatModifierExplicitCreateInfoEXT *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkImageStencilUsageCreateInfo));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkImageCreateInfo_pnext_temp(dec);
            vn_decode_VkImageStencilUsageCreateInfo_self_temp(dec, (VkImageStencilUsageCreateInfo *)pnext);
        }
        break;
    default:
        /* unexpected struct */
        pnext = NULL;
        vn_cs_decoder_set_fatal(dec);
        break;
    }

    return pnext;
}

static inline void
vn_decode_VkImageCreateInfo_self_temp(struct vn_cs_decoder *dec, VkImageCreateInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkFlags(dec, &val->flags);
    vn_decode_VkImageType(dec, &val->imageType);
    vn_decode_VkFormat(dec, &val->format);
    vn_decode_VkExtent3D_temp(dec, &val->extent);
    vn_decode_uint32_t(dec, &val->mipLevels);
    vn_decode_uint32_t(dec, &val->arrayLayers);
    vn_decode_VkSampleCountFlagBits(dec, &val->samples);
    vn_decode_VkImageTiling(dec, &val->tiling);
    vn_decode_VkFlags(dec, &val->usage);
    vn_decode_VkSharingMode(dec, &val->sharingMode);
    vn_decode_uint32_t(dec, &val->queueFamilyIndexCount);
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, val->queueFamilyIndexCount);
        val->pQueueFamilyIndices = vn_cs_decoder_alloc_temp_array(dec, sizeof(*val->pQueueFamilyIndices), array_size);
        if (!val->pQueueFamilyIndices) return;
        vn_decode_uint32_t_array(dec, (uint32_t *)val->pQueueFamilyIndices, array_size);
    } else {
        vn_decode_array_size_unchecked(dec);
        val->pQueueFamilyIndices = NULL;
    }
    vn_decode_VkImageLayout(dec, &val->initialLayout);
}

static inline void
vn_decode_VkImageCreateInfo_temp(struct vn_cs_decoder *dec, VkImageCreateInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_IMAGE_CREATE_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkImageCreateInfo_pnext_temp(dec);
    vn_decode_VkImageCreateInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkImageCreateInfo_handle_self(VkImageCreateInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->flags */
    /* skip val->imageType */
    /* skip val->format */
    vn_replace_VkExtent3D_handle(&val->extent);
    /* skip val->mipLevels */
    /* skip val->arrayLayers */
    /* skip val->samples */
    /* skip val->tiling */
    /* skip val->usage */
    /* skip val->sharingMode */
    /* skip val->queueFamilyIndexCount */
    /* skip val->pQueueFamilyIndices */
    /* skip val->initialLayout */
}

static inline void
vn_replace_VkImageCreateInfo_handle(VkImageCreateInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_IMAGE_CREATE_INFO:
            vn_replace_VkImageCreateInfo_handle_self((VkImageCreateInfo *)pnext);
            break;
        case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO:
            vn_replace_VkExternalMemoryImageCreateInfo_handle_self((VkExternalMemoryImageCreateInfo *)pnext);
            break;
        case VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO:
            vn_replace_VkImageFormatListCreateInfo_handle_self((VkImageFormatListCreateInfo *)pnext);
            break;
        case VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_LIST_CREATE_INFO_EXT:
            vn_replace_VkImageDrmFormatModifierListCreateInfoEXT_handle_self((VkImageDrmFormatModifierListCreateInfoEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_EXPLICIT_CREATE_INFO_EXT:
            vn_replace_VkImageDrmFormatModifierExplicitCreateInfoEXT_handle_self((VkImageDrmFormatModifierExplicitCreateInfoEXT *)pnext);
            break;
        case VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO:
            vn_replace_VkImageStencilUsageCreateInfo_handle_self((VkImageStencilUsageCreateInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkBindImageMemoryDeviceGroupInfo chain */

static inline void *
vn_decode_VkBindImageMemoryDeviceGroupInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkBindImageMemoryDeviceGroupInfo_self_temp(struct vn_cs_decoder *dec, VkBindImageMemoryDeviceGroupInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_uint32_t(dec, &val->deviceIndexCount);
    if (vn_peek_array_size(dec)) {
        const size_t array_size = vn_decode_array_size(dec, val->deviceIndexCount);
        val->pDeviceIndices = vn_cs_decoder_alloc_temp_array(dec, sizeof(*val->pDeviceIndices), array_size);
        if (!val->pDeviceIndices) return;
        vn_decode_uint32_t_array(dec, (uint32_t *)val->pDeviceIndices, array_size);
    } else {
        vn_decode_array_size(dec, val->deviceIndexCount);
        val->pDeviceIndices = NULL;
    }
    vn_decode_uint32_t(dec, &val->splitInstanceBindRegionCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, val->splitInstanceBindRegionCount);
        val->pSplitInstanceBindRegions = vn_cs_decoder_alloc_temp_array(dec, sizeof(*val->pSplitInstanceBindRegions), iter_count);
        if (!val->pSplitInstanceBindRegions) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkRect2D_temp(dec, &((VkRect2D *)val->pSplitInstanceBindRegions)[i]);
    } else {
        vn_decode_array_size(dec, val->splitInstanceBindRegionCount);
        val->pSplitInstanceBindRegions = NULL;
    }
}

static inline void
vn_decode_VkBindImageMemoryDeviceGroupInfo_temp(struct vn_cs_decoder *dec, VkBindImageMemoryDeviceGroupInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkBindImageMemoryDeviceGroupInfo_pnext_temp(dec);
    vn_decode_VkBindImageMemoryDeviceGroupInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkBindImageMemoryDeviceGroupInfo_handle_self(VkBindImageMemoryDeviceGroupInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->deviceIndexCount */
    /* skip val->pDeviceIndices */
    /* skip val->splitInstanceBindRegionCount */
    if (val->pSplitInstanceBindRegions) {
       for (uint32_t i = 0; i < val->splitInstanceBindRegionCount; i++)
            vn_replace_VkRect2D_handle(&((VkRect2D *)val->pSplitInstanceBindRegions)[i]);
    }
}

static inline void
vn_replace_VkBindImageMemoryDeviceGroupInfo_handle(VkBindImageMemoryDeviceGroupInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO:
            vn_replace_VkBindImageMemoryDeviceGroupInfo_handle_self((VkBindImageMemoryDeviceGroupInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkBindImagePlaneMemoryInfo chain */

static inline void *
vn_decode_VkBindImagePlaneMemoryInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkBindImagePlaneMemoryInfo_self_temp(struct vn_cs_decoder *dec, VkBindImagePlaneMemoryInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkImageAspectFlagBits(dec, &val->planeAspect);
}

static inline void
vn_decode_VkBindImagePlaneMemoryInfo_temp(struct vn_cs_decoder *dec, VkBindImagePlaneMemoryInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkBindImagePlaneMemoryInfo_pnext_temp(dec);
    vn_decode_VkBindImagePlaneMemoryInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkBindImagePlaneMemoryInfo_handle_self(VkBindImagePlaneMemoryInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->planeAspect */
}

static inline void
vn_replace_VkBindImagePlaneMemoryInfo_handle(VkBindImagePlaneMemoryInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO:
            vn_replace_VkBindImagePlaneMemoryInfo_handle_self((VkBindImagePlaneMemoryInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkBindImageMemoryInfo chain */

static inline void *
vn_decode_VkBindImageMemoryInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkBindImageMemoryDeviceGroupInfo));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkBindImageMemoryInfo_pnext_temp(dec);
            vn_decode_VkBindImageMemoryDeviceGroupInfo_self_temp(dec, (VkBindImageMemoryDeviceGroupInfo *)pnext);
        }
        break;
    case VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkBindImagePlaneMemoryInfo));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkBindImageMemoryInfo_pnext_temp(dec);
            vn_decode_VkBindImagePlaneMemoryInfo_self_temp(dec, (VkBindImagePlaneMemoryInfo *)pnext);
        }
        break;
    default:
        /* unexpected struct */
        pnext = NULL;
        vn_cs_decoder_set_fatal(dec);
        break;
    }

    return pnext;
}

static inline void
vn_decode_VkBindImageMemoryInfo_self_temp(struct vn_cs_decoder *dec, VkBindImageMemoryInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkImage_lookup(dec, &val->image);
    vn_decode_VkDeviceMemory_lookup(dec, &val->memory);
    vn_decode_VkDeviceSize(dec, &val->memoryOffset);
}

static inline void
vn_decode_VkBindImageMemoryInfo_temp(struct vn_cs_decoder *dec, VkBindImageMemoryInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkBindImageMemoryInfo_pnext_temp(dec);
    vn_decode_VkBindImageMemoryInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkBindImageMemoryInfo_handle_self(VkBindImageMemoryInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    vn_replace_VkImage_handle(&val->image);
    vn_replace_VkDeviceMemory_handle(&val->memory);
    /* skip val->memoryOffset */
}

static inline void
vn_replace_VkBindImageMemoryInfo_handle(VkBindImageMemoryInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_INFO:
            vn_replace_VkBindImageMemoryInfo_handle_self((VkBindImageMemoryInfo *)pnext);
            break;
        case VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO:
            vn_replace_VkBindImageMemoryDeviceGroupInfo_handle_self((VkBindImageMemoryDeviceGroupInfo *)pnext);
            break;
        case VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO:
            vn_replace_VkBindImagePlaneMemoryInfo_handle_self((VkBindImagePlaneMemoryInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkImagePlaneMemoryRequirementsInfo chain */

static inline void *
vn_decode_VkImagePlaneMemoryRequirementsInfo_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkImagePlaneMemoryRequirementsInfo_self_temp(struct vn_cs_decoder *dec, VkImagePlaneMemoryRequirementsInfo *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkImageAspectFlagBits(dec, &val->planeAspect);
}

static inline void
vn_decode_VkImagePlaneMemoryRequirementsInfo_temp(struct vn_cs_decoder *dec, VkImagePlaneMemoryRequirementsInfo *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkImagePlaneMemoryRequirementsInfo_pnext_temp(dec);
    vn_decode_VkImagePlaneMemoryRequirementsInfo_self_temp(dec, val);
}

static inline void
vn_replace_VkImagePlaneMemoryRequirementsInfo_handle_self(VkImagePlaneMemoryRequirementsInfo *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    /* skip val->planeAspect */
}

static inline void
vn_replace_VkImagePlaneMemoryRequirementsInfo_handle(VkImagePlaneMemoryRequirementsInfo *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO:
            vn_replace_VkImagePlaneMemoryRequirementsInfo_handle_self((VkImagePlaneMemoryRequirementsInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkImageMemoryRequirementsInfo2 chain */

static inline void *
vn_decode_VkImageMemoryRequirementsInfo2_pnext_temp(struct vn_cs_decoder *dec)
{
    VkBaseOutStructure *pnext;
    VkStructureType stype;

    if (!vn_decode_simple_pointer(dec))
        return NULL;

    vn_decode_VkStructureType(dec, &stype);
    switch ((int32_t)stype) {
    case VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO:
        pnext = vn_cs_decoder_alloc_temp(dec, sizeof(VkImagePlaneMemoryRequirementsInfo));
        if (pnext) {
            pnext->sType = stype;
            pnext->pNext = vn_decode_VkImageMemoryRequirementsInfo2_pnext_temp(dec);
            vn_decode_VkImagePlaneMemoryRequirementsInfo_self_temp(dec, (VkImagePlaneMemoryRequirementsInfo *)pnext);
        }
        break;
    default:
        /* unexpected struct */
        pnext = NULL;
        vn_cs_decoder_set_fatal(dec);
        break;
    }

    return pnext;
}

static inline void
vn_decode_VkImageMemoryRequirementsInfo2_self_temp(struct vn_cs_decoder *dec, VkImageMemoryRequirementsInfo2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkImage_lookup(dec, &val->image);
}

static inline void
vn_decode_VkImageMemoryRequirementsInfo2_temp(struct vn_cs_decoder *dec, VkImageMemoryRequirementsInfo2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_IMAGE_MEMORY_REQUIREMENTS_INFO_2)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkImageMemoryRequirementsInfo2_pnext_temp(dec);
    vn_decode_VkImageMemoryRequirementsInfo2_self_temp(dec, val);
}

static inline void
vn_replace_VkImageMemoryRequirementsInfo2_handle_self(VkImageMemoryRequirementsInfo2 *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    vn_replace_VkImage_handle(&val->image);
}

static inline void
vn_replace_VkImageMemoryRequirementsInfo2_handle(VkImageMemoryRequirementsInfo2 *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_IMAGE_MEMORY_REQUIREMENTS_INFO_2:
            vn_replace_VkImageMemoryRequirementsInfo2_handle_self((VkImageMemoryRequirementsInfo2 *)pnext);
            break;
        case VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO:
            vn_replace_VkImagePlaneMemoryRequirementsInfo_handle_self((VkImagePlaneMemoryRequirementsInfo *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkImageSparseMemoryRequirementsInfo2 chain */

static inline void *
vn_decode_VkImageSparseMemoryRequirementsInfo2_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkImageSparseMemoryRequirementsInfo2_self_temp(struct vn_cs_decoder *dec, VkImageSparseMemoryRequirementsInfo2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkImage_lookup(dec, &val->image);
}

static inline void
vn_decode_VkImageSparseMemoryRequirementsInfo2_temp(struct vn_cs_decoder *dec, VkImageSparseMemoryRequirementsInfo2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_IMAGE_SPARSE_MEMORY_REQUIREMENTS_INFO_2)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkImageSparseMemoryRequirementsInfo2_pnext_temp(dec);
    vn_decode_VkImageSparseMemoryRequirementsInfo2_self_temp(dec, val);
}

static inline void
vn_replace_VkImageSparseMemoryRequirementsInfo2_handle_self(VkImageSparseMemoryRequirementsInfo2 *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    vn_replace_VkImage_handle(&val->image);
}

static inline void
vn_replace_VkImageSparseMemoryRequirementsInfo2_handle(VkImageSparseMemoryRequirementsInfo2 *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_IMAGE_SPARSE_MEMORY_REQUIREMENTS_INFO_2:
            vn_replace_VkImageSparseMemoryRequirementsInfo2_handle_self((VkImageSparseMemoryRequirementsInfo2 *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkSparseImageMemoryRequirements2 chain */

static inline void
vn_encode_VkSparseImageMemoryRequirements2_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkSparseImageMemoryRequirements2_self(struct vn_cs_encoder *enc, const VkSparseImageMemoryRequirements2 *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkSparseImageMemoryRequirements(enc, &val->memoryRequirements);
}

static inline void
vn_encode_VkSparseImageMemoryRequirements2(struct vn_cs_encoder *enc, const VkSparseImageMemoryRequirements2 *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_SPARSE_IMAGE_MEMORY_REQUIREMENTS_2);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_SPARSE_IMAGE_MEMORY_REQUIREMENTS_2 });
    vn_encode_VkSparseImageMemoryRequirements2_pnext(enc, val->pNext);
    vn_encode_VkSparseImageMemoryRequirements2_self(enc, val);
}

static inline void *
vn_decode_VkSparseImageMemoryRequirements2_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkSparseImageMemoryRequirements2_self_partial_temp(struct vn_cs_decoder *dec, VkSparseImageMemoryRequirements2 *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkSparseImageMemoryRequirements_partial_temp(dec, &val->memoryRequirements);
}

static inline void
vn_decode_VkSparseImageMemoryRequirements2_partial_temp(struct vn_cs_decoder *dec, VkSparseImageMemoryRequirements2 *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_SPARSE_IMAGE_MEMORY_REQUIREMENTS_2)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkSparseImageMemoryRequirements2_pnext_partial_temp(dec);
    vn_decode_VkSparseImageMemoryRequirements2_self_partial_temp(dec, val);
}

/* struct VkDeviceImageMemoryRequirements chain */

static inline void *
vn_decode_VkDeviceImageMemoryRequirements_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkDeviceImageMemoryRequirements_self_temp(struct vn_cs_decoder *dec, VkDeviceImageMemoryRequirements *val)
{
    /* skip val->{sType,pNext} */
    if (vn_decode_simple_pointer(dec)) {
        val->pCreateInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pCreateInfo));
        if (!val->pCreateInfo) return;
        vn_decode_VkImageCreateInfo_temp(dec, (VkImageCreateInfo *)val->pCreateInfo);
    } else {
        val->pCreateInfo = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
    vn_decode_VkImageAspectFlagBits(dec, &val->planeAspect);
}

static inline void
vn_decode_VkDeviceImageMemoryRequirements_temp(struct vn_cs_decoder *dec, VkDeviceImageMemoryRequirements *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_DEVICE_IMAGE_MEMORY_REQUIREMENTS)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkDeviceImageMemoryRequirements_pnext_temp(dec);
    vn_decode_VkDeviceImageMemoryRequirements_self_temp(dec, val);
}

static inline void
vn_replace_VkDeviceImageMemoryRequirements_handle_self(VkDeviceImageMemoryRequirements *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    if (val->pCreateInfo)
        vn_replace_VkImageCreateInfo_handle((VkImageCreateInfo *)val->pCreateInfo);
    /* skip val->planeAspect */
}

static inline void
vn_replace_VkDeviceImageMemoryRequirements_handle(VkDeviceImageMemoryRequirements *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_DEVICE_IMAGE_MEMORY_REQUIREMENTS:
            vn_replace_VkDeviceImageMemoryRequirements_handle_self((VkDeviceImageMemoryRequirements *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkImageDrmFormatModifierPropertiesEXT chain */

static inline void
vn_encode_VkImageDrmFormatModifierPropertiesEXT_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkImageDrmFormatModifierPropertiesEXT_self(struct vn_cs_encoder *enc, const VkImageDrmFormatModifierPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_uint64_t(enc, &val->drmFormatModifier);
}

static inline void
vn_encode_VkImageDrmFormatModifierPropertiesEXT(struct vn_cs_encoder *enc, const VkImageDrmFormatModifierPropertiesEXT *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_PROPERTIES_EXT);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_PROPERTIES_EXT });
    vn_encode_VkImageDrmFormatModifierPropertiesEXT_pnext(enc, val->pNext);
    vn_encode_VkImageDrmFormatModifierPropertiesEXT_self(enc, val);
}

static inline void *
vn_decode_VkImageDrmFormatModifierPropertiesEXT_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkImageDrmFormatModifierPropertiesEXT_self_partial_temp(struct vn_cs_decoder *dec, VkImageDrmFormatModifierPropertiesEXT *val)
{
    /* skip val->{sType,pNext} */
    /* skip val->drmFormatModifier */
}

static inline void
vn_decode_VkImageDrmFormatModifierPropertiesEXT_partial_temp(struct vn_cs_decoder *dec, VkImageDrmFormatModifierPropertiesEXT *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_PROPERTIES_EXT)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkImageDrmFormatModifierPropertiesEXT_pnext_partial_temp(dec);
    vn_decode_VkImageDrmFormatModifierPropertiesEXT_self_partial_temp(dec, val);
}

/* struct VkImageSubresource2KHR chain */

static inline void *
vn_decode_VkImageSubresource2KHR_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkImageSubresource2KHR_self_temp(struct vn_cs_decoder *dec, VkImageSubresource2KHR *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkImageSubresource_temp(dec, &val->imageSubresource);
}

static inline void
vn_decode_VkImageSubresource2KHR_temp(struct vn_cs_decoder *dec, VkImageSubresource2KHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_IMAGE_SUBRESOURCE_2_KHR)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkImageSubresource2KHR_pnext_temp(dec);
    vn_decode_VkImageSubresource2KHR_self_temp(dec, val);
}

static inline void
vn_replace_VkImageSubresource2KHR_handle_self(VkImageSubresource2KHR *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    vn_replace_VkImageSubresource_handle(&val->imageSubresource);
}

static inline void
vn_replace_VkImageSubresource2KHR_handle(VkImageSubresource2KHR *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_IMAGE_SUBRESOURCE_2_KHR:
            vn_replace_VkImageSubresource2KHR_handle_self((VkImageSubresource2KHR *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

/* struct VkSubresourceLayout2KHR chain */

static inline void
vn_encode_VkSubresourceLayout2KHR_pnext(struct vn_cs_encoder *enc, const void *val)
{
    /* no known/supported struct */
    vn_encode_simple_pointer(enc, NULL);
}

static inline void
vn_encode_VkSubresourceLayout2KHR_self(struct vn_cs_encoder *enc, const VkSubresourceLayout2KHR *val)
{
    /* skip val->{sType,pNext} */
    vn_encode_VkSubresourceLayout(enc, &val->subresourceLayout);
}

static inline void
vn_encode_VkSubresourceLayout2KHR(struct vn_cs_encoder *enc, const VkSubresourceLayout2KHR *val)
{
    assert(val->sType == VK_STRUCTURE_TYPE_SUBRESOURCE_LAYOUT_2_KHR);
    vn_encode_VkStructureType(enc, &(VkStructureType){ VK_STRUCTURE_TYPE_SUBRESOURCE_LAYOUT_2_KHR });
    vn_encode_VkSubresourceLayout2KHR_pnext(enc, val->pNext);
    vn_encode_VkSubresourceLayout2KHR_self(enc, val);
}

static inline void *
vn_decode_VkSubresourceLayout2KHR_pnext_partial_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkSubresourceLayout2KHR_self_partial_temp(struct vn_cs_decoder *dec, VkSubresourceLayout2KHR *val)
{
    /* skip val->{sType,pNext} */
    vn_decode_VkSubresourceLayout_partial_temp(dec, &val->subresourceLayout);
}

static inline void
vn_decode_VkSubresourceLayout2KHR_partial_temp(struct vn_cs_decoder *dec, VkSubresourceLayout2KHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_SUBRESOURCE_LAYOUT_2_KHR)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkSubresourceLayout2KHR_pnext_partial_temp(dec);
    vn_decode_VkSubresourceLayout2KHR_self_partial_temp(dec, val);
}

/* struct VkDeviceImageSubresourceInfoKHR chain */

static inline void *
vn_decode_VkDeviceImageSubresourceInfoKHR_pnext_temp(struct vn_cs_decoder *dec)
{
    /* no known/supported struct */
    if (vn_decode_simple_pointer(dec))
        vn_cs_decoder_set_fatal(dec);
    return NULL;
}

static inline void
vn_decode_VkDeviceImageSubresourceInfoKHR_self_temp(struct vn_cs_decoder *dec, VkDeviceImageSubresourceInfoKHR *val)
{
    /* skip val->{sType,pNext} */
    if (vn_decode_simple_pointer(dec)) {
        val->pCreateInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pCreateInfo));
        if (!val->pCreateInfo) return;
        vn_decode_VkImageCreateInfo_temp(dec, (VkImageCreateInfo *)val->pCreateInfo);
    } else {
        val->pCreateInfo = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
    if (vn_decode_simple_pointer(dec)) {
        val->pSubresource = vn_cs_decoder_alloc_temp(dec, sizeof(*val->pSubresource));
        if (!val->pSubresource) return;
        vn_decode_VkImageSubresource2KHR_temp(dec, (VkImageSubresource2KHR *)val->pSubresource);
    } else {
        val->pSubresource = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void
vn_decode_VkDeviceImageSubresourceInfoKHR_temp(struct vn_cs_decoder *dec, VkDeviceImageSubresourceInfoKHR *val)
{
    VkStructureType stype;
    vn_decode_VkStructureType(dec, &stype);
    if (stype != VK_STRUCTURE_TYPE_DEVICE_IMAGE_SUBRESOURCE_INFO_KHR)
        vn_cs_decoder_set_fatal(dec);

    val->sType = stype;
    val->pNext = vn_decode_VkDeviceImageSubresourceInfoKHR_pnext_temp(dec);
    vn_decode_VkDeviceImageSubresourceInfoKHR_self_temp(dec, val);
}

static inline void
vn_replace_VkDeviceImageSubresourceInfoKHR_handle_self(VkDeviceImageSubresourceInfoKHR *val)
{
    /* skip val->sType */
    /* skip val->pNext */
    if (val->pCreateInfo)
        vn_replace_VkImageCreateInfo_handle((VkImageCreateInfo *)val->pCreateInfo);
    if (val->pSubresource)
        vn_replace_VkImageSubresource2KHR_handle((VkImageSubresource2KHR *)val->pSubresource);
}

static inline void
vn_replace_VkDeviceImageSubresourceInfoKHR_handle(VkDeviceImageSubresourceInfoKHR *val)
{
    struct VkBaseOutStructure *pnext = (struct VkBaseOutStructure *)val;

    do {
        switch ((int32_t)pnext->sType) {
        case VK_STRUCTURE_TYPE_DEVICE_IMAGE_SUBRESOURCE_INFO_KHR:
            vn_replace_VkDeviceImageSubresourceInfoKHR_handle_self((VkDeviceImageSubresourceInfoKHR *)pnext);
            break;
        default:
            /* ignore unknown/unsupported struct */
            break;
        }
        pnext = pnext->pNext;
    } while (pnext);
}

static inline void vn_decode_vkGetImageMemoryRequirements_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetImageMemoryRequirements *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    vn_decode_VkImage_lookup(dec, &args->image);
    if (vn_decode_simple_pointer(dec)) {
        args->pMemoryRequirements = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pMemoryRequirements));
        if (!args->pMemoryRequirements) return;
        vn_decode_VkMemoryRequirements_partial_temp(dec, args->pMemoryRequirements);
    } else {
        args->pMemoryRequirements = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkGetImageMemoryRequirements_args_handle(struct vn_command_vkGetImageMemoryRequirements *args)
{
    vn_replace_VkDevice_handle(&args->device);
    vn_replace_VkImage_handle(&args->image);
    /* skip args->pMemoryRequirements */
}

static inline void vn_encode_vkGetImageMemoryRequirements_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetImageMemoryRequirements *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetImageMemoryRequirements_EXT});

    /* skip args->device */
    /* skip args->image */
    if (vn_encode_simple_pointer(enc, args->pMemoryRequirements))
        vn_encode_VkMemoryRequirements(enc, args->pMemoryRequirements);
}

static inline void vn_decode_vkBindImageMemory_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkBindImageMemory *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    vn_decode_VkImage_lookup(dec, &args->image);
    vn_decode_VkDeviceMemory_lookup(dec, &args->memory);
    vn_decode_VkDeviceSize(dec, &args->memoryOffset);
}

static inline void vn_replace_vkBindImageMemory_args_handle(struct vn_command_vkBindImageMemory *args)
{
    vn_replace_VkDevice_handle(&args->device);
    vn_replace_VkImage_handle(&args->image);
    vn_replace_VkDeviceMemory_handle(&args->memory);
    /* skip args->memoryOffset */
}

static inline void vn_encode_vkBindImageMemory_reply(struct vn_cs_encoder *enc, const struct vn_command_vkBindImageMemory *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkBindImageMemory_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->device */
    /* skip args->image */
    /* skip args->memory */
    /* skip args->memoryOffset */
}

static inline void vn_decode_vkGetImageSparseMemoryRequirements_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetImageSparseMemoryRequirements *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    vn_decode_VkImage_lookup(dec, &args->image);
    if (vn_decode_simple_pointer(dec)) {
        args->pSparseMemoryRequirementCount = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pSparseMemoryRequirementCount));
        if (!args->pSparseMemoryRequirementCount) return;
        vn_decode_uint32_t(dec, args->pSparseMemoryRequirementCount);
    } else {
        args->pSparseMemoryRequirementCount = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, (args->pSparseMemoryRequirementCount ? *args->pSparseMemoryRequirementCount : 0));
        args->pSparseMemoryRequirements = vn_cs_decoder_alloc_temp_array(dec, sizeof(*args->pSparseMemoryRequirements), iter_count);
        if (!args->pSparseMemoryRequirements) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkSparseImageMemoryRequirements_partial_temp(dec, &args->pSparseMemoryRequirements[i]);
    } else {
        vn_decode_array_size_unchecked(dec);
        args->pSparseMemoryRequirements = NULL;
    }
}

static inline void vn_replace_vkGetImageSparseMemoryRequirements_args_handle(struct vn_command_vkGetImageSparseMemoryRequirements *args)
{
    vn_replace_VkDevice_handle(&args->device);
    vn_replace_VkImage_handle(&args->image);
    /* skip args->pSparseMemoryRequirementCount */
    /* skip args->pSparseMemoryRequirements */
}

static inline void vn_encode_vkGetImageSparseMemoryRequirements_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetImageSparseMemoryRequirements *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetImageSparseMemoryRequirements_EXT});

    /* skip args->device */
    /* skip args->image */
    if (vn_encode_simple_pointer(enc, args->pSparseMemoryRequirementCount))
        vn_encode_uint32_t(enc, args->pSparseMemoryRequirementCount);
    if (args->pSparseMemoryRequirements) {
        vn_encode_array_size(enc, (args->pSparseMemoryRequirementCount ? *args->pSparseMemoryRequirementCount : 0));
        for (uint32_t i = 0; i < (args->pSparseMemoryRequirementCount ? *args->pSparseMemoryRequirementCount : 0); i++)
            vn_encode_VkSparseImageMemoryRequirements(enc, &args->pSparseMemoryRequirements[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void vn_decode_vkCreateImage_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkCreateImage *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    if (vn_decode_simple_pointer(dec)) {
        args->pCreateInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pCreateInfo));
        if (!args->pCreateInfo) return;
        vn_decode_VkImageCreateInfo_temp(dec, (VkImageCreateInfo *)args->pCreateInfo);
    } else {
        args->pCreateInfo = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
    if (vn_decode_simple_pointer(dec)) {
        vn_cs_decoder_set_fatal(dec);
    } else {
        args->pAllocator = NULL;
    }
    if (vn_decode_simple_pointer(dec)) {
        args->pImage = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pImage));
        if (!args->pImage) return;
        vn_decode_VkImage(dec, args->pImage);
    } else {
        args->pImage = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkCreateImage_args_handle(struct vn_command_vkCreateImage *args)
{
    vn_replace_VkDevice_handle(&args->device);
    if (args->pCreateInfo)
        vn_replace_VkImageCreateInfo_handle((VkImageCreateInfo *)args->pCreateInfo);
    /* skip args->pAllocator */
    /* skip args->pImage */
}

static inline void vn_encode_vkCreateImage_reply(struct vn_cs_encoder *enc, const struct vn_command_vkCreateImage *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkCreateImage_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->device */
    /* skip args->pCreateInfo */
    /* skip args->pAllocator */
    if (vn_encode_simple_pointer(enc, args->pImage))
        vn_encode_VkImage(enc, args->pImage);
}

static inline void vn_decode_vkDestroyImage_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkDestroyImage *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    vn_decode_VkImage_lookup(dec, &args->image);
    if (vn_decode_simple_pointer(dec)) {
        vn_cs_decoder_set_fatal(dec);
    } else {
        args->pAllocator = NULL;
    }
}

static inline void vn_replace_vkDestroyImage_args_handle(struct vn_command_vkDestroyImage *args)
{
    vn_replace_VkDevice_handle(&args->device);
    vn_replace_VkImage_handle(&args->image);
    /* skip args->pAllocator */
}

static inline void vn_encode_vkDestroyImage_reply(struct vn_cs_encoder *enc, const struct vn_command_vkDestroyImage *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkDestroyImage_EXT});

    /* skip args->device */
    /* skip args->image */
    /* skip args->pAllocator */
}

static inline void vn_decode_vkGetImageSubresourceLayout_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetImageSubresourceLayout *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    vn_decode_VkImage_lookup(dec, &args->image);
    if (vn_decode_simple_pointer(dec)) {
        args->pSubresource = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pSubresource));
        if (!args->pSubresource) return;
        vn_decode_VkImageSubresource_temp(dec, (VkImageSubresource *)args->pSubresource);
    } else {
        args->pSubresource = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
    if (vn_decode_simple_pointer(dec)) {
        args->pLayout = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pLayout));
        if (!args->pLayout) return;
        vn_decode_VkSubresourceLayout_partial_temp(dec, args->pLayout);
    } else {
        args->pLayout = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkGetImageSubresourceLayout_args_handle(struct vn_command_vkGetImageSubresourceLayout *args)
{
    vn_replace_VkDevice_handle(&args->device);
    vn_replace_VkImage_handle(&args->image);
    if (args->pSubresource)
        vn_replace_VkImageSubresource_handle((VkImageSubresource *)args->pSubresource);
    /* skip args->pLayout */
}

static inline void vn_encode_vkGetImageSubresourceLayout_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetImageSubresourceLayout *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetImageSubresourceLayout_EXT});

    /* skip args->device */
    /* skip args->image */
    /* skip args->pSubresource */
    if (vn_encode_simple_pointer(enc, args->pLayout))
        vn_encode_VkSubresourceLayout(enc, args->pLayout);
}

static inline void vn_decode_vkBindImageMemory2_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkBindImageMemory2 *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    vn_decode_uint32_t(dec, &args->bindInfoCount);
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, args->bindInfoCount);
        args->pBindInfos = vn_cs_decoder_alloc_temp_array(dec, sizeof(*args->pBindInfos), iter_count);
        if (!args->pBindInfos) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkBindImageMemoryInfo_temp(dec, &((VkBindImageMemoryInfo *)args->pBindInfos)[i]);
    } else {
        vn_decode_array_size(dec, args->bindInfoCount);
        args->pBindInfos = NULL;
    }
}

static inline void vn_replace_vkBindImageMemory2_args_handle(struct vn_command_vkBindImageMemory2 *args)
{
    vn_replace_VkDevice_handle(&args->device);
    /* skip args->bindInfoCount */
    if (args->pBindInfos) {
       for (uint32_t i = 0; i < args->bindInfoCount; i++)
            vn_replace_VkBindImageMemoryInfo_handle(&((VkBindImageMemoryInfo *)args->pBindInfos)[i]);
    }
}

static inline void vn_encode_vkBindImageMemory2_reply(struct vn_cs_encoder *enc, const struct vn_command_vkBindImageMemory2 *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkBindImageMemory2_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->device */
    /* skip args->bindInfoCount */
    /* skip args->pBindInfos */
}

static inline void vn_decode_vkGetImageMemoryRequirements2_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetImageMemoryRequirements2 *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    if (vn_decode_simple_pointer(dec)) {
        args->pInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pInfo));
        if (!args->pInfo) return;
        vn_decode_VkImageMemoryRequirementsInfo2_temp(dec, (VkImageMemoryRequirementsInfo2 *)args->pInfo);
    } else {
        args->pInfo = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
    if (vn_decode_simple_pointer(dec)) {
        args->pMemoryRequirements = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pMemoryRequirements));
        if (!args->pMemoryRequirements) return;
        vn_decode_VkMemoryRequirements2_partial_temp(dec, args->pMemoryRequirements);
    } else {
        args->pMemoryRequirements = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkGetImageMemoryRequirements2_args_handle(struct vn_command_vkGetImageMemoryRequirements2 *args)
{
    vn_replace_VkDevice_handle(&args->device);
    if (args->pInfo)
        vn_replace_VkImageMemoryRequirementsInfo2_handle((VkImageMemoryRequirementsInfo2 *)args->pInfo);
    /* skip args->pMemoryRequirements */
}

static inline void vn_encode_vkGetImageMemoryRequirements2_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetImageMemoryRequirements2 *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetImageMemoryRequirements2_EXT});

    /* skip args->device */
    /* skip args->pInfo */
    if (vn_encode_simple_pointer(enc, args->pMemoryRequirements))
        vn_encode_VkMemoryRequirements2(enc, args->pMemoryRequirements);
}

static inline void vn_decode_vkGetImageSparseMemoryRequirements2_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetImageSparseMemoryRequirements2 *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    if (vn_decode_simple_pointer(dec)) {
        args->pInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pInfo));
        if (!args->pInfo) return;
        vn_decode_VkImageSparseMemoryRequirementsInfo2_temp(dec, (VkImageSparseMemoryRequirementsInfo2 *)args->pInfo);
    } else {
        args->pInfo = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
    if (vn_decode_simple_pointer(dec)) {
        args->pSparseMemoryRequirementCount = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pSparseMemoryRequirementCount));
        if (!args->pSparseMemoryRequirementCount) return;
        vn_decode_uint32_t(dec, args->pSparseMemoryRequirementCount);
    } else {
        args->pSparseMemoryRequirementCount = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, (args->pSparseMemoryRequirementCount ? *args->pSparseMemoryRequirementCount : 0));
        args->pSparseMemoryRequirements = vn_cs_decoder_alloc_temp_array(dec, sizeof(*args->pSparseMemoryRequirements), iter_count);
        if (!args->pSparseMemoryRequirements) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkSparseImageMemoryRequirements2_partial_temp(dec, &args->pSparseMemoryRequirements[i]);
    } else {
        vn_decode_array_size_unchecked(dec);
        args->pSparseMemoryRequirements = NULL;
    }
}

static inline void vn_replace_vkGetImageSparseMemoryRequirements2_args_handle(struct vn_command_vkGetImageSparseMemoryRequirements2 *args)
{
    vn_replace_VkDevice_handle(&args->device);
    if (args->pInfo)
        vn_replace_VkImageSparseMemoryRequirementsInfo2_handle((VkImageSparseMemoryRequirementsInfo2 *)args->pInfo);
    /* skip args->pSparseMemoryRequirementCount */
    /* skip args->pSparseMemoryRequirements */
}

static inline void vn_encode_vkGetImageSparseMemoryRequirements2_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetImageSparseMemoryRequirements2 *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetImageSparseMemoryRequirements2_EXT});

    /* skip args->device */
    /* skip args->pInfo */
    if (vn_encode_simple_pointer(enc, args->pSparseMemoryRequirementCount))
        vn_encode_uint32_t(enc, args->pSparseMemoryRequirementCount);
    if (args->pSparseMemoryRequirements) {
        vn_encode_array_size(enc, (args->pSparseMemoryRequirementCount ? *args->pSparseMemoryRequirementCount : 0));
        for (uint32_t i = 0; i < (args->pSparseMemoryRequirementCount ? *args->pSparseMemoryRequirementCount : 0); i++)
            vn_encode_VkSparseImageMemoryRequirements2(enc, &args->pSparseMemoryRequirements[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void vn_decode_vkGetDeviceImageMemoryRequirements_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetDeviceImageMemoryRequirements *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    if (vn_decode_simple_pointer(dec)) {
        args->pInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pInfo));
        if (!args->pInfo) return;
        vn_decode_VkDeviceImageMemoryRequirements_temp(dec, (VkDeviceImageMemoryRequirements *)args->pInfo);
    } else {
        args->pInfo = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
    if (vn_decode_simple_pointer(dec)) {
        args->pMemoryRequirements = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pMemoryRequirements));
        if (!args->pMemoryRequirements) return;
        vn_decode_VkMemoryRequirements2_partial_temp(dec, args->pMemoryRequirements);
    } else {
        args->pMemoryRequirements = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkGetDeviceImageMemoryRequirements_args_handle(struct vn_command_vkGetDeviceImageMemoryRequirements *args)
{
    vn_replace_VkDevice_handle(&args->device);
    if (args->pInfo)
        vn_replace_VkDeviceImageMemoryRequirements_handle((VkDeviceImageMemoryRequirements *)args->pInfo);
    /* skip args->pMemoryRequirements */
}

static inline void vn_encode_vkGetDeviceImageMemoryRequirements_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetDeviceImageMemoryRequirements *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetDeviceImageMemoryRequirements_EXT});

    /* skip args->device */
    /* skip args->pInfo */
    if (vn_encode_simple_pointer(enc, args->pMemoryRequirements))
        vn_encode_VkMemoryRequirements2(enc, args->pMemoryRequirements);
}

static inline void vn_decode_vkGetDeviceImageSparseMemoryRequirements_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetDeviceImageSparseMemoryRequirements *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    if (vn_decode_simple_pointer(dec)) {
        args->pInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pInfo));
        if (!args->pInfo) return;
        vn_decode_VkDeviceImageMemoryRequirements_temp(dec, (VkDeviceImageMemoryRequirements *)args->pInfo);
    } else {
        args->pInfo = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
    if (vn_decode_simple_pointer(dec)) {
        args->pSparseMemoryRequirementCount = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pSparseMemoryRequirementCount));
        if (!args->pSparseMemoryRequirementCount) return;
        vn_decode_uint32_t(dec, args->pSparseMemoryRequirementCount);
    } else {
        args->pSparseMemoryRequirementCount = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
    if (vn_peek_array_size(dec)) {
        const uint32_t iter_count = vn_decode_array_size(dec, (args->pSparseMemoryRequirementCount ? *args->pSparseMemoryRequirementCount : 0));
        args->pSparseMemoryRequirements = vn_cs_decoder_alloc_temp_array(dec, sizeof(*args->pSparseMemoryRequirements), iter_count);
        if (!args->pSparseMemoryRequirements) return;
        for (uint32_t i = 0; i < iter_count; i++)
            vn_decode_VkSparseImageMemoryRequirements2_partial_temp(dec, &args->pSparseMemoryRequirements[i]);
    } else {
        vn_decode_array_size_unchecked(dec);
        args->pSparseMemoryRequirements = NULL;
    }
}

static inline void vn_replace_vkGetDeviceImageSparseMemoryRequirements_args_handle(struct vn_command_vkGetDeviceImageSparseMemoryRequirements *args)
{
    vn_replace_VkDevice_handle(&args->device);
    if (args->pInfo)
        vn_replace_VkDeviceImageMemoryRequirements_handle((VkDeviceImageMemoryRequirements *)args->pInfo);
    /* skip args->pSparseMemoryRequirementCount */
    /* skip args->pSparseMemoryRequirements */
}

static inline void vn_encode_vkGetDeviceImageSparseMemoryRequirements_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetDeviceImageSparseMemoryRequirements *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetDeviceImageSparseMemoryRequirements_EXT});

    /* skip args->device */
    /* skip args->pInfo */
    if (vn_encode_simple_pointer(enc, args->pSparseMemoryRequirementCount))
        vn_encode_uint32_t(enc, args->pSparseMemoryRequirementCount);
    if (args->pSparseMemoryRequirements) {
        vn_encode_array_size(enc, (args->pSparseMemoryRequirementCount ? *args->pSparseMemoryRequirementCount : 0));
        for (uint32_t i = 0; i < (args->pSparseMemoryRequirementCount ? *args->pSparseMemoryRequirementCount : 0); i++)
            vn_encode_VkSparseImageMemoryRequirements2(enc, &args->pSparseMemoryRequirements[i]);
    } else {
        vn_encode_array_size(enc, 0);
    }
}

static inline void vn_decode_vkGetImageDrmFormatModifierPropertiesEXT_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetImageDrmFormatModifierPropertiesEXT *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    vn_decode_VkImage_lookup(dec, &args->image);
    if (vn_decode_simple_pointer(dec)) {
        args->pProperties = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pProperties));
        if (!args->pProperties) return;
        vn_decode_VkImageDrmFormatModifierPropertiesEXT_partial_temp(dec, args->pProperties);
    } else {
        args->pProperties = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkGetImageDrmFormatModifierPropertiesEXT_args_handle(struct vn_command_vkGetImageDrmFormatModifierPropertiesEXT *args)
{
    vn_replace_VkDevice_handle(&args->device);
    vn_replace_VkImage_handle(&args->image);
    /* skip args->pProperties */
}

static inline void vn_encode_vkGetImageDrmFormatModifierPropertiesEXT_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetImageDrmFormatModifierPropertiesEXT *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetImageDrmFormatModifierPropertiesEXT_EXT});

    vn_encode_VkResult(enc, &args->ret);
    /* skip args->device */
    /* skip args->image */
    if (vn_encode_simple_pointer(enc, args->pProperties))
        vn_encode_VkImageDrmFormatModifierPropertiesEXT(enc, args->pProperties);
}

static inline void vn_decode_vkGetImageSubresourceLayout2KHR_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetImageSubresourceLayout2KHR *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    vn_decode_VkImage_lookup(dec, &args->image);
    if (vn_decode_simple_pointer(dec)) {
        args->pSubresource = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pSubresource));
        if (!args->pSubresource) return;
        vn_decode_VkImageSubresource2KHR_temp(dec, (VkImageSubresource2KHR *)args->pSubresource);
    } else {
        args->pSubresource = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
    if (vn_decode_simple_pointer(dec)) {
        args->pLayout = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pLayout));
        if (!args->pLayout) return;
        vn_decode_VkSubresourceLayout2KHR_partial_temp(dec, args->pLayout);
    } else {
        args->pLayout = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkGetImageSubresourceLayout2KHR_args_handle(struct vn_command_vkGetImageSubresourceLayout2KHR *args)
{
    vn_replace_VkDevice_handle(&args->device);
    vn_replace_VkImage_handle(&args->image);
    if (args->pSubresource)
        vn_replace_VkImageSubresource2KHR_handle((VkImageSubresource2KHR *)args->pSubresource);
    /* skip args->pLayout */
}

static inline void vn_encode_vkGetImageSubresourceLayout2KHR_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetImageSubresourceLayout2KHR *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetImageSubresourceLayout2KHR_EXT});

    /* skip args->device */
    /* skip args->image */
    /* skip args->pSubresource */
    if (vn_encode_simple_pointer(enc, args->pLayout))
        vn_encode_VkSubresourceLayout2KHR(enc, args->pLayout);
}

static inline void vn_decode_vkGetDeviceImageSubresourceLayoutKHR_args_temp(struct vn_cs_decoder *dec, struct vn_command_vkGetDeviceImageSubresourceLayoutKHR *args)
{
    vn_decode_VkDevice_lookup(dec, &args->device);
    if (vn_decode_simple_pointer(dec)) {
        args->pInfo = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pInfo));
        if (!args->pInfo) return;
        vn_decode_VkDeviceImageSubresourceInfoKHR_temp(dec, (VkDeviceImageSubresourceInfoKHR *)args->pInfo);
    } else {
        args->pInfo = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
    if (vn_decode_simple_pointer(dec)) {
        args->pLayout = vn_cs_decoder_alloc_temp(dec, sizeof(*args->pLayout));
        if (!args->pLayout) return;
        vn_decode_VkSubresourceLayout2KHR_partial_temp(dec, args->pLayout);
    } else {
        args->pLayout = NULL;
        vn_cs_decoder_set_fatal(dec);
    }
}

static inline void vn_replace_vkGetDeviceImageSubresourceLayoutKHR_args_handle(struct vn_command_vkGetDeviceImageSubresourceLayoutKHR *args)
{
    vn_replace_VkDevice_handle(&args->device);
    if (args->pInfo)
        vn_replace_VkDeviceImageSubresourceInfoKHR_handle((VkDeviceImageSubresourceInfoKHR *)args->pInfo);
    /* skip args->pLayout */
}

static inline void vn_encode_vkGetDeviceImageSubresourceLayoutKHR_reply(struct vn_cs_encoder *enc, const struct vn_command_vkGetDeviceImageSubresourceLayoutKHR *args)
{
    vn_encode_VkCommandTypeEXT(enc, &(VkCommandTypeEXT){VK_COMMAND_TYPE_vkGetDeviceImageSubresourceLayoutKHR_EXT});

    /* skip args->device */
    /* skip args->pInfo */
    if (vn_encode_simple_pointer(enc, args->pLayout))
        vn_encode_VkSubresourceLayout2KHR(enc, args->pLayout);
}

static inline void vn_dispatch_vkGetImageMemoryRequirements(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetImageMemoryRequirements args;

    if (!ctx->dispatch_vkGetImageMemoryRequirements) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetImageMemoryRequirements_args_temp(ctx->decoder, &args);
    if (!args.device) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetImageMemoryRequirements(ctx, &args);

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder)) {
        if (vn_cs_encoder_acquire(ctx->encoder)) {
            vn_encode_vkGetImageMemoryRequirements_reply(ctx->encoder, &args);
            vn_cs_encoder_release(ctx->encoder);
        }
    }

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkBindImageMemory(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkBindImageMemory args;

    if (!ctx->dispatch_vkBindImageMemory) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkBindImageMemory_args_temp(ctx->decoder, &args);
    if (!args.device) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkBindImageMemory(ctx, &args);

#ifdef DEBUG
    if (!vn_cs_decoder_get_fatal(ctx->decoder) && vn_dispatch_should_log_result(args.ret))
        vn_dispatch_debug_log(ctx, "vkBindImageMemory returned %d", args.ret);
#endif

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder)) {
        if (vn_cs_encoder_acquire(ctx->encoder)) {
            vn_encode_vkBindImageMemory_reply(ctx->encoder, &args);
            vn_cs_encoder_release(ctx->encoder);
        }
    }

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetImageSparseMemoryRequirements(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetImageSparseMemoryRequirements args;

    if (!ctx->dispatch_vkGetImageSparseMemoryRequirements) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetImageSparseMemoryRequirements_args_temp(ctx->decoder, &args);
    if (!args.device) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetImageSparseMemoryRequirements(ctx, &args);

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder)) {
        if (vn_cs_encoder_acquire(ctx->encoder)) {
            vn_encode_vkGetImageSparseMemoryRequirements_reply(ctx->encoder, &args);
            vn_cs_encoder_release(ctx->encoder);
        }
    }

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkCreateImage(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkCreateImage args;

    if (!ctx->dispatch_vkCreateImage) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkCreateImage_args_temp(ctx->decoder, &args);
    if (!args.device) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkCreateImage(ctx, &args);

#ifdef DEBUG
    if (!vn_cs_decoder_get_fatal(ctx->decoder) && vn_dispatch_should_log_result(args.ret))
        vn_dispatch_debug_log(ctx, "vkCreateImage returned %d", args.ret);
#endif

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder)) {
        if (vn_cs_encoder_acquire(ctx->encoder)) {
            vn_encode_vkCreateImage_reply(ctx->encoder, &args);
            vn_cs_encoder_release(ctx->encoder);
        }
    }

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkDestroyImage(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkDestroyImage args;

    if (!ctx->dispatch_vkDestroyImage) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkDestroyImage_args_temp(ctx->decoder, &args);
    if (!args.device) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkDestroyImage(ctx, &args);

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder)) {
        if (vn_cs_encoder_acquire(ctx->encoder)) {
            vn_encode_vkDestroyImage_reply(ctx->encoder, &args);
            vn_cs_encoder_release(ctx->encoder);
        }
    }

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetImageSubresourceLayout(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetImageSubresourceLayout args;

    if (!ctx->dispatch_vkGetImageSubresourceLayout) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetImageSubresourceLayout_args_temp(ctx->decoder, &args);
    if (!args.device) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetImageSubresourceLayout(ctx, &args);

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder)) {
        if (vn_cs_encoder_acquire(ctx->encoder)) {
            vn_encode_vkGetImageSubresourceLayout_reply(ctx->encoder, &args);
            vn_cs_encoder_release(ctx->encoder);
        }
    }

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkBindImageMemory2(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkBindImageMemory2 args;

    if (!ctx->dispatch_vkBindImageMemory2) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkBindImageMemory2_args_temp(ctx->decoder, &args);
    if (!args.device) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkBindImageMemory2(ctx, &args);

#ifdef DEBUG
    if (!vn_cs_decoder_get_fatal(ctx->decoder) && vn_dispatch_should_log_result(args.ret))
        vn_dispatch_debug_log(ctx, "vkBindImageMemory2 returned %d", args.ret);
#endif

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder)) {
        if (vn_cs_encoder_acquire(ctx->encoder)) {
            vn_encode_vkBindImageMemory2_reply(ctx->encoder, &args);
            vn_cs_encoder_release(ctx->encoder);
        }
    }

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetImageMemoryRequirements2(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetImageMemoryRequirements2 args;

    if (!ctx->dispatch_vkGetImageMemoryRequirements2) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetImageMemoryRequirements2_args_temp(ctx->decoder, &args);
    if (!args.device) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetImageMemoryRequirements2(ctx, &args);

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder)) {
        if (vn_cs_encoder_acquire(ctx->encoder)) {
            vn_encode_vkGetImageMemoryRequirements2_reply(ctx->encoder, &args);
            vn_cs_encoder_release(ctx->encoder);
        }
    }

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetImageSparseMemoryRequirements2(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetImageSparseMemoryRequirements2 args;

    if (!ctx->dispatch_vkGetImageSparseMemoryRequirements2) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetImageSparseMemoryRequirements2_args_temp(ctx->decoder, &args);
    if (!args.device) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetImageSparseMemoryRequirements2(ctx, &args);

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder)) {
        if (vn_cs_encoder_acquire(ctx->encoder)) {
            vn_encode_vkGetImageSparseMemoryRequirements2_reply(ctx->encoder, &args);
            vn_cs_encoder_release(ctx->encoder);
        }
    }

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetDeviceImageMemoryRequirements(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetDeviceImageMemoryRequirements args;

    if (!ctx->dispatch_vkGetDeviceImageMemoryRequirements) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetDeviceImageMemoryRequirements_args_temp(ctx->decoder, &args);
    if (!args.device) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetDeviceImageMemoryRequirements(ctx, &args);

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder)) {
        if (vn_cs_encoder_acquire(ctx->encoder)) {
            vn_encode_vkGetDeviceImageMemoryRequirements_reply(ctx->encoder, &args);
            vn_cs_encoder_release(ctx->encoder);
        }
    }

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetDeviceImageSparseMemoryRequirements(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetDeviceImageSparseMemoryRequirements args;

    if (!ctx->dispatch_vkGetDeviceImageSparseMemoryRequirements) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetDeviceImageSparseMemoryRequirements_args_temp(ctx->decoder, &args);
    if (!args.device) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetDeviceImageSparseMemoryRequirements(ctx, &args);

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder)) {
        if (vn_cs_encoder_acquire(ctx->encoder)) {
            vn_encode_vkGetDeviceImageSparseMemoryRequirements_reply(ctx->encoder, &args);
            vn_cs_encoder_release(ctx->encoder);
        }
    }

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetImageDrmFormatModifierPropertiesEXT(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetImageDrmFormatModifierPropertiesEXT args;

    if (!ctx->dispatch_vkGetImageDrmFormatModifierPropertiesEXT) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetImageDrmFormatModifierPropertiesEXT_args_temp(ctx->decoder, &args);
    if (!args.device) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetImageDrmFormatModifierPropertiesEXT(ctx, &args);

#ifdef DEBUG
    if (!vn_cs_decoder_get_fatal(ctx->decoder) && vn_dispatch_should_log_result(args.ret))
        vn_dispatch_debug_log(ctx, "vkGetImageDrmFormatModifierPropertiesEXT returned %d", args.ret);
#endif

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder)) {
        if (vn_cs_encoder_acquire(ctx->encoder)) {
            vn_encode_vkGetImageDrmFormatModifierPropertiesEXT_reply(ctx->encoder, &args);
            vn_cs_encoder_release(ctx->encoder);
        }
    }

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetImageSubresourceLayout2KHR(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetImageSubresourceLayout2KHR args;

    if (!ctx->dispatch_vkGetImageSubresourceLayout2KHR) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetImageSubresourceLayout2KHR_args_temp(ctx->decoder, &args);
    if (!args.device) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetImageSubresourceLayout2KHR(ctx, &args);

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder)) {
        if (vn_cs_encoder_acquire(ctx->encoder)) {
            vn_encode_vkGetImageSubresourceLayout2KHR_reply(ctx->encoder, &args);
            vn_cs_encoder_release(ctx->encoder);
        }
    }

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

static inline void vn_dispatch_vkGetDeviceImageSubresourceLayoutKHR(struct vn_dispatch_context *ctx, VkCommandFlagsEXT flags)
{
    struct vn_command_vkGetDeviceImageSubresourceLayoutKHR args;

    if (!ctx->dispatch_vkGetDeviceImageSubresourceLayoutKHR) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    vn_decode_vkGetDeviceImageSubresourceLayoutKHR_args_temp(ctx->decoder, &args);
    if (!args.device) {
        vn_cs_decoder_set_fatal(ctx->decoder);
        return;
    }

    if (!vn_cs_decoder_get_fatal(ctx->decoder))
        ctx->dispatch_vkGetDeviceImageSubresourceLayoutKHR(ctx, &args);

    if ((flags & VK_COMMAND_GENERATE_REPLY_BIT_EXT) && !vn_cs_decoder_get_fatal(ctx->decoder)) {
        if (vn_cs_encoder_acquire(ctx->encoder)) {
            vn_encode_vkGetDeviceImageSubresourceLayoutKHR_reply(ctx->encoder, &args);
            vn_cs_encoder_release(ctx->encoder);
        }
    }

    vn_cs_decoder_reset_temp_pool(ctx->decoder);
}

#pragma GCC diagnostic pop

#endif /* VN_PROTOCOL_RENDERER_IMAGE_H */
