package org.subethamail.smtp.auth;

/**
 * This a convenient class that saves you setting up the factories that we know
 * about; you can always add more afterwards. Currently this factory supports:
 *
 * PLAIN LOGIN
 *
 * @author Jeff Schnitzer
 */
public final class EasyAuthenticationHandlerFactory extends MultipleAuthenticationHandlerFactory
{
	/** Just hold on to this so that the caller can get it later, if necessary */
	private final UsernamePasswordValidator validator;

	public EasyAuthenticationHandlerFactory(UsernamePasswordValidator validator)
	{
		this.validator = validator;
		this.addFactory(new PlainAuthenticationHandlerFactory(this.validator));
		this.addFactory(new LoginAuthenticationHandlerFactory(this.validator));
	}

	public UsernamePasswordValidator getValidator()
	{
		return this.validator;
	}
}
