## Proposed changes

Describe the big picture of your changes here to communicate to the maintainers
why we should accept this pull request. If it fixes a bug or resolves a feature
request, be sure to link to that issue.

## Types of changes

Please check the type of change your PR introduces:

- [ ] Release (new release request)
- [ ] Bugfix (non-breaking change which fixes an issue)
- [ ] New feature (non-breaking change which adds functionality)
- [ ] Code style update (PEP8, lint, formatting, renaming, etc)
- [ ] Refactoring (no functional changes, no api changes)
- [ ] Breaking change (fix or feature that would cause existing functionality to not work as expected)
- [ ] Build related changes (build process, tests runner, etc)
- [ ] Other (please describe):

## Checklist

_Put an `x` in the boxes that apply. You can also fill these out after creating
the PR. If you're unsure about any of them, don't hesitate to ask. We're here to
help! This is simply a reminder of what we are going to look for before merging
your code._

- [ ] Lint and unit tests pass locally with my changes
- [ ] I have added tests that prove my fix is effective or that my feature works

## Other information

Any other information that is important to this PR such as screenshots of how
the component looks before and after the change.

<!--
    Pull request template based on the following templates:
    * https://raw.githubusercontent.com/ionic-team/ionic/master/.github/PULL_REQUEST_TEMPLATE.md
    * https://raw.githubusercontent.com/appium/appium/master/.github/PULL_REQUEST_TEMPLATE.md
-->
