/***************************************************************************
 *   copyright           : (C) 2004 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "gsm.h"

struct charset_translation gsm_chars[] = {
  { 0x0040, { 0x80, 0x00 }, 1 }, //commercial at
    { 0x0040, { 0x00, 0x00 }, 1 }, //commercial at
  { 0x00a3, { 0x01, 0x00 }, 1 }, //pound sign
  { 0x0024, { 0x02, 0x00 }, 1 }, //dollar sign
  { 0x00a5, { 0x03, 0x00 }, 1 }, //yen sign
  { 0x00e8, { 0x04, 0x00 }, 1 }, //small 'e' with grave
  { 0x00e9, { 0x05, 0x00 }, 1 }, //small 'e' with acute
  { 0x00f9, { 0x06, 0x00 }, 1 }, //small 'u' with grave
  { 0x00ec, { 0x07, 0x00 }, 1 }, //small 'i' with grave
  { 0x00f2, { 0x08, 0x00 }, 1 }, //small 'o' with grave
  { 0x00e7, { 0x09, 0x00 }, 1 }, //small 'c' with cedilla
    { 0x00c7, { 0x09, 0x00 }, 1 }, //capital 'C' with cedilla
  { 0x000a, { 0x0a, 0x00 }, 1 }, //line feed
  { 0x00d8, { 0x0b, 0x00 }, 1 }, //small 'O' with stroke
  { 0x00f8, { 0x0c, 0x00 }, 1 }, //small 'o' with stroke
  { 0x000d, { 0x0d, 0x00 }, 1 }, //carriage return
  { 0x00c5, { 0x0e, 0x00 }, 1 }, //capital 'A' with ring above
  { 0x00e5, { 0x0f, 0x00 }, 1 }, //small 'a' with ring above
  { 0x0394, { 0x10, 0x00 }, 1 }, //capital delta
  { 0x005f, { 0x11, 0x00 }, 1 }, //underscore / low line
  { 0x03a6, { 0x12, 0x00 }, 1 }, //capital phi
  { 0x0393, { 0x13, 0x00 }, 1 }, //capital gamma
  { 0x039b, { 0x14, 0x00 }, 1 }, //capital lambda
  { 0x03a9, { 0x15, 0x00 }, 1 }, //capital omega
  { 0x03a0, { 0x16, 0x00 }, 1 }, //capital pi
  { 0x03a8, { 0x17, 0x00 }, 1 }, //capital psi
  { 0x03a3, { 0x18, 0x00 }, 1 }, //capital sigma
  { 0x0398, { 0x19, 0x00 }, 1 }, //capital theta
  { 0x039a, { 0x1a, 0x00 }, 1 }, //capital xi
  //begin extension table one
  { 0x000c, { 0x1b, 0x0a }, 2 }, //form feed
  { 0x005e, { 0x1b, 0x14 }, 2 }, //circumflex accent
  { 0x007b, { 0x1b, 0x28 }, 2 }, //left curly bracket
  { 0x007d, { 0x1b, 0x29 }, 2 }, //right curly bracket
  { 0x005c, { 0x1b, 0x2f }, 2 }, //reverse solidus (back slash)
  { 0x005b, { 0x1b, 0x3c }, 2 }, //left square bracket
  { 0x007e, { 0x1b, 0x3d }, 2 }, //tilde
  { 0x005d, { 0x1b, 0x3e }, 2 }, //right square bracket
  { 0x007c, { 0x1b, 0x40 }, 2 }, //vertical line
  { 0x20ac, { 0x1b, 0x65 }, 2 }, //euro sign
  //end extension table one
  { 0x00c6, { 0x1c, 0x00 }, 1 }, //capital AE
  { 0x00e6, { 0x1d, 0x00 }, 1 }, //small ae
  { 0x00df, { 0x1e, 0x00 }, 1 }, //small sharp s (german)
  { 0x00c9, { 0x1f, 0x00 }, 1 }, //capital 'E' with acute
  { 0x0020, { 0x20, 0x00 }, 1 }, //space
  { 0x0021, { 0x21, 0x00 }, 1 }, //exclamation mark
  { 0x0022, { 0x22, 0x00 }, 1 }, //quotation mark
  { 0x0023, { 0x23, 0x00 }, 1 }, //number sign
  { 0x00a4, { 0x24, 0x00 }, 1 }, //currency sign
    { 0x00b0, { 0x24, 0x00 }, 1 }, //degree sign (not official, preference of author)
  { 0x0025, { 0x25, 0x00 }, 1 }, //percent sign
  { 0x0026, { 0x26, 0x00 }, 1 }, //ambersand
  { 0x0027, { 0x27, 0x00 }, 1 }, //apostrophe
  { 0x0028, { 0x28, 0x00 }, 1 }, //left parenthesis
  { 0x0029, { 0x29, 0x00 }, 1 }, //right parenthesis
  { 0x002a, { 0x2a, 0x00 }, 1 }, //asterisk
  { 0x002b, { 0x2b, 0x00 }, 1 }, //plus sign
  { 0x002c, { 0x2c, 0x00 }, 1 }, //comma
  { 0x002d, { 0x2d, 0x00 }, 1 }, //hyphen / minus
  { 0x002e, { 0x2e, 0x00 }, 1 }, //full stop
  { 0x002f, { 0x2f, 0x00 }, 1 }, //solidus
  { 0x0030, { 0x30, 0x00 }, 1 }, //digit zero
  { 0x0031, { 0x31, 0x00 }, 1 }, //digit one
  { 0x0032, { 0x32, 0x00 }, 1 }, //digit two
  { 0x0033, { 0x33, 0x00 }, 1 }, //digit three
  { 0x0034, { 0x34, 0x00 }, 1 }, //digit four
  { 0x0035, { 0x35, 0x00 }, 1 }, //digit five
  { 0x0036, { 0x36, 0x00 }, 1 }, //digit six
  { 0x0037, { 0x37, 0x00 }, 1 }, //digit seven
  { 0x0038, { 0x38, 0x00 }, 1 }, //digit eight
  { 0x0039, { 0x39, 0x00 }, 1 }, //digit nine
  { 0x003a, { 0x3a, 0x00 }, 1 }, //colon
  { 0x003b, { 0x3b, 0x00 }, 1 }, //semicolon
  { 0x003c, { 0x3c, 0x00 }, 1 }, //less-than sign
  { 0x003d, { 0x3d, 0x00 }, 1 }, //equals sign
  { 0x003e, { 0x3e, 0x00 }, 1 }, //greater-than sign
  { 0x003f, { 0x3f, 0x00 }, 1 }, //question mark
  { 0x00a1, { 0x40, 0x00 }, 1 }, //inverted exclamation mark
  { 0x0041, { 0x41, 0x00 }, 1 }, //A
    { 0x0391, { 0x41, 0x00 }, 1 }, //capital alpha
  { 0x0042, { 0x42, 0x00 }, 1 }, //B
    { 0x0392, { 0x42, 0x00 }, 1 }, //capital beta
  { 0x0043, { 0x43, 0x00 }, 1 }, //C
  { 0x0044, { 0x44, 0x00 }, 1 }, //D
  { 0x0045, { 0x45, 0x00 }, 1 }, //E
    { 0x0395, { 0x45, 0x00 }, 1 }, //capital epsilon
  { 0x0046, { 0x46, 0x00 }, 1 }, //F
  { 0x0047, { 0x47, 0x00 }, 1 }, //G
  { 0x0048, { 0x48, 0x00 }, 1 }, //H
    { 0x0397, { 0x48, 0x00 }, 1 }, //capital eta
  { 0x0049, { 0x49, 0x00 }, 1 }, //I
    { 0x0399, { 0x49, 0x00 }, 1 }, //capital iota
  { 0x004a, { 0x4a, 0x00 }, 1 }, //J
  { 0x004b, { 0x4b, 0x00 }, 1 }, //K
    { 0x039a, { 0x4b, 0x00 }, 1 }, //capital kappa
  { 0x004c, { 0x4c, 0x00 }, 1 }, //L
  { 0x004d, { 0x4d, 0x00 }, 1 }, //M
    { 0x039c, { 0x4d, 0x00 }, 1 }, //capital mu
  { 0x004e, { 0x4e, 0x00 }, 1 }, //N
    { 0x039d, { 0x4e, 0x00 }, 1 }, //capital nu
  { 0x004f, { 0x4f, 0x00 }, 1 }, //O
    { 0x039f, { 0x4f, 0x00 }, 1 }, //capital omicron
  { 0x0050, { 0x50, 0x00 }, 1 }, //P
    { 0x03a1, { 0x50, 0x00 }, 1 }, //capital rho
  { 0x0051, { 0x51, 0x00 }, 1 }, //Q
  { 0x0052, { 0x52, 0x00 }, 1 }, //R
  { 0x0053, { 0x53, 0x00 }, 1 }, //S
  { 0x0054, { 0x54, 0x00 }, 1 }, //T
    { 0x03a4, { 0x54, 0x00 }, 1 }, //capitla tau
  { 0x0055, { 0x55, 0x00 }, 1 }, //U
    { 0x03a5, { 0x55, 0x00 }, 1 }, //capital upsilon
  { 0x0056, { 0x56, 0x00 }, 1 }, //V
  { 0x0057, { 0x57, 0x00 }, 1 }, //W
  { 0x0058, { 0x58, 0x00 }, 1 }, //X
    { 0x03a7, { 0x58, 0x00 }, 1 }, //capital chi
  { 0x0059, { 0x59, 0x00 }, 1 }, //Y
  { 0x005a, { 0x5a, 0x00 }, 1 }, //Z
    { 0x0396, { 0x5a, 0x00 }, 1 }, //capital zeta
  { 0x00c4, { 0x5b, 0x00 }, 1 }, //capital 'A' with diaeresis
  { 0x00d6, { 0x5c, 0x00 }, 1 }, //capital 'O' with diaeresis
  { 0x00d1, { 0x5d, 0x00 }, 1 }, //capital 'N' with tilde
  { 0x00dc, { 0x5e, 0x00 }, 1 }, //capital 'U' with diaeresis
  { 0x00a7, { 0x5f, 0x00 }, 1 }, //section sign
  { 0x00bf, { 0x60, 0x00 }, 1 }, //inverted question mark
  { 0x0061, { 0x61, 0x00 }, 1 }, //a
  { 0x0062, { 0x62, 0x00 }, 1 }, //b
  { 0x0063, { 0x63, 0x00 }, 1 }, //c
  { 0x0064, { 0x64, 0x00 }, 1 }, //d
  { 0x0065, { 0x65, 0x00 }, 1 }, //e
  { 0x0066, { 0x66, 0x00 }, 1 }, //f
  { 0x0067, { 0x67, 0x00 }, 1 }, //g
  { 0x0068, { 0x68, 0x00 }, 1 }, //h
  { 0x0069, { 0x69, 0x00 }, 1 }, //i
  { 0x006a, { 0x6a, 0x00 }, 1 }, //j
  { 0x006b, { 0x6b, 0x00 }, 1 }, //k
  { 0x006c, { 0x6c, 0x00 }, 1 }, //l
  { 0x006d, { 0x6d, 0x00 }, 1 }, //m
  { 0x006e, { 0x6e, 0x00 }, 1 }, //n
  { 0x006f, { 0x6f, 0x00 }, 1 }, //o
  { 0x0070, { 0x70, 0x00 }, 1 }, //p
  { 0x0071, { 0x71, 0x00 }, 1 }, //q
  { 0x0072, { 0x72, 0x00 }, 1 }, //r
  { 0x0073, { 0x73, 0x00 }, 1 }, //s
  { 0x0074, { 0x74, 0x00 }, 1 }, //t
  { 0x0075, { 0x75, 0x00 }, 1 }, //u
  { 0x0076, { 0x76, 0x00 }, 1 }, //v
  { 0x0077, { 0x77, 0x00 }, 1 }, //w
  { 0x0078, { 0x78, 0x00 }, 1 }, //x
  { 0x0079, { 0x79, 0x00 }, 1 }, //y
  { 0x007a, { 0x7a, 0x00 }, 1 }, //z
  { 0x00e4, { 0x7b, 0x00 }, 1 }, //small 'a' with diaeresis
  { 0x00f6, { 0x7c, 0x00 }, 1 }, //small 'o' wiht diaeesis
  { 0x00f1, { 0x7d, 0x00 }, 1 }, //small 'n' with tilde
  { 0x00fc, { 0x7e, 0x00 }, 1 }, //small 'u' with diaeresis
  { 0x00e0, { 0x7f, 0x00 }, 1 }, //small 'a' with grave

  //final element
  { 0x0000, { 0x00, 0x00 }, 0 }
};

#include <string.h>
size_t gsmwidth (const  gsmchar_t* input) {
  size_t count = strlen((char*)input);
  unsigned int i = 0;

  if (input == NULL) return 0;
  for (; input[i] != 0; ++i)
    /* 0x1b marks an extension table */
    if (input[i] == 0x1b) --count;
  return count;
}

unsigned int gsm_count (ucs4char_t* input, unsigned int count) {
  unsigned int i = 0;
  unsigned int k = 0;
  unsigned int g;

  if (input == NULL) return 0;

  for (; (count == 0 || k < count) && input[i] != 0 ; ++i) {
    for (g = 0; gsm_chars[g].gsize != 0; ++g) {
      if (input[i] == gsm_chars[g].uval) break;
    }
    k += gsm_chars[g].gsize;
  }
  /* Since some characters have an encoded size of two
   * k can be greater or equal than count
   * in this case, the last char won't fit
   */
  if (count != 0) {
    if (k > count) --i;
    return i;
  } else {
    return k;
  }
}
