// =============================================================================
// Scilab ( https://www.scilab.org/ ) - This file is part of Scilab
// Copyright (C) 2014 - Scilab Enterprises - Paul Bignier
//
//  This file is distributed under the same license as the Scilab package.
// =============================================================================
//
// <-- CLI SHELL MODE -->
//
// <-- Non-regression test for bug 11714 -->
//
// <-- GitLab URL -->
// https://gitlab.com/scilab/scilab/-/issues/11714
//
// <-- Short Description -->
// help_from_sci sometimes failed when function had "<imagedata>" comments.

path = SCI+"/modules/helptools/tests/nonreg_tests/";
copyfile(path+"bug_11714.sci", TMPDIR + filesep());
path = TMPDIR + filesep();

help_from_sci(path+"bug_11714.sci", path); // Create bug_11714.xml

assert_checktrue(isfile(path+"bug_11714.xml"));
fd = mopen(path+"bug_11714.xml");
mgetl(fd, 28);
image = mgetl(fd, 1); // Read the 29th line of bug_11714.xml

refImage = "<imagedata fileref=""myimage.png"" align=""center"" valign=""middle""/>";
assert_checkequal(image, refImage);

mclose(fd);
deletefile(path+"bug_11714.xml");
