.TH sane\-pint 5 "14 Jul 2008" "@PACKAGEVERSION@" "SANE Scanner Access Now Easy"
.IX sane\-pint
.SH NAME
sane\-pint \- SANE backend for scanners that use the PINT device driver
.SH DESCRIPTION
The
.B sane\-pint
library implements a SANE (Scanner Access Now Easy) backend that
provides generic access to hand-held and flatbed scanners using the
PINT (PINT Is Not Twain) device driver.  The PINT driver is being
actively developed on the OpenBSD platform, and has been ported to a
few other *NIX-like operating systems.
.PP
PINT is designed to provide an
.BR ioctl (2)
interface to many different scanner types.  However, this backend has
only been tested with flatbed single-pass scanners, and more work will
probably be required to get it to use other scanner types
successfully.
.PP
If have successfully used the PINT driver with your scanner, but it
does not work using this SANE backend, please let us know.  To do
this, send a mail with the relevant information for your scanner to
.IR sane\-devel@alioth-lists.debian.net .
Have a look at
.I http://www.sane\-project.org/mailing\-lists.html
concerning subscription to sane\-devel.

.SH "DEVICE NAMES"
This backend expects device names of the form:
.PP
.RS
.I special
.RE
.PP
Where
.I special
is the UNIX path-name for the special device that corresponds to the
scanner.  The special device name must be a PINT device or a symlink
to such a device.  For example, under NetBSD or OpenBSD, such a device
name could be
.I /dev/ss0
or
.IR /dev/scan0 .
.SH CONFIGURATION
The contents of the
.IR pint.conf .
file is a list of device names that correspond to PINT
scanners.  Empty lines and lines starting with a hash mark (#) are
ignored.  A sample configuration file is shown below:
.PP
.RS
/dev/scanner
.br
# this is a comment
.br
/dev/ss1
.RE
.SH FILES
.TP
.I @CONFIGDIR@/pint.conf
The backend configuration file (see also description of
.B SANE_CONFIG_DIR
below).
.TP
.I @LIBDIR@/libsane\-pint.a
The static library implementing this backend.
.TP
.I @LIBDIR@/libsane\-pint.so
The shared library implementing this backend (present on systems that
support dynamic loading).
.SH ENVIRONMENT
.TP
.B SANE_CONFIG_DIR
This environment variable specifies the list of directories that may
contain the configuration file.  On *NIX systems, the directories are
separated by a colon (`:'), under OS/2, they are separated by a
semi-colon (`;').  If this variable is not set, the configuration file
is searched in two default directories: first, the current working
directory (".") and then in
.IR @CONFIGDIR@ .
If the value of the
environment variable ends with the directory separator character, then
the default directories are searched after the explicitly specified
directories.  For example, setting
.B SANE_CONFIG_DIR
to "/tmp/config:" would result in directories
.IR "tmp/config" ,
.BR "." ,
and
.I "@CONFIGDIR@"
being searched (in this order).
.TP
.B SANE_DEBUG_PINT
If the library was compiled with debug support enabled, this
environment variable controls the debug level for this backend.  E.g.,
a value of 128 requests all debug output to be printed.  Smaller
levels reduce verbosity.

.SH SEE ALSO
.BR sane (7)

.SH AUTHOR
Gordon Matzigkeit, adapted from existing backends written by David
Mosberger.
.SH BUGS

There are minor roundoff errors when adjusting the ranges, since
PINT uses units of 1/1200 of an inch, and SANE normally uses
millimeters.  Symptoms of these errors are skewed images.  This should
really be fixed (no pun intended) as soon as possible, but I just
don't know/care enough about fixed-point representation and roundoff
errors to do this correctly.  Workaround: use inches as the scanning
unit, and everything usually works fine.

The PINT 0.5e interface does not provide a way to determine valid
ranges for DPI, modes, and scan sizes.  So, the SANE backend queries
the PINT device, and dynamically discovers valid ranges by doing a
binary search.  This means that the driver takes longer to initialize
than seems necessary.

Resetting the scanner does not seem to work (at least not on my HP
ScanJet 4p).  For that reason, the driver sends a SCIOCRESTART, then
gobbles up any remaining input until it hits EOF.

Not all of the scanners have been identified (i.e. whether they are
flatbed or handheld).

X and Y resolutions are assumed to be the same.

No testing has been done on three-pass or handheld scanners, or with
Automatic Document Feeder support.
