.\" $NCDId: @(#)auedit.man,v 1.5 1994/06/01 17:42:08 greg Exp $
.TH AUEDIT 1 "" ""
.SH NAME
auedit \- graphically record and edit audio files
.SH SYNOPSIS
.B auedit
[\-audio \fIservername\fP] [\fB\-toolkitoption ...\fP] [filename]
.SH DESCRIPTION
\fIauedit\fP provides an X-based window-oriented interface allowing the user
to record and edit audio files.  The editing features available include:
.IP \fBo\fP 4
Cutting, copying, pasting, and mixing within a single \fIauedit\fP instance
or between multiple \fIauedit\fP instances.
.IP \fBo\fP 4
Changing the amplitude of an interval.
.IP \fBo\fP 4
Reversing an interval.
.IP \fBo\fP 4
Fading in or out an interval.
.SH AUEDIT AND THE ATHENA WIDGET SET
\fIauedit\fP uses the X Toolkit Intrinsics and the Athena Widget Set.
For more information, see the Athena Widget Set documentation.
.SH SCREEN LAYOUT
\fIauedit\fP starts out with a single window divided into several areas:
.IP \fBo\fP 4
A collection of drop\-down menus and command buttons.
.IP \fBo\fP 4
A volume indicator and control slider.
.IP \fBo\fP 4
The audio file represented as a wave form.  If the audio data contains
multiple tracks, the tracks will be displayed in ascending order.  For stereo
data, the convention is left track, then right track.
.IP \fBo\fP 4
A set of indicators displaying the interval start, duration, and end and the
current position.  These indicators are in units of minutes, seconds, and
hundredths of seconds.
.IP \fBo\fP 4
Buttons to play, stop, and pause the audio.
.IP \fBo\fP 4
Two menus indicating the current file and data formats.
.IP \fBo\fP 4
Two editable fields containing the current frequency and the audio file
comment.
.SH INTERVALS
Many functions in \fIauedit\fP operate on a range of audio data called
an \fBinterval\fP.  The initial interval encompasses all of the audio
data.  The interval is indicated within the wave form by two solid,
vertical lines.  The left marker indicates the start of the interval.
The right marker indicates the end of the interval.  To select an
interval of audio data, use the mouse to move the interval markers in
the wave form.  Pressing a mouse button in the wave form will select
the marker closest to the mouse position.  That marker may then be
dragged to the desired location in the wave form.  Note that the
markers may not cross over each other.
.SH PLAYING AN INTERVAL
To play an interval, click on the Play button (the one with the
triangle on its side).  The audio data delimited by the start and end
markers will be played.  A dashed vertical line will indicate the
approximate position of the data currently being played.  To stop
playing, click on the Stop button (the one containing a solid square).
Clicking on Pause (the button containing two vertical, parallel lines)
will pause the playing.  To resume, click on Pause again.  The volume
slider controls the play volume.  The interval is played at the
frequency specified by the \fBFrequency\fP field.  Note that while
data is being played, most other functions are disabled.
.SH "THE FILE MENU"
.IP "New..." 20
Initializes \fIauedit\fP with an empty file.  You will be prompted for the
number of tracks for the new file.
.IP "Load..." 20
Loads a file.  You will be prompted for the file name.
.IP "Save" 20
Saves the current file.  A backup file will be created by appending a tilde
(~) to the current file name.  The file format, data format, frequency and
comment are used when saving the file.
.IP "Save as..." 20
Saves the current file under a new name.  You will be prompted for the
file name.  The file format, data format, frequency and
comment are used when saving the file.
.IP "Save interval..." 20
Saves the interval to a file.  You
will be prompted for a file name.  The file format, data format, frequency and
comment are used when saving the file.
.IP "Revert" 20
Discards all changes made since the last save and restores the data to its
state following the last save.
.IP "Exit" 20
Exits \fIauedit\fP.  If there have been changes made to the current file that
have not been saved, you will be asked if you wish to save them.
.SH "THE EDIT MENU"
The cut, copy, and paste commands in the edit menu transfer data to and from
a selection buffer.  This buffer is shared between all instances of
\fIauedit\fP.  This means that you can cut or copy data from one instance
of \fIauedit\fP and paste it into another instance.  The only restriction
is that the audio data in both instances must have the same number of
tracks.  When transferring data between instances of differing frequencies,
the data will be converted to the frequency of the destination.  This can
be used to change the frequency of the data in a single instance of
\fIauedit\fP.  First, cut the data whose frequency you wish to change.  Then
change the \fBFrequency\fP field to the desired frequency.  Finally, paste
the data back in.  The frequency of the data will be converted to the
frequency specified in the \fBFrequency\fP field.
.IP "Cut" 20
Moves the interval to the selection buffer.
.IP "Copy" 20
Copies the interval to the selection buffer.
.IP "Paste insert" 20
Inserts the selection buffer at the point marked by the start marker.
.IP "Paste replace" 20
Replaces the data at the point marked by the start marker with the data from
the selection buffer.
.IP "Paste mix" 20
Mixes the data at the point marked by the start marker with the data from
the selection buffer.  The mixing function is an average.
.IP "Undo" 20
Undoes the last operation that modified the audio data.  This includes effects
operations in addition to editing operations.  If the last operation was
an \fBUndo\fP then the undo is undone, restoring the data to the state prior
to the first undo.
.SH "THE ZOOM MENU"
.IP "In" 20
Zoom in by a factor of two.
.IP "Out" 20
Zoom out by a factor of two.
.IP "Markers" 20
Zoom in to the interval delimited by the start and end markers.
.IP "Full" 20
Zoom out to display all of the audio data.
.SH "THE EFFECTS MENU"
All operations under the effects menu apply to the current interval.
.IP "Amplitude..." 20
Scale the amplitude.  You will be prompted for the scale.  The scale may be
non-integral.
.IP "Max Amplitude" 20
Scales the interval to its maximum amplitude without clipping.
.IP "Reverse" 20
Reverses the order of the data within the interval.
.IP "Fade In" 20
Linearly scales the interval using a scale ranging from 0.0 to 1.0.
.IP "Fade Out" 20
Linearly scales the interval using a scale ranging from 1.0 to 0.0.
.SH "THE RECORD COMMAND"
Clicking on the \fBRecord\fP button brings up the record dialog box.
The record dialog box consists of:
.IP \fBo\fP 4
A duration field.  This is the maximum duration of the recording in
seconds.
.IP \fBo\fP 4
A frequency field.  This is the frequency of the recording in hertz.
.IP \fBo\fP 4
An input mode toggle button.  Clicking this button toggles between
line mode and microphone mode.
.IP \fBo\fP 4
A gain slider.  This controls the input gain level.
.IP \fBo\fP 4
A record toggle button.  Clicking this button starts and stops the recording.
.IP \fBo\fP 4
A monitor toggle button.  Clicking this button toggles the record monitoring
feature that lets you hear what you're recording.
.IP \fBo\fP 4
A dismiss command button.  Clicking this button stops any current
recording and dismisses the record dialog box.
.SH OPTIONS
The following options may be used with \fIauedit\fP:
.IP "\fB\-audio\fP \fIservername\fP" 8
This option specifies the Network Audio System server to which \fIauedit\fP should connect.
.SH "SEE ALSO"
nas(1), auconvert(1), X(1)
.SH BUGS
There is no way to manipulate individual tracks.
.SH COPYRIGHT
Copyright 1993, 1994 Network Computing Devices, Inc.
.SH AUTHOR
Greg Renda, Network Computing Devices, Inc.
