/* BEGIN software license
 *
 * MsXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2018 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the MsXpertSuite project.
 *
 * The MsXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


#ifndef SEQUENCE_HPP
#define SEQUENCE_HPP


/////////////////////// Qt includes
#include <QString>


/////////////////////// Local includes
#include "exportimportconfig.h"
#include "Monomer.hpp"
#include "Prop.hpp"


namespace MsXpS
{

namespace libXpertMass
{


  class DECLSPEC Sequence
  {
    public:
    Sequence(const QString & = QString());
    Sequence(const Sequence &other);

    virtual ~Sequence();

    Sequence &operator=(const Sequence &other);

    void setMonomerText(const QString &);
    void appendMonomerText(const QString &);
    virtual int makeMonomerText();
    const QString *monomerText();
    QString *monomerText(int, int, bool) const;
    QString *monomerText(const CoordinateList &, bool, bool) const;

    const QList<const Monomer *> &monomerList() const;
    QList<const Monomer *> *monomerListPtr();

    int nextCode(QString *, int *, QString *, int);
    const Monomer *at(int) const;
    int monomerIndex(const Monomer *);

    int size() const;
    bool isInBound(int index);

    void unspacifyMonomerText();

    int makeMonomerList(PolChemDefCstSPtr, bool = true, QList<int> * = 0);

    bool insertMonomerAt(const Monomer *, int);
    virtual bool prepareMonomerRemoval(const Monomer *);
    virtual bool removeMonomerAt(int);

    int findForwardMotif(Sequence *, PolChemDefCstSPtr, int *);

    bool validate(PolChemDefCstSPtr);

    quint16 checksum(int = -1, int = -1, bool = false) const;

    protected:
    QString m_monomerText;
    QList<const Monomer *> m_monomerList;
  };

} // namespace libXpertMass

} // namespace MsXpS


#endif // SEQUENCE_HPP
