# Stefan Achatz 2012
#
# Tries to find libpango and sets following variables according to found capabilities:
#
# PANGO_FOUND
# PANGO_INCLUDE_DIRS
# PANGO_LIBRARIES

FIND_PACKAGE(PkgConfig)
PKG_CHECK_MODULES(PKG_PANGO pango)

FIND_PATH(PANGO_INCLUDE_DIRS pango/pango.h
  HINTS
    ${PKG_PANGO_INCLUDE_DIRS}
    ${PKG_PANGO_INCLUDEDIR}
  PATH_SUFFIXES pango-1.0
)

FIND_LIBRARY(PANGO_LIBRARIES pango-1.0
  HINTS ${PKG_PANGO_LIBRARY_DIRS}
)

IF(PANGO_LIBRARIES AND PANGO_INCLUDE_DIRS)
  SET(PANGO_FOUND true)
ENDIF()

IF(PANGO_FIND_REQUIRED AND NOT PANGO_FOUND)
  MESSAGE(FATAL_ERROR "Could not find PANGO")
ENDIF()
