import QtQuick 2.4
import Lomiri.Components 1.3
import Dekko.Contacts 1.0
import Dekko.Lomiri.Components 1.0
import "../../actions/views"
import Dekko.Lomiri.Constants 1.0


DekkoPage {

    pageHeader {
        title: qsTr("Addressbooks")
        backAction: Action {
            iconName: "back"
            onTriggered: {
                ViewActions.popStage()
            }
        }
    }


    PageContent {
        ScrollView {
            anchors.fill: parent
            ListView {
                anchors.fill: parent
                model: ContactsStore.addressBooksModel
                add: DekkoAnimation.listViewAddTransition
                addDisplaced: DekkoAnimation.listViewAddDisplacedTransition
                remove: DekkoAnimation.listViewRemoveTransition
                removeDisplaced: DekkoAnimation.listViewRemoveDisplacedTransition
                delegate: Item {
                    width: parent.width
                    height: contents.height
                    property var addressbook: model.qtObject
                    Column {
                        id: contents
                        anchors {
                            left: parent.left
                            top: parent.top
                            topMargin: units.gu(1)
                            right: parent.right
                        }

                        Item {
                            width: parent.width
                            height: units.gu(2)
                            Label {
                                anchors {
                                    left: parent.left
                                    leftMargin: units.gu(2)
                                    verticalCenter: parent.verticalCenter
                                }
                                text: addressbook.displayName
                                color: Suru.secondaryForegroundColor
                            }
                        }

                        ListItem {
                            height: configLayout.height
                            divider.visible: false
                            visible: !addressbook.collections.count
                            ListItemLayout {
                                id: configLayout
                                title.text: qsTr("Add Collection")
                            } 
                        }

                        Repeater {
                            model: addressbook ? addressbook.collections : null
                            delegate: ListItem {
                                height: layout.height
                                ListItemLayout {
                                    id: layout
                                    title.text: model.name
                                    Icon {
                                        height: units.gu(3)
                                        width: height
                                        name: "contact-group"
                                        SlotsLayout.position: SlotsLayout.Leading
                                    }
                                    ProgressionSlot {}
                                }
                                onClicked: ContactActions.setSelectedAddressBook(model.index)
                                divider.visible: false

                                Line {
                                    anchors {
                                        right: parent.right
                                        bottom: parent.bottom
                                        left: parent.left
                                        leftMargin: units.gu(7)
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}
