/*
 * Decompiled with CFR 0.152.
 */
package org.lisaac.ldt.editors;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.widgets.Shell;
import org.lisaac.ldt.LisaacPlugin;
import org.lisaac.ldt.editors.ColorManager;
import org.lisaac.ldt.editors.HoverPresenter;
import org.lisaac.ldt.editors.LisaacScanner;
import org.lisaac.ldt.model.LisaacModel;
import org.lisaac.ldt.model.items.IVariable;
import org.lisaac.ldt.model.items.Prototype;
import org.lisaac.ldt.model.items.Slot;

public class LisaacTextHover
implements ITextHover,
ITextHoverExtension {
    protected LisaacModel model;
    protected String filename;
    protected ColorManager colorManager;

    public LisaacTextHover(LisaacModel model, String filename, ColorManager colorManager) {
        this.model = model;
        this.filename = filename;
        this.colorManager = colorManager;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        block13: {
            block12: {
                boolean enableHover = LisaacPlugin.getDefault().getPreferenceStore().getBoolean("lisaac_hover");
                if (enableHover) break block12;
                return null;
            }
            if (this.model != null) break block13;
            return null;
        }
        try {
            Prototype prototype;
            String text = textViewer.getDocument().get(hoverRegion.getOffset(), hoverRegion.getLength());
            if (LisaacScanner.isPrototypeIdentifier(text)) {
                Prototype prototype2 = this.model.getPrototype(text);
                if (prototype2 != null) {
                    return "<I>Prototype</I> : " + prototype2.getHoverInformation();
                }
            } else if (LisaacScanner.isIdentifier(text) && (prototype = this.model.getPrototype(LisaacModel.extractPrototypeName(this.filename))) != null) {
                Slot slot = prototype.getSlotFromKeyword(text, prototype.openParser(), hoverRegion.getOffset());
                if (slot != null) {
                    return "<I>Slot</I> : " + slot.getHoverInformation();
                }
                slot = prototype.getSlot(hoverRegion.getOffset());
                IVariable variable = slot.getVariable(text, hoverRegion.getOffset());
                if (variable != null) {
                    return variable.getHoverInformation();
                }
                slot = prototype.lookupSlot(text);
                if (slot != null) {
                    return "<I>Argument</I> : " + slot.getHoverInformation();
                }
            }
        }
        catch (BadLocationException badLocationException) {
        }
        catch (CoreException coreException) {}
        return null;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        try {
            return this.selectWord(textViewer.getDocument(), offset);
        }
        catch (BadLocationException badLocationException) {
            return new Region(offset, 0);
        }
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, "Lisaac", (DefaultInformationControl.IInformationPresenter)new HoverPresenter(LisaacTextHover.this.colorManager));
            }
        };
    }

    protected IRegion selectWord(IDocument doc, int caretPos) throws BadLocationException {
        char c;
        int pos = caretPos;
        while (pos >= 0) {
            c = doc.getChar(pos);
            if (!Character.isJavaIdentifierPart(c)) break;
            --pos;
        }
        int startPos = pos + 1;
        pos = caretPos;
        int length = doc.getLength();
        while (pos < length) {
            c = doc.getChar(pos);
            if (!Character.isJavaIdentifierPart(c)) break;
            ++pos;
        }
        int endPos = pos;
        return new Region(startPos, endPos - startPos);
    }
}

