
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2023 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQVideoFrameFormat.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QVideoFrameFormat>
#include <QMatrix4x4>
#include <QRect>
#include <QSize>
#include <QVideoFrame>
#include "gsiQt.h"
#include "gsiQtMultimediaCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QVideoFrameFormat

//  Constructor QVideoFrameFormat::QVideoFrameFormat()


static void _init_ctor_QVideoFrameFormat_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QVideoFrameFormat> ();
}

static void _call_ctor_QVideoFrameFormat_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QVideoFrameFormat *> (new QVideoFrameFormat ());
}


//  Constructor QVideoFrameFormat::QVideoFrameFormat(const QSize &size, QVideoFrameFormat::PixelFormat pixelFormat)


static void _init_ctor_QVideoFrameFormat_5072 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<const QSize & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("pixelFormat");
  decl->add_arg<const qt_gsi::Converter<QVideoFrameFormat::PixelFormat>::target_type & > (argspec_1);
  decl->set_return_new<QVideoFrameFormat> ();
}

static void _call_ctor_QVideoFrameFormat_5072 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSize &arg1 = gsi::arg_reader<const QSize & >() (args, heap);
  const qt_gsi::Converter<QVideoFrameFormat::PixelFormat>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<QVideoFrameFormat::PixelFormat>::target_type & >() (args, heap);
  ret.write<QVideoFrameFormat *> (new QVideoFrameFormat (arg1, qt_gsi::QtToCppAdaptor<QVideoFrameFormat::PixelFormat>(arg2).cref()));
}


//  Constructor QVideoFrameFormat::QVideoFrameFormat(const QVideoFrameFormat &format)


static void _init_ctor_QVideoFrameFormat_3005 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QVideoFrameFormat & > (argspec_0);
  decl->set_return_new<QVideoFrameFormat> ();
}

static void _call_ctor_QVideoFrameFormat_3005 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVideoFrameFormat &arg1 = gsi::arg_reader<const QVideoFrameFormat & >() (args, heap);
  ret.write<QVideoFrameFormat *> (new QVideoFrameFormat (arg1));
}


// void QVideoFrameFormat::detach()


static void _init_f_detach_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_detach_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVideoFrameFormat *)cls)->detach ();
}


// QString QVideoFrameFormat::fragmentShaderFileName()


static void _init_f_fragmentShaderFileName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_fragmentShaderFileName_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QVideoFrameFormat *)cls)->fragmentShaderFileName ());
}


// int QVideoFrameFormat::frameHeight()


static void _init_f_frameHeight_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_frameHeight_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QVideoFrameFormat *)cls)->frameHeight ());
}


// double QVideoFrameFormat::frameRate()


static void _init_f_frameRate_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_frameRate_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QVideoFrameFormat *)cls)->frameRate ());
}


// QSize QVideoFrameFormat::frameSize()


static void _init_f_frameSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_frameSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QVideoFrameFormat *)cls)->frameSize ());
}


// int QVideoFrameFormat::frameWidth()


static void _init_f_frameWidth_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_frameWidth_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QVideoFrameFormat *)cls)->frameWidth ());
}


// bool QVideoFrameFormat::isMirrored()


static void _init_f_isMirrored_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isMirrored_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QVideoFrameFormat *)cls)->isMirrored ());
}


// bool QVideoFrameFormat::isValid()


static void _init_f_isValid_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isValid_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QVideoFrameFormat *)cls)->isValid ());
}


// bool QVideoFrameFormat::operator!=(const QVideoFrameFormat &format)


static void _init_f_operator_excl__eq__c3005 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QVideoFrameFormat & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_excl__eq__c3005 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVideoFrameFormat &arg1 = gsi::arg_reader<const QVideoFrameFormat & >() (args, heap);
  ret.write<bool > ((bool)((QVideoFrameFormat *)cls)->operator!= (arg1));
}


// QVideoFrameFormat &QVideoFrameFormat::operator=(const QVideoFrameFormat &format)


static void _init_f_operator_eq__3005 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QVideoFrameFormat & > (argspec_0);
  decl->set_return<QVideoFrameFormat & > ();
}

static void _call_f_operator_eq__3005 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVideoFrameFormat &arg1 = gsi::arg_reader<const QVideoFrameFormat & >() (args, heap);
  ret.write<QVideoFrameFormat & > ((QVideoFrameFormat &)((QVideoFrameFormat *)cls)->operator= (arg1));
}


// bool QVideoFrameFormat::operator==(const QVideoFrameFormat &format)


static void _init_f_operator_eq__eq__c3005 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QVideoFrameFormat & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_eq__eq__c3005 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVideoFrameFormat &arg1 = gsi::arg_reader<const QVideoFrameFormat & >() (args, heap);
  ret.write<bool > ((bool)((QVideoFrameFormat *)cls)->operator== (arg1));
}


// QVideoFrameFormat::PixelFormat QVideoFrameFormat::pixelFormat()


static void _init_f_pixelFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QVideoFrameFormat::PixelFormat>::target_type > ();
}

static void _call_f_pixelFormat_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QVideoFrameFormat::PixelFormat>::target_type > ((qt_gsi::Converter<QVideoFrameFormat::PixelFormat>::target_type)qt_gsi::CppToQtAdaptor<QVideoFrameFormat::PixelFormat>(((QVideoFrameFormat *)cls)->pixelFormat ()));
}


// int QVideoFrameFormat::planeCount()


static void _init_f_planeCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_planeCount_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QVideoFrameFormat *)cls)->planeCount ());
}


// QVideoFrameFormat::Direction QVideoFrameFormat::scanLineDirection()


static void _init_f_scanLineDirection_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QVideoFrameFormat::Direction>::target_type > ();
}

static void _call_f_scanLineDirection_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QVideoFrameFormat::Direction>::target_type > ((qt_gsi::Converter<QVideoFrameFormat::Direction>::target_type)qt_gsi::CppToQtAdaptor<QVideoFrameFormat::Direction>(((QVideoFrameFormat *)cls)->scanLineDirection ()));
}


// void QVideoFrameFormat::setFrameRate(double rate)


static void _init_f_setFrameRate_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rate");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFrameRate_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVideoFrameFormat *)cls)->setFrameRate (arg1);
}


// void QVideoFrameFormat::setFrameSize(const QSize &size)


static void _init_f_setFrameSize_1805 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<const QSize & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFrameSize_1805 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSize &arg1 = gsi::arg_reader<const QSize & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVideoFrameFormat *)cls)->setFrameSize (arg1);
}


// void QVideoFrameFormat::setFrameSize(int width, int height)


static void _init_f_setFrameSize_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("width");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("height");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setFrameSize_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVideoFrameFormat *)cls)->setFrameSize (arg1, arg2);
}


// void QVideoFrameFormat::setMirrored(bool mirrored)


static void _init_f_setMirrored_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mirrored");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMirrored_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVideoFrameFormat *)cls)->setMirrored (arg1);
}


// void QVideoFrameFormat::setScanLineDirection(QVideoFrameFormat::Direction direction)


static void _init_f_setScanLineDirection_3173 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("direction");
  decl->add_arg<const qt_gsi::Converter<QVideoFrameFormat::Direction>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setScanLineDirection_3173 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QVideoFrameFormat::Direction>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QVideoFrameFormat::Direction>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVideoFrameFormat *)cls)->setScanLineDirection (qt_gsi::QtToCppAdaptor<QVideoFrameFormat::Direction>(arg1).cref());
}


// void QVideoFrameFormat::setViewport(const QRect &viewport)


static void _init_f_setViewport_1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("viewport");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setViewport_1792 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = gsi::arg_reader<const QRect & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVideoFrameFormat *)cls)->setViewport (arg1);
}


// void QVideoFrameFormat::setYCbCrColorSpace(QVideoFrameFormat::YCbCrColorSpace colorSpace)


static void _init_f_setYCbCrColorSpace_3682 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("colorSpace");
  decl->add_arg<const qt_gsi::Converter<QVideoFrameFormat::YCbCrColorSpace>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setYCbCrColorSpace_3682 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QVideoFrameFormat::YCbCrColorSpace>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QVideoFrameFormat::YCbCrColorSpace>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVideoFrameFormat *)cls)->setYCbCrColorSpace (qt_gsi::QtToCppAdaptor<QVideoFrameFormat::YCbCrColorSpace>(arg1).cref());
}


// void QVideoFrameFormat::swap(QVideoFrameFormat &other)


static void _init_f_swap_2310 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<QVideoFrameFormat & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_swap_2310 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QVideoFrameFormat &arg1 = gsi::arg_reader<QVideoFrameFormat & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVideoFrameFormat *)cls)->swap (arg1);
}


// void QVideoFrameFormat::updateUniformData(QByteArray *dst, const QVideoFrame &frame, const QMatrix4x4 &transform, float opacity)


static void _init_f_updateUniformData_c6899 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dst");
  decl->add_arg<QByteArray * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("frame");
  decl->add_arg<const QVideoFrame & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("transform");
  decl->add_arg<const QMatrix4x4 & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("opacity");
  decl->add_arg<float > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_updateUniformData_c6899 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QByteArray *arg1 = gsi::arg_reader<QByteArray * >() (args, heap);
  const QVideoFrame &arg2 = gsi::arg_reader<const QVideoFrame & >() (args, heap);
  const QMatrix4x4 &arg3 = gsi::arg_reader<const QMatrix4x4 & >() (args, heap);
  float arg4 = gsi::arg_reader<float >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVideoFrameFormat *)cls)->updateUniformData (arg1, arg2, arg3, arg4);
}


// QString QVideoFrameFormat::vertexShaderFileName()


static void _init_f_vertexShaderFileName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_vertexShaderFileName_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QVideoFrameFormat *)cls)->vertexShaderFileName ());
}


// QRect QVideoFrameFormat::viewport()


static void _init_f_viewport_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_f_viewport_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRect > ((QRect)((QVideoFrameFormat *)cls)->viewport ());
}


// QVideoFrameFormat::YCbCrColorSpace QVideoFrameFormat::yCbCrColorSpace()


static void _init_f_yCbCrColorSpace_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QVideoFrameFormat::YCbCrColorSpace>::target_type > ();
}

static void _call_f_yCbCrColorSpace_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QVideoFrameFormat::YCbCrColorSpace>::target_type > ((qt_gsi::Converter<QVideoFrameFormat::YCbCrColorSpace>::target_type)qt_gsi::CppToQtAdaptor<QVideoFrameFormat::YCbCrColorSpace>(((QVideoFrameFormat *)cls)->yCbCrColorSpace ()));
}


// static QImage::Format QVideoFrameFormat::imageFormatFromPixelFormat(QVideoFrameFormat::PixelFormat format)


static void _init_f_imageFormatFromPixelFormat_3375 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const qt_gsi::Converter<QVideoFrameFormat::PixelFormat>::target_type & > (argspec_0);
  decl->set_return<qt_gsi::Converter<QImage::Format>::target_type > ();
}

static void _call_f_imageFormatFromPixelFormat_3375 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QVideoFrameFormat::PixelFormat>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QVideoFrameFormat::PixelFormat>::target_type & >() (args, heap);
  ret.write<qt_gsi::Converter<QImage::Format>::target_type > ((qt_gsi::Converter<QImage::Format>::target_type)qt_gsi::CppToQtAdaptor<QImage::Format>(QVideoFrameFormat::imageFormatFromPixelFormat (qt_gsi::QtToCppAdaptor<QVideoFrameFormat::PixelFormat>(arg1).cref())));
}


// static QVideoFrameFormat::PixelFormat QVideoFrameFormat::pixelFormatFromImageFormat(QImage::Format format)


static void _init_f_pixelFormatFromImageFormat_1733 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const qt_gsi::Converter<QImage::Format>::target_type & > (argspec_0);
  decl->set_return<qt_gsi::Converter<QVideoFrameFormat::PixelFormat>::target_type > ();
}

static void _call_f_pixelFormatFromImageFormat_1733 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QImage::Format>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QImage::Format>::target_type & >() (args, heap);
  ret.write<qt_gsi::Converter<QVideoFrameFormat::PixelFormat>::target_type > ((qt_gsi::Converter<QVideoFrameFormat::PixelFormat>::target_type)qt_gsi::CppToQtAdaptor<QVideoFrameFormat::PixelFormat>(QVideoFrameFormat::pixelFormatFromImageFormat (qt_gsi::QtToCppAdaptor<QImage::Format>(arg1).cref())));
}


// static QString QVideoFrameFormat::pixelFormatToString(QVideoFrameFormat::PixelFormat pixelFormat)


static void _init_f_pixelFormatToString_3375 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pixelFormat");
  decl->add_arg<const qt_gsi::Converter<QVideoFrameFormat::PixelFormat>::target_type & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_pixelFormatToString_3375 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QVideoFrameFormat::PixelFormat>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QVideoFrameFormat::PixelFormat>::target_type & >() (args, heap);
  ret.write<QString > ((QString)QVideoFrameFormat::pixelFormatToString (qt_gsi::QtToCppAdaptor<QVideoFrameFormat::PixelFormat>(arg1).cref()));
}



namespace gsi
{

static gsi::Methods methods_QVideoFrameFormat () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QVideoFrameFormat::QVideoFrameFormat()\nThis method creates an object of class QVideoFrameFormat.", &_init_ctor_QVideoFrameFormat_0, &_call_ctor_QVideoFrameFormat_0);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QVideoFrameFormat::QVideoFrameFormat(const QSize &size, QVideoFrameFormat::PixelFormat pixelFormat)\nThis method creates an object of class QVideoFrameFormat.", &_init_ctor_QVideoFrameFormat_5072, &_call_ctor_QVideoFrameFormat_5072);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QVideoFrameFormat::QVideoFrameFormat(const QVideoFrameFormat &format)\nThis method creates an object of class QVideoFrameFormat.", &_init_ctor_QVideoFrameFormat_3005, &_call_ctor_QVideoFrameFormat_3005);
  methods += new qt_gsi::GenericMethod ("detach", "@brief Method void QVideoFrameFormat::detach()\n", false, &_init_f_detach_0, &_call_f_detach_0);
  methods += new qt_gsi::GenericMethod ("fragmentShaderFileName", "@brief Method QString QVideoFrameFormat::fragmentShaderFileName()\n", true, &_init_f_fragmentShaderFileName_c0, &_call_f_fragmentShaderFileName_c0);
  methods += new qt_gsi::GenericMethod ("frameHeight", "@brief Method int QVideoFrameFormat::frameHeight()\n", true, &_init_f_frameHeight_c0, &_call_f_frameHeight_c0);
  methods += new qt_gsi::GenericMethod ("frameRate", "@brief Method double QVideoFrameFormat::frameRate()\n", true, &_init_f_frameRate_c0, &_call_f_frameRate_c0);
  methods += new qt_gsi::GenericMethod ("frameSize", "@brief Method QSize QVideoFrameFormat::frameSize()\n", true, &_init_f_frameSize_c0, &_call_f_frameSize_c0);
  methods += new qt_gsi::GenericMethod ("frameWidth", "@brief Method int QVideoFrameFormat::frameWidth()\n", true, &_init_f_frameWidth_c0, &_call_f_frameWidth_c0);
  methods += new qt_gsi::GenericMethod ("isMirrored?", "@brief Method bool QVideoFrameFormat::isMirrored()\n", true, &_init_f_isMirrored_c0, &_call_f_isMirrored_c0);
  methods += new qt_gsi::GenericMethod ("isValid?", "@brief Method bool QVideoFrameFormat::isValid()\n", true, &_init_f_isValid_c0, &_call_f_isValid_c0);
  methods += new qt_gsi::GenericMethod ("!=", "@brief Method bool QVideoFrameFormat::operator!=(const QVideoFrameFormat &format)\n", true, &_init_f_operator_excl__eq__c3005, &_call_f_operator_excl__eq__c3005);
  methods += new qt_gsi::GenericMethod ("assign", "@brief Method QVideoFrameFormat &QVideoFrameFormat::operator=(const QVideoFrameFormat &format)\n", false, &_init_f_operator_eq__3005, &_call_f_operator_eq__3005);
  methods += new qt_gsi::GenericMethod ("==", "@brief Method bool QVideoFrameFormat::operator==(const QVideoFrameFormat &format)\n", true, &_init_f_operator_eq__eq__c3005, &_call_f_operator_eq__eq__c3005);
  methods += new qt_gsi::GenericMethod ("pixelFormat", "@brief Method QVideoFrameFormat::PixelFormat QVideoFrameFormat::pixelFormat()\n", true, &_init_f_pixelFormat_c0, &_call_f_pixelFormat_c0);
  methods += new qt_gsi::GenericMethod ("planeCount", "@brief Method int QVideoFrameFormat::planeCount()\n", true, &_init_f_planeCount_c0, &_call_f_planeCount_c0);
  methods += new qt_gsi::GenericMethod ("scanLineDirection", "@brief Method QVideoFrameFormat::Direction QVideoFrameFormat::scanLineDirection()\n", true, &_init_f_scanLineDirection_c0, &_call_f_scanLineDirection_c0);
  methods += new qt_gsi::GenericMethod ("setFrameRate", "@brief Method void QVideoFrameFormat::setFrameRate(double rate)\n", false, &_init_f_setFrameRate_1071, &_call_f_setFrameRate_1071);
  methods += new qt_gsi::GenericMethod ("setFrameSize", "@brief Method void QVideoFrameFormat::setFrameSize(const QSize &size)\n", false, &_init_f_setFrameSize_1805, &_call_f_setFrameSize_1805);
  methods += new qt_gsi::GenericMethod ("setFrameSize", "@brief Method void QVideoFrameFormat::setFrameSize(int width, int height)\n", false, &_init_f_setFrameSize_1426, &_call_f_setFrameSize_1426);
  methods += new qt_gsi::GenericMethod ("setMirrored", "@brief Method void QVideoFrameFormat::setMirrored(bool mirrored)\n", false, &_init_f_setMirrored_864, &_call_f_setMirrored_864);
  methods += new qt_gsi::GenericMethod ("setScanLineDirection", "@brief Method void QVideoFrameFormat::setScanLineDirection(QVideoFrameFormat::Direction direction)\n", false, &_init_f_setScanLineDirection_3173, &_call_f_setScanLineDirection_3173);
  methods += new qt_gsi::GenericMethod ("setViewport", "@brief Method void QVideoFrameFormat::setViewport(const QRect &viewport)\n", false, &_init_f_setViewport_1792, &_call_f_setViewport_1792);
  methods += new qt_gsi::GenericMethod ("setYCbCrColorSpace", "@brief Method void QVideoFrameFormat::setYCbCrColorSpace(QVideoFrameFormat::YCbCrColorSpace colorSpace)\n", false, &_init_f_setYCbCrColorSpace_3682, &_call_f_setYCbCrColorSpace_3682);
  methods += new qt_gsi::GenericMethod ("swap", "@brief Method void QVideoFrameFormat::swap(QVideoFrameFormat &other)\n", false, &_init_f_swap_2310, &_call_f_swap_2310);
  methods += new qt_gsi::GenericMethod ("updateUniformData", "@brief Method void QVideoFrameFormat::updateUniformData(QByteArray *dst, const QVideoFrame &frame, const QMatrix4x4 &transform, float opacity)\n", true, &_init_f_updateUniformData_c6899, &_call_f_updateUniformData_c6899);
  methods += new qt_gsi::GenericMethod ("vertexShaderFileName", "@brief Method QString QVideoFrameFormat::vertexShaderFileName()\n", true, &_init_f_vertexShaderFileName_c0, &_call_f_vertexShaderFileName_c0);
  methods += new qt_gsi::GenericMethod ("viewport", "@brief Method QRect QVideoFrameFormat::viewport()\n", true, &_init_f_viewport_c0, &_call_f_viewport_c0);
  methods += new qt_gsi::GenericMethod ("yCbCrColorSpace", "@brief Method QVideoFrameFormat::YCbCrColorSpace QVideoFrameFormat::yCbCrColorSpace()\n", true, &_init_f_yCbCrColorSpace_c0, &_call_f_yCbCrColorSpace_c0);
  methods += new qt_gsi::GenericStaticMethod ("imageFormatFromPixelFormat", "@brief Static method QImage::Format QVideoFrameFormat::imageFormatFromPixelFormat(QVideoFrameFormat::PixelFormat format)\nThis method is static and can be called without an instance.", &_init_f_imageFormatFromPixelFormat_3375, &_call_f_imageFormatFromPixelFormat_3375);
  methods += new qt_gsi::GenericStaticMethod ("pixelFormatFromImageFormat", "@brief Static method QVideoFrameFormat::PixelFormat QVideoFrameFormat::pixelFormatFromImageFormat(QImage::Format format)\nThis method is static and can be called without an instance.", &_init_f_pixelFormatFromImageFormat_1733, &_call_f_pixelFormatFromImageFormat_1733);
  methods += new qt_gsi::GenericStaticMethod ("pixelFormatToString", "@brief Static method QString QVideoFrameFormat::pixelFormatToString(QVideoFrameFormat::PixelFormat pixelFormat)\nThis method is static and can be called without an instance.", &_init_f_pixelFormatToString_3375, &_call_f_pixelFormatToString_3375);
  return methods;
}

gsi::Class<QVideoFrameFormat> decl_QVideoFrameFormat ("QtMultimedia", "QVideoFrameFormat",
  methods_QVideoFrameFormat (),
  "@qt\n@brief Binding of QVideoFrameFormat");


GSI_QTMULTIMEDIA_PUBLIC gsi::Class<QVideoFrameFormat> &qtdecl_QVideoFrameFormat () { return decl_QVideoFrameFormat; }

}


//  Implementation of the enum wrapper class for QVideoFrameFormat::Direction
namespace qt_gsi
{

static gsi::Enum<QVideoFrameFormat::Direction> decl_QVideoFrameFormat_Direction_Enum ("QtMultimedia", "QVideoFrameFormat_Direction",
    gsi::enum_const ("TopToBottom", QVideoFrameFormat::TopToBottom, "@brief Enum constant QVideoFrameFormat::TopToBottom") +
    gsi::enum_const ("BottomToTop", QVideoFrameFormat::BottomToTop, "@brief Enum constant QVideoFrameFormat::BottomToTop"),
  "@qt\n@brief This class represents the QVideoFrameFormat::Direction enum");

static gsi::QFlagsClass<QVideoFrameFormat::Direction > decl_QVideoFrameFormat_Direction_Enums ("QtMultimedia", "QVideoFrameFormat_QFlags_Direction",
  "@qt\n@brief This class represents the QFlags<QVideoFrameFormat::Direction> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QVideoFrameFormat> inject_QVideoFrameFormat_Direction_Enum_in_parent (decl_QVideoFrameFormat_Direction_Enum.defs ());
static gsi::ClassExt<QVideoFrameFormat> decl_QVideoFrameFormat_Direction_Enum_as_child (decl_QVideoFrameFormat_Direction_Enum, "Direction");
static gsi::ClassExt<QVideoFrameFormat> decl_QVideoFrameFormat_Direction_Enums_as_child (decl_QVideoFrameFormat_Direction_Enums, "QFlags_Direction");

}


//  Implementation of the enum wrapper class for QVideoFrameFormat::PixelFormat
namespace qt_gsi
{

static gsi::Enum<QVideoFrameFormat::PixelFormat> decl_QVideoFrameFormat_PixelFormat_Enum ("QtMultimedia", "QVideoFrameFormat_PixelFormat",
    gsi::enum_const ("Format_Invalid", QVideoFrameFormat::Format_Invalid, "@brief Enum constant QVideoFrameFormat::Format_Invalid") +
    gsi::enum_const ("Format_ARGB8888", QVideoFrameFormat::Format_ARGB8888, "@brief Enum constant QVideoFrameFormat::Format_ARGB8888") +
    gsi::enum_const ("Format_ARGB8888_Premultiplied", QVideoFrameFormat::Format_ARGB8888_Premultiplied, "@brief Enum constant QVideoFrameFormat::Format_ARGB8888_Premultiplied") +
    gsi::enum_const ("Format_XRGB8888", QVideoFrameFormat::Format_XRGB8888, "@brief Enum constant QVideoFrameFormat::Format_XRGB8888") +
    gsi::enum_const ("Format_BGRA8888", QVideoFrameFormat::Format_BGRA8888, "@brief Enum constant QVideoFrameFormat::Format_BGRA8888") +
    gsi::enum_const ("Format_BGRA8888_Premultiplied", QVideoFrameFormat::Format_BGRA8888_Premultiplied, "@brief Enum constant QVideoFrameFormat::Format_BGRA8888_Premultiplied") +
    gsi::enum_const ("Format_BGRX8888", QVideoFrameFormat::Format_BGRX8888, "@brief Enum constant QVideoFrameFormat::Format_BGRX8888") +
    gsi::enum_const ("Format_ABGR8888", QVideoFrameFormat::Format_ABGR8888, "@brief Enum constant QVideoFrameFormat::Format_ABGR8888") +
    gsi::enum_const ("Format_XBGR8888", QVideoFrameFormat::Format_XBGR8888, "@brief Enum constant QVideoFrameFormat::Format_XBGR8888") +
    gsi::enum_const ("Format_RGBA8888", QVideoFrameFormat::Format_RGBA8888, "@brief Enum constant QVideoFrameFormat::Format_RGBA8888") +
    gsi::enum_const ("Format_RGBX8888", QVideoFrameFormat::Format_RGBX8888, "@brief Enum constant QVideoFrameFormat::Format_RGBX8888") +
    gsi::enum_const ("Format_AYUV", QVideoFrameFormat::Format_AYUV, "@brief Enum constant QVideoFrameFormat::Format_AYUV") +
    gsi::enum_const ("Format_AYUV_Premultiplied", QVideoFrameFormat::Format_AYUV_Premultiplied, "@brief Enum constant QVideoFrameFormat::Format_AYUV_Premultiplied") +
    gsi::enum_const ("Format_YUV420P", QVideoFrameFormat::Format_YUV420P, "@brief Enum constant QVideoFrameFormat::Format_YUV420P") +
    gsi::enum_const ("Format_YUV422P", QVideoFrameFormat::Format_YUV422P, "@brief Enum constant QVideoFrameFormat::Format_YUV422P") +
    gsi::enum_const ("Format_YV12", QVideoFrameFormat::Format_YV12, "@brief Enum constant QVideoFrameFormat::Format_YV12") +
    gsi::enum_const ("Format_UYVY", QVideoFrameFormat::Format_UYVY, "@brief Enum constant QVideoFrameFormat::Format_UYVY") +
    gsi::enum_const ("Format_YUYV", QVideoFrameFormat::Format_YUYV, "@brief Enum constant QVideoFrameFormat::Format_YUYV") +
    gsi::enum_const ("Format_NV12", QVideoFrameFormat::Format_NV12, "@brief Enum constant QVideoFrameFormat::Format_NV12") +
    gsi::enum_const ("Format_NV21", QVideoFrameFormat::Format_NV21, "@brief Enum constant QVideoFrameFormat::Format_NV21") +
    gsi::enum_const ("Format_IMC1", QVideoFrameFormat::Format_IMC1, "@brief Enum constant QVideoFrameFormat::Format_IMC1") +
    gsi::enum_const ("Format_IMC2", QVideoFrameFormat::Format_IMC2, "@brief Enum constant QVideoFrameFormat::Format_IMC2") +
    gsi::enum_const ("Format_IMC3", QVideoFrameFormat::Format_IMC3, "@brief Enum constant QVideoFrameFormat::Format_IMC3") +
    gsi::enum_const ("Format_IMC4", QVideoFrameFormat::Format_IMC4, "@brief Enum constant QVideoFrameFormat::Format_IMC4") +
    gsi::enum_const ("Format_Y8", QVideoFrameFormat::Format_Y8, "@brief Enum constant QVideoFrameFormat::Format_Y8") +
    gsi::enum_const ("Format_Y16", QVideoFrameFormat::Format_Y16, "@brief Enum constant QVideoFrameFormat::Format_Y16") +
    gsi::enum_const ("Format_P010", QVideoFrameFormat::Format_P010, "@brief Enum constant QVideoFrameFormat::Format_P010") +
    gsi::enum_const ("Format_P016", QVideoFrameFormat::Format_P016, "@brief Enum constant QVideoFrameFormat::Format_P016") +
    gsi::enum_const ("Format_SamplerExternalOES", QVideoFrameFormat::Format_SamplerExternalOES, "@brief Enum constant QVideoFrameFormat::Format_SamplerExternalOES") +
    gsi::enum_const ("Format_Jpeg", QVideoFrameFormat::Format_Jpeg, "@brief Enum constant QVideoFrameFormat::Format_Jpeg") +
    gsi::enum_const ("Format_SamplerRect", QVideoFrameFormat::Format_SamplerRect, "@brief Enum constant QVideoFrameFormat::Format_SamplerRect"),
  "@qt\n@brief This class represents the QVideoFrameFormat::PixelFormat enum");

static gsi::QFlagsClass<QVideoFrameFormat::PixelFormat > decl_QVideoFrameFormat_PixelFormat_Enums ("QtMultimedia", "QVideoFrameFormat_QFlags_PixelFormat",
  "@qt\n@brief This class represents the QFlags<QVideoFrameFormat::PixelFormat> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QVideoFrameFormat> inject_QVideoFrameFormat_PixelFormat_Enum_in_parent (decl_QVideoFrameFormat_PixelFormat_Enum.defs ());
static gsi::ClassExt<QVideoFrameFormat> decl_QVideoFrameFormat_PixelFormat_Enum_as_child (decl_QVideoFrameFormat_PixelFormat_Enum, "PixelFormat");
static gsi::ClassExt<QVideoFrameFormat> decl_QVideoFrameFormat_PixelFormat_Enums_as_child (decl_QVideoFrameFormat_PixelFormat_Enums, "QFlags_PixelFormat");

}


//  Implementation of the enum wrapper class for QVideoFrameFormat::YCbCrColorSpace
namespace qt_gsi
{

static gsi::Enum<QVideoFrameFormat::YCbCrColorSpace> decl_QVideoFrameFormat_YCbCrColorSpace_Enum ("QtMultimedia", "QVideoFrameFormat_YCbCrColorSpace",
    gsi::enum_const ("YCbCr_Undefined", QVideoFrameFormat::YCbCr_Undefined, "@brief Enum constant QVideoFrameFormat::YCbCr_Undefined") +
    gsi::enum_const ("YCbCr_BT601", QVideoFrameFormat::YCbCr_BT601, "@brief Enum constant QVideoFrameFormat::YCbCr_BT601") +
    gsi::enum_const ("YCbCr_BT709", QVideoFrameFormat::YCbCr_BT709, "@brief Enum constant QVideoFrameFormat::YCbCr_BT709") +
    gsi::enum_const ("YCbCr_xvYCC601", QVideoFrameFormat::YCbCr_xvYCC601, "@brief Enum constant QVideoFrameFormat::YCbCr_xvYCC601") +
    gsi::enum_const ("YCbCr_xvYCC709", QVideoFrameFormat::YCbCr_xvYCC709, "@brief Enum constant QVideoFrameFormat::YCbCr_xvYCC709") +
    gsi::enum_const ("YCbCr_JPEG", QVideoFrameFormat::YCbCr_JPEG, "@brief Enum constant QVideoFrameFormat::YCbCr_JPEG"),
  "@qt\n@brief This class represents the QVideoFrameFormat::YCbCrColorSpace enum");

static gsi::QFlagsClass<QVideoFrameFormat::YCbCrColorSpace > decl_QVideoFrameFormat_YCbCrColorSpace_Enums ("QtMultimedia", "QVideoFrameFormat_QFlags_YCbCrColorSpace",
  "@qt\n@brief This class represents the QFlags<QVideoFrameFormat::YCbCrColorSpace> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QVideoFrameFormat> inject_QVideoFrameFormat_YCbCrColorSpace_Enum_in_parent (decl_QVideoFrameFormat_YCbCrColorSpace_Enum.defs ());
static gsi::ClassExt<QVideoFrameFormat> decl_QVideoFrameFormat_YCbCrColorSpace_Enum_as_child (decl_QVideoFrameFormat_YCbCrColorSpace_Enum, "YCbCrColorSpace");
static gsi::ClassExt<QVideoFrameFormat> decl_QVideoFrameFormat_YCbCrColorSpace_Enums_as_child (decl_QVideoFrameFormat_YCbCrColorSpace_Enums, "QFlags_YCbCrColorSpace");

}

