/**
 * JNA-InChI - Library for calling InChI from Java
 * Copyright © 2018 Daniel Lowe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package io.github.dan2097.jnainchi.inchi;
import java.util.Arrays;
import java.util.List;

import com.sun.jna.Structure;
import com.sun.jna.Structure.ByReference;
/**
 * This file was autogenerated by <a href="http://jnaerator.googlecode.com/">JNAerator</a>,<br>
 * a tool written by <a href="http://ochafik.com/">Olivier Chafik</a> that <a href="http://code.google.com/p/jnaerator/wiki/CreditsAndLicense">uses a few opensource projects.</a>.<br>
 * For help, please visit <a href="http://nativelibs4java.googlecode.com/">NativeLibs4Java</a> , <a href="http://rococoa.dev.java.net/">Rococoa</a>, or <a href="http://jna.dev.java.net/">JNA</a>.
 */
public class tagNormAtom extends Structure implements ByReference {
  /**
   * chem. element name<br>
   * C type : char[6]
   */
  public byte[] elname = new byte[6];
  /**
   * number of the element in the Periodic Table<br>
   * C type : U_CHAR
   */
  public byte el_number;
  /**
   * positions (from 0) of the neighbors in the NORM_ATOM array<br>
   * C type : AT_NUMBR[20]
   */
  public short[] neighbor = new short[20];
  /**
   * original atom number, starts from 1<br>
   * C type : AT_NUMBR
   */
  public short orig_at_number;
  /**
   * atom number within a component before terminal H removal<br>
   * C type : AT_NUMBR
   */
  public short orig_compt_at_numb;
  /**
   * 1=Up,4=Either,6=Down (this atom is at the pointing wedge)<br>
   * negative =&gt; on the opposite side of the wedge; 3=Either double bond<br>
   * C type : S_CHAR[20]
   */
  public byte[] bond_stereo = new byte[20];
  /**
   * 1=single, 2=double, 3=triple, 4=1/2 (bond order is 1 or 2)<br>
   * C type : U_CHAR[20]
   */
  public byte[] bond_type = new byte[20];
  /**
   * number of bonds = number of neighbors not greater than MAXVAL<br>
   * C type : S_CHAR
   */
  public byte valence;
  /**
   * sum of bond types (1,2,3); type 4 needs special treatment<br>
   * C type : S_CHAR
   */
  public byte chem_bonds_valence;
  /**
   * number of adjacent implicit hydrogen atoms including D and T<br>
   * C type : S_CHAR
   */
  public byte num_H;
  /**
   * number of adjacent implicit 1H(protium), 2H(D), 3H(T) &lt; 16<br>
   * C type : S_CHAR[3]
   */
  public byte[] num_iso_H = new byte[3];
  /**
   * =0 =&gt; natural isotopic abundances<br>
   * C type : S_CHAR
   */
  public byte iso_atw_diff;
  /**
   * charge<br>
   * C type : S_CHAR
   */
  public byte charge;
  /**
   * RADICAL_SINGLET, RADICAL_DOUBLET, or RADICAL_TRIPLET<br>
   * C type : S_CHAR
   */
  public byte radical;
  /**
   * flag of detected stereo ambiguity<br>
   * C type : S_CHAR
   */
  public byte bAmbiguousStereo;
  /**
   * AT_FLAG_ISO_H_POINT: atom may have exchangeable isotopic H<br>
   * C type : S_CHAR
   */
  public byte cFlags;
  /**
   * ATT_NONE, ATT_ACIDIC, etc. See InChI normalization code<br>
   * C type : AT_NUMBR
   */
  public short at_type;
  /**
   * number of the structure component &gt; 0<br>
   * C type : AT_NUMBR
   */
  public short component;
  /**
   * id of a tautomeric group<br>
   * C type : AT_NUMBR
   */
  public short endpoint;
  /**
   * id of a positive charge group<br>
   * C type : AT_NUMBR
   */
  public short c_point;
  /** x coordinate */
  public double x;
  /** y coordinate */
  public double y;
  /** x coordinate */
  public double z;
  /**
   * bit=1 =&gt; stereobond; bit=2 =&gt; stereocenter<br>
   * C type : S_CHAR
   */
  public byte bUsed0DParity;
  /**
   * tetrahedral (sp3) cml parity<br>
   * C type : S_CHAR
   */
  public byte p_parity;
  /**
   * orig_at_number of each neighbor &gt; 0; 0=&gt; no neighbor<br>
   * C type : AT_NUMBR[4]
   */
  public short[] p_orig_at_num = new short[4];
  /**
   * neighbor[] index of another end of this SB, starts from 0<br>
   * C type : S_CHAR[3]
   */
  public byte[] sb_ord = new byte[3];
  /**
   * neighbor[] index of a bond that is not this SB; starts from 0;<br>
   * -1 means the neighbor is a removed explicit H<br>
   * C type : S_CHAR[3]
   */
  public byte[] sn_ord = new byte[3];
  /**
   * parities of stereobonds (sp2) incident to this atom<br>
   * C type : S_CHAR[3]
   */
  public byte[] sb_parity = new byte[3];
  /**
   * orig_at_number of sn_ord[] neighbor &gt; 0<br>
   * C type : AT_NUMBR[3]
   */
  public short[] sn_orig_at_num = new short[3];
  /**
   * is the atom a cut-vertex or not<br>
   * C type : S_CHAR
   */
  public byte bCutVertex;
  /**
   * starts from 1; number of a ring system<br>
   * C type : AT_NUMBR
   */
  public short nRingSystem;
  /**
   * number of atoms in a ring system to which this at belongs<br>
   * C type : AT_NUMBR
   */
  public short nNumAtInRingSystem;
  /**
   * ambiguous if the atom is a cut-vertex: better apply this to bonds<br>
   * C type : AT_NUMBR
   */
  public short nBlockSystem;

  protected List<String> getFieldOrder() {
    return Arrays.asList("elname", "el_number", "neighbor", "orig_at_number", "orig_compt_at_numb", "bond_stereo", "bond_type", "valence", "chem_bonds_valence", "num_H", "num_iso_H", "iso_atw_diff", "charge", "radical", "bAmbiguousStereo", "cFlags", "at_type", "component", "endpoint", "c_point", "x", "y", "z", "bUsed0DParity", "p_parity", "p_orig_at_num", "sb_ord", "sn_ord", "sb_parity", "sn_orig_at_num", "bCutVertex", "nRingSystem", "nNumAtInRingSystem", "nBlockSystem");
  }

}
