/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.datamodel.AlignmentI;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.io.AlignFile;
import jalview.io.FileParse;
import jalview.schemes.UserColourScheme;
import jalview.util.Format;
import java.awt.Color;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class FeaturesFile
extends AlignFile {
    public FeaturesFile() {
    }

    public FeaturesFile(String inFile, String type) throws IOException {
        super(inFile, type);
    }

    public FeaturesFile(FileParse source) throws IOException {
        super(source);
    }

    public boolean parse(AlignmentI align, Hashtable colours, boolean removeHTML) {
        return this.parse(align, colours, null, removeHTML);
    }

    public boolean parse(AlignmentI align, Hashtable colours, Hashtable featureLink, boolean removeHTML) {
        String line = null;
        try {
            SequenceI seq = null;
            String token = null;
            String featureGroup = null;
            String groupLink = null;
            Hashtable<String, String> typeLink = new Hashtable<String, String>();
            boolean GFFFile = true;
            block12: while ((line = this.nextLine()) != null) {
                String type;
                if (line.startsWith("#")) continue;
                StringTokenizer st = new StringTokenizer(line, "\t");
                if (st.countTokens() > 1 && st.countTokens() < 4) {
                    GFFFile = false;
                    type = st.nextToken();
                    if (type.equalsIgnoreCase("startgroup")) {
                        featureGroup = st.nextToken();
                        if (!st.hasMoreElements()) continue;
                        groupLink = st.nextToken();
                        featureLink.put(featureGroup, groupLink);
                        continue;
                    }
                    if (type.equalsIgnoreCase("endgroup")) {
                        st.nextToken();
                        featureGroup = null;
                        groupLink = null;
                        continue;
                    }
                    UserColourScheme ucs = new UserColourScheme(st.nextToken());
                    colours.put(type, ucs.findColour('A'));
                    if (!st.hasMoreElements()) continue;
                    String link = st.nextToken();
                    typeLink.put(type, link);
                    if (featureLink == null) {
                        featureLink = new Hashtable<String, String>();
                    }
                    featureLink.put(type, link);
                    continue;
                }
                String seqId = "";
                while (st.hasMoreElements()) {
                    SequenceFeature sf;
                    int end;
                    int start;
                    String desc;
                    if (GFFFile && (seq = align.findName(seqId = (token = st.nextToken()), true)) != null) {
                        float score;
                        desc = st.nextToken();
                        type = st.nextToken();
                        try {
                            start = Integer.parseInt(st.nextToken());
                        }
                        catch (NumberFormatException ex) {
                            start = 0;
                        }
                        try {
                            end = Integer.parseInt(st.nextToken());
                        }
                        catch (NumberFormatException ex) {
                            end = -1;
                        }
                        try {
                            score = new Float(st.nextToken()).floatValue();
                        }
                        catch (NumberFormatException ex) {
                            score = 0.0f;
                        }
                        sf = new SequenceFeature(type, desc, start, end, score, null);
                        try {
                            sf.setValue("STRAND", st.nextToken());
                            sf.setValue("FRAME", st.nextToken());
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        if (st.hasMoreTokens()) {
                            StringBuffer attributes = new StringBuffer();
                            while (st.hasMoreTokens()) {
                                attributes.append("\t" + st.nextElement());
                            }
                            sf.setValue("ATTRIBUTES", attributes.toString());
                        }
                        seq.addSequenceFeature(sf);
                        while ((seq = align.findName(seq, seqId, true)) != null) {
                            seq.addSequenceFeature(new SequenceFeature(sf));
                        }
                        continue block12;
                    }
                    desc = GFFFile && seq == null ? token : st.nextToken();
                    if (!st.hasMoreTokens()) {
                        System.err.println("DEBUG: Run out of tokens when trying to identify the destination for the feature.. giving up.");
                        return false;
                    }
                    token = st.nextToken();
                    if (!token.equals("ID_NOT_SPECIFIED")) {
                        seqId = token;
                        seq = align.findName(seqId, true);
                        st.nextToken();
                    } else {
                        seqId = null;
                        try {
                            int index = Integer.parseInt(st.nextToken());
                            seq = align.getSequenceAt(index);
                        }
                        catch (NumberFormatException ex) {
                            seq = null;
                        }
                    }
                    if (seq == null) {
                        System.out.println("Sequence not found: " + line);
                        continue block12;
                    }
                    start = Integer.parseInt(st.nextToken());
                    end = Integer.parseInt(st.nextToken());
                    type = st.nextToken();
                    if (!colours.containsKey(type)) {
                        UserColourScheme ucs = new UserColourScheme(type);
                        colours.put(type, ucs.findColour('A'));
                    }
                    sf = new SequenceFeature(type, desc, "", start, end, featureGroup);
                    if (groupLink != null && removeHTML) {
                        sf.addLink(groupLink);
                        sf.description = sf.description + "%LINK%";
                    }
                    if (typeLink.containsKey(type) && removeHTML) {
                        sf.addLink(typeLink.get(type).toString());
                        sf.description = sf.description + "%LINK%";
                    }
                    this.parseDescriptionHTML(sf, removeHTML);
                    seq.addSequenceFeature(sf);
                    while (seqId != null && (seq = align.findName(seq, seqId, false)) != null) {
                        seq.addSequenceFeature(new SequenceFeature(sf));
                    }
                    GFFFile = false;
                }
            }
        }
        catch (Exception ex) {
            System.out.println(line);
            System.out.println("Error parsing feature file: " + ex + "\n" + line);
            ex.printStackTrace(System.err);
            return false;
        }
        return true;
    }

    public void parseDescriptionHTML(SequenceFeature sf, boolean removeHTML) {
        if (sf.getDescription() == null) {
            return;
        }
        if (removeHTML && sf.getDescription().toUpperCase().indexOf("<HTML>") == -1) {
            removeHTML = false;
        }
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(sf.getDescription(), "<");
        String tag = null;
        while (st.hasMoreElements()) {
            String token = st.nextToken("&>");
            if (token.equalsIgnoreCase("html") || token.startsWith("/")) continue;
            tag = null;
            int startTag = token.indexOf("<");
            if (startTag > -1) {
                tag = token.substring(startTag + 1);
                token = token.substring(0, startTag);
            }
            if (tag != null && tag.toUpperCase().startsWith("A HREF=")) {
                if (token.length() > 0) {
                    sb.append(token);
                }
                String link = tag.substring(tag.indexOf("\"") + 1, tag.length() - 1);
                String label = st.nextToken("<>");
                sf.addLink(label + "|" + link);
                sb.append(label + "%LINK%");
                continue;
            }
            if (tag != null && tag.equalsIgnoreCase("br")) {
                sb.append("\n");
                continue;
            }
            if (token.startsWith("lt;")) {
                sb.append("<" + token.substring(3));
                continue;
            }
            if (token.startsWith("gt;")) {
                sb.append(">" + token.substring(3));
                continue;
            }
            if (token.startsWith("amp;")) {
                sb.append("&" + token.substring(4));
                continue;
            }
            sb.append(token);
        }
        if (removeHTML) {
            sf.description = sb.toString();
        }
    }

    public String printJalviewFormat(SequenceI[] seqs, Hashtable visible) {
        return this.printJalviewFormat(seqs, visible, true);
    }

    public String printJalviewFormat(SequenceI[] seqs, Hashtable visible, boolean visOnly) {
        SequenceFeature[] next;
        StringBuffer out = new StringBuffer();
        if (visOnly && (visible == null || visible.size() < 1)) {
            return "No Features Visible";
        }
        if (visible != null && visOnly) {
            Enumeration en = visible.keys();
            while (en.hasMoreElements()) {
                String type = en.nextElement().toString();
                int color = Integer.parseInt(visible.get(type).toString());
                out.append(type + "\t" + Format.getHexString(new Color(color)) + "\n");
            }
        }
        Vector<String> groups = new Vector<String>();
        int groupIndex = 0;
        for (int i = 0; i < seqs.length; ++i) {
            next = seqs[i].getSequenceFeatures();
            if (next == null) continue;
            for (int j = 0; j < next.length; ++j) {
                if (visOnly && !visible.containsKey(next[j].type) || next[j].featureGroup == null || groups.contains(next[j].featureGroup)) continue;
                groups.addElement(next[j].featureGroup);
            }
        }
        String group = null;
        do {
            if (groups.size() > 0 && groupIndex < groups.size()) {
                group = groups.elementAt(groupIndex).toString();
                out.append("\nSTARTGROUP\t" + group + "\n");
            } else {
                group = null;
            }
            for (int i = 0; i < seqs.length; ++i) {
                next = seqs[i].getSequenceFeatures();
                if (next == null) continue;
                for (int j = 0; j < next.length; ++j) {
                    if (visOnly && !visible.containsKey(next[j].type) || group != null && (next[j].featureGroup == null || !next[j].featureGroup.equals(group)) || group == null && next[j].featureGroup != null) continue;
                    if (next[j].description == null || next[j].description.equals("")) {
                        out.append(next[j].type + "\t");
                    } else {
                        if (next[j].links != null && next[j].getDescription().indexOf("<html>") == -1) {
                            out.append("<html>");
                        }
                        out.append(next[j].description + " ");
                        if (next[j].links != null) {
                            for (int l = 0; l < next[j].links.size(); ++l) {
                                String label = next[j].links.elementAt(l).toString();
                                String href = label.substring(label.indexOf("|") + 1);
                                label = label.substring(0, label.indexOf("|"));
                                if (next[j].description.indexOf(href) != -1) continue;
                                out.append("<a href=\"" + href + "\">" + label + "</a>");
                            }
                            if (next[j].getDescription().indexOf("</html>") == -1) {
                                out.append("</html>");
                            }
                        }
                        out.append("\t");
                    }
                    out.append(seqs[i].getName() + "\t-1\t" + next[j].begin + "\t" + next[j].end + "\t" + next[j].type + "\n");
                }
            }
            if (group == null) break;
            out.append("ENDGROUP\t" + group + "\n");
        } while (++groupIndex < groups.size() + 1);
        return out.toString();
    }

    public String printGFFFormat(SequenceI[] seqs, Hashtable visible) {
        return this.printGFFFormat(seqs, visible, true);
    }

    public String printGFFFormat(SequenceI[] seqs, Hashtable visible, boolean visOnly) {
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < seqs.length; ++i) {
            if (seqs[i].getSequenceFeatures() == null) continue;
            SequenceFeature[] next = seqs[i].getSequenceFeatures();
            for (int j = 0; j < next.length; ++j) {
                if (visOnly && !visible.containsKey(next[j].type)) continue;
                String source = next[j].featureGroup;
                if (source == null) {
                    source = next[j].getDescription();
                }
                out.append(seqs[i].getName() + "\t" + source + "\t" + next[j].type + "\t" + next[j].begin + "\t" + next[j].end + "\t" + next[j].score + "\t");
                if (next[j].getValue("STRAND") != null) {
                    out.append(next[j].getValue("STRAND") + "\t");
                } else {
                    out.append(".\t");
                }
                if (next[j].getValue("FRAME") != null) {
                    out.append(next[j].getValue("FRAME"));
                } else {
                    out.append(".");
                }
                if (next[j].getValue("ATTRIBUTES") != null) {
                    out.append(next[j].getValue("ATTRIBUTES"));
                }
                out.append("\n");
            }
        }
        return out.toString();
    }

    public void parse() {
    }

    public String print() {
        return "USE printGFFFormat() or printJalviewFormat()";
    }
}

